/*
 * Decompiled with CFR 0.152.
 */
package mtr.render;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import mtr.MTRClient;
import mtr.block.BlockNode;
import mtr.block.BlockPlatform;
import mtr.block.BlockSignalLightBase;
import mtr.block.BlockSignalSemaphoreBase;
import mtr.client.ClientCache;
import mtr.client.ClientData;
import mtr.client.Config;
import mtr.client.IDrawing;
import mtr.client.ResourcePackCreatorProperties;
import mtr.data.IGui;
import mtr.data.Lift;
import mtr.data.LiftClient;
import mtr.data.Rail;
import mtr.data.RailType;
import mtr.data.RailwayData;
import mtr.data.Route;
import mtr.data.SignalBlocks;
import mtr.data.Station;
import mtr.data.Train;
import mtr.data.TrainClient;
import mtr.data.TransportMode;
import mtr.entity.EntitySeat;
import mtr.item.ItemNodeModifierBase;
import mtr.mappings.EntityRendererMapper;
import mtr.mappings.Text;
import mtr.mappings.Utilities;
import mtr.mappings.UtilitiesClient;
import mtr.model.ModelLift1;
import mtr.path.PathData;
import mtr.render.MoreRenderLayers;
import mtr.render.TrainRendererBase;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_765;
import org.apache.commons.lang3.StringUtils;

public class RenderTrains
extends EntityRendererMapper<EntitySeat>
implements IGui {
    public static int maxTrainRenderDistance;
    public static ResourcePackCreatorProperties creatorProperties;
    private static float lastRenderedTick;
    private static int prevPlatformCount;
    private static int prevSidingCount;
    private static UUID renderedUuid;
    public static final int PLAYER_RENDER_OFFSET = 1000;
    public static final Set<String> AVAILABLE_TEXTURES;
    public static final Set<String> UNAVAILABLE_TEXTURES;
    public static final int DETAIL_RADIUS = 32;
    public static final int DETAIL_RADIUS_SQUARED = 1024;
    public static final int LIFT_LIGHT_COLOR = -65536;
    private static final int MAX_RADIUS_REPLAY_MOD = 1024;
    private static final int TICKS_PER_SECOND = 20;
    private static final int DISMOUNT_PROGRESS_BAR_LENGTH = 30;
    private static final int TOTAL_RENDER_STAGES = 2;
    private static final List<List<Map<class_2960, Set<BiConsumer<class_4587, class_4588>>>>> RENDERS;
    private static final List<List<Map<class_2960, Set<BiConsumer<class_4587, class_4588>>>>> CURRENT_RENDERS;
    private static final class_2960 LIFT_TEXTURE;
    private static final class_2960 ARROW_TEXTURE;

    public RenderTrains(Object parameter) {
        super(parameter);
    }

    public void render(EntitySeat entity, float entityYaw, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int entityLight) {
        RenderTrains.render(entity, tickDelta, matrices, vertexConsumers);
    }

    public class_2960 getTextureLocation(EntitySeat entity) {
        return null;
    }

    public static void render(EntitySeat entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers) {
        int j;
        int i;
        boolean useAnnouncements;
        boolean alreadyRendered;
        boolean backupRendering;
        class_310 client = class_310.method_1551();
        boolean bl = backupRendering = entity == null;
        if (!backupRendering && MTRClient.isPehkui()) {
            return;
        }
        boolean bl2 = alreadyRendered = renderedUuid != null && (backupRendering || entity.method_5667() != renderedUuid);
        if (backupRendering) {
            renderedUuid = null;
        }
        class_746 player = client.field_1724;
        class_638 world = client.field_1687;
        if (alreadyRendered || player == null || world == null) {
            return;
        }
        if (!backupRendering) {
            renderedUuid = entity.method_5667();
        }
        int renderDistanceChunks = UtilitiesClient.getRenderDistance();
        float lastFrameDuration = MTRClient.getLastFrameDuration();
        float newLastFrameDuration = client.method_1493() || lastRenderedTick == MTRClient.getGameTick() ? 0.0f : lastFrameDuration;
        boolean bl3 = useAnnouncements = Config.useTTSAnnouncements() || Config.showAnnouncementMessages();
        if (Config.useDynamicFPS()) {
            if ((double)lastFrameDuration > 0.5) {
                maxTrainRenderDistance = Math.max(maxTrainRenderDistance - (maxTrainRenderDistance - 32) / 2, 32);
            } else if ((double)lastFrameDuration < 0.4) {
                maxTrainRenderDistance = Math.min(maxTrainRenderDistance + 1, renderDistanceChunks * (Config.trainRenderDistanceRatio() + 1));
            }
        } else {
            maxTrainRenderDistance = renderDistanceChunks * (Config.trainRenderDistanceRatio() + 1);
        }
        if (!backupRendering) {
            matrices.method_22909();
            matrices.method_22903();
            class_243 cameraPosition = client.field_1773.method_19418().method_19326();
            matrices.method_22904(-cameraPosition.field_1352, -cameraPosition.field_1351, -cameraPosition.field_1350);
        }
        matrices.method_22903();
        TrainRendererBase.setupStaticInfo(matrices, vertexConsumers, entity, tickDelta);
        TrainRendererBase.setBatch(false);
        ClientData.TRAINS.forEach(arg_0 -> RenderTrains.lambda$render$4((class_1937)world, newLastFrameDuration, player, useAnnouncements, arg_0));
        if (!Config.hideTranslucentParts()) {
            TrainRendererBase.setBatch(true);
            ClientData.TRAINS.forEach(TrainClient::renderTranslucent);
        }
        ClientData.LIFTS.forEach(arg_0 -> RenderTrains.lambda$render$6((class_1937)world, matrices, vertexConsumers, newLastFrameDuration, arg_0));
        boolean renderColors = RenderTrains.isHoldingRailRelated((class_1657)player);
        int maxRailDistance = renderDistanceChunks * 16;
        HashMap renderedRailMap = new HashMap();
        ClientData.RAILS.forEach((arg_0, arg_1) -> RenderTrains.lambda$render$9(player, maxRailDistance, renderedRailMap, (class_1937)world, renderColors, matrices, vertexConsumers, arg_0, arg_1));
        matrices.method_22909();
        if (lastRenderedTick != MTRClient.getGameTick()) {
            for (i = 0; i < 2; ++i) {
                for (j = 0; j < QueuedRenderLayer.values().length; ++j) {
                    CURRENT_RENDERS.get(i).get(j).clear();
                    CURRENT_RENDERS.get(i).get(j).putAll(RENDERS.get(i).get(j));
                    RENDERS.get(i).get(j).clear();
                }
            }
        }
        for (i = 0; i < 2; ++i) {
            for (j = 0; j < QueuedRenderLayer.values().length; ++j) {
                QueuedRenderLayer queuedRenderLayer = QueuedRenderLayer.values()[j];
                CURRENT_RENDERS.get(i).get(j).forEach((key, value) -> {
                    class_4588 vertexConsumer = vertexConsumers.getBuffer(switch (queuedRenderLayer) {
                        case QueuedRenderLayer.LIGHT -> MoreRenderLayers.getLight(key, false);
                        case QueuedRenderLayer.LIGHT_TRANSLUCENT -> MoreRenderLayers.getLight(key, true);
                        case QueuedRenderLayer.INTERIOR -> MoreRenderLayers.getInterior(key);
                        default -> MoreRenderLayers.getExterior(key);
                    });
                    value.forEach(renderer -> renderer.accept(matrices, vertexConsumer));
                });
            }
        }
        if (prevPlatformCount != ClientData.PLATFORMS.size() || prevSidingCount != ClientData.SIDINGS.size()) {
            ClientData.DATA_CACHE.sync();
        }
        prevPlatformCount = ClientData.PLATFORMS.size();
        prevSidingCount = ClientData.SIDINGS.size();
        ClientData.DATA_CACHE.clearDataIfNeeded();
        lastRenderedTick = MTRClient.getGameTick();
    }

    public static boolean shouldNotRender(class_2338 pos, int maxDistance, class_2350 facing) {
        class_1297 camera = class_310.method_1551().field_1719;
        return RenderTrains.shouldNotRender(camera == null ? null : camera.method_19538(), pos, maxDistance, facing);
    }

    public static void clearTextureAvailability() {
        AVAILABLE_TEXTURES.clear();
        UNAVAILABLE_TEXTURES.clear();
    }

    public static void renderLiftDisplay(class_4587 matrices, class_4597 vertexConsumers, class_2338 pos, String floorNumber, Lift.LiftDirection liftDirection, float maxWidth, float height) {
        if (RenderTrains.shouldNotRender(pos, Math.min(16, maxTrainRenderDistance), null)) {
            return;
        }
        class_4597.class_4598 immediate = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
        IDrawing.drawStringWithFont(matrices, class_310.method_1551().field_1772, immediate, floorNumber, IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.BOTTOM, 0.0f, height, maxWidth, -1.0f, 18.0f / maxWidth, -65536, false, 0xF000F0, null);
        immediate.method_22993();
        if (liftDirection != Lift.LiftDirection.NONE) {
            IDrawing.drawTexture(matrices, vertexConsumers.getBuffer(MoreRenderLayers.getLight(ARROW_TEXTURE, true)), -maxWidth / 6.0f, 0.0f, maxWidth / 3.0f, maxWidth / 3.0f, 0.0f, liftDirection == Lift.LiftDirection.UP ? 0.0f : 1.0f, 1.0f, liftDirection == Lift.LiftDirection.UP ? 1.0f : 0.0f, class_2350.field_11036, -65536, 0xF000F0);
        }
    }

    public static boolean isHoldingRailRelated(class_1657 player) {
        return Utilities.isHolding(player, item -> item instanceof ItemNodeModifierBase || class_2248.method_9503((class_1792)item) instanceof BlockSignalLightBase || class_2248.method_9503((class_1792)item) instanceof BlockNode || class_2248.method_9503((class_1792)item) instanceof BlockSignalSemaphoreBase || class_2248.method_9503((class_1792)item) instanceof BlockPlatform);
    }

    public static boolean showShiftProgressBar() {
        class_310 client = class_310.method_1551();
        class_746 player = client.field_1724;
        float shiftHoldingTicks = ClientData.getShiftHoldingTicks();
        if (shiftHoldingTicks > 0.0f && player != null) {
            int progressFilled = class_3532.method_15340((int)((int)(shiftHoldingTicks * 30.0f / 30.0f)), (int)0, (int)30);
            String progressBar = String.format("\u00a76%s\u00a77%s", StringUtils.repeat((char)'|', (int)progressFilled), StringUtils.repeat((char)'|', (int)(30 - progressFilled)));
            player.method_7353((class_2561)Text.translatable("gui.mtr.dismount_hold", client.field_1690.field_1832.method_16007(), progressBar), true);
            return false;
        }
        return true;
    }

    @Deprecated
    public static void scheduleRender(class_2960 resourceLocation, boolean priority, Function<class_2960, class_1921> getVertexConsumer, BiConsumer<class_4587, class_4588> callback) {
        RenderTrains.scheduleRender(resourceLocation, priority, QueuedRenderLayer.EXTERIOR, callback);
    }

    public static void scheduleRender(class_2960 resourceLocation, boolean priority, QueuedRenderLayer queuedRenderLayer, BiConsumer<class_4587, class_4588> callback) {
        Map<class_2960, Set<BiConsumer<class_4587, class_4588>>> map = RENDERS.get(priority ? 1 : 0).get(queuedRenderLayer.ordinal());
        if (!map.containsKey(resourceLocation)) {
            map.put(resourceLocation, new HashSet());
        }
        map.get(resourceLocation).add(callback);
    }

    public static String getInterchangeRouteNames(Station station, Route thisRoute, Route nextRoute) {
        String thisRouteSplit = thisRoute.name.split("\\|\\|")[0];
        String nextRouteSplit = nextRoute == null ? null : nextRoute.name.split("\\|\\|")[0];
        Map<Integer, ClientCache.ColorNameTuple> routesInStation = ClientData.DATA_CACHE.stationIdToRoutes.get(station.id);
        if (routesInStation != null) {
            List<String> interchangeRoutes = routesInStation.values().stream().filter(interchangeRoute -> {
                String routeName = interchangeRoute.name.split("\\|\\|")[0];
                return !routeName.equals(thisRouteSplit) && !routeName.equals(nextRouteSplit);
            }).map(interchangeRoute -> interchangeRoute.name).collect(Collectors.toList());
            return IGui.mergeStationsWithCommas(interchangeRoutes);
        }
        return "";
    }

    private static double maxDistanceXZ(class_243 pos1, class_2338 pos2) {
        return Math.max(Math.abs(pos1.field_1352 - (double)pos2.method_10263()), Math.abs(pos1.field_1350 - (double)pos2.method_10260()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean shouldNotRender(class_243 cameraPos, class_2338 pos, int maxDistance, class_2350 facing) {
        double playerZOffset;
        double playerXOffset;
        boolean playerFacingAway = cameraPos == null || facing == null ? false : (facing.method_10166() == class_2350.class_2351.field_11048 ? Math.signum(playerXOffset = cameraPos.field_1352 - (double)pos.method_10263() - 0.5) == (double)facing.method_10148() && Math.abs(playerXOffset) >= 0.5 : Math.signum(playerZOffset = cameraPos.field_1350 - (double)pos.method_10260() - 0.5) == (double)facing.method_10165() && Math.abs(playerZOffset) >= 0.5);
        if (cameraPos == null) return true;
        if (playerFacingAway) return true;
        double d = RenderTrains.maxDistanceXZ(cameraPos, pos);
        int n = MTRClient.isReplayMod() ? 1024 : maxDistance;
        if (!(d > (double)n)) return false;
        return true;
    }

    private static void renderRailStandard(class_1937 world, Rail rail, float yOffset, boolean renderColors, float railWidth) {
        RenderTrains.renderRailStandard(world, rail, yOffset, renderColors, railWidth, renderColors && rail.railType == RailType.QUARTZ ? "mtr:textures/block/rail_preview.png" : "textures/block/rail.png", -1.0f, -1.0f, -1.0f, -1.0f);
    }

    private static void renderRailStandard(class_1937 world, Rail rail, float yOffset, boolean renderColors, float railWidth, String texture, float u1, float v1, float u2, float v2) {
        int maxRailDistance = UtilitiesClient.getRenderDistance() * 16;
        rail.render((x1, z1, x2, z2, x3, z3, x4, z4, y1, y2) -> {
            class_2338 pos2 = RailwayData.newBlockPos(x1, y1, z1);
            if (RenderTrains.shouldNotRender(pos2, maxRailDistance, null)) {
                return;
            }
            int light2 = class_765.method_23687((int)world.method_8314(class_1944.field_9282, pos2), (int)world.method_8314(class_1944.field_9284, pos2));
            if (rail.railType == RailType.NONE) {
                if (rail.transportMode != TransportMode.CABLE_CAR && renderColors) {
                    RenderTrains.scheduleRender(new class_2960("mtr:textures/block/one_way_rail_arrow.png"), false, QueuedRenderLayer.EXTERIOR, (class_4587 matrices, class_4588 vertexConsumer) -> {
                        IDrawing.drawTexture(matrices, vertexConsumer, (float)x1, (float)y1 + yOffset, (float)z1, (float)x2, (float)y1 + yOffset + 0.003125f, (float)z2, (float)x3, (float)y2 + yOffset, (float)z3, (float)x4, (float)y2 + yOffset + 0.003125f, (float)z4, 0.0f, 0.25f, 1.0f, 0.75f, class_2350.field_11036, -1, light2);
                        IDrawing.drawTexture(matrices, vertexConsumer, (float)x2, (float)y1 + yOffset + 0.003125f, (float)z2, (float)x1, (float)y1 + yOffset, (float)z1, (float)x4, (float)y2 + yOffset + 0.003125f, (float)z4, (float)x3, (float)y2 + yOffset, (float)z3, 0.0f, 0.25f, 1.0f, 0.75f, class_2350.field_11036, -1, light2);
                    });
                }
            } else {
                float textureOffset = (float)((int)(x1 + z1) % 4) * 0.25f + (float)Config.trackTextureOffset() / 32.0f;
                int color = renderColors || !Config.hideSpecialRailColors() && rail.railType.hasSavedRail ? rail.railType.color : -1;
                RenderTrains.scheduleRender(new class_2960(texture), false, QueuedRenderLayer.EXTERIOR, (class_4587 matrices, class_4588 vertexConsumer) -> {
                    IDrawing.drawTexture(matrices, vertexConsumer, (float)x1, (float)y1 + yOffset, (float)z1, (float)x2, (float)y1 + yOffset + 0.003125f, (float)z2, (float)x3, (float)y2 + yOffset, (float)z3, (float)x4, (float)y2 + yOffset + 0.003125f, (float)z4, u1 < 0.0f ? 0.0f : u1, v1 < 0.0f ? 0.1875f + textureOffset : v1, u2 < 0.0f ? 1.0f : u2, v2 < 0.0f ? 0.3125f + textureOffset : v2, class_2350.field_11036, color, light2);
                    IDrawing.drawTexture(matrices, vertexConsumer, (float)x2, (float)y1 + yOffset + 0.003125f, (float)z2, (float)x1, (float)y1 + yOffset, (float)z1, (float)x4, (float)y2 + yOffset + 0.003125f, (float)z4, (float)x3, (float)y2 + yOffset, (float)z3, u1 < 0.0f ? 0.0f : u1, v1 < 0.0f ? 0.1875f + textureOffset : v1, u2 < 0.0f ? 1.0f : u2, v2 < 0.0f ? 0.3125f + textureOffset : v2, class_2350.field_11036, color, light2);
                });
            }
        }, -railWidth, railWidth);
    }

    private static void renderSignalsStandard(class_1937 world, class_4587 matrices, class_4597 vertexConsumers, Rail rail, class_2338 startPos, class_2338 endPos) {
        int maxRailDistance = UtilitiesClient.getRenderDistance() * 16;
        List<SignalBlocks.SignalBlock> signalBlocks = ClientData.SIGNAL_BLOCKS.getSignalBlocksAtTrack(PathData.getRailProduct(startPos, endPos));
        float width = 1.0f / (float)class_1767.values().length;
        for (int i = 0; i < signalBlocks.size(); ++i) {
            SignalBlocks.SignalBlock signalBlock = signalBlocks.get(i);
            boolean shouldGlow = signalBlock.isOccupied() && (int)Math.floor(MTRClient.getGameTick()) % 20 < 10;
            class_4588 vertexConsumer = shouldGlow ? vertexConsumers.getBuffer(MoreRenderLayers.getLight(new class_2960("mtr:textures/block/white.png"), false)) : vertexConsumers.getBuffer(MoreRenderLayers.getExterior(new class_2960("textures/block/white_wool.png")));
            float u1 = width * (float)i + 1.0f - width * (float)signalBlocks.size() / 2.0f;
            float u2 = u1 + width;
            int color = 0xFF000000 | signalBlock.color.method_7794().field_16011;
            rail.render((x1, z1, x2, z2, x3, z3, x4, z4, y1, y2) -> {
                class_2338 pos2 = RailwayData.newBlockPos(x1, y1, z1);
                if (RenderTrains.shouldNotRender(pos2, maxRailDistance, null)) {
                    return;
                }
                int light2 = shouldGlow ? 0xF000F0 : class_765.method_23687((int)world.method_8314(class_1944.field_9282, pos2), (int)world.method_8314(class_1944.field_9284, pos2));
                IDrawing.drawTexture(matrices, vertexConsumer, (float)x1, (float)y1, (float)z1, (float)x2, (float)y1 + 0.003125f, (float)z2, (float)x3, (float)y2, (float)z3, (float)x4, (float)y2 + 0.003125f, (float)z4, u1, 0.0f, u2, 1.0f, class_2350.field_11036, color, light2);
                IDrawing.drawTexture(matrices, vertexConsumer, (float)x4, (float)y2 + 0.003125f, (float)z4, (float)x3, (float)y2, (float)z3, (float)x2, (float)y1 + 0.003125f, (float)z2, (float)x1, (float)y1, (float)z1, u1, 0.0f, u2, 1.0f, class_2350.field_11036, color, light2);
            }, u1 - 1.0f, u2 - 1.0f);
        }
    }

    private static class_2561 getStationText(Station station, String textKey) {
        if (station != null) {
            return Text.literal(IGui.formatStationName(IGui.insertTranslation("gui.mtr." + textKey + "_station_cjk", "gui.mtr." + textKey + "_station", 1, IGui.textOrUntitled(station.name))));
        }
        return Text.literal("");
    }

    private static /* synthetic */ void lambda$render$9(class_746 player, int maxRailDistance, Map renderedRailMap, class_1937 world, boolean renderColors, class_4587 matrices, class_4597 vertexConsumers, class_2338 startPos, Map railMap) {
        railMap.forEach((endPos, rail) -> {
            if (!RailwayData.isBetween(player.method_23317(), startPos.method_10263(), endPos.method_10263(), maxRailDistance) || !RailwayData.isBetween(player.method_23321(), startPos.method_10260(), endPos.method_10260(), maxRailDistance)) {
                return;
            }
            UUID railProduct = PathData.getRailProduct(startPos, endPos);
            if (renderedRailMap.containsKey(railProduct)) {
                if (renderedRailMap.get(railProduct) == rail.railType) {
                    return;
                }
            } else {
                renderedRailMap.put(railProduct, rail.railType);
            }
            switch (rail.transportMode) {
                case TRAIN: {
                    RenderTrains.renderRailStandard(world, rail, 0.065625f, renderColors, 1.0f);
                    if (!renderColors) break;
                    RenderTrains.renderSignalsStandard(world, matrices, vertexConsumers, rail, startPos, endPos);
                    break;
                }
                case BOAT: {
                    if (!renderColors) break;
                    RenderTrains.renderRailStandard(world, rail, 0.065625f, true, 0.5f);
                    RenderTrains.renderSignalsStandard(world, matrices, vertexConsumers, rail, startPos, endPos);
                    break;
                }
                case CABLE_CAR: {
                    if (rail.railType.hasSavedRail || rail.railType == RailType.CABLE_CAR_STATION) {
                        RenderTrains.renderRailStandard(world, rail, 0.253125f, renderColors, 0.25f, "mtr:textures/block/metal.png", 0.25f, 0.0f, 0.75f, 1.0f);
                    }
                    if (renderColors && !rail.railType.hasSavedRail) {
                        RenderTrains.renderRailStandard(world, rail, 0.503125f, true, 1.0f, "mtr:textures/block/one_way_rail_arrow.png", 0.0f, 0.75f, 1.0f, 0.25f);
                    }
                    if (rail.railType == RailType.NONE) break;
                    rail.render((x1, z1, x2, z2, x3, z3, x4, z4, y1, y2) -> {
                        int r = renderColors ? rail.railType.color >> 16 & 0xFF : 0;
                        int g = renderColors ? rail.railType.color >> 8 & 0xFF : 0;
                        int b = renderColors ? rail.railType.color & 0xFF : 0;
                        IDrawing.drawLine(matrices, vertexConsumers, (float)x1, (float)y1 + 0.5f, (float)z1, (float)x3, (float)y2 + 0.5f, (float)z3, r, g, b);
                    }, 0.0f, 0.0f);
                    break;
                }
                case AIRPLANE: {
                    if (renderColors) {
                        RenderTrains.renderRailStandard(world, rail, 0.065625f, true, 1.0f);
                        RenderTrains.renderSignalsStandard(world, matrices, vertexConsumers, rail, startPos, endPos);
                        break;
                    }
                    RenderTrains.renderRailStandard(world, rail, 0.065625f, false, 0.25f, "textures/block/iron_block.png", 0.25f, 0.0f, 0.75f, 1.0f);
                }
            }
        });
    }

    private static /* synthetic */ void lambda$render$6(class_1937 world, class_4587 matrices, class_4597 vertexConsumers, float newLastFrameDuration, LiftClient lift) {
        lift.tickClient(world, (x, y, z, frontDoorValue, backDoorValue) -> {
            class_2338 posAverage = TrainRendererBase.applyAverageTransform(lift.getViewOffset(), x, y, z);
            if (posAverage == null) {
                return;
            }
            matrices.method_22904(x, y, z);
            UtilitiesClient.rotateXDegrees(matrices, 180.0f);
            UtilitiesClient.rotateYDegrees(matrices, 180.0f + lift.facing.method_10144());
            int light = class_765.method_23687((int)world.method_8314(class_1944.field_9282, posAverage), (int)world.method_8314(class_1944.field_9284, posAverage));
            new ModelLift1(lift.liftHeight, lift.liftWidth, lift.liftDepth, lift.isDoubleSided).render(matrices, vertexConsumers, lift, LIFT_TEXTURE, light, frontDoorValue, backDoorValue, false, 0, 1, false, true, false, false, false);
            for (int i = 0; i < (lift.isDoubleSided ? 2 : 1); ++i) {
                UtilitiesClient.rotateYDegrees(matrices, 180.0f);
                matrices.method_22903();
                matrices.method_22904(0.875, -1.5, (double)((float)lift.liftDepth / 2.0f) - 0.25 - (double)0.003125f);
                RenderTrains.renderLiftDisplay(matrices, vertexConsumers, posAverage, ClientData.DATA_CACHE.requestLiftFloorText(lift.getCurrentFloorBlockPos())[0], lift.getLiftDirection(), 0.1875f, 0.3125f);
                matrices.method_22909();
            }
            matrices.method_22909();
        }, newLastFrameDuration);
    }

    private static /* synthetic */ void lambda$render$4(class_1937 world, float newLastFrameDuration, class_746 player, boolean useAnnouncements, TrainClient train) {
        train.simulateTrain(world, newLastFrameDuration, (speed, stopIndex, routeIds) -> {
            Route thisRoute = train.getThisRoute();
            Station thisStation = train.getThisStation();
            Station nextStation = train.getNextStation();
            Station lastStation = train.getLastStation();
            if (!(!RenderTrains.showShiftProgressBar() || train.isCurrentlyManual() && Train.isHoldingKey((class_1657)player))) {
                if (speed > 5.0f || thisRoute == null || thisStation == null || lastStation == null) {
                    player.method_7353((class_2561)Text.translatable("gui.mtr.vehicle_speed", Float.valueOf(RailwayData.round(speed, 1)), Float.valueOf(RailwayData.round(speed * 3.6f, 1))), true);
                } else {
                    player.method_7353(switch ((int)(System.currentTimeMillis() / 1000L % 3L)) {
                        default -> RenderTrains.getStationText(thisStation, "this");
                        case 1 -> {
                            if (nextStation == null) {
                                yield RenderTrains.getStationText(thisStation, "this");
                            }
                            yield RenderTrains.getStationText(nextStation, "next");
                        }
                        case 2 -> RenderTrains.getStationText(lastStation, "last_" + thisRoute.transportMode.toString().toLowerCase(Locale.ENGLISH));
                    }, true);
                }
            }
        }, (stopIndex, routeIds) -> {
            Route thisRoute = train.getThisRoute();
            Route nextRoute = train.getNextRoute();
            Station nextStation = train.getNextStation();
            Station lastStation = train.getLastStation();
            if (useAnnouncements && thisRoute != null && nextStation != null && !thisRoute.disableNextStationAnnouncements) {
                Station nextFinalStation;
                String nextRouteSplit;
                ArrayList<String> messages = new ArrayList<String>();
                boolean isLightRailRoute = thisRoute.isLightRailRoute;
                messages.add(IGui.insertTranslation(isLightRailRoute ? "gui.mtr.next_station_light_rail_announcement_cjk" : "gui.mtr.next_station_announcement_cjk", isLightRailRoute ? "gui.mtr.next_station_light_rail_announcement" : "gui.mtr.next_station_announcement", 1, nextStation.name));
                String mergedInterchangeRoutes = RenderTrains.getInterchangeRouteNames(nextStation, thisRoute, nextRoute);
                if (!mergedInterchangeRoutes.isEmpty()) {
                    messages.add(IGui.insertTranslation("gui.mtr.interchange_announcement_cjk", "gui.mtr.interchange_announcement", 1, mergedInterchangeRoutes));
                }
                ArrayList<String> connectingStationList = new ArrayList<String>();
                ((Set)ClientData.DATA_CACHE.stationIdToConnectingStations.get(nextStation)).forEach(connectingStation -> {
                    String connectingStationMergedInterchangeRoutes = RenderTrains.getInterchangeRouteNames(connectingStation, thisRoute, nextRoute);
                    if (!connectingStationMergedInterchangeRoutes.isEmpty()) {
                        connectingStationList.add(IGui.insertTranslation("gui.mtr.connecting_station_interchange_announcement_part_cjk", "gui.mtr.connecting_station_interchange_announcement_part", 2, connectingStationMergedInterchangeRoutes, connectingStation.name));
                    }
                });
                if (!connectingStationList.isEmpty()) {
                    messages.add(IGui.insertTranslation("gui.mtr.connecting_station_part_cjk", "gui.mtr.connecting_station_part", 1, IGui.mergeStationsWithCommas(connectingStationList)));
                }
                String thisRouteSplit = thisRoute.name.split("\\|\\|")[0];
                String string = nextRouteSplit = nextRoute == null ? null : nextRoute.name.split("\\|\\|")[0];
                if (lastStation != null && nextStation.id == lastStation.id && nextRoute != null && !nextRoute.platformIds.isEmpty() && !nextRouteSplit.equals(thisRouteSplit) && (nextFinalStation = (Station)ClientData.DATA_CACHE.platformIdToStation.get(nextRoute.getLastPlatformId())) != null) {
                    String modeString = thisRoute.transportMode.toString().toLowerCase(Locale.ENGLISH);
                    if (nextRoute.isLightRailRoute) {
                        messages.add(IGui.insertTranslation("gui.mtr.next_route_" + modeString + "_light_rail_announcement_cjk", "gui.mtr.next_route_" + modeString + "_light_rail_announcement", nextRoute.lightRailRouteNumber, 1, nextFinalStation.name.split("\\|\\|")[0]));
                    } else {
                        messages.add(IGui.insertTranslation("gui.mtr.next_route_" + modeString + "_announcement_cjk", "gui.mtr.next_route_" + modeString + "_announcement", 2, nextRouteSplit, nextFinalStation.name.split("\\|\\|")[0]));
                    }
                }
                IDrawing.narrateOrAnnounce(IGui.mergeStations(messages, "", " "));
            }
        }, (stopIndex, routeIds) -> {
            Route thisRoute = train.getThisRoute();
            Station lastStation = train.getLastStation();
            if (useAnnouncements && thisRoute != null && thisRoute.isLightRailRoute && lastStation != null) {
                IDrawing.narrateOrAnnounce(IGui.insertTranslation("gui.mtr.light_rail_route_announcement_cjk", "gui.mtr.light_rail_route_announcement", thisRoute.lightRailRouteNumber, 1, lastStation.name));
            }
        });
    }

    static {
        creatorProperties = new ResourcePackCreatorProperties();
        AVAILABLE_TEXTURES = new HashSet<String>();
        UNAVAILABLE_TEXTURES = new HashSet<String>();
        RENDERS = new ArrayList<List<Map<class_2960, Set<BiConsumer<class_4587, class_4588>>>>>(2);
        CURRENT_RENDERS = new ArrayList<List<Map<class_2960, Set<BiConsumer<class_4587, class_4588>>>>>(2);
        LIFT_TEXTURE = new class_2960("mtr:textures/entity/lift_1.png");
        ARROW_TEXTURE = new class_2960("mtr:textures/block/sign/lift_arrow.png");
        for (int i = 0; i < 2; ++i) {
            int renderStageCount = QueuedRenderLayer.values().length;
            ArrayList rendersList = new ArrayList(renderStageCount);
            ArrayList currentRendersList = new ArrayList(renderStageCount);
            for (int j = 0; j < renderStageCount; ++j) {
                rendersList.add(j, new HashMap());
                currentRendersList.add(j, new HashMap());
            }
            RENDERS.add(i, rendersList);
            CURRENT_RENDERS.add(i, currentRendersList);
        }
    }

    public static enum QueuedRenderLayer {
        LIGHT,
        LIGHT_TRANSLUCENT,
        INTERIOR,
        EXTERIOR;

    }
}

