/*
 * Decompiled with CFR 0.152.
 */
package mtr.render;

import java.util.UUID;
import mtr.MTRClient;
import mtr.client.Config;
import mtr.data.RailwayData;
import mtr.data.TrainClient;
import mtr.entity.EntitySeat;
import mtr.mappings.Utilities;
import mtr.mappings.UtilitiesClient;
import mtr.render.RenderTrains;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_746;
import net.minecraft.class_898;

public abstract class TrainRendererBase {
    protected static class_4184 camera;
    protected static class_1937 world;
    protected static float lastFrameDuration;
    protected static class_4587 matrices;
    protected static class_4597 vertexConsumers;
    protected static boolean isTranslucentBatch;
    private static class_1297 cameraEntity;
    private static boolean hasEntity;
    private static double entityX;
    private static double entityY;
    private static double entityZ;
    private static class_898 entityRenderDispatcher;
    private static class_746 player;
    private static class_243 playerEyePosition;

    public abstract TrainRendererBase createTrainInstance(TrainClient var1);

    public abstract void renderCar(int var1, double var2, double var4, double var6, float var8, float var9, boolean var10, boolean var11);

    public abstract void renderConnection(class_243 var1, class_243 var2, class_243 var3, class_243 var4, class_243 var5, class_243 var6, class_243 var7, class_243 var8, double var9, double var11, double var13, float var15, float var16);

    public abstract void renderBarrier(class_243 var1, class_243 var2, class_243 var3, class_243 var4, class_243 var5, class_243 var6, class_243 var7, class_243 var8, double var9, double var11, double var13, float var15, float var16);

    public static void renderRidingPlayer(class_243 viewOffset, UUID playerId, class_243 playerPositionOffset) {
        class_2338 posAverage = TrainRendererBase.applyAverageTransform(viewOffset, playerPositionOffset.field_1352, playerPositionOffset.field_1351, playerPositionOffset.field_1350);
        if (posAverage == null) {
            return;
        }
        matrices.method_46416(0.0f, 1000.0f, 0.0f);
        class_1657 renderPlayer = world.method_18470(playerId);
        if (renderPlayer != null && (!playerId.equals(player.method_5667()) || camera.method_19333())) {
            entityRenderDispatcher.method_3954((class_1297)renderPlayer, playerPositionOffset.field_1352, playerPositionOffset.field_1351, playerPositionOffset.field_1350, 0.0f, 1.0f, matrices, vertexConsumers, 0xF000F0);
        }
        matrices.method_22909();
    }

    public static void setupStaticInfo(class_4587 matrices, class_4597 vertexConsumers, EntitySeat entity, float tickDelta) {
        class_310 client = class_310.method_1551();
        camera = client.field_1773.method_19418();
        entityRenderDispatcher = client.method_1561();
        world = client.field_1687;
        player = client.field_1724;
        lastFrameDuration = MTRClient.getLastFrameDuration();
        TrainRendererBase.matrices = matrices;
        TrainRendererBase.vertexConsumers = vertexConsumers;
        cameraEntity = client.field_1719;
        hasEntity = entity != null;
        entityX = hasEntity ? class_3532.method_16436((double)tickDelta, (double)entity.field_6038, (double)entity.method_23317()) : 0.0;
        entityY = hasEntity ? class_3532.method_16436((double)tickDelta, (double)entity.field_5971, (double)entity.method_23318()) : 0.0;
        entityZ = hasEntity ? class_3532.method_16436((double)tickDelta, (double)entity.field_5989, (double)entity.method_23321()) : 0.0;
        playerEyePosition = player == null ? class_243.field_1353 : player.method_5836(client.method_1488());
    }

    public static void setBatch(boolean isTranslucentBatch) {
        TrainRendererBase.isTranslucentBatch = isTranslucentBatch;
    }

    public static class_2338 applyAverageTransform(class_243 viewOffset, double x, double y, double z) {
        boolean noOffset = viewOffset == null;
        class_243 cameraPos = cameraEntity == null ? null : cameraEntity.method_19538();
        class_2338 posAverage = RailwayData.newBlockPos(x + (noOffset || cameraPos == null ? 0.0 : cameraPos.field_1352), y + (noOffset || cameraPos == null ? 0.0 : cameraPos.field_1351), z + (noOffset || cameraPos == null ? 0.0 : cameraPos.field_1350));
        if (RenderTrains.shouldNotRender(posAverage, UtilitiesClient.getRenderDistance() * (Config.trainRenderDistanceRatio() + 1), null)) {
            return null;
        }
        matrices.method_22903();
        if (viewOffset != null) {
            double offsetZ;
            double offsetY;
            double offsetX;
            if (MTRClient.isVivecraft() && hasEntity) {
                offsetX = entityX;
                offsetY = entityY;
                offsetZ = entityZ;
            } else {
                class_243 cameraOffset = camera.method_19333() ? playerEyePosition : camera.method_19326();
                offsetX = cameraOffset.field_1352;
                offsetY = cameraOffset.field_1351;
                offsetZ = cameraOffset.field_1350;
            }
            float cameraYaw = camera.method_19330();
            matrices.method_22904(offsetX, offsetY, offsetZ);
            UtilitiesClient.rotateYDegrees(matrices, Utilities.getYaw((class_1297)player) - cameraYaw + (float)(Math.abs(Utilities.getYaw((class_1297)player) - cameraYaw) > 90.0f ? 180 : 0));
            matrices.method_22904(-viewOffset.field_1352, -viewOffset.field_1351, -viewOffset.field_1350);
        }
        return posAverage;
    }
}

