/*
 * Decompiled with CFR 0.152.
 */
package mtr.screen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mtr.client.ClientData;
import mtr.client.IDrawing;
import mtr.data.IGui;
import mtr.data.NameColorDataBase;
import mtr.mappings.Text;
import mtr.mappings.UtilitiesClient;
import mtr.screen.WidgetBetterTextField;
import mtr.screen.WidgetSilentImageButton;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_329;
import net.minecraft.class_339;
import net.minecraft.class_344;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4588;

public class DashboardList
implements IGui {
    public int x;
    public int y;
    public int width;
    public int height;
    private final WidgetBetterTextField textFieldSearch;
    private final class_344 buttonPrevPage;
    private final class_344 buttonNextPage;
    private final class_344 buttonFind;
    private final class_344 buttonDrawArea;
    private final class_344 buttonEdit;
    private final class_344 buttonUp;
    private final class_344 buttonDown;
    private final class_344 buttonAdd;
    private final class_344 buttonDelete;
    private final Supplier<String> getSearch;
    private final Consumer<String> setSearch;
    private List<NameColorDataBase> dataSorted = new ArrayList<NameColorDataBase>();
    private final Map<Integer, NameColorDataBase> dataFiltered = new HashMap<Integer, NameColorDataBase>();
    private int hoverIndex;
    private int page;
    private int totalPages;
    private boolean hasFind;
    private boolean hasDrawArea;
    private boolean hasEdit;
    private boolean hasSort;
    private boolean hasAdd;
    private boolean hasDelete;
    private static final int TOP_OFFSET = 24;

    public <T> DashboardList(BiConsumer<NameColorDataBase, Integer> onFind, BiConsumer<NameColorDataBase, Integer> onDrawArea, BiConsumer<NameColorDataBase, Integer> onEdit, Runnable onSort, BiConsumer<NameColorDataBase, Integer> onAdd, BiConsumer<NameColorDataBase, Integer> onDelete, Supplier<List<T>> getList, Supplier<String> getSearch, Consumer<String> setSearch) {
        this(onFind, onDrawArea, onEdit, onSort, onAdd, onDelete, getList, getSearch, setSearch, true);
    }

    public <T> DashboardList(BiConsumer<NameColorDataBase, Integer> onFind, BiConsumer<NameColorDataBase, Integer> onDrawArea, BiConsumer<NameColorDataBase, Integer> onEdit, Runnable onSort, BiConsumer<NameColorDataBase, Integer> onAdd, BiConsumer<NameColorDataBase, Integer> onDelete, Supplier<List<T>> getList, Supplier<String> getSearch, Consumer<String> setSearch, boolean playSound) {
        this.getSearch = getSearch;
        this.setSearch = setSearch;
        this.textFieldSearch = new WidgetBetterTextField(Text.translatable("gui.mtr.search", new Object[0]).getString());
        this.buttonPrevPage = new class_344(0, 0, 0, 20, 0, 0, 20, new class_2960("mtr:textures/gui/icon_left.png"), 20, 40, button -> this.setPage(this.page - 1));
        this.buttonNextPage = new class_344(0, 0, 0, 20, 0, 0, 20, new class_2960("mtr:textures/gui/icon_right.png"), 20, 40, button -> this.setPage(this.page + 1));
        this.buttonFind = new WidgetSilentImageButton(0, 0, 0, 20, 0, 0, 20, new class_2960("mtr:textures/gui/icon_find.png"), 20, 40, button -> this.onClick(onFind), playSound);
        this.buttonDrawArea = new class_344(0, 0, 0, 20, 0, 0, 20, new class_2960("mtr:textures/gui/icon_draw_area.png"), 20, 40, button -> this.onClick(onDrawArea));
        this.buttonEdit = new class_344(0, 0, 0, 20, 0, 0, 20, new class_2960("mtr:textures/gui/icon_edit.png"), 20, 40, button -> this.onClick(onEdit));
        this.buttonUp = new class_344(0, 0, 0, 20, 0, 0, 20, new class_2960("mtr:textures/gui/icon_up.png"), 20, 40, button -> {
            this.onUp(getList);
            onSort.run();
        });
        this.buttonDown = new class_344(0, 0, 0, 20, 0, 0, 20, new class_2960("mtr:textures/gui/icon_down.png"), 20, 40, button -> {
            this.onDown(getList);
            onSort.run();
        });
        this.buttonAdd = new class_344(0, 0, 0, 20, 0, 0, 20, new class_2960("mtr:textures/gui/icon_add.png"), 20, 40, button -> this.onClick(onAdd));
        this.buttonDelete = new class_344(0, 0, 0, 20, 0, 0, 20, new class_2960("mtr:textures/gui/icon_delete.png"), 20, 40, button -> this.onClick(onDelete));
    }

    public void init(Consumer<class_339> addDrawableChild) {
        IDrawing.setPositionAndWidth((class_339)this.buttonPrevPage, this.x, this.y + 2, 20);
        IDrawing.setPositionAndWidth((class_339)this.buttonNextPage, this.x + 60, this.y + 2, 20);
        IDrawing.setPositionAndWidth((class_339)this.textFieldSearch, this.x + 80 + 2, this.y + 2, this.width - 80 - 4);
        this.textFieldSearch.method_1863(this.setSearch);
        this.textFieldSearch.method_1852(this.getSearch.get());
        this.buttonFind.field_22764 = false;
        this.buttonDrawArea.field_22764 = false;
        this.buttonEdit.field_22764 = false;
        this.buttonUp.field_22764 = false;
        this.buttonDown.field_22764 = false;
        this.buttonAdd.field_22764 = false;
        this.buttonDelete.field_22764 = false;
        addDrawableChild.accept((class_339)this.buttonPrevPage);
        addDrawableChild.accept((class_339)this.buttonNextPage);
        addDrawableChild.accept((class_339)this.buttonFind);
        addDrawableChild.accept((class_339)this.buttonDrawArea);
        addDrawableChild.accept((class_339)this.buttonEdit);
        addDrawableChild.accept((class_339)this.buttonUp);
        addDrawableChild.accept((class_339)this.buttonDown);
        addDrawableChild.accept((class_339)this.buttonAdd);
        addDrawableChild.accept((class_339)this.buttonDelete);
        addDrawableChild.accept((class_339)this.textFieldSearch);
    }

    public void tick() {
        this.textFieldSearch.method_1865();
        UtilitiesClient.setWidgetX((class_339)this.buttonPrevPage, this.x);
        UtilitiesClient.setWidgetX((class_339)this.buttonNextPage, this.x + 60);
        UtilitiesClient.setWidgetX((class_339)this.textFieldSearch, this.x + 80 + 2);
        String text = this.textFieldSearch.method_1882();
        this.dataFiltered.clear();
        for (int i = 0; i < this.dataSorted.size(); ++i) {
            if (!this.dataSorted.get((int)i).name.toLowerCase(Locale.ENGLISH).contains(text.toLowerCase(Locale.ENGLISH))) continue;
            this.dataFiltered.put(i, this.dataSorted.get(i));
        }
        int dataSize = this.dataFiltered.size();
        this.totalPages = dataSize == 0 ? 1 : (int)Math.ceil((double)dataSize / (double)this.itemsToShow());
        this.setPage(this.page);
    }

    public void setData(Set<? extends NameColorDataBase> dataSet, boolean hasFind, boolean hasDrawArea, boolean hasEdit, boolean hasSort, boolean hasAdd, boolean hasDelete) {
        ArrayList<? extends NameColorDataBase> dataList = new ArrayList<NameColorDataBase>(dataSet);
        Collections.sort(dataList);
        this.setData(dataList, hasFind, hasDrawArea, hasEdit, hasSort, hasAdd, hasDelete);
    }

    public void setData(List<? extends NameColorDataBase> dataList, boolean hasFind, boolean hasDrawArea, boolean hasEdit, boolean hasSort, boolean hasAdd, boolean hasDelete) {
        this.dataSorted = new ArrayList<NameColorDataBase>(dataList);
        this.hasFind = hasFind;
        boolean hasPermission = ClientData.hasPermission();
        this.hasDrawArea = hasPermission && hasDrawArea;
        this.hasEdit = hasPermission && hasEdit;
        this.hasSort = hasPermission && hasSort;
        this.hasAdd = hasPermission && hasAdd;
        this.hasDelete = hasPermission && hasDelete;
    }

    public void render(class_4587 matrices, class_327 textRenderer) {
        class_329.method_25300((class_4587)matrices, (class_327)textRenderer, (String)String.format("%s/%s", this.page + 1, this.totalPages), (int)(this.x + 40), (int)(this.y + 6 + 2), (int)-1);
        int itemsToShow = this.itemsToShow();
        for (int i = 0; i < itemsToShow; ++i) {
            if (i + itemsToShow * this.page >= this.dataFiltered.size()) continue;
            int drawY = 20 * i + 6 + 24;
            ArrayList<Integer> sortedKeys = new ArrayList<Integer>(this.dataFiltered.keySet());
            Collections.sort(sortedKeys);
            NameColorDataBase data = this.dataFiltered.get(sortedKeys.get(i + itemsToShow * this.page));
            class_289 tesselator = class_289.method_1348();
            class_287 buffer = tesselator.method_1349();
            UtilitiesClient.beginDrawingRectangle(buffer);
            IDrawing.drawRectangle((class_4588)buffer, this.x + 6, this.y + drawY, this.x + 6 + 8, this.y + drawY + 8, 0xFF000000 | data.color);
            tesselator.method_1350();
            UtilitiesClient.finishDrawingRectangle();
            String drawString = IGui.formatStationName(data.name);
            int textStart = 20;
            int textWidth = textRenderer.method_1727(drawString);
            int availableSpace = this.width - 20;
            matrices.method_22903();
            matrices.method_46416((float)(this.x + 20), 0.0f, 0.0f);
            if (textWidth > availableSpace) {
                matrices.method_22905((float)availableSpace / (float)textWidth, 1.0f, 1.0f);
            }
            textRenderer.method_1729(matrices, drawString, 0.0f, (float)(this.y + drawY), -1);
            matrices.method_22909();
        }
    }

    public void mouseMoved(double mouseX, double mouseY) {
        this.buttonFind.field_22764 = false;
        this.buttonDrawArea.field_22764 = false;
        this.buttonEdit.field_22764 = false;
        this.buttonUp.field_22764 = false;
        this.buttonDown.field_22764 = false;
        this.buttonAdd.field_22764 = false;
        this.buttonDelete.field_22764 = false;
        if (mouseX >= (double)this.x && mouseX < (double)(this.x + this.width) && mouseY >= (double)(this.y + 24) && mouseY < (double)(this.y + 24 + 20 * this.itemsToShow())) {
            boolean hasSortFiltered;
            this.hoverIndex = ((int)mouseY - this.y - 24) / 20;
            int dataSize = this.dataFiltered.size();
            int itemsToShow = this.itemsToShow();
            boolean bl = hasSortFiltered = this.hasSort && dataSize == this.dataSorted.size();
            if (this.hoverIndex >= 0 && this.hoverIndex + this.page * itemsToShow < dataSize) {
                this.buttonFind.field_22764 = this.hasFind;
                this.buttonDrawArea.field_22764 = this.hasDrawArea;
                this.buttonEdit.field_22764 = this.hasEdit;
                this.buttonUp.field_22764 = hasSortFiltered;
                this.buttonDown.field_22764 = hasSortFiltered;
                this.buttonAdd.field_22764 = this.hasAdd;
                this.buttonDelete.field_22764 = this.hasDelete;
                this.buttonUp.field_22763 = this.hoverIndex + itemsToShow * this.page > 0;
                this.buttonDown.field_22763 = this.hoverIndex + itemsToShow * this.page < dataSize - 1;
                int renderOffset = this.y + this.hoverIndex * 20 + 24;
                IDrawing.setPositionAndWidth((class_339)this.buttonFind, this.x + this.width - 20 * (1 + (this.hasDelete ? 1 : 0) + (this.hasAdd ? 1 : 0) + (hasSortFiltered ? 2 : 0) + (this.hasEdit ? 1 : 0) + (this.hasDrawArea ? 1 : 0)), renderOffset, 20);
                IDrawing.setPositionAndWidth((class_339)this.buttonDrawArea, this.x + this.width - 20 * (1 + (this.hasDelete ? 1 : 0) + (this.hasAdd ? 1 : 0) + (hasSortFiltered ? 2 : 0) + (this.hasEdit ? 1 : 0)), renderOffset, 20);
                IDrawing.setPositionAndWidth((class_339)this.buttonEdit, this.x + this.width - 20 * (1 + (this.hasDelete ? 1 : 0) + (this.hasAdd ? 1 : 0) + (hasSortFiltered ? 2 : 0)), renderOffset, 20);
                IDrawing.setPositionAndWidth((class_339)this.buttonUp, this.x + this.width - 20 * (2 + (this.hasDelete ? 1 : 0) + (this.hasAdd ? 1 : 0)), renderOffset, 20);
                IDrawing.setPositionAndWidth((class_339)this.buttonDown, this.x + this.width - 20 * (1 + (this.hasDelete ? 1 : 0) + (this.hasAdd ? 1 : 0)), renderOffset, 20);
                IDrawing.setPositionAndWidth((class_339)this.buttonAdd, this.x + this.width - 20 * (1 + (this.hasDelete ? 1 : 0)), renderOffset, 20);
                IDrawing.setPositionAndWidth((class_339)this.buttonDelete, this.x + this.width - 20, renderOffset, 20);
            }
        }
    }

    public void mouseScrolled(double mouseX, double mouseY, double amount) {
        if (mouseX >= (double)this.x && mouseX < (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY < (double)(this.y + this.height)) {
            this.setPage(this.page + (int)Math.signum(-amount));
        }
    }

    public void clearSearch() {
        this.textFieldSearch.method_1852("");
    }

    public int getHoverItemIndex() {
        ArrayList<Integer> sortedKeys = new ArrayList<Integer>(this.dataFiltered.keySet());
        Collections.sort(sortedKeys);
        int sortedIndex = this.hoverIndex + this.itemsToShow() * this.page;
        if (sortedIndex >= 0 && sortedIndex < sortedKeys.size()) {
            return (Integer)sortedKeys.get(sortedIndex);
        }
        return -1;
    }

    private void setPage(int newPage) {
        this.page = class_3532.method_15340((int)newPage, (int)0, (int)(this.totalPages - 1));
        this.buttonPrevPage.field_22764 = this.page > 0;
        this.buttonNextPage.field_22764 = this.page < this.totalPages - 1;
    }

    private void onClick(BiConsumer<NameColorDataBase, Integer> onClick) {
        int index = this.getHoverItemIndex();
        if (index >= 0 && index < this.dataSorted.size()) {
            onClick.accept(this.dataSorted.get(index), index);
        }
    }

    private <T> void onUp(Supplier<List<T>> getList) {
        if (this.textFieldSearch.method_1882().isEmpty()) {
            int index = this.hoverIndex + this.itemsToShow() * this.page;
            List<T> list = getList.get();
            if (class_437.method_25442()) {
                list.add(0, list.remove(index));
            } else {
                T aboveItem = list.get(index - 1);
                T thisItem = list.get(index);
                list.set(index - 1, thisItem);
                list.set(index, aboveItem);
            }
        }
    }

    private <T> void onDown(Supplier<List<T>> getList) {
        if (this.textFieldSearch.method_1882().isEmpty()) {
            int index = this.hoverIndex + this.itemsToShow() * this.page;
            List<T> list = getList.get();
            if (class_437.method_25442()) {
                list.add(list.remove(index));
            } else {
                T thisItem = list.get(index);
                T belowItem = list.get(index + 1);
                list.set(index, belowItem);
                list.set(index + 1, thisItem);
            }
        }
    }

    private int itemsToShow() {
        return (this.height - 24) / 20;
    }
}

