/*
 * Decompiled with CFR 0.152.
 */
package mtr.screen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mtr.client.ClientData;
import mtr.client.IDrawing;
import mtr.data.IGui;
import mtr.data.NameColorDataBase;
import mtr.mappings.ScreenMapper;
import mtr.mappings.Text;
import mtr.mappings.UtilitiesClient;
import mtr.screen.DashboardList;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_4587;

public class DashboardListSelectorScreen
extends ScreenMapper
implements IGui {
    private final DashboardList availableList;
    private final DashboardList selectedList;
    private final class_4185 buttonDone;
    private final ScreenMapper previousScreen;
    private final Runnable onClose;
    private final List<NameColorDataBase> allData;
    private final Collection<Long> selectedIds;
    private final boolean isSingleSelect;
    private final boolean canRepeat;

    public DashboardListSelectorScreen(Runnable onClose, List<NameColorDataBase> allData, Collection<Long> selectedIds, boolean isSingleSelect, boolean canRepeat) {
        this(null, onClose, allData, selectedIds, isSingleSelect, canRepeat);
    }

    public DashboardListSelectorScreen(ScreenMapper previousScreen, List<NameColorDataBase> allData, Collection<Long> selectedIds, boolean isSingleSelect, boolean canRepeat) {
        this(previousScreen, null, allData, selectedIds, isSingleSelect, canRepeat);
    }

    private DashboardListSelectorScreen(ScreenMapper previousScreen, Runnable onClose, List<NameColorDataBase> allData, Collection<Long> selectedIds, boolean isSingleSelect, boolean canRepeat) {
        super((class_2561)Text.literal(""));
        this.previousScreen = previousScreen;
        this.onClose = onClose;
        this.allData = allData;
        this.selectedIds = selectedIds;
        this.isSingleSelect = isSingleSelect;
        this.canRepeat = canRepeat;
        this.availableList = new DashboardList(null, null, null, null, this::onAdd, null, null, () -> ClientData.ROUTES_PLATFORMS_SEARCH, text -> {
            ClientData.ROUTES_PLATFORMS_SEARCH = text;
        });
        this.selectedList = new DashboardList(null, null, null, this::updateList, null, this::onDelete, () -> selectedIds instanceof ArrayList ? (List)selectedIds : new ArrayList(), () -> ClientData.ROUTES_PLATFORMS_SELECTED_SEARCH, text -> {
            ClientData.ROUTES_PLATFORMS_SELECTED_SEARCH = text;
        });
        this.buttonDone = UtilitiesClient.newButton((class_2561)Text.translatable("gui.done", new Object[0]), button -> this.method_25419());
    }

    protected void method_25426() {
        super.method_25426();
        this.availableList.x = this.field_22789 / 2 - 144 - 20;
        this.selectedList.x = this.field_22789 / 2 + 20;
        this.selectedList.y = 40;
        this.availableList.y = 40;
        this.availableList.height = this.selectedList.height = this.field_22790 - 100;
        this.selectedList.width = 144;
        this.availableList.width = 144;
        this.availableList.init(this::addDrawableChild);
        this.selectedList.init(this::addDrawableChild);
        IDrawing.setPositionAndWidth((class_339)this.buttonDone, (this.field_22789 - 144) / 2, this.field_22790 - 40, 144);
        this.addDrawableChild(this.buttonDone);
        this.updateList();
    }

    public void method_25393() {
        this.availableList.tick();
        this.selectedList.tick();
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        try {
            this.method_25420(matrices);
            this.availableList.render(matrices, this.field_22793);
            this.selectedList.render(matrices, this.field_22793);
            super.method_25394(matrices, mouseX, mouseY, delta);
            DashboardListSelectorScreen.method_27534((class_4587)matrices, (class_327)this.field_22793, (class_2561)Text.translatable("gui.mtr.available", new Object[0]), (int)(this.field_22789 / 2 - 72 - 20), (int)26, (int)-1);
            DashboardListSelectorScreen.method_27534((class_4587)matrices, (class_327)this.field_22793, (class_2561)Text.translatable("gui.mtr.selected", new Object[0]), (int)(this.field_22789 / 2 + 72 + 20), (int)26, (int)-1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void method_16014(double mouseX, double mouseY) {
        this.availableList.mouseMoved(mouseX, mouseY);
        this.selectedList.mouseMoved(mouseX, mouseY);
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        this.availableList.mouseScrolled(mouseX, mouseY, amount);
        this.selectedList.mouseScrolled(mouseX, mouseY, amount);
        return super.method_25401(mouseX, mouseY, amount);
    }

    public void method_25419() {
        super.method_25419();
        if (this.onClose != null) {
            this.onClose.run();
        }
        if (this.field_22787 != null && this.previousScreen != null) {
            UtilitiesClient.setScreen(this.field_22787, this.previousScreen);
        }
    }

    public boolean method_25421() {
        return false;
    }

    private void updateList() {
        ArrayList<NameColorDataBase> availableData = new ArrayList<NameColorDataBase>();
        for (NameColorDataBase data2 : this.allData) {
            if (!this.canRepeat && this.selectedIds.contains(data2.id)) continue;
            availableData.add(data2);
        }
        ArrayList selectedData = new ArrayList();
        for (long selectedId : this.selectedIds) {
            this.allData.stream().filter(data -> data.id == selectedId).findFirst().ifPresent(selectedData::add);
        }
        this.availableList.setData(availableData, false, false, false, false, true, false);
        this.selectedList.setData(selectedData, false, false, false, this.canRepeat, false, true);
    }

    private void onAdd(NameColorDataBase data, int index) {
        if (this.isSingleSelect) {
            this.selectedIds.clear();
        }
        this.selectedIds.add(data.id);
        this.updateList();
    }

    private void onDelete(NameColorDataBase data, int index) {
        if (this.canRepeat && this.selectedIds instanceof ArrayList) {
            ((ArrayList)this.selectedIds).remove(index);
        } else {
            this.selectedIds.remove(data.id);
        }
        this.updateList();
    }
}

