/*
 * Decompiled with CFR 0.152.
 */
package mtr.screen;

import java.util.Locale;
import mtr.client.ClientData;
import mtr.client.IDrawing;
import mtr.data.IGui;
import mtr.data.Route;
import mtr.data.RouteType;
import mtr.data.Station;
import mtr.data.TransportMode;
import mtr.mappings.Text;
import mtr.mappings.UtilitiesClient;
import mtr.packet.IPacket;
import mtr.packet.PacketTrainDataGuiClient;
import mtr.screen.DashboardScreen;
import mtr.screen.EditNameColorScreenBase;
import mtr.screen.WidgetBetterCheckbox;
import mtr.screen.WidgetBetterTextField;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_4587;

public class EditRouteScreen
extends EditNameColorScreenBase<Route>
implements IGui,
IPacket {
    private RouteType routeType;
    private final class_2561 lightRailRouteNumberText = Text.translatable("gui.mtr.light_rail_route_number", new Object[0]);
    private final WidgetBetterTextField textFieldLightRailRouteNumber = new WidgetBetterTextField("");
    private final class_4185 buttonRouteType = UtilitiesClient.newButton((class_2561)Text.translatable("gui.mtr.add_value", new Object[0]), button -> this.setRouteTypeText(((Route)this.data).transportMode, this.routeType.next()));
    private final WidgetBetterCheckbox buttonIsLightRailRoute = new WidgetBetterCheckbox(0, 0, 0, 20, (class_2561)Text.translatable("gui.mtr.is_light_rail_route", new Object[0]), this::setIsLightRailRoute);
    private final WidgetBetterCheckbox buttonIsRouteHidden = new WidgetBetterCheckbox(0, 0, 0, 20, (class_2561)Text.translatable("gui.mtr.is_route_hidden", new Object[0]), this::setIsRouteHidden);
    private final WidgetBetterCheckbox buttonDisableNextStationAnnouncements = new WidgetBetterCheckbox(0, 0, 0, 20, (class_2561)Text.translatable("gui.mtr.disable_next_station_announcements", new Object[0]), this::setDisableNextStationAnnouncements);
    private final WidgetBetterCheckbox buttonIsClockwiseRoute = new WidgetBetterCheckbox(0, 0, 0, 20, (class_2561)Text.translatable("gui.mtr.is_clockwise_route", new Object[0]), this::setIsClockwise);
    private final WidgetBetterCheckbox buttonIsAntiClockwiseRoute = new WidgetBetterCheckbox(0, 0, 0, 20, (class_2561)Text.translatable("gui.mtr.is_anticlockwise_route", new Object[0]), this::setIsAntiClockwise);
    private final boolean isCircular;
    private static final int CHECKBOX_WIDTH = 160;

    public EditRouteScreen(Route route, DashboardScreen dashboardScreen) {
        super(route, dashboardScreen, "gui.mtr.route_name", "gui.mtr.route_color");
        if (route.platformIds.size() > 0) {
            Station firstStation = (Station)ClientData.DATA_CACHE.platformIdToStation.get(route.getFirstPlatformId());
            Station lastStation = (Station)ClientData.DATA_CACHE.platformIdToStation.get(route.getLastPlatformId());
            this.isCircular = firstStation != null && lastStation != null && firstStation.id == lastStation.id;
        } else {
            this.isCircular = false;
        }
    }

    protected void method_25426() {
        this.setPositionsAndInit(20, this.field_22789 / 4 * 3 - 20, this.field_22789 - 20);
        IDrawing.setPositionAndWidth((class_339)this.buttonRouteType, 20, 60, 160);
        this.setRouteTypeText(((Route)this.data).transportMode, ((Route)this.data).routeType);
        IDrawing.setPositionAndWidth((class_339)this.buttonIsRouteHidden, 20, 80, 160);
        IDrawing.setPositionAndWidth((class_339)this.buttonDisableNextStationAnnouncements, 20, 100, 160);
        IDrawing.setPositionAndWidth((class_339)this.buttonIsLightRailRoute, 20, 120, 160);
        IDrawing.setPositionAndWidth((class_339)this.textFieldLightRailRouteNumber, 22, 162, 156);
        this.textFieldLightRailRouteNumber.method_1852(((Route)this.data).lightRailRouteNumber);
        IDrawing.setPositionAndWidth((class_339)this.buttonIsClockwiseRoute, 20, 184, 160);
        IDrawing.setPositionAndWidth((class_339)this.buttonIsAntiClockwiseRoute, 20, 204, 160);
        if (((Route)this.data).transportMode.hasRouteTypeVariation) {
            this.addDrawableChild(this.buttonRouteType);
        }
        this.addDrawableChild(this.textFieldLightRailRouteNumber);
        this.addDrawableChild(this.buttonIsLightRailRoute);
        this.addDrawableChild(this.buttonIsRouteHidden);
        this.addDrawableChild(this.buttonDisableNextStationAnnouncements);
        if (this.isCircular) {
            this.addDrawableChild(this.buttonIsClockwiseRoute);
            this.addDrawableChild(this.buttonIsAntiClockwiseRoute);
        }
        this.setIsLightRailRoute(((Route)this.data).isLightRailRoute);
        this.setIsRouteHidden(((Route)this.data).isHidden);
        this.setDisableNextStationAnnouncements(((Route)this.data).disableNextStationAnnouncements);
        this.setIsClockwise(((Route)this.data).circularState == Route.CircularState.CLOCKWISE);
        this.setIsAntiClockwise(((Route)this.data).circularState == Route.CircularState.ANTICLOCKWISE);
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        try {
            this.method_25420(matrices);
            this.renderTextFields(matrices);
            if (this.textFieldLightRailRouteNumber.field_22764) {
                EditRouteScreen.method_27535((class_4587)matrices, (class_327)this.field_22793, (class_2561)this.lightRailRouteNumberText, (int)20, (int)146, (int)-1);
            }
            super.method_25394(matrices, mouseX, mouseY, delta);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void saveData() {
        super.saveData();
        ((Route)this.data).routeType = this.routeType;
        ((Route)this.data).isLightRailRoute = this.buttonIsLightRailRoute.method_20372();
        ((Route)this.data).lightRailRouteNumber = this.textFieldLightRailRouteNumber.method_1882();
        ((Route)this.data).isHidden = this.buttonIsRouteHidden.method_20372();
        ((Route)this.data).disableNextStationAnnouncements = this.buttonDisableNextStationAnnouncements.method_20372();
        ((Route)this.data).circularState = this.isCircular ? (this.buttonIsClockwiseRoute.method_20372() ? Route.CircularState.CLOCKWISE : (this.buttonIsAntiClockwiseRoute.method_20372() ? Route.CircularState.ANTICLOCKWISE : Route.CircularState.NONE)) : Route.CircularState.NONE;
        ((Route)this.data).setExtraData(packet -> PacketTrainDataGuiClient.sendUpdate(PACKET_UPDATE_ROUTE, packet));
    }

    private void setRouteTypeText(TransportMode transportMode, RouteType newRouteType) {
        this.routeType = newRouteType;
        this.buttonRouteType.method_25355((class_2561)Text.translatable(String.format("gui.mtr.route_type_%s_%s", new Object[]{transportMode, this.routeType}).toLowerCase(Locale.ENGLISH), new Object[0]));
    }

    private void setIsLightRailRoute(boolean isLightRailRoute) {
        this.buttonIsLightRailRoute.setChecked(isLightRailRoute);
        this.textFieldLightRailRouteNumber.field_22764 = isLightRailRoute;
    }

    private void setIsRouteHidden(boolean isRouteHidden) {
        this.buttonIsRouteHidden.setChecked(isRouteHidden);
    }

    private void setDisableNextStationAnnouncements(boolean hasNextStationAnnouncements) {
        this.buttonDisableNextStationAnnouncements.setChecked(hasNextStationAnnouncements);
    }

    private void setIsClockwise(boolean isClockwise) {
        this.buttonIsClockwiseRoute.setChecked(isClockwise);
        if (isClockwise) {
            this.buttonIsAntiClockwiseRoute.setChecked(false);
        }
    }

    private void setIsAntiClockwise(boolean isAntiClockwise) {
        this.buttonIsAntiClockwiseRoute.setChecked(isAntiClockwise);
        if (isAntiClockwise) {
            this.buttonIsClockwiseRoute.setChecked(false);
        }
    }
}

