/*
 * Decompiled with CFR 0.152.
 */
package mtr.screen;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import mtr.client.ClientData;
import mtr.client.IDrawing;
import mtr.data.DataConverter;
import mtr.data.NameColorDataBase;
import mtr.data.Station;
import mtr.mappings.Text;
import mtr.mappings.UtilitiesClient;
import mtr.packet.PacketTrainDataGuiClient;
import mtr.screen.DashboardList;
import mtr.screen.DashboardScreen;
import mtr.screen.EditNameColorScreenBase;
import mtr.screen.WidgetBetterTextField;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_4587;

public class EditStationScreen
extends EditNameColorScreenBase<Station> {
    String editingExit;
    int editingDestinationIndex;
    int clickDelay;
    private final class_2561 stationZoneText = Text.translatable("gui.mtr.zone", new Object[0]);
    private final class_2561 exitParentsText = Text.translatable("gui.mtr.exit_parents", new Object[0]);
    private final class_2561 exitDestinationsText = Text.translatable("gui.mtr.exit_destinations", new Object[0]);
    private final WidgetBetterTextField textFieldZone = new WidgetBetterTextField(WidgetBetterTextField.TextFieldFilter.INTEGER, "", 6);
    private final WidgetBetterTextField textFieldExitParentLetter = new WidgetBetterTextField(WidgetBetterTextField.TextFieldFilter.LETTER, "A", 1);
    private final WidgetBetterTextField textFieldExitParentNumber = new WidgetBetterTextField(WidgetBetterTextField.TextFieldFilter.POSITIVE_INTEGER, "1", 2);
    private final WidgetBetterTextField textFieldExitDestination = new WidgetBetterTextField("");
    private final class_4185 buttonAddExitParent = UtilitiesClient.newButton((class_2561)Text.translatable("gui.mtr.add_exit", new Object[0]), button -> this.checkClickDelay(() -> this.changeEditingExit("", -1)));
    private final class_4185 buttonDoneExitParent = UtilitiesClient.newButton((class_2561)Text.translatable("gui.done", new Object[0]), button -> this.checkClickDelay(this::onDoneExitParent));
    private final class_4185 buttonAddExitDestination = UtilitiesClient.newButton((class_2561)Text.translatable("gui.mtr.add_exit_destination", new Object[0]), button -> this.checkClickDelay(() -> this.changeEditingExit(this.editingExit, station.exits.containsKey(this.editingExit) ? station.exits.get(this.editingExit).size() : -1)));
    private final class_4185 buttonDoneExitDestination = UtilitiesClient.newButton((class_2561)Text.translatable("gui.done", new Object[0]), button -> this.checkClickDelay(this::onDoneExitDestination));
    private final DashboardList exitParentList = new DashboardList(null, null, this::onEditExitParent, null, null, this::onDeleteExitParent, null, () -> ClientData.EXIT_PARENTS_SEARCH, text -> {
        ClientData.EXIT_PARENTS_SEARCH = text;
    });
    private final DashboardList exitDestinationList = new DashboardList(null, null, this::onEditExitDestination, this::onSortExitDestination, null, this::onDeleteExitDestination, this::getExitDestinationList, () -> ClientData.EXIT_DESTINATIONS_SEARCH, text -> {
        ClientData.EXIT_DESTINATIONS_SEARCH = text;
    });
    private static final int EXIT_PANELS_START = 70;

    public EditStationScreen(Station station, DashboardScreen dashboardScreen) {
        super(station, dashboardScreen, "gui.mtr.station_name", "gui.mtr.station_color");
    }

    protected void method_25426() {
        this.setPositionsAndInit(0, this.field_22789 / 2, this.field_22789 / 4 * 3);
        IDrawing.setPositionAndWidth((class_339)this.textFieldZone, this.field_22789 / 4 * 3 + 2, 22, this.field_22789 / 4 - 4);
        int yExitText = this.field_22790 - 40 - 2;
        IDrawing.setPositionAndWidth((class_339)this.textFieldExitParentLetter, 2, yExitText, this.field_22789 / 4 - 4);
        IDrawing.setPositionAndWidth((class_339)this.textFieldExitParentNumber, 2 + this.field_22789 / 4, yExitText, this.field_22789 / 4 - 4);
        IDrawing.setPositionAndWidth((class_339)this.textFieldExitDestination, this.field_22789 / 2 + 2, yExitText, this.field_22789 / 2 - 4);
        IDrawing.setPositionAndWidth((class_339)this.buttonAddExitParent, 0, this.field_22790 - 20, this.field_22789 / 2);
        IDrawing.setPositionAndWidth((class_339)this.buttonDoneExitParent, 0, this.field_22790 - 20, this.field_22789 / 2);
        IDrawing.setPositionAndWidth((class_339)this.buttonAddExitDestination, this.field_22789 / 2, this.field_22790 - 20, this.field_22789 / 2);
        IDrawing.setPositionAndWidth((class_339)this.buttonDoneExitDestination, this.field_22789 / 2, this.field_22790 - 20, this.field_22789 / 2);
        this.textFieldZone.method_1852(String.valueOf(((Station)this.data).zone));
        this.exitParentList.x = 0;
        this.exitParentList.y = 70;
        this.exitParentList.height = this.field_22790 - 70 - 20;
        this.exitParentList.width = this.field_22789 / 2;
        this.exitDestinationList.x = this.field_22789 / 2;
        this.exitDestinationList.y = 70;
        this.exitDestinationList.height = this.field_22790 - 70 - 20;
        this.exitDestinationList.width = this.field_22789 / 2;
        this.exitParentList.init(this::addDrawableChild);
        this.exitDestinationList.init(this::addDrawableChild);
        this.addDrawableChild(this.textFieldZone);
        this.addDrawableChild(this.textFieldExitParentLetter);
        this.addDrawableChild(this.textFieldExitParentNumber);
        this.addDrawableChild(this.textFieldExitDestination);
        this.addDrawableChild(this.buttonAddExitParent);
        this.addDrawableChild(this.buttonDoneExitParent);
        this.addDrawableChild(this.buttonAddExitDestination);
        this.addDrawableChild(this.buttonDoneExitDestination);
        this.changeEditingExit(null, -1);
    }

    @Override
    public void method_25393() {
        super.method_25393();
        if (this.clickDelay > 0) {
            --this.clickDelay;
        }
        this.textFieldZone.method_1865();
        this.textFieldExitParentLetter.method_1865();
        this.textFieldExitParentNumber.method_1865();
        this.textFieldExitDestination.method_1865();
        this.exitParentList.tick();
        this.exitDestinationList.tick();
        List exitParents = ((Station)this.data).exits.keySet().stream().sorted().map(value -> {
            List<String> destinations = ((Station)this.data).exits.get(value);
            String additional = destinations.size() > 1 ? "(+" + (destinations.size() - 1) + ")" : "";
            return new DataConverter((String)(destinations.size() > 0 ? value + "|" + destinations.get(0) + "|" + additional : value), 0);
        }).collect(Collectors.toList());
        this.exitParentList.setData(exitParents, false, false, true, false, false, true);
        ArrayList exitDestinations = this.parentExists() ? ((Station)this.data).exits.get(this.editingExit).stream().map(value -> new DataConverter((String)value, 0)).collect(Collectors.toList()) : new ArrayList();
        this.exitDestinationList.setData(exitDestinations, false, false, true, true, false, true);
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        try {
            this.method_25420(matrices);
            this.renderTextFields(matrices);
            EditStationScreen.method_25301((class_4587)matrices, (int)(this.field_22789 / 2), (int)50, (int)this.field_22790, (int)Integer.MAX_VALUE);
            this.exitParentList.render(matrices, this.field_22793);
            this.exitDestinationList.render(matrices, this.field_22793);
            EditStationScreen.method_27534((class_4587)matrices, (class_327)this.field_22793, (class_2561)this.stationZoneText, (int)(this.field_22789 / 8 * 7), (int)6, (int)-1);
            EditStationScreen.method_27534((class_4587)matrices, (class_327)this.field_22793, (class_2561)this.exitParentsText, (int)(this.field_22789 / 4), (int)56, (int)-1);
            if (this.parentExists()) {
                EditStationScreen.method_27534((class_4587)matrices, (class_327)this.field_22793, (class_2561)this.exitDestinationsText, (int)(3 * this.field_22789 / 4), (int)56, (int)-1);
            }
            super.method_25394(matrices, mouseX, mouseY, delta);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void method_16014(double mouseX, double mouseY) {
        this.exitParentList.mouseMoved(mouseX, mouseY);
        this.exitDestinationList.mouseMoved(mouseX, mouseY);
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        this.exitParentList.mouseScrolled(mouseX, mouseY, amount);
        this.exitDestinationList.mouseScrolled(mouseX, mouseY, amount);
        return super.method_25401(mouseX, mouseY, amount);
    }

    @Override
    protected void saveData() {
        super.saveData();
        try {
            ((Station)this.data).zone = Integer.parseInt(this.textFieldZone.method_1882());
        }
        catch (Exception ignored) {
            ((Station)this.data).zone = 0;
        }
        ((Station)this.data).setZone(packet -> PacketTrainDataGuiClient.sendUpdate(PACKET_UPDATE_STATION, packet));
    }

    private void changeEditingExit(String editingExit, int editingDestinationIndex) {
        this.editingExit = editingExit;
        int n = this.editingDestinationIndex = this.parentExists() ? editingDestinationIndex : -1;
        if (editingExit != null) {
            this.textFieldExitParentLetter.method_1852(editingExit.toUpperCase(Locale.ENGLISH).replaceAll("[^A-Z]", ""));
            this.textFieldExitParentNumber.method_1852(editingExit.replaceAll("\\D", ""));
        }
        if (editingDestinationIndex >= 0 && editingDestinationIndex < ((Station)this.data).exits.get(editingExit).size()) {
            this.textFieldExitDestination.method_1852(((Station)this.data).exits.get(editingExit).get(editingDestinationIndex));
        } else {
            this.textFieldExitDestination.method_1852("");
        }
        this.textFieldExitParentLetter.field_22764 = editingExit != null;
        this.textFieldExitParentNumber.field_22764 = editingExit != null;
        this.textFieldExitDestination.field_22764 = editingDestinationIndex >= 0;
        this.buttonAddExitParent.field_22764 = editingExit == null;
        this.buttonDoneExitParent.field_22764 = editingExit != null;
        this.buttonAddExitDestination.field_22764 = this.parentExists() && editingDestinationIndex < 0;
        this.buttonDoneExitDestination.field_22764 = editingDestinationIndex >= 0;
        this.exitDestinationList.x = this.parentExists() ? this.field_22789 / 2 : this.field_22789;
        this.exitParentList.height = this.field_22790 - 70 - (editingExit == null ? 20 : 44);
        this.exitDestinationList.height = this.field_22790 - 70 - (editingDestinationIndex >= 0 ? 44 : 20);
    }

    private void onDoneExitParent() {
        String parentLetter = this.textFieldExitParentLetter.method_1882();
        String parentNumber = this.textFieldExitParentNumber.method_1882();
        if (!parentLetter.isEmpty() && !parentNumber.isEmpty()) {
            try {
                String exitParent = parentLetter + Integer.parseInt(parentNumber);
                ((Station)this.data).setExitParent(this.editingExit, exitParent, packet -> PacketTrainDataGuiClient.sendUpdate(PACKET_UPDATE_STATION, packet));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.changeEditingExit(null, -1);
    }

    private void onDoneExitDestination() {
        String destination = this.textFieldExitDestination.method_1882();
        if (this.parentExists() && this.editingDestinationIndex >= 0 && !destination.isEmpty()) {
            List<String> destinations = ((Station)this.data).exits.get(this.editingExit);
            if (this.editingDestinationIndex < destinations.size()) {
                destinations.set(this.editingDestinationIndex, destination);
            } else {
                destinations.add(destination);
            }
            ((Station)this.data).setExitDestinations(this.editingExit, packet -> PacketTrainDataGuiClient.sendUpdate(PACKET_UPDATE_STATION, packet));
        }
        this.changeEditingExit(this.editingExit, -1);
    }

    private void onEditExitParent(NameColorDataBase listData, int index) {
        this.changeEditingExit(EditStationScreen.formatExitName(listData.name), -1);
    }

    private void onDeleteExitParent(NameColorDataBase listData, int index) {
        ((Station)this.data).deleteExitParent(EditStationScreen.formatExitName(listData.name), packet -> PacketTrainDataGuiClient.sendUpdate(PACKET_UPDATE_STATION, packet));
        this.changeEditingExit(null, -1);
    }

    private void onEditExitDestination(NameColorDataBase listData, int index) {
        this.changeEditingExit(this.editingExit, index);
    }

    private void onSortExitDestination() {
        ((Station)this.data).setExitDestinations(this.editingExit, packet -> PacketTrainDataGuiClient.sendUpdate(PACKET_UPDATE_STATION, packet));
        this.changeEditingExit(this.editingExit, -1);
    }

    private void onDeleteExitDestination(NameColorDataBase listData, int index) {
        if (this.parentExists()) {
            ((Station)this.data).exits.get(this.editingExit).remove(listData.name);
            ((Station)this.data).setExitDestinations(this.editingExit, packet -> PacketTrainDataGuiClient.sendUpdate(PACKET_UPDATE_STATION, packet));
        }
        this.changeEditingExit(this.editingExit, -1);
    }

    private List<String> getExitDestinationList() {
        return this.parentExists() ? ((Station)this.data).exits.get(this.editingExit) : new ArrayList<String>();
    }

    private void checkClickDelay(Runnable callback) {
        if (this.clickDelay == 0) {
            callback.run();
            this.clickDelay = 10;
        }
    }

    private boolean parentExists() {
        return this.editingExit != null && ((Station)this.data).exits.containsKey(this.editingExit);
    }

    private static String formatExitName(String text) {
        return text.split("\\|")[0];
    }
}

