/*
 * Decompiled with CFR 0.152.
 */
package mtr.screen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import mtr.client.ClientData;
import mtr.client.IDrawing;
import mtr.data.DataConverter;
import mtr.data.IGui;
import mtr.data.IPIDS;
import mtr.data.NameColorDataBase;
import mtr.data.Platform;
import mtr.data.RailwayData;
import mtr.data.Station;
import mtr.mappings.ScreenMapper;
import mtr.mappings.Text;
import mtr.mappings.UtilitiesClient;
import mtr.packet.IPacket;
import mtr.packet.PacketTrainDataGuiClient;
import mtr.screen.DashboardListSelectorScreen;
import mtr.screen.WidgetBetterCheckbox;
import mtr.screen.WidgetBetterTextField;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_329;
import net.minecraft.class_339;
import net.minecraft.class_344;
import net.minecraft.class_3532;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_638;

public class PIDSConfigScreen
extends ScreenMapper
implements IGui,
IPacket {
    private final class_2338 pos1;
    private final class_2338 pos2;
    private final String[] messages;
    private final boolean[] hideArrival;
    private final WidgetBetterTextField[] textFieldMessages;
    private final WidgetBetterCheckbox[] buttonsHideArrival;
    private final WidgetBetterTextField displayPageInput;
    private final class_2561 messageText = Text.translatable("gui.mtr.pids_message", new Object[0]);
    private final class_2561 hideArrivalText = Text.translatable("gui.mtr.hide_arrival", new Object[0]);
    private final WidgetBetterCheckbox selectAllCheckbox;
    private final class_4185 filterButton;
    private final class_344 buttonPrevPage;
    private final class_344 buttonNextPage;
    private final Set<Long> filterPlatformIds;
    private final int displayPage;
    private final int maxArrivals;
    private final int linesPerArrival;
    private int page = 0;
    private static final int MAX_MESSAGE_LENGTH = 2048;
    private static final int TEXT_FIELDS_Y_OFFSET = 162;

    public PIDSConfigScreen(class_2338 pos1, class_2338 pos2, int maxArrivals, int linesPerArrival) {
        super((class_2561)Text.literal(""));
        int i;
        this.pos1 = pos1;
        this.pos2 = pos2;
        this.maxArrivals = maxArrivals;
        this.linesPerArrival = linesPerArrival;
        this.messages = new String[maxArrivals * linesPerArrival];
        for (i = 0; i < maxArrivals * linesPerArrival; ++i) {
            this.messages[i] = "";
        }
        this.hideArrival = new boolean[maxArrivals];
        this.selectAllCheckbox = new WidgetBetterCheckbox(0, 0, 0, 20, (class_2561)Text.translatable("gui.mtr.automatically_detect_nearby_platform", new Object[0]), checked -> {});
        this.textFieldMessages = new WidgetBetterTextField[maxArrivals * linesPerArrival];
        for (i = 0; i < maxArrivals * linesPerArrival; ++i) {
            this.textFieldMessages[i] = new WidgetBetterTextField("", 2048);
        }
        this.buttonsHideArrival = new WidgetBetterCheckbox[maxArrivals];
        for (i = 0; i < maxArrivals; ++i) {
            this.buttonsHideArrival[i] = new WidgetBetterCheckbox(0, 0, 0, 20, this.hideArrivalText, checked -> {});
        }
        this.buttonPrevPage = new class_344(0, 0, 0, 20, 0, 0, 20, new class_2960("mtr:textures/gui/icon_left.png"), 20, 40, button -> this.setPage(this.page - 1));
        this.buttonNextPage = new class_344(0, 0, 0, 20, 0, 0, 20, new class_2960("mtr:textures/gui/icon_right.png"), 20, 40, button -> this.setPage(this.page + 1));
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            this.filterPlatformIds = new HashSet<Long>();
            this.displayPage = 0;
        } else {
            class_2586 entity = world.method_8321(pos1);
            if (entity instanceof IPIDS.TileEntityPIDS) {
                int i2;
                this.filterPlatformIds = ((IPIDS.TileEntityPIDS)entity).getPlatformIds();
                for (i2 = 0; i2 < maxArrivals * linesPerArrival; ++i2) {
                    this.messages[i2] = ((IPIDS.TileEntityPIDS)entity).getMessage(i2);
                }
                for (i2 = 0; i2 < maxArrivals; ++i2) {
                    this.hideArrival[i2] = ((IPIDS.TileEntityPIDS)entity).getHideArrival(i2);
                }
                this.displayPage = ((IPIDS.TileEntityPIDS)entity).getDisplayPage();
            } else {
                this.filterPlatformIds = new HashSet<Long>();
                this.displayPage = 0;
            }
        }
        this.filterButton = PIDSConfigScreen.getPlatformFilterButton(pos1, this.selectAllCheckbox, this.filterPlatformIds, this);
        this.displayPageInput = new WidgetBetterTextField(WidgetBetterTextField.TextFieldFilter.POSITIVE_INTEGER, "1", 3);
    }

    protected void method_25426() {
        super.method_25426();
        int hideArrivalWidth = this.field_22793.method_27525((class_5348)this.hideArrivalText) + 20 + 6;
        int customMessageWidth = this.field_22793.method_27525((class_5348)this.messageText) + 20 + 6;
        IDrawing.setPositionAndWidth((class_339)this.selectAllCheckbox, 20, 20, 144);
        this.selectAllCheckbox.setChecked(this.filterPlatformIds.isEmpty());
        this.addDrawableChild(this.selectAllCheckbox);
        IDrawing.setPositionAndWidth((class_339)this.filterButton, 20, 60, 72);
        this.filterButton.method_25355((class_2561)Text.translatable("selectWorld.edit", new Object[0]));
        this.addDrawableChild(this.filterButton);
        IDrawing.setPositionAndWidth((class_339)this.displayPageInput, 22, 102, 68);
        this.displayPageInput.method_1852(String.valueOf(this.displayPage + 1));
        this.addDrawableChild(this.displayPageInput);
        IDrawing.setPositionAndWidth((class_339)this.buttonPrevPage, customMessageWidth, 140, 20);
        this.addDrawableChild(this.buttonPrevPage);
        IDrawing.setPositionAndWidth((class_339)this.buttonNextPage, customMessageWidth + 60, 140, 20);
        this.addDrawableChild(this.buttonNextPage);
        for (int i = 0; i < this.textFieldMessages.length; ++i) {
            WidgetBetterTextField textFieldMessage = this.textFieldMessages[i];
            int y = 162 + 24 * (i % this.getMaxArrivalsPerPage());
            IDrawing.setPositionAndWidth((class_339)textFieldMessage, 22, y, this.field_22789 - 40 - 4 - hideArrivalWidth);
            textFieldMessage.method_1852(this.messages[i]);
            this.addDrawableChild(textFieldMessage);
            if (i % this.linesPerArrival != 0) continue;
            int index = i / this.linesPerArrival;
            WidgetBetterCheckbox buttonHideArrival = this.buttonsHideArrival[index];
            IDrawing.setPositionAndWidth((class_339)buttonHideArrival, this.field_22789 - 20 - hideArrivalWidth + 6, y, hideArrivalWidth);
            buttonHideArrival.setChecked(this.hideArrival[index]);
            this.addDrawableChild(buttonHideArrival);
        }
        this.setPage(0);
    }

    private void setPage(int newPage) {
        int maxArrivalsPerPage = this.getMaxArrivalsPerPage();
        int maxPages = this.getMaxPages() - 1;
        this.page = class_3532.method_15340((int)newPage, (int)0, (int)maxPages);
        for (int i = 0; i < this.textFieldMessages.length; ++i) {
            boolean bl = this.textFieldMessages[i].field_22764 = i / maxArrivalsPerPage == this.page;
            if (i % this.linesPerArrival != 0) continue;
            this.buttonsHideArrival[i / this.linesPerArrival].field_22764 = i / maxArrivalsPerPage == this.page;
        }
        this.buttonPrevPage.field_22764 = this.page > 0;
        this.buttonNextPage.field_22764 = this.page < maxPages;
    }

    public void method_25393() {
        for (WidgetBetterTextField textFieldMessage : this.textFieldMessages) {
            textFieldMessage.method_1865();
        }
    }

    public void method_25419() {
        int i;
        for (i = 0; i < this.textFieldMessages.length; ++i) {
            this.messages[i] = this.textFieldMessages[i].method_1882();
        }
        for (i = 0; i < this.buttonsHideArrival.length; ++i) {
            this.hideArrival[i] = this.buttonsHideArrival[i].method_20372();
        }
        if (this.selectAllCheckbox.method_20372()) {
            this.filterPlatformIds.clear();
        }
        int displayPage = 0;
        try {
            displayPage = Math.max(0, Integer.parseInt(this.displayPageInput.method_1882()) - 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PacketTrainDataGuiClient.sendPIDSConfigC2S(this.pos1, this.pos2, this.messages, this.hideArrival, this.filterPlatformIds, displayPage);
        super.method_25419();
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        try {
            this.method_25420(matrices);
            this.field_22793.method_30883(matrices, (class_2561)Text.translatable("gui.mtr.display_page", new Object[0]), 20.0f, 86.0f, -1);
            this.field_22793.method_30883(matrices, (class_2561)Text.translatable("gui.mtr.filtered_platforms", this.selectAllCheckbox.method_20372() ? 0 : this.filterPlatformIds.size()), 20.0f, 46.0f, -1);
            this.field_22793.method_30883(matrices, this.messageText, 20.0f, 146.0f, -1);
            int maxPages = this.getMaxPages();
            if (maxPages > 1) {
                class_329.method_25300((class_4587)matrices, (class_327)this.field_22793, (String)String.format("%s/%s", this.page + 1, maxPages), (int)(60 + this.field_22793.method_27525((class_5348)this.messageText) + 6), (int)146, (int)-1);
            }
            super.method_25394(matrices, mouseX, mouseY, delta);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean method_25421() {
        return false;
    }

    private int getMaxArrivalsPerPage() {
        return Math.max(1, (this.field_22790 - 162 - 20) / 24);
    }

    private int getMaxPages() {
        return (int)Math.ceil((float)this.maxArrivals / (float)this.getMaxArrivalsPerPage());
    }

    public static class_4185 getPlatformFilterButton(class_2338 pos, WidgetBetterCheckbox selectAllCheckbox, Set<Long> filterPlatformIds, ScreenMapper thisScreen) {
        return UtilitiesClient.newButton(button -> {
            Station station = RailwayData.getStation(ClientData.STATIONS, ClientData.DATA_CACHE, pos);
            if (station != null) {
                ArrayList<NameColorDataBase> platformsForList = new ArrayList<NameColorDataBase>();
                ArrayList<Platform> platforms = new ArrayList<Platform>(ClientData.DATA_CACHE.requestStationIdToPlatforms(station.id).values());
                Collections.sort(platforms);
                platforms.stream().map(platform -> new DataConverter(platform.id, platform.name + " " + IGui.mergeStations(ClientData.DATA_CACHE.requestPlatformIdToRoutes(platform.id).stream().map(route -> route.stationDetails.get((int)(route.stationDetails.size() - 1)).stationName).collect(Collectors.toList())), 0)).forEach(platformsForList::add);
                if (selectAllCheckbox.method_20372()) {
                    filterPlatformIds.clear();
                }
                class_310 minecraft = class_310.method_1551();
                UtilitiesClient.setScreen(minecraft, new DashboardListSelectorScreen(() -> {
                    UtilitiesClient.setScreen(minecraft, thisScreen);
                    selectAllCheckbox.setChecked(filterPlatformIds.isEmpty());
                }, platformsForList, (Collection<Long>)filterPlatformIds, false, false));
            }
        });
    }
}

