/*
 * Decompiled with CFR 0.152.
 */
package mtr.screen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import mtr.block.BlockRailwaySign;
import mtr.block.BlockRouteSignBase;
import mtr.client.ClientData;
import mtr.client.CustomResources;
import mtr.client.IDrawing;
import mtr.data.DataConverter;
import mtr.data.IGui;
import mtr.data.NameColorDataBase;
import mtr.data.Platform;
import mtr.data.RailwayData;
import mtr.data.Station;
import mtr.mappings.ScreenMapper;
import mtr.mappings.Text;
import mtr.mappings.UtilitiesClient;
import mtr.packet.PacketTrainDataGuiClient;
import mtr.render.RenderRailwaySign;
import mtr.screen.DashboardListSelectorScreen;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_329;
import net.minecraft.class_339;
import net.minecraft.class_344;
import net.minecraft.class_3532;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_638;

public class RailwaySignScreen
extends ScreenMapper
implements IGui {
    private int editingIndex = -1;
    private int page;
    private int totalPages;
    private int columns;
    private int rows;
    private final class_2338 signPos;
    private final boolean isRailwaySign;
    private final int length;
    private final String[] signIds;
    private final Set<Long> selectedIds;
    private final List<NameColorDataBase> exitsForList = new ArrayList<NameColorDataBase>();
    private final List<NameColorDataBase> platformsForList = new ArrayList<NameColorDataBase>();
    private final List<NameColorDataBase> routesForList = new ArrayList<NameColorDataBase>();
    private final List<NameColorDataBase> stationsForList = new ArrayList<NameColorDataBase>();
    private final List<String> allSignIds = new ArrayList<String>();
    private final class_4185[] buttonsEdit;
    private final class_4185[] buttonsSelection;
    private final class_4185 buttonClear;
    private final class_344 buttonPrevPage;
    private final class_344 buttonNextPage;
    private static final int SIGN_SIZE = 32;
    private static final int SIGN_BUTTON_SIZE = 16;
    private static final int BUTTON_Y_START = 62;

    public RailwaySignScreen(class_2338 signPos) {
        super((class_2561)Text.literal(""));
        int i;
        this.signPos = signPos;
        class_638 world = class_310.method_1551().field_1687;
        for (BlockRailwaySign.SignType signType : BlockRailwaySign.SignType.values()) {
            this.allSignIds.add(signType.toString());
        }
        ArrayList<String> sortedKeys = new ArrayList<String>(CustomResources.CUSTOM_SIGNS.keySet());
        Collections.sort(sortedKeys);
        this.allSignIds.addAll(sortedKeys);
        try {
            Station station = RailwayData.getStation(ClientData.STATIONS, ClientData.DATA_CACHE, signPos);
            if (station != null) {
                Map<String, List<String>> exits = station.getGeneratedExits();
                ArrayList<String> exitParents = new ArrayList<String>(exits.keySet());
                exitParents.sort(String::compareTo);
                exitParents.forEach(exitParent -> {
                    List destinations = (List)exits.get(exitParent);
                    this.exitsForList.add(new DataConverter(Station.serializeExit(exitParent), exitParent + " " + (destinations.size() > 0 ? (String)destinations.get(0) : ""), 0));
                });
                ArrayList<Platform> platforms = new ArrayList<Platform>(ClientData.DATA_CACHE.requestStationIdToPlatforms(station.id).values());
                Collections.sort(platforms);
                platforms.stream().map(platform -> new DataConverter(platform.id, platform.name + " " + IGui.mergeStations(ClientData.DATA_CACHE.requestPlatformIdToRoutes(platform.id).stream().map(route -> route.stationDetails.get((int)(route.stationDetails.size() - 1)).stationName).collect(Collectors.toList())), 0)).forEach(this.platformsForList::add);
                ClientData.DATA_CACHE.getAllRoutesIncludingConnectingStations(station).forEach((color, route) -> this.routesForList.add(new DataConverter(route.color, route.name, route.color)));
                ClientData.DATA_CACHE.getConnectingStationsIncludingThisOne(station).forEach(connectingStation -> this.stationsForList.add(new DataConverter(connectingStation.id, connectingStation.name, connectingStation.color)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (world != null) {
            class_2586 entity = world.method_8321(signPos);
            if (entity instanceof BlockRailwaySign.TileEntityRailwaySign) {
                this.signIds = ((BlockRailwaySign.TileEntityRailwaySign)entity).getSignIds();
                this.selectedIds = ((BlockRailwaySign.TileEntityRailwaySign)entity).getSelectedIds();
                this.isRailwaySign = true;
            } else {
                this.signIds = new String[0];
                this.selectedIds = new HashSet<Long>();
                this.isRailwaySign = false;
                if (entity instanceof BlockRouteSignBase.TileEntityRouteSignBase) {
                    this.selectedIds.add(((BlockRouteSignBase.TileEntityRouteSignBase)entity).getPlatformId());
                }
            }
            this.length = world.method_8320(signPos).method_26204() instanceof BlockRailwaySign ? ((BlockRailwaySign)world.method_8320((class_2338)signPos).method_26204()).length : 0;
        } else {
            this.length = 0;
            this.signIds = new String[0];
            this.selectedIds = new HashSet<Long>();
            this.isRailwaySign = false;
        }
        this.buttonsEdit = new class_4185[this.length];
        for (i = 0; i < this.buttonsEdit.length; ++i) {
            int index = i;
            this.buttonsEdit[i] = UtilitiesClient.newButton((class_2561)Text.translatable("selectWorld.edit", new Object[0]), button -> this.edit(index));
        }
        this.buttonsSelection = new class_4185[this.allSignIds.size()];
        for (i = 0; i < this.allSignIds.size(); ++i) {
            int index = i;
            this.buttonsSelection[i] = UtilitiesClient.newButton(16, (class_2561)Text.literal(""), button -> this.setNewSignId(this.allSignIds.get(index)));
        }
        this.buttonClear = UtilitiesClient.newButton((class_2561)Text.translatable("gui.mtr.reset_sign", new Object[0]), button -> this.setNewSignId(null));
        this.buttonPrevPage = new class_344(0, 0, 0, 20, 0, 0, 20, new class_2960("mtr:textures/gui/icon_left.png"), 20, 40, button -> this.setPage(this.page - 1));
        this.buttonNextPage = new class_344(0, 0, 0, 20, 0, 0, 20, new class_2960("mtr:textures/gui/icon_right.png"), 20, 40, button -> this.setPage(this.page + 1));
    }

    protected void method_25426() {
        super.method_25426();
        for (int i = 0; i < this.buttonsEdit.length; ++i) {
            IDrawing.setPositionAndWidth((class_339)this.buttonsEdit[i], (this.field_22789 - 32 * this.length) / 2 + i * 32, 32, 32);
            this.addDrawableChild(this.buttonsEdit[i]);
        }
        this.columns = Math.max((this.field_22789 - 48) / 128 * 2, 1);
        this.rows = Math.max((this.field_22790 - 32 - 80) / 16, 1);
        int xOffsetSmall = (this.field_22789 - 16 * (this.columns * 4 + 3)) / 2 + 16;
        int xOffsetBig = xOffsetSmall + 16 * (this.columns + 1);
        this.totalPages = this.loopSigns((index, x, y, isBig) -> {
            IDrawing.setPositionAndWidth((class_339)this.buttonsSelection[index], (isBig ? xOffsetBig : xOffsetSmall) + x, 62 + y, isBig ? 48 : 16);
            this.buttonsSelection[index].field_22764 = false;
            this.addDrawableChild(this.buttonsSelection[index]);
        }, true);
        int buttonClearX = (this.field_22789 - 144 - 80) / 2;
        int buttonY = this.field_22790 - 40;
        IDrawing.setPositionAndWidth((class_339)this.buttonClear, buttonClearX, buttonY, 144);
        this.buttonClear.field_22764 = false;
        this.addDrawableChild(this.buttonClear);
        IDrawing.setPositionAndWidth((class_339)this.buttonPrevPage, buttonClearX + 144, buttonY, 20);
        this.buttonPrevPage.field_22764 = false;
        this.addDrawableChild(this.buttonPrevPage);
        IDrawing.setPositionAndWidth((class_339)this.buttonNextPage, buttonClearX + 144 + 60, buttonY, 20);
        this.buttonNextPage.field_22764 = false;
        this.addDrawableChild(this.buttonNextPage);
        if (!this.isRailwaySign && this.field_22787 != null) {
            UtilitiesClient.setScreen(this.field_22787, new DashboardListSelectorScreen(this::method_25419, this.platformsForList, this.selectedIds, true, false));
        }
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        try {
            this.method_25420(matrices);
            super.method_25394(matrices, mouseX, mouseY, delta);
            if (this.field_22787 == null) {
                return;
            }
            for (int i = 0; i < this.signIds.length; ++i) {
                if (this.signIds[i] == null) continue;
                RenderRailwaySign.drawSign(matrices, null, null, this.field_22793, this.signPos, this.signIds[i], (float)(this.field_22789 - 32 * this.length) / 2.0f + (float)(i * 32), 0.0f, 32.0f, RenderRailwaySign.getMaxWidth(this.signIds, i, false), RenderRailwaySign.getMaxWidth(this.signIds, i, true), this.selectedIds, class_2350.field_11036, 0, (textureId, x, y, size, flipTexture) -> {
                    UtilitiesClient.beginDrawingTexture(textureId);
                    RailwaySignScreen.method_25290((class_4587)matrices, (int)((int)x), (int)((int)y), (float)0.0f, (float)0.0f, (int)((int)size), (int)((int)size), (int)((int)(flipTexture ? -size : size)), (int)((int)size));
                });
            }
            if (this.editingIndex >= 0) {
                int xOffsetSmall = (this.field_22789 - 16 * (this.columns * 4 + 3)) / 2 + 16;
                int xOffsetBig = xOffsetSmall + 16 * (this.columns + 1);
                this.loopSigns((index, x, y, isBig) -> {
                    String signId = this.allSignIds.get(index);
                    CustomResources.CustomSign sign = RenderRailwaySign.getSign(signId);
                    if (sign != null) {
                        boolean moveRight = sign.hasCustomText() && sign.flipCustomText;
                        UtilitiesClient.beginDrawingTexture(sign.textureId);
                        RenderRailwaySign.drawSign(matrices, null, null, this.field_22793, this.signPos, signId, (isBig ? xOffsetBig : xOffsetSmall) + x + (moveRight ? 32 : 0), 62 + y, 16.0f, 2.0f, 2.0f, this.selectedIds, class_2350.field_11036, 0, (textureId, x1, y1, size, flipTexture) -> RailwaySignScreen.method_25290((class_4587)matrices, (int)((int)x1), (int)((int)y1), (float)0.0f, (float)0.0f, (int)((int)size), (int)((int)size), (int)((int)(flipTexture ? -size : size)), (int)((int)size)));
                    }
                }, false);
                class_329.method_25300((class_4587)matrices, (class_327)this.field_22793, (String)String.format("%s/%s", this.page + 1, this.totalPages), (int)((this.field_22789 - 144 - 80) / 2 + 144 + 40), (int)(this.field_22790 - 40 + 6), (int)-1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        this.setPage(this.page + (int)Math.signum(-amount));
        return super.method_25401(mouseX, mouseY, amount);
    }

    public void method_25419() {
        PacketTrainDataGuiClient.sendSignIdsC2S(this.signPos, this.selectedIds, this.signIds);
        super.method_25419();
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25410(class_310 client, int width, int height) {
        super.method_25410(client, width, height);
        for (class_4185 button : this.buttonsEdit) {
            button.field_22763 = true;
        }
        for (class_4185 button : this.buttonsSelection) {
            button.field_22764 = false;
        }
        this.editingIndex = -1;
    }

    private int loopSigns(LoopSignsCallback loopSignsCallback, boolean ignorePage) {
        int pageCount = this.rows * this.columns;
        int indexSmall = 0;
        int indexBig = 0;
        int columnSmall = 0;
        int columnBig = 0;
        int rowSmall = 0;
        int rowBig = 0;
        int totalPagesSmallCount = 1;
        int totalPagesBigCount = 1;
        for (int i = 0; i < this.allSignIds.size(); ++i) {
            boolean onPage;
            CustomResources.CustomSign sign = RenderRailwaySign.getSign(this.allSignIds.get(i));
            boolean isBig = sign != null && sign.hasCustomText();
            this.buttonsSelection[i].field_22764 = onPage = (isBig ? indexBig : indexSmall) / pageCount == this.page;
            if (ignorePage || onPage) {
                loopSignsCallback.loopSignsCallback(i, (isBig ? columnBig * 3 : columnSmall) * 16, (isBig ? rowBig : rowSmall) * 16, isBig);
            }
            if (isBig) {
                ++columnBig;
                if (totalPagesBigCount < 0) {
                    totalPagesBigCount = -totalPagesBigCount + 1;
                }
                if (columnBig >= this.columns) {
                    columnBig = 0;
                    if (++rowBig >= this.rows) {
                        rowBig = 0;
                        totalPagesBigCount = -totalPagesBigCount;
                    }
                }
                ++indexBig;
                continue;
            }
            ++columnSmall;
            if (totalPagesSmallCount < 0) {
                totalPagesSmallCount = -totalPagesSmallCount + 1;
            }
            if (columnSmall >= this.columns) {
                columnSmall = 0;
                if (++rowSmall >= this.rows) {
                    rowSmall = 0;
                    totalPagesSmallCount = -totalPagesSmallCount;
                }
            }
            ++indexSmall;
        }
        return Math.max(Math.abs(totalPagesBigCount), Math.abs(totalPagesSmallCount));
    }

    private void edit(int editingIndex) {
        this.editingIndex = editingIndex;
        for (class_4185 button : this.buttonsEdit) {
            button.field_22763 = true;
        }
        this.buttonClear.field_22764 = true;
        this.setPage(this.page);
        this.buttonsEdit[editingIndex].field_22763 = false;
    }

    private void setNewSignId(String newSignId) {
        if (this.editingIndex >= 0 && this.editingIndex < this.signIds.length) {
            boolean isStation;
            this.signIds[this.editingIndex] = newSignId;
            boolean isExitLetter = newSignId != null && (newSignId.equals(BlockRailwaySign.SignType.EXIT_LETTER.toString()) || newSignId.equals(BlockRailwaySign.SignType.EXIT_LETTER_FLIPPED.toString()));
            boolean isPlatform = newSignId != null && (newSignId.equals(BlockRailwaySign.SignType.PLATFORM.toString()) || newSignId.equals(BlockRailwaySign.SignType.PLATFORM_FLIPPED.toString()));
            boolean isLine = newSignId != null && (newSignId.equals(BlockRailwaySign.SignType.LINE.toString()) || newSignId.equals(BlockRailwaySign.SignType.LINE_FLIPPED.toString()));
            boolean bl = isStation = newSignId != null && (newSignId.equals(BlockRailwaySign.SignType.STATION.toString()) || newSignId.equals(BlockRailwaySign.SignType.STATION_FLIPPED.toString()));
            if ((isExitLetter || isPlatform || isLine || isStation) && this.field_22787 != null) {
                UtilitiesClient.setScreen(this.field_22787, new DashboardListSelectorScreen(this, isExitLetter ? this.exitsForList : (isPlatform ? this.platformsForList : (isLine ? this.routesForList : this.stationsForList)), this.selectedIds, false, false));
            }
        }
    }

    private void setPage(int newPage) {
        this.page = class_3532.method_15340((int)newPage, (int)0, (int)(this.totalPages - 1));
        this.buttonPrevPage.field_22764 = this.editingIndex >= 0 && this.page > 0;
        this.buttonNextPage.field_22764 = this.editingIndex >= 0 && this.page < this.totalPages - 1;
    }

    @FunctionalInterface
    private static interface LoopSignsCallback {
        public void loopSignsCallback(int var1, int var2, int var3, boolean var4);
    }
}

