/*
 * Decompiled with CFR 0.152.
 */
package mtr.screen;

import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.Locale;
import java.util.function.Consumer;
import mtr.client.CustomResources;
import mtr.client.ICustomResources;
import mtr.client.IDrawing;
import mtr.client.IResourcePackCreatorProperties;
import mtr.data.IGui;
import mtr.mappings.ScreenMapper;
import mtr.mappings.Text;
import mtr.mappings.UtilitiesClient;
import mtr.render.RenderTrains;
import mtr.screen.FileUploaderScreen;
import mtr.screen.ResourcePackCreatorScreen;
import mtr.screen.WidgetBetterTextField;
import mtr.screen.WidgetColorSelector;
import mtr.screen.WidgetShorterSlider;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_5348;

public class ResourcePackCreatorOptionsScreen
extends ScreenMapper
implements IResourcePackCreatorProperties,
ICustomResources,
IGui {
    private final ResourcePackCreatorScreen resourcePackCreatorScreen;
    private final class_4185 buttonChooseModelFile;
    private final class_4185 buttonChoosePropertiesFile;
    private final class_4185 buttonChooseTextureFile;
    private final WidgetBetterTextField textFieldId;
    private final WidgetBetterTextField textFieldName;
    private final WidgetColorSelector colorSelector;
    private final WidgetBetterTextField textFieldGangwayConnectionId;
    private final WidgetBetterTextField textFieldTrainBarrierId;
    private final WidgetShorterSlider sliderRiderOffset;
    private final class_4185 buttonDone;
    private final class_4185 buttonExport;
    private static final class_2561 FILE_MODEL_TEXT = Text.translatable("gui.mtr.file_model", new Object[0]);
    private static final class_2561 FILE_PROPERTIES_TEXT = Text.translatable("gui.mtr.file_properties", new Object[0]);
    private static final class_2561 FILE_TEXTURE_TEXT = Text.translatable("gui.mtr.file_texture", new Object[0]);
    private static final class_2561 NAME_TEXT = Text.translatable("gui.mtr.custom_resources_name", new Object[0]);
    private static final class_2561 ID_TEXT = Text.translatable("gui.mtr.custom_resources_id", new Object[0]);
    private static final class_2561 GANGWAY_CONNECTION_ID_TEXT = Text.translatable("gui.mtr.custom_resources_gangway_connection_id", new Object[0]);
    private static final class_2561 TRAIN_BARRIER_ID_TEXT = Text.translatable("gui.mtr.custom_resources_train_barrier_id", new Object[0]);

    public ResourcePackCreatorOptionsScreen(ResourcePackCreatorScreen resourcePackCreatorScreen) {
        super((class_2561)Text.literal(""));
        this.resourcePackCreatorScreen = resourcePackCreatorScreen;
        this.buttonChooseModelFile = UtilitiesClient.newButton(button -> this.buttonCallback(path -> {
            RenderTrains.creatorProperties.loadModelFile((Path)path);
            this.updateControls(false);
        }));
        this.buttonChoosePropertiesFile = UtilitiesClient.newButton(button -> this.buttonCallback(path -> {
            RenderTrains.creatorProperties.loadPropertiesFile((Path)path);
            this.updateControls(false);
        }));
        this.buttonChooseTextureFile = UtilitiesClient.newButton(button -> this.buttonCallback(path -> {
            RenderTrains.creatorProperties.loadTextureFile((Path)path);
            this.updateControls(false);
        }));
        this.textFieldId = new WidgetBetterTextField("my_custom_train_id");
        this.textFieldName = new WidgetBetterTextField("My Custom Train Name");
        this.colorSelector = new WidgetColorSelector(this, true, this::onUpdateColor);
        this.textFieldGangwayConnectionId = new WidgetBetterTextField("mtr:textures/entity/sp1900");
        this.textFieldTrainBarrierId = new WidgetBetterTextField("mtr:textures/entity/r211");
        this.sliderRiderOffset = new WidgetShorterSlider(0, 144, 18, value -> {
            RenderTrains.creatorProperties.editCustomResourcesRiderOffset((float)(value - 2) / 4.0f);
            this.updateControls(true);
            return Text.translatable("gui.mtr.custom_resources_rider_offset", Float.valueOf((float)(value - 2) / 4.0f)).getString();
        }, null);
        this.buttonDone = UtilitiesClient.newButton((class_2561)Text.translatable("gui.done", new Object[0]), button -> this.method_25419());
        this.buttonExport = UtilitiesClient.newButton((class_2561)Text.translatable("gui.mtr.custom_resources_export_resource_pack", new Object[0]), button -> RenderTrains.creatorProperties.export());
    }

    protected void method_25426() {
        super.method_25426();
        int newWidth = this.field_22789 - 40;
        int yStart = (this.field_22790 - 200 - 16) / 2;
        int textWidth = Math.max(Math.max(this.field_22793.method_27525((class_5348)FILE_MODEL_TEXT), Math.max(this.field_22793.method_27525((class_5348)FILE_PROPERTIES_TEXT), this.field_22793.method_27525((class_5348)FILE_TEXTURE_TEXT))), Math.max(Math.max(this.field_22793.method_27525((class_5348)NAME_TEXT), this.field_22793.method_27525((class_5348)ID_TEXT)), Math.max(this.field_22793.method_27525((class_5348)GANGWAY_CONNECTION_ID_TEXT), this.field_22793.method_27525((class_5348)TRAIN_BARRIER_ID_TEXT)))) + 6;
        IDrawing.setPositionAndWidth((class_339)this.buttonChooseModelFile, 20 + textWidth, yStart, newWidth - textWidth);
        IDrawing.setPositionAndWidth((class_339)this.buttonChoosePropertiesFile, 20 + textWidth, yStart + 20, newWidth - textWidth);
        IDrawing.setPositionAndWidth((class_339)this.buttonChooseTextureFile, 20 + textWidth, yStart + 40, newWidth - textWidth);
        IDrawing.setPositionAndWidth((class_339)this.textFieldId, 20 + textWidth + 2, yStart + 70 + 2, newWidth - 40 - 4 - textWidth);
        IDrawing.setPositionAndWidth((class_339)this.colorSelector, 20 + newWidth + 2 - 40, yStart + 70 + 2, 36);
        IDrawing.setPositionAndWidth((class_339)this.textFieldName, 20 + textWidth + 2, yStart + 90 + 6, newWidth - 4 - textWidth);
        IDrawing.setPositionAndWidth((class_339)this.textFieldGangwayConnectionId, 20 + textWidth + 2, yStart + 110 + 10, newWidth - 4 - textWidth);
        IDrawing.setPositionAndWidth((class_339)this.textFieldTrainBarrierId, 20 + textWidth + 2, yStart + 130 + 14, newWidth - 4 - textWidth);
        this.textFieldId.method_1863(text -> {
            RenderTrains.creatorProperties.editCustomResourcesId(ResourcePackCreatorOptionsScreen.formatText(this.textFieldId, text, false));
            this.updateControls(false);
        });
        this.textFieldName.method_1863(text -> {
            RenderTrains.creatorProperties.editCustomResourcesName((String)text);
            this.updateControls(false);
        });
        this.textFieldGangwayConnectionId.method_1863(text -> {
            RenderTrains.creatorProperties.editCustomResourcesGangwayConnectionId(ResourcePackCreatorOptionsScreen.formatText(this.textFieldGangwayConnectionId, text, true));
            this.updateControls(false);
        });
        this.textFieldTrainBarrierId.method_1863(text -> {
            RenderTrains.creatorProperties.editCustomResourcesTrainBarrierId(ResourcePackCreatorOptionsScreen.formatText(this.textFieldTrainBarrierId, text, true));
            this.updateControls(false);
        });
        IDrawing.setPositionAndWidth((class_339)this.sliderRiderOffset, 20, yStart + 150 + 16, textWidth);
        this.sliderRiderOffset.setHeight(20);
        IDrawing.setPositionAndWidth((class_339)this.buttonDone, 20, yStart + 180 + 16, textWidth);
        IDrawing.setPositionAndWidth((class_339)this.buttonExport, 20 + textWidth, yStart + 180 + 16, newWidth - textWidth);
        this.updateControls(true);
        this.addDrawableChild(this.buttonChooseModelFile);
        this.addDrawableChild(this.buttonChoosePropertiesFile);
        this.addDrawableChild(this.buttonChooseTextureFile);
        this.addDrawableChild(this.textFieldId);
        this.addDrawableChild(this.colorSelector);
        this.addDrawableChild(this.textFieldName);
        this.addDrawableChild(this.textFieldGangwayConnectionId);
        this.addDrawableChild(this.textFieldTrainBarrierId);
        this.addDrawableChild(this.sliderRiderOffset);
        this.addDrawableChild(this.buttonDone);
        this.addDrawableChild(this.buttonExport);
    }

    public void method_25393() {
        this.textFieldId.method_1865();
        this.textFieldName.method_1865();
        this.textFieldGangwayConnectionId.method_1865();
        this.textFieldTrainBarrierId.method_1865();
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        try {
            this.method_25420(matrices);
            super.method_25394(matrices, mouseX, mouseY, delta);
            int yStart = (this.field_22790 - 200 - 16) / 2;
            ResourcePackCreatorOptionsScreen.method_27535((class_4587)matrices, (class_327)this.field_22793, (class_2561)FILE_MODEL_TEXT, (int)20, (int)(yStart + 6), (int)-1);
            ResourcePackCreatorOptionsScreen.method_27535((class_4587)matrices, (class_327)this.field_22793, (class_2561)FILE_PROPERTIES_TEXT, (int)20, (int)(yStart + 20 + 6), (int)-1);
            ResourcePackCreatorOptionsScreen.method_27535((class_4587)matrices, (class_327)this.field_22793, (class_2561)FILE_TEXTURE_TEXT, (int)20, (int)(yStart + 40 + 6), (int)-1);
            ResourcePackCreatorOptionsScreen.method_27535((class_4587)matrices, (class_327)this.field_22793, (class_2561)ID_TEXT, (int)20, (int)(yStart + 70 + 2 + 6), (int)-1);
            ResourcePackCreatorOptionsScreen.method_27535((class_4587)matrices, (class_327)this.field_22793, (class_2561)NAME_TEXT, (int)20, (int)(yStart + 90 + 6 + 6), (int)-1);
            ResourcePackCreatorOptionsScreen.method_27535((class_4587)matrices, (class_327)this.field_22793, (class_2561)GANGWAY_CONNECTION_ID_TEXT, (int)20, (int)(yStart + 110 + 10 + 6), (int)-1);
            ResourcePackCreatorOptionsScreen.method_27535((class_4587)matrices, (class_327)this.field_22793, (class_2561)TRAIN_BARRIER_ID_TEXT, (int)20, (int)(yStart + 130 + 14 + 6), (int)-1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void method_25419() {
        super.method_25419();
        if (this.field_22787 != null) {
            UtilitiesClient.setScreen(this.field_22787, this.resourcePackCreatorScreen);
        }
    }

    private void updateControls(boolean formatTextFields) {
        String modelFileName = RenderTrains.creatorProperties.getModelFileName();
        this.buttonChooseModelFile.method_25355((class_2561)(modelFileName.isEmpty() ? Text.translatable("gui.mtr.file_upload", new Object[0]) : Text.literal(modelFileName)));
        String propertiesFileName = RenderTrains.creatorProperties.getPropertiesFileName();
        this.buttonChoosePropertiesFile.method_25355((class_2561)(propertiesFileName.isEmpty() ? Text.translatable("gui.mtr.file_upload", new Object[0]) : Text.literal(propertiesFileName)));
        String textureFileName = RenderTrains.creatorProperties.getTextureFileName();
        this.buttonChooseTextureFile.method_25355((class_2561)(textureFileName.isEmpty() ? Text.translatable("gui.mtr.file_upload", new Object[0]) : Text.literal(textureFileName)));
        JsonObject customTrainObject = RenderTrains.creatorProperties.getCustomTrainObject();
        int sliderRiderOffsetValue = Math.round(customTrainObject.get("rider_offset").getAsFloat() * 4.0f + 2.0f);
        if (sliderRiderOffsetValue != this.sliderRiderOffset.getIntValue()) {
            this.sliderRiderOffset.setValue(sliderRiderOffsetValue);
        }
        if (formatTextFields) {
            this.textFieldId.method_1852(RenderTrains.creatorProperties.getCustomTrainId());
            int color = CustomResources.colorStringToInt(customTrainObject.get("color").getAsString());
            this.colorSelector.setColor(color);
            if (color == 0) {
                RenderTrains.creatorProperties.editCustomResourcesColor(this.colorSelector.getColor());
            }
            this.textFieldName.method_1852(customTrainObject.get("name").getAsString());
            this.textFieldGangwayConnectionId.method_1852(customTrainObject.get("gangway_connection_id").getAsString());
            this.textFieldTrainBarrierId.method_1852(customTrainObject.get("train_barrier_id").getAsString());
        }
        this.buttonExport.field_22763 = !this.textFieldId.method_1882().isEmpty() && !this.textFieldName.method_1882().isEmpty() && !RenderTrains.creatorProperties.getModelFileName().isEmpty() && !RenderTrains.creatorProperties.getTextureFileName().isEmpty();
    }

    private void onUpdateColor() {
        RenderTrains.creatorProperties.editCustomResourcesColor(this.colorSelector.getColor());
        this.updateControls(false);
    }

    private void buttonCallback(Consumer<Path> callback) {
        if (this.field_22787 != null) {
            UtilitiesClient.setScreen(this.field_22787, new FileUploaderScreen(this, paths -> {
                if (!paths.isEmpty()) {
                    try {
                        callback.accept((Path)paths.get(0));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }));
        }
    }

    private static String formatText(WidgetBetterTextField textField, String text, boolean isFileName) {
        String cutText = text.toLowerCase(Locale.ENGLISH).replaceAll(isFileName ? "[^\\w:/]" : "\\W", "");
        while (!cutText.isEmpty() && cutText.substring(0, 1).replaceAll("[^a-z]", "").isEmpty()) {
            cutText = cutText.substring(1);
        }
        if (!cutText.equals(text)) {
            textField.method_1852(cutText);
        }
        return cutText;
    }
}

