/*
 * Decompiled with CFR 0.152.
 */
package mtr.screen;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import mtr.Icons;
import mtr.client.CustomResources;
import mtr.client.DoorAnimationType;
import mtr.client.IDrawing;
import mtr.client.IResourcePackCreatorProperties;
import mtr.data.DataConverter;
import mtr.data.EnumHelper;
import mtr.data.IGui;
import mtr.data.NameColorDataBase;
import mtr.data.TransportMode;
import mtr.mappings.ScreenMapper;
import mtr.mappings.Text;
import mtr.mappings.UtilitiesClient;
import mtr.model.ModelTrainBase;
import mtr.render.RenderTrains;
import mtr.screen.DashboardList;
import mtr.screen.ResourcePackCreatorOptionsScreen;
import mtr.screen.WidgetBetterCheckbox;
import mtr.screen.WidgetBetterTextField;
import mtr.screen.WidgetColorSelector;
import mtr.screen.WidgetShorterSlider;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_329;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_765;

public class ResourcePackCreatorScreen
extends ScreenMapper
implements IResourcePackCreatorProperties,
IGui,
Icons {
    private int editingPartIndex = -1;
    private final class_4185 buttonOptions = UtilitiesClient.newButton((class_2561)Text.translatable("menu.options", new Object[0]), button -> {
        if (this.field_22787 != null) {
            UtilitiesClient.setScreen(this.field_22787, new ResourcePackCreatorOptionsScreen(this));
        }
    });
    private final DashboardList availableModelPartsList = new DashboardList(null, null, null, null, this::onAdd, null, null, () -> "", text -> {});
    private final DashboardList usedModelPartsList = new DashboardList(null, null, this::onEdit, null, null, this::onDelete, null, () -> "", text -> {});
    private final WidgetShorterSlider sliderCars = new WidgetShorterSlider(0, 0, 31, value -> {
        cars = value + 1;
        this.updateControls(true);
        return Text.translatable("gui.mtr.vehicle_cars", cars).getString();
    }, null);
    private final WidgetShorterSlider sliderBrightness = new WidgetShorterSlider(0, 0, 100, value -> {
        brightness = value;
        this.updateControls(true);
        return Text.translatable("gui.mtr.vehicle_brightness", brightness).getString();
    }, null);
    private final class_4185 buttonToggleTrainDirection = UtilitiesClient.newButton(button -> {
        head1IsFront = !head1IsFront;
        this.updateControls(true);
    });
    private final class_4185 buttonDoorLeft = UtilitiesClient.newButton(button -> {
        openingLeft = !openingLeft;
        this.updateControls(true);
    });
    private final class_4185 buttonDoorRight = UtilitiesClient.newButton(button -> {
        openingRight = !openingRight;
        this.updateControls(true);
    });
    private final class_4185 buttonTransportMode = UtilitiesClient.newButton(button -> {
        RenderTrains.creatorProperties.editTransportMode();
        this.updateControls(true);
    });
    private final WidgetShorterSlider sliderLength = new WidgetShorterSlider(0, 0, 31, value -> {
        RenderTrains.creatorProperties.editLength(value + 1);
        this.updateControls(true);
        return Text.translatable("gui.mtr.vehicle_length", value + 1).getString();
    }, null);
    private final WidgetShorterSlider sliderWidth = new WidgetShorterSlider(0, 0, 7, value -> {
        RenderTrains.creatorProperties.editWidth(value + 1);
        this.updateControls(true);
        return Text.translatable("gui.mtr.vehicle_width", value + 1).getString();
    }, null);
    private final WidgetShorterSlider sliderDoorMax = new WidgetShorterSlider(0, 0, 31, value -> {
        RenderTrains.creatorProperties.editDoorMax(value + 1);
        this.updateControls(true);
        return Text.translatable("gui.mtr.vehicle_door_max", value + 1).getString();
    }, null);
    private final class_4185 buttonDoorAnimationType = UtilitiesClient.newButton(button -> {
        RenderTrains.creatorProperties.editDoorAnimationType();
        this.updateControls(true);
    });
    private final WidgetBetterCheckbox checkboxPartMirror = new WidgetBetterCheckbox(0, 0, 0, 20, (class_2561)Text.translatable("gui.mtr.part_mirror", new Object[0]), checked -> {
        RenderTrains.creatorProperties.editPartMirror(this.editingPartIndex, checked);
        this.updateControls(true);
    });
    private final WidgetBetterCheckbox checkboxPartSkipRenderingIfTooFar = new WidgetBetterCheckbox(0, 0, 0, 20, (class_2561)Text.translatable("gui.mtr.part_skip_rendering_if_too_far", new Object[0]), checked -> {
        RenderTrains.creatorProperties.editPartSkipRenderingIfTooFar(this.editingPartIndex, checked);
        this.updateControls(true);
    });
    private final WidgetBetterCheckbox checkboxIsDisplay = new WidgetBetterCheckbox(0, 0, 0, 20, (class_2561)Text.translatable("gui.mtr.part_is_display", new Object[0]), checked -> {
        RenderTrains.creatorProperties.editPartDisplay(this.editingPartIndex, checked);
        this.updateControls(true);
    });
    private final WidgetShorterSlider sliderDisplayXPadding = new WidgetShorterSlider(0, 0, 40, value -> {
        float newValue = (float)(value - 20) / 20.0f;
        RenderTrains.creatorProperties.editPartDisplayPadding(this.editingPartIndex, newValue, false);
        this.updateControls(true);
        return Text.translatable("gui.mtr.part_display_x_padding", Float.valueOf(newValue)).getString();
    }, null);
    private final WidgetShorterSlider sliderDisplayYPadding = new WidgetShorterSlider(0, 0, 40, value -> {
        float newValue = (float)(value - 20) / 20.0f;
        RenderTrains.creatorProperties.editPartDisplayPadding(this.editingPartIndex, newValue, true);
        this.updateControls(true);
        return Text.translatable("gui.mtr.part_display_y_padding", Float.valueOf(newValue)).getString();
    }, null);
    private final WidgetShorterSlider sliderDisplayCjkSizeRatio = new WidgetShorterSlider(0, 0, 40, value -> {
        float newValue = (float)(value - 20) / 10.0f;
        RenderTrains.creatorProperties.editPartDisplayCjkSizeRatio(this.editingPartIndex, newValue);
        this.updateControls(true);
        return Text.translatable("gui.mtr.part_display_cjk_size_ratio", Float.valueOf(newValue)).getString();
    }, null);
    private final class_4185 buttonDisplayType = UtilitiesClient.newButton(button -> {
        RenderTrains.creatorProperties.editPartDisplayType(this.editingPartIndex);
        this.updateControls(true);
    });
    private final WidgetColorSelector colorSelectorDisplayCjk = new WidgetColorSelector(this, false, () -> this.onUpdateColor(true));
    private final WidgetColorSelector colorSelectorDisplay = new WidgetColorSelector(this, false, () -> this.onUpdateColor(false));
    private final WidgetBetterCheckbox checkboxShouldScroll = new WidgetBetterCheckbox(0, 0, 0, 20, (class_2561)Text.translatable("gui.mtr.part_display_should_scroll", new Object[0]), checked -> {
        RenderTrains.creatorProperties.editPartDisplayShouldScroll(this.editingPartIndex, checked);
        this.updateControls(true);
    });
    private final WidgetBetterCheckbox checkboxForceUpperCase = new WidgetBetterCheckbox(0, 0, 0, 20, (class_2561)Text.translatable("gui.mtr.part_display_force_upper_case", new Object[0]), checked -> {
        RenderTrains.creatorProperties.editPartDisplayForceUpperCase(this.editingPartIndex, checked);
        this.updateControls(true);
    });
    private final WidgetBetterCheckbox checkboxForceSingleLine = new WidgetBetterCheckbox(0, 0, 0, 20, (class_2561)Text.translatable("gui.mtr.part_display_force_single_line", new Object[0]), checked -> {
        RenderTrains.creatorProperties.editPartDisplayForceSingleLine(this.editingPartIndex, checked);
        this.updateControls(true);
    });
    private final WidgetBetterTextField textFieldDisplayTest = new WidgetBetterTextField("\u6e2c\u8a66|Test", Integer.MAX_VALUE);
    private final class_4185 buttonPartStage = UtilitiesClient.newButton(button -> {
        RenderTrains.creatorProperties.editPartRenderStage(this.editingPartIndex);
        this.updateControls(true);
    });
    private final class_4185 buttonPartDoorOffset = UtilitiesClient.newButton(button -> {
        RenderTrains.creatorProperties.editPartDoorOffset(this.editingPartIndex);
        this.updateControls(true);
    });
    private final class_4185 buttonPartRenderCondition = UtilitiesClient.newButton(button -> {
        RenderTrains.creatorProperties.editPartRenderCondition(this.editingPartIndex);
        this.updateControls(true);
    });
    private final WidgetBetterTextField textFieldPositions = new WidgetBetterTextField("[^\\d.,\\[\\]\\- ]", "[0,0]", Integer.MAX_VALUE);
    private final WidgetBetterTextField textFieldWhitelistedCars = new WidgetBetterTextField("[^%\\d,+\\- ]", "5,-4,%3,%2+1", Integer.MAX_VALUE);
    private final WidgetBetterTextField textFieldBlacklistedCars = new WidgetBetterTextField("[^%\\d,+\\- ]", "5,-4,%3,%2+1", Integer.MAX_VALUE);
    private final class_4185 buttonDone = UtilitiesClient.newButton((class_2561)Text.translatable("gui.done", new Object[0]), button -> {
        this.editingPartIndex = -1;
        this.updateControls(true);
    });
    private static int guiCounter;
    private static boolean hideGui;
    private static float translation;
    private static float yaw;
    private static float roll;
    private static float scale;
    private static int cars;
    private static int brightness;
    private static boolean head1IsFront;
    private static float doorLeftValue;
    private static float doorRightValue;
    private static boolean openingLeft;
    private static boolean openingRight;
    private static final int MIN_SCALE = 1;
    private static final float MOUSE_SCALE = 0.005f;
    private static final String DEFAULT_TEST_STRING = "\u6e2c\u8a66|Test";

    public ResourcePackCreatorScreen() {
        super((class_2561)Text.literal(""));
    }

    protected void method_25426() {
        super.method_25426();
        IDrawing.setPositionAndWidth((class_339)this.buttonOptions, 0, this.field_22790 - 20, 144);
        this.availableModelPartsList.x = 0;
        this.availableModelPartsList.y = 20;
        this.availableModelPartsList.width = 144;
        this.availableModelPartsList.height = this.field_22790 - 40;
        this.usedModelPartsList.y = 90;
        this.usedModelPartsList.width = 144;
        this.usedModelPartsList.height = this.field_22790 - 90;
        int textWidth1 = Math.max(this.field_22793.method_27525((class_5348)Text.translatable("gui.mtr.vehicle_cars", 88)), this.field_22793.method_27525((class_5348)Text.translatable("gui.mtr.vehicle_brightness", 888)));
        int remainingWidth = this.field_22789 - 288 - 16;
        UtilitiesClient.setWidgetX((class_339)this.sliderCars, 152);
        UtilitiesClient.setWidgetY((class_339)this.sliderCars, this.field_22790 - 8 - 60);
        this.sliderCars.method_25358(remainingWidth - 6 - textWidth1);
        this.sliderCars.setHeight(10);
        this.sliderCars.setValue(-1);
        UtilitiesClient.setWidgetX((class_339)this.sliderBrightness, 152);
        UtilitiesClient.setWidgetY((class_339)this.sliderBrightness, this.field_22790 - 8 - 50);
        this.sliderBrightness.method_25358(remainingWidth - 6 - textWidth1);
        this.sliderBrightness.setHeight(10);
        IDrawing.setPositionAndWidth((class_339)this.buttonToggleTrainDirection, 152, this.field_22790 - 8 - 40, remainingWidth);
        IDrawing.setPositionAndWidth((class_339)this.buttonDoorLeft, 152, this.field_22790 - 8 - 20, remainingWidth / 2);
        IDrawing.setPositionAndWidth((class_339)this.buttonDoorRight, 152 + remainingWidth / 2, this.field_22790 - 8 - 20, remainingWidth / 2);
        int xStart = this.field_22789 - 144;
        IDrawing.setPositionAndWidth((class_339)this.buttonTransportMode, xStart, 0, 144);
        class_5250 lengthText = Text.translatable("gui.mtr.vehicle_length", 88);
        class_5250 widthText = Text.translatable("gui.mtr.vehicle_width", 88);
        class_5250 doorMaxText = Text.translatable("gui.mtr.vehicle_door_max", 88);
        int textWidth2 = Math.max(this.field_22793.method_27525((class_5348)lengthText), Math.max(this.field_22793.method_27525((class_5348)widthText), this.field_22793.method_27525((class_5348)doorMaxText))) + 12;
        UtilitiesClient.setWidgetX((class_339)this.sliderLength, xStart);
        UtilitiesClient.setWidgetY((class_339)this.sliderLength, 20);
        this.sliderLength.method_25358(144 - textWidth2);
        this.sliderLength.setHeight(10);
        this.sliderLength.setValue(RenderTrains.creatorProperties.getLength() - 1);
        UtilitiesClient.setWidgetX((class_339)this.sliderWidth, xStart);
        UtilitiesClient.setWidgetY((class_339)this.sliderWidth, 30);
        this.sliderWidth.method_25358(144 - textWidth2);
        this.sliderWidth.setHeight(10);
        this.sliderWidth.setValue(RenderTrains.creatorProperties.getWidth() - 1);
        UtilitiesClient.setWidgetX((class_339)this.sliderDoorMax, xStart);
        UtilitiesClient.setWidgetY((class_339)this.sliderDoorMax, 40);
        this.sliderDoorMax.method_25358(144 - textWidth2);
        this.sliderDoorMax.setHeight(10);
        this.sliderDoorMax.setValue(RenderTrains.creatorProperties.getDoorMax() - 1);
        IDrawing.setPositionAndWidth((class_339)this.buttonDoorAnimationType, xStart, 50, 144);
        IDrawing.setPositionAndWidth((class_339)this.checkboxPartMirror, 0, 20, 144);
        IDrawing.setPositionAndWidth((class_339)this.checkboxPartSkipRenderingIfTooFar, 0, 40, 144);
        IDrawing.setPositionAndWidth((class_339)this.checkboxIsDisplay, 0, 60, 144);
        class_5250 displayXPaddingText = Text.translatable("gui.mtr.part_display_x_padding", -8.88);
        class_5250 displayYPaddingText = Text.translatable("gui.mtr.part_display_y_padding", -8.88);
        class_5250 displayCjkSizeRatioText = Text.translatable("gui.mtr.part_display_cjk_size_ratio", -8.88);
        int textWidth3 = Math.max(Math.max(this.field_22793.method_27525((class_5348)displayXPaddingText), this.field_22793.method_27525((class_5348)displayYPaddingText)), this.field_22793.method_27525((class_5348)displayCjkSizeRatioText)) + 12;
        UtilitiesClient.setWidgetX((class_339)this.sliderDisplayXPadding, 0);
        UtilitiesClient.setWidgetY((class_339)this.sliderDisplayXPadding, 80);
        this.sliderDisplayXPadding.method_25358(144 - textWidth3);
        this.sliderDisplayXPadding.setHeight(10);
        UtilitiesClient.setWidgetX((class_339)this.sliderDisplayYPadding, 0);
        UtilitiesClient.setWidgetY((class_339)this.sliderDisplayYPadding, 90);
        this.sliderDisplayYPadding.method_25358(144 - textWidth3);
        this.sliderDisplayYPadding.setHeight(10);
        UtilitiesClient.setWidgetX((class_339)this.sliderDisplayCjkSizeRatio, 0);
        UtilitiesClient.setWidgetY((class_339)this.sliderDisplayCjkSizeRatio, 100);
        this.sliderDisplayCjkSizeRatio.method_25358(144 - textWidth3);
        this.sliderDisplayCjkSizeRatio.setHeight(10);
        IDrawing.setPositionAndWidth((class_339)this.buttonDisplayType, 0, 110, 144);
        IDrawing.setPositionAndWidth((class_339)this.colorSelectorDisplayCjk, 124, 130, 10);
        IDrawing.setPositionAndWidth((class_339)this.colorSelectorDisplay, 134, 130, 10);
        IDrawing.setPositionAndWidth((class_339)this.checkboxShouldScroll, 0, 150, 144);
        IDrawing.setPositionAndWidth((class_339)this.checkboxForceUpperCase, 0, 170, 144);
        IDrawing.setPositionAndWidth((class_339)this.checkboxForceSingleLine, 0, 190, 144);
        IDrawing.setPositionAndWidth((class_339)this.textFieldDisplayTest, 2, 212, 140);
        this.textFieldDisplayTest.method_1852(DEFAULT_TEST_STRING);
        IDrawing.setPositionAndWidth((class_339)this.buttonPartStage, xStart, 0, 144);
        IDrawing.setPositionAndWidth((class_339)this.buttonPartDoorOffset, xStart, 20, 144);
        IDrawing.setPositionAndWidth((class_339)this.buttonPartRenderCondition, xStart, 40, 144);
        IDrawing.setPositionAndWidth((class_339)this.textFieldPositions, this.field_22789, 76, 140);
        IDrawing.setPositionAndWidth((class_339)this.textFieldWhitelistedCars, this.field_22789, 114, 140);
        IDrawing.setPositionAndWidth((class_339)this.textFieldBlacklistedCars, this.field_22789, 152, 140);
        IDrawing.setPositionAndWidth((class_339)this.buttonDone, xStart, this.field_22790 - 20, 144);
        this.textFieldPositions.method_1863(text -> {
            RenderTrains.creatorProperties.editPartPositions(this.editingPartIndex, this.textFieldPositions.method_1882());
            this.updateControls(false);
        });
        this.textFieldWhitelistedCars.method_1863(text -> {
            RenderTrains.creatorProperties.editPartWhitelistedCars(this.editingPartIndex, this.textFieldWhitelistedCars.method_1882());
            this.updateControls(false);
        });
        this.textFieldBlacklistedCars.method_1863(text -> {
            RenderTrains.creatorProperties.editPartBlacklistedCars(this.editingPartIndex, this.textFieldBlacklistedCars.method_1882());
            this.updateControls(false);
        });
        this.updateControls(true);
        this.addDrawableChild(this.buttonOptions);
        this.availableModelPartsList.init(this::addDrawableChild);
        this.usedModelPartsList.init(this::addDrawableChild);
        this.addDrawableChild(this.sliderCars);
        this.addDrawableChild(this.sliderBrightness);
        this.addDrawableChild(this.buttonToggleTrainDirection);
        this.addDrawableChild(this.buttonDoorLeft);
        this.addDrawableChild(this.buttonDoorRight);
        this.addDrawableChild(this.buttonTransportMode);
        this.addDrawableChild(this.sliderLength);
        this.addDrawableChild(this.sliderWidth);
        this.addDrawableChild(this.sliderDoorMax);
        this.addDrawableChild(this.buttonDoorAnimationType);
        this.addDrawableChild(this.checkboxPartMirror);
        this.addDrawableChild(this.checkboxPartSkipRenderingIfTooFar);
        this.addDrawableChild(this.checkboxIsDisplay);
        this.addDrawableChild(this.sliderDisplayXPadding);
        this.addDrawableChild(this.sliderDisplayYPadding);
        this.addDrawableChild(this.sliderDisplayCjkSizeRatio);
        this.addDrawableChild(this.buttonDisplayType);
        this.addDrawableChild(this.colorSelectorDisplayCjk);
        this.addDrawableChild(this.colorSelectorDisplay);
        this.addDrawableChild(this.checkboxShouldScroll);
        this.addDrawableChild(this.checkboxForceUpperCase);
        this.addDrawableChild(this.checkboxForceSingleLine);
        this.addDrawableChild(this.textFieldDisplayTest);
        this.addDrawableChild(this.buttonPartStage);
        this.addDrawableChild(this.buttonPartDoorOffset);
        this.addDrawableChild(this.buttonPartRenderCondition);
        this.addDrawableChild(this.textFieldPositions);
        this.addDrawableChild(this.textFieldWhitelistedCars);
        this.addDrawableChild(this.textFieldBlacklistedCars);
        this.addDrawableChild(this.buttonDone);
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        try {
            if (guiCounter == 0 && this.field_22787 != null) {
                hideGui = this.field_22787.field_1690.field_1842;
                class_329.method_25294((class_4587)matrices, (int)0, (int)0, (int)this.field_22789, (int)this.field_22790, (int)-16777216);
            }
            class_329.method_25294((class_4587)matrices, (int)0, (int)0, (int)144, (int)this.field_22790, (int)-15592942);
            class_329.method_25294((class_4587)matrices, (int)(this.field_22789 - 144), (int)0, (int)this.field_22789, (int)this.field_22790, (int)-15592942);
            this.availableModelPartsList.render(matrices, this.field_22793);
            this.usedModelPartsList.render(matrices, this.field_22793);
            super.method_25394(matrices, mouseX, mouseY, delta);
            if (this.isEditing()) {
                ResourcePackCreatorScreen.method_27534((class_4587)matrices, (class_327)this.field_22793, (class_2561)Text.translatable("gui.mtr.editing_part", RenderTrains.creatorProperties.getPropertiesPartsArray().get(this.editingPartIndex).getAsJsonObject().get("name").getAsString()), (int)72, (int)6, (int)-1);
                if (this.colorSelectorDisplay.field_22764) {
                    ResourcePackCreatorScreen.method_27535((class_4587)matrices, (class_327)this.field_22793, (class_2561)Text.translatable(this.colorSelectorDisplayCjk.field_22764 ? "gui.mtr.part_display_text_color_cjk" : "gui.mtr.part_display_text_color", new Object[0]), (int)6, (int)136, (int)-1);
                }
                ResourcePackCreatorScreen.method_27534((class_4587)matrices, (class_327)this.field_22793, (class_2561)Text.translatable("gui.mtr.part_positions", new Object[0]), (int)(this.field_22789 - 72), (int)66, (int)-1);
                ResourcePackCreatorScreen.method_27534((class_4587)matrices, (class_327)this.field_22793, (class_2561)Text.translatable("gui.mtr.part_whitelisted_cars", new Object[0]), (int)(this.field_22789 - 72), (int)104, (int)-1);
                ResourcePackCreatorScreen.method_27534((class_4587)matrices, (class_327)this.field_22793, (class_2561)Text.translatable("gui.mtr.part_blacklisted_cars", new Object[0]), (int)(this.field_22789 - 72), (int)142, (int)-1);
            } else {
                ResourcePackCreatorScreen.method_27534((class_4587)matrices, (class_327)this.field_22793, (class_2561)Text.translatable("gui.mtr.available_model_parts", new Object[0]), (int)72, (int)6, (int)-1);
                ResourcePackCreatorScreen.method_27534((class_4587)matrices, (class_327)this.field_22793, (class_2561)Text.translatable("gui.mtr.used_model_parts", new Object[0]), (int)(this.field_22789 - 72), (int)76, (int)-1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        guiCounter = 2;
    }

    public void method_16014(double mouseX, double mouseY) {
        this.availableModelPartsList.mouseMoved(mouseX, mouseY);
        this.usedModelPartsList.mouseMoved(mouseX, mouseY);
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (mouseX >= 144.0 && mouseX < (double)(this.field_22789 - 144)) {
            scale = Math.max(scale - (float)amount, 1.0f);
            float bound = (float)(cars * RenderTrains.creatorProperties.getLength()) / 2.0f;
            translation = class_3532.method_15363((float)translation, (float)(-bound), (float)bound);
        }
        this.availableModelPartsList.mouseScrolled(mouseX, mouseY, amount);
        this.usedModelPartsList.mouseScrolled(mouseX, mouseY, amount);
        return super.method_25401(mouseX, mouseY, amount);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (mouseX >= 144.0 && mouseX < (double)(this.field_22789 - 144) && mouseY < (double)(this.field_22790 - 8 - 60)) {
            if (button == 0) {
                class_243 movement = new class_243(0.0, deltaY * (double)0.005f * (double)scale, deltaX * (double)0.005f * (double)scale).method_1024(yaw).method_31033(roll);
                float bound = (float)(cars * RenderTrains.creatorProperties.getLength()) / 2.0f;
                translation = class_3532.method_15363((float)(translation - (float)movement.field_1350), (float)(-bound), (float)bound);
            } else {
                roll = (float)((double)roll - (double)((float)deltaY * 0.005f * scale) * Math.cos(yaw -= (float)deltaX * 0.005f * scale));
            }
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public void method_25393() {
        this.availableModelPartsList.tick();
        this.usedModelPartsList.tick();
        this.textFieldPositions.method_1865();
        this.textFieldWhitelistedCars.method_1865();
        this.textFieldBlacklistedCars.method_1865();
        float maxTime = EnumHelper.valueOf(DoorAnimationType.STANDARD, (String)RenderTrains.creatorProperties.getDoorAnimationType()).maxTime;
        float increment = 0.015625f;
        if (openingLeft) {
            if (doorLeftValue < maxTime) {
                doorLeftValue = Math.min(maxTime, doorLeftValue + 0.015625f);
            }
        } else if (doorLeftValue > 0.0f) {
            doorLeftValue = Math.max(0.0f, doorLeftValue - 0.015625f);
        }
        if (openingRight) {
            if (doorRightValue < maxTime) {
                doorRightValue = Math.min(maxTime, doorRightValue + 0.015625f);
            }
        } else if (doorRightValue > 0.0f) {
            doorRightValue = Math.max(0.0f, doorRightValue - 0.015625f);
        }
    }

    public String getTestText() {
        return IGui.textOrUntitled(this.textFieldDisplayTest.method_1882());
    }

    private List<DataConverter> updatePartsList(JsonArray jsonArray, Function<JsonObject, Integer> color, Function<JsonObject, String> extraText) {
        ArrayList<DataConverter> listData = new ArrayList<DataConverter>();
        if (jsonArray.size() > 0) {
            try {
                jsonArray.forEach(jsonElement -> {
                    JsonObject jsonObject = jsonElement.getAsJsonObject();
                    String name = jsonObject.get("name").getAsString();
                    listData.add(new DataConverter(extraText == null ? name : ((String)extraText.apply(jsonObject)).replace("%s", name), 0xFF000000 | (color == null ? 0 : (Integer)color.apply(jsonObject))));
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return listData;
    }

    private void updateControls(boolean formatTextFields) {
        int sliderDoorMaxValue;
        int sliderWidthValue;
        this.availableModelPartsList.setData(this.updatePartsList(RenderTrains.creatorProperties.getModelPartsArray(), null, null), false, false, false, false, true, false);
        JsonArray partsArray = RenderTrains.creatorProperties.getPropertiesPartsArray();
        this.usedModelPartsList.setData(this.updatePartsList(partsArray, ResourcePackCreatorScreen::getColor, ResourcePackCreatorScreen::getName), false, false, true, false, false, true);
        String transportModeString = RenderTrains.creatorProperties.getTransportMode();
        this.buttonTransportMode.method_25355((class_2561)Text.translatable("gui.mtr.transport_mode_" + transportModeString.toLowerCase(Locale.ENGLISH), new Object[0]));
        cars = class_3532.method_15340((int)cars, (int)1, (int)Math.min(32, EnumHelper.valueOf(TransportMode.TRAIN, (String)transportModeString).maxLength));
        this.buttonDoorAnimationType.method_25355((class_2561)Text.translatable("gui.mtr.door_animation_type_" + RenderTrains.creatorProperties.getDoorAnimationType().toLowerCase(Locale.ENGLISH), new Object[0]));
        int sliderCarsValue = cars - 1;
        if (sliderCarsValue != this.sliderCars.getIntValue()) {
            this.sliderCars.setValue(sliderCarsValue);
        }
        if (brightness != this.sliderBrightness.getIntValue()) {
            this.sliderBrightness.setValue(brightness);
        }
        this.buttonToggleTrainDirection.method_25355((class_2561)Text.translatable("gui.mtr.vehicle_direction_" + (head1IsFront ? "forwards" : "backwards"), new Object[0]));
        this.buttonDoorLeft.method_25355((class_2561)Text.literal(openingLeft ? "\u25b6|\u25c0" : "\u25c0|\u25b6").method_27693(" ").method_10852((class_2561)Text.translatable("gui.mtr.left", new Object[0])));
        this.buttonDoorRight.method_25355((class_2561)Text.literal(openingRight ? "\u25b6|\u25c0" : "\u25c0|\u25b6").method_27693(" ").method_10852((class_2561)Text.translatable("gui.mtr.right", new Object[0])));
        int sliderLengthValue = RenderTrains.creatorProperties.getLength() - 1;
        if (sliderLengthValue != this.sliderLength.getIntValue()) {
            this.sliderLength.setValue(sliderLengthValue);
        }
        if ((sliderWidthValue = RenderTrains.creatorProperties.getWidth() - 1) != this.sliderWidth.getIntValue()) {
            this.sliderWidth.setValue(sliderWidthValue);
        }
        if ((sliderDoorMaxValue = RenderTrains.creatorProperties.getDoorMax() - 1) != this.sliderDoorMax.getIntValue()) {
            this.sliderDoorMax.setValue(sliderDoorMaxValue);
        }
        if (this.isEditing()) {
            this.buttonOptions.field_22764 = false;
            this.buttonTransportMode.field_22764 = false;
            this.sliderLength.field_22764 = false;
            this.sliderWidth.field_22764 = false;
            this.sliderDoorMax.field_22764 = false;
            this.buttonDoorAnimationType.field_22764 = false;
            this.checkboxPartMirror.field_22764 = true;
            this.checkboxPartSkipRenderingIfTooFar.field_22764 = true;
            this.checkboxIsDisplay.field_22764 = true;
            this.buttonPartStage.field_22764 = true;
            this.buttonPartDoorOffset.field_22764 = true;
            this.buttonPartRenderCondition.field_22764 = true;
            UtilitiesClient.setWidgetX((class_339)this.textFieldPositions, this.field_22789 - 144 + 2);
            UtilitiesClient.setWidgetX((class_339)this.textFieldWhitelistedCars, this.field_22789 - 144 + 2);
            UtilitiesClient.setWidgetX((class_339)this.textFieldBlacklistedCars, this.field_22789 - 144 + 2);
            this.buttonDone.field_22764 = true;
            this.availableModelPartsList.x = this.field_22789;
            this.usedModelPartsList.x = this.field_22789;
            JsonObject partObject = partsArray.get(this.editingPartIndex).getAsJsonObject();
            this.checkboxPartMirror.setChecked(partObject.get("mirror").getAsBoolean());
            this.checkboxPartSkipRenderingIfTooFar.setChecked(partObject.get("skip_rendering_if_too_far").getAsBoolean());
            boolean hasDisplay = partObject.has("display");
            this.checkboxIsDisplay.setChecked(hasDisplay);
            this.sliderDisplayXPadding.field_22764 = hasDisplay;
            this.sliderDisplayYPadding.field_22764 = hasDisplay;
            this.sliderDisplayCjkSizeRatio.field_22764 = hasDisplay;
            this.buttonDisplayType.field_22764 = hasDisplay;
            this.colorSelectorDisplayCjk.field_22764 = hasDisplay;
            this.colorSelectorDisplay.field_22764 = hasDisplay;
            this.checkboxShouldScroll.field_22764 = hasDisplay;
            this.checkboxForceUpperCase.field_22764 = hasDisplay;
            this.checkboxForceSingleLine.field_22764 = hasDisplay;
            UtilitiesClient.setWidgetX((class_339)this.textFieldDisplayTest, (hasDisplay ? 0 : this.field_22789) + 2);
            if (hasDisplay) {
                int sliderDisplayCjkSizeRatio;
                int sliderDisplayYPaddingValue;
                boolean shouldScroll = partObject.getAsJsonObject("display").get("should_scroll").getAsBoolean();
                boolean forceSingleLine = partObject.getAsJsonObject("display").get("force_single_line").getAsBoolean();
                int sliderDisplayXPaddingValue = Math.round(partObject.getAsJsonObject("display").get("x_padding").getAsFloat() * 20.0f + 20.0f);
                if (sliderDisplayXPaddingValue != this.sliderDisplayXPadding.getIntValue()) {
                    this.sliderDisplayXPadding.setValue(sliderDisplayXPaddingValue);
                }
                if ((sliderDisplayYPaddingValue = Math.round(partObject.getAsJsonObject("display").get("y_padding").getAsFloat() * 20.0f + 20.0f)) != this.sliderDisplayYPadding.getIntValue()) {
                    this.sliderDisplayYPadding.setValue(sliderDisplayYPaddingValue);
                }
                if ((sliderDisplayCjkSizeRatio = (forceSingleLine ? 0 : Math.round(partObject.getAsJsonObject("display").get("cjk_size_ratio").getAsFloat() * 10.0f)) + 20) != this.sliderDisplayCjkSizeRatio.getIntValue()) {
                    this.sliderDisplayCjkSizeRatio.setValue(sliderDisplayCjkSizeRatio);
                }
                this.colorSelectorDisplayCjk.field_22764 = !shouldScroll;
                this.sliderDisplayCjkSizeRatio.field_22764 = !forceSingleLine;
                this.buttonDisplayType.method_25355((class_2561)Text.translatable("gui.mtr.part_display_type_" + partObject.getAsJsonObject("display").get("type").getAsString().toLowerCase(Locale.ENGLISH), new Object[0]));
                this.colorSelectorDisplayCjk.setColor(CustomResources.colorStringToInt(partObject.getAsJsonObject("display").get("color_cjk").getAsString()));
                this.colorSelectorDisplay.setColor(CustomResources.colorStringToInt(partObject.getAsJsonObject("display").get("color").getAsString()));
                this.checkboxShouldScroll.setChecked(shouldScroll);
                this.checkboxForceUpperCase.setChecked(partObject.getAsJsonObject("display").get("force_upper_case").getAsBoolean());
                this.checkboxForceSingleLine.setChecked(forceSingleLine);
            }
            this.buttonPartStage.method_25355((class_2561)Text.translatable("gui.mtr.part_stage_" + partObject.get("stage").getAsString().toLowerCase(Locale.ENGLISH), new Object[0]));
            this.buttonPartDoorOffset.method_25355((class_2561)Text.translatable("gui.mtr.part_door_offset_" + partObject.get("door_offset").getAsString().toLowerCase(Locale.ENGLISH), new Object[0]));
            this.buttonPartRenderCondition.method_25355((class_2561)Text.translatable("gui.mtr.part_render_condition_" + partObject.get("render_condition").getAsString().toLowerCase(Locale.ENGLISH), new Object[0]));
            if (formatTextFields) {
                StringBuilder positionsString = new StringBuilder();
                JsonArray positionsArray = partObject.getAsJsonArray("positions");
                for (int i = 0; i < positionsArray.size(); ++i) {
                    try {
                        JsonArray positionArray = positionsArray.get(i).getAsJsonArray();
                        positionsString.append("[").append(positionArray.get(0).getAsFloat()).append(",").append(positionArray.get(1).getAsFloat()).append("],");
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.textFieldPositions.method_1852(positionsString.toString().replace(".0,", ",").replace(".0]", "]"));
                this.textFieldWhitelistedCars.method_1852(partObject.get("whitelisted_cars").toString());
                this.textFieldBlacklistedCars.method_1852(partObject.get("blacklisted_cars").toString());
            }
        } else {
            this.buttonOptions.field_22764 = true;
            this.buttonTransportMode.field_22764 = true;
            this.sliderLength.field_22764 = true;
            this.sliderWidth.field_22764 = true;
            this.sliderDoorMax.field_22764 = true;
            this.buttonDoorAnimationType.field_22764 = true;
            this.checkboxPartMirror.field_22764 = false;
            this.checkboxPartSkipRenderingIfTooFar.field_22764 = false;
            this.checkboxIsDisplay.field_22764 = false;
            this.sliderDisplayXPadding.field_22764 = false;
            this.sliderDisplayYPadding.field_22764 = false;
            this.sliderDisplayCjkSizeRatio.field_22764 = false;
            this.buttonDisplayType.field_22764 = false;
            this.colorSelectorDisplayCjk.field_22764 = false;
            this.colorSelectorDisplay.field_22764 = false;
            this.checkboxShouldScroll.field_22764 = false;
            this.checkboxForceUpperCase.field_22764 = false;
            this.checkboxForceSingleLine.field_22764 = false;
            UtilitiesClient.setWidgetX((class_339)this.textFieldDisplayTest, this.field_22789 + 2);
            this.buttonPartStage.field_22764 = false;
            this.buttonPartDoorOffset.field_22764 = false;
            this.buttonPartRenderCondition.field_22764 = false;
            UtilitiesClient.setWidgetX((class_339)this.textFieldPositions, this.field_22789 + 2);
            UtilitiesClient.setWidgetX((class_339)this.textFieldWhitelistedCars, this.field_22789 + 2);
            UtilitiesClient.setWidgetX((class_339)this.textFieldBlacklistedCars, this.field_22789 + 2);
            this.buttonDone.field_22764 = false;
            this.availableModelPartsList.x = 0;
            this.usedModelPartsList.x = this.field_22789 - 144;
        }
    }

    private void onAdd(NameColorDataBase data, int index) {
        RenderTrains.creatorProperties.addPart(data.name);
        this.updateControls(true);
    }

    private void onEdit(NameColorDataBase data, int index) {
        this.editingPartIndex = index;
        this.updateControls(true);
    }

    private void onDelete(NameColorDataBase data, int index) {
        RenderTrains.creatorProperties.removePart(index);
        this.editingPartIndex = -1;
        this.updateControls(true);
    }

    private void onUpdateColor(boolean isCjk) {
        RenderTrains.creatorProperties.editPartDisplayColor(this.editingPartIndex, (isCjk ? this.colorSelectorDisplayCjk : this.colorSelectorDisplay).getColor(), isCjk);
        this.updateControls(false);
    }

    private boolean isEditing() {
        return this.editingPartIndex >= 0 && this.editingPartIndex < RenderTrains.creatorProperties.getPropertiesPartsArray().size();
    }

    public static void render(class_4587 matrices) {
        if (guiCounter > 0) {
            class_310 minecraft = class_310.method_1551();
            minecraft.field_1690.field_1842 = --guiCounter != 0 || hideGui;
            matrices.method_22903();
            class_4597.class_4598 immediate = minecraft.method_22940().method_23000();
            IDrawing.drawTexture(matrices, immediate.getBuffer(class_1921.method_23577()), -2.1474836E9f, 2.1474836E9f, -256.0f, 2.1474836E9f, -2.1474836E9f, -256.0f, class_2350.field_11036, -16777216, 0);
            immediate.method_22993();
            matrices.method_46416(0.0f, 0.0f, -scale);
            UtilitiesClient.rotateYDegrees(matrices, 90.0f);
            UtilitiesClient.rotateXDegrees(matrices, 180.0f);
            UtilitiesClient.rotateY(matrices, yaw);
            UtilitiesClient.rotateZ(matrices, roll);
            int light = class_765.method_23687((int)0, (int)((int)Math.round((double)brightness / 100.0 * 15.0)));
            for (int i = 0; i < cars; ++i) {
                matrices.method_22903();
                matrices.method_46416(0.0f, 0.0f, ((float)i - (float)(cars - 1) / 2.0f) * (float)(RenderTrains.creatorProperties.getLength() + 1) + translation);
                RenderTrains.creatorProperties.render(matrices, i, cars, head1IsFront, doorLeftValue, doorRightValue, openingRight || openingLeft, light);
                matrices.method_22909();
            }
            matrices.method_22909();
        }
    }

    private static int getColor(JsonObject jsonObject) {
        ModelTrainBase.RenderStage renderStage = EnumHelper.valueOf(ModelTrainBase.RenderStage.EXTERIOR, jsonObject.get("stage").getAsString());
        switch (renderStage) {
            case EXTERIOR: {
                return 6405455;
            }
            case INTERIOR: {
                return 15022389;
            }
            case INTERIOR_TRANSLUCENT: {
                return 16485376;
            }
            case LIGHTS: {
                return 15914496;
            }
            case ALWAYS_ON_LIGHTS: {
                return 2001125;
            }
        }
        return 0;
    }

    private static String getName(JsonObject jsonObject) {
        boolean mirror = jsonObject.get("mirror").getAsBoolean();
        int positionCount = jsonObject.getAsJsonArray("positions").size();
        return (mirror ? "*" : "") + "%s (" + positionCount + "x)";
    }

    static {
        scale = 10.0f;
        brightness = 50;
        head1IsFront = true;
        doorLeftValue = 0.0f;
        doorRightValue = 0.0f;
        openingLeft = false;
        openingRight = false;
    }
}

