/*
 * Decompiled with CFR 0.152.
 */
package mtr.screen;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import mtr.Icons;
import mtr.Patreon;
import mtr.client.ClientData;
import mtr.client.IDrawing;
import mtr.client.TrainClientRegistry;
import mtr.client.TrainProperties;
import mtr.data.NameColorDataBase;
import mtr.data.RailType;
import mtr.data.RailwayData;
import mtr.data.Siding;
import mtr.data.Train;
import mtr.data.TrainType;
import mtr.data.TransportMode;
import mtr.mappings.Text;
import mtr.mappings.UtilitiesClient;
import mtr.packet.IPacket;
import mtr.packet.PacketTrainDataGuiClient;
import mtr.screen.DashboardList;
import mtr.screen.DashboardScreen;
import mtr.screen.SavedRailScreenBase;
import mtr.screen.WidgetBetterCheckbox;
import mtr.screen.WidgetBetterTextField;
import mtr.screen.WidgetShorterSlider;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public class SidingScreen
extends SavedRailScreenBase<Siding>
implements Icons {
    private boolean isSelectingTrain;
    private final float oldAcceleration;
    private final boolean oldIsManual;
    private final int oldMaxManualSpeed;
    private final int oldDwellTime;
    private final TransportMode transportMode;
    private final class_4185 buttonSelectTrain;
    private final DashboardList availableTrainsList;
    private final WidgetBetterCheckbox buttonUnlimitedTrains;
    private final WidgetBetterTextField textFieldMaxTrains;
    private final WidgetShorterSlider sliderAccelerationConstant;
    private final WidgetBetterCheckbox buttonIsManual;
    private final WidgetShorterSlider sliderMaxManualSpeed;
    private static final class_2561 SELECTED_TRAIN_TEXT = Text.translatable("gui.mtr.selected_vehicle", new Object[0]);
    private static final class_2561 MAX_TRAINS_TEXT = Text.translatable("gui.mtr.max_vehicles", new Object[0]);
    private static final class_2561 ACCELERATION_CONSTANT_TEXT = Text.translatable("gui.mtr.acceleration", new Object[0]);
    private static final class_2561 MANUAL_TO_AUTOMATIC_TIME = Text.translatable("gui.mtr.manual_to_automatic_time", new Object[0]);
    private static final class_2561 MAX_MANUAL_SPEED = Text.translatable("gui.mtr.max_manual_speed", new Object[0]);
    private static final int MAX_TRAINS_TEXT_LENGTH = 3;
    private static final int MAX_TRAINS_WIDTH = 80;
    private static final int DESCRIPTION_WIDTH = 160;
    private static final int SLIDER_SCALE = 1000;
    private static final float ACCELERATION_UNIT_CONVERSION_1 = 400.0f;
    private static final float ACCELERATION_UNIT_CONVERSION_2 = 1440.0f;
    private static final Map<String, String> WIKIPEDIA_ARTICLES = new HashMap<String, String>();

    public SidingScreen(Siding siding, TransportMode transportMode, DashboardScreen dashboardScreen) {
        super(siding, transportMode, dashboardScreen, SELECTED_TRAIN_TEXT, MAX_TRAINS_TEXT, ACCELERATION_CONSTANT_TEXT, MANUAL_TO_AUTOMATIC_TIME, MAX_MANUAL_SPEED);
        this.transportMode = transportMode;
        this.buttonSelectTrain = UtilitiesClient.newButton(button -> this.onSelectingTrain());
        this.availableTrainsList = new DashboardList(null, null, null, null, this::onAdd, null, null, () -> ClientData.TRAINS_SEARCH, text -> {
            ClientData.TRAINS_SEARCH = text;
        });
        this.textFieldMaxTrains = new WidgetBetterTextField(WidgetBetterTextField.TextFieldFilter.POSITIVE_INTEGER, "", 3);
        this.sliderAccelerationConstant = new WidgetShorterSlider(0, 80, Math.round(49.000004f), this::accelerationSliderFormatter, null);
        this.buttonIsManual = new WidgetBetterCheckbox(0, 0, 0, 20, (class_2561)Text.translatable("gui.mtr.is_manual", new Object[0]), checked -> {
            if (checked && !this.textFieldMaxTrains.method_1882().equals("1")) {
                this.textFieldMaxTrains.method_1852("1");
            }
            this.setIsSelectingTrain(false);
        });
        this.sliderMaxManualSpeed = new WidgetShorterSlider(0, 80, RailType.DIAMOND.ordinal(), this::speedSliderFormatter, null);
        this.buttonUnlimitedTrains = new WidgetBetterCheckbox(0, 0, 0, 20, (class_2561)Text.translatable("gui.mtr.unlimited_vehicles", new Object[0]), checked -> {
            if (checked) {
                this.buttonIsManual.setChecked(false);
            }
            if (checked && !this.textFieldMaxTrains.method_1882().isEmpty()) {
                this.textFieldMaxTrains.method_1852("");
            } else if (!checked && this.textFieldMaxTrains.method_1882().isEmpty()) {
                this.textFieldMaxTrains.method_1852("1");
            }
            this.setIsSelectingTrain(false);
        });
        this.oldAcceleration = ((Siding)this.savedRailBase).getAccelerationConstant();
        this.oldIsManual = ((Siding)this.savedRailBase).getIsManual();
        this.oldMaxManualSpeed = ((Siding)this.savedRailBase).getMaxManualSpeed();
        this.oldDwellTime = ((Siding)this.savedRailBase).getDwellTime();
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        IDrawing.setPositionAndWidth((class_339)this.buttonSelectTrain, 20 + this.textWidth, 44, this.field_22789 - this.textWidth - 40);
        IDrawing.setPositionAndWidth((class_339)this.buttonUnlimitedTrains, 20 + this.textWidth + 80 + 4 + 4, 66, this.field_22789 - this.textWidth - 40);
        this.addDrawableChild(this.buttonSelectTrain);
        this.availableTrainsList.y = 20;
        this.availableTrainsList.height = this.field_22790 - 40;
        this.availableTrainsList.width = this.field_22789 - 160 - 60;
        this.availableTrainsList.init(this::addDrawableChild);
        this.buttonIsManual.setChecked(((Siding)this.savedRailBase).getIsManual());
        this.buttonUnlimitedTrains.setChecked(((Siding)this.savedRailBase).getUnlimitedTrains());
        IDrawing.setPositionAndWidth((class_339)this.textFieldMaxTrains, 20 + this.textWidth + 2, 66, 76);
        this.textFieldMaxTrains.method_1852(((Siding)this.savedRailBase).getUnlimitedTrains() ? "" : String.valueOf(((Siding)this.savedRailBase).getMaxTrains() + 1));
        this.textFieldMaxTrains.method_1863(text -> {
            this.buttonUnlimitedTrains.setChecked(text.isEmpty());
            if (!text.equals("1")) {
                this.buttonIsManual.setChecked(false);
            }
            this.setIsSelectingTrain(false);
        });
        UtilitiesClient.setWidgetX((class_339)this.sliderAccelerationConstant, 20 + this.textWidth);
        UtilitiesClient.setWidgetY((class_339)this.sliderAccelerationConstant, 88);
        this.sliderAccelerationConstant.setHeight(20);
        this.sliderAccelerationConstant.setValue(Math.round((((Siding)this.savedRailBase).getAccelerationConstant() - 0.001f) * 1000.0f));
        IDrawing.setPositionAndWidth((class_339)this.buttonIsManual, 20, 128, this.field_22789 - this.textWidth - 40);
        UtilitiesClient.setWidgetX((class_339)this.sliderMaxManualSpeed, 20 + this.textWidth);
        UtilitiesClient.setWidgetY((class_339)this.sliderMaxManualSpeed, 148);
        this.sliderMaxManualSpeed.setHeight(20);
        this.sliderMaxManualSpeed.setValue(((Siding)this.savedRailBase).getMaxManualSpeed());
        UtilitiesClient.setWidgetY((class_339)this.sliderDwellTimeMin, 168);
        UtilitiesClient.setWidgetY((class_339)this.sliderDwellTimeSec, 178);
        this.setIsSelectingTrain(false);
        if (this.showScheduleControls) {
            this.addDrawableChild(this.buttonUnlimitedTrains);
            this.addDrawableChild(this.textFieldMaxTrains);
            this.addDrawableChild(this.sliderAccelerationConstant);
            this.addDrawableChild(this.buttonIsManual);
            this.addDrawableChild(this.sliderMaxManualSpeed);
        }
    }

    @Override
    public void method_25393() {
        super.method_25393();
        this.availableTrainsList.tick();
        this.textFieldMaxTrains.method_1865();
    }

    @Override
    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        block6: {
            block5: {
                super.method_25394(matrices, mouseX, mouseY, delta);
                if (this.isSelectingTrain) break block5;
                this.field_22793.method_30883(matrices, SELECTED_TRAIN_TEXT, 20.0f, 50.0f, -1);
                if (!this.showScheduleControls) break block6;
                this.field_22793.method_30883(matrices, MAX_TRAINS_TEXT, 20.0f, 72.0f, -1);
                this.field_22793.method_30883(matrices, ACCELERATION_CONSTANT_TEXT, 20.0f, 94.0f, -1);
                if (!this.buttonIsManual.method_20372()) break block6;
                this.field_22793.method_30883(matrices, MAX_MANUAL_SPEED, 20.0f, 154.0f, -1);
                this.field_22793.method_30883(matrices, MANUAL_TO_AUTOMATIC_TIME, 20.0f, 174.0f, -1);
                break block6;
            }
            int index = this.availableTrainsList.getHoverItemIndex();
            if (index >= 0) {
                TrainProperties properties = TrainClientRegistry.getTrainProperties(this.transportMode, index);
                int spacing = TrainType.getSpacing(properties.baseTrainType);
                int cars = (int)Math.floor(((Siding)this.savedRailBase).railLength / (float)spacing);
                int y = 20;
                y = this.drawWrappedText(matrices, properties.name, y, -1);
                y = this.drawWrappedText(matrices, (class_2561)Text.translatable("gui.mtr.vehicle_length", spacing - 1), y, -1);
                y = this.drawWrappedText(matrices, (class_2561)Text.translatable("gui.mtr.cars_to_spawn", (cars == 0 ? "\u26a0 " : "") + Math.min(cars, ((Siding)this.savedRailBase).transportMode.maxLength)), y, -1);
                if (properties.description != null) {
                    for (String text : properties.description.split("[|\n]")) {
                        y = this.drawWrappedText(matrices, (class_2561)Text.literal(text), y, -5592406);
                    }
                }
                if (properties.wikipediaArticle != null) {
                    String fullText = SidingScreen.fetchWikipediaArticle(properties.wikipediaArticle);
                    for (String text : fullText.split("\n")) {
                        y = this.drawWrappedText(matrices, (class_2561)Text.literal(text), y, -5592406);
                    }
                }
            }
        }
    }

    @Override
    public void method_25419() {
        float accelerationConstant;
        int maxTrains;
        try {
            maxTrains = Math.max(0, Integer.parseInt(this.textFieldMaxTrains.method_1882()) - 1);
        }
        catch (Exception ignored) {
            maxTrains = 0;
        }
        try {
            accelerationConstant = RailwayData.round(class_3532.method_15363((float)((float)this.sliderAccelerationConstant.getIntValue() / 1000.0f + 0.001f), (float)0.001f, (float)0.05f), 3);
        }
        catch (Exception ignored) {
            accelerationConstant = 0.01f;
        }
        boolean isManual = this.buttonIsManual.method_20372();
        int maxManualSpeed = this.sliderMaxManualSpeed.getIntValue();
        int minutes = this.sliderDwellTimeMin.getIntValue();
        float second = (float)this.sliderDwellTimeSec.getIntValue() / 2.0f;
        int dwellTime = (int)((second + (float)(minutes * 60)) * 2.0f);
        ((Siding)this.savedRailBase).setUnlimitedTrains(this.buttonUnlimitedTrains.method_20372(), maxTrains, isManual, maxManualSpeed, accelerationConstant, dwellTime, this.oldAcceleration != accelerationConstant || this.oldIsManual != isManual || this.oldMaxManualSpeed != maxManualSpeed || this.oldDwellTime != dwellTime, packet -> PacketTrainDataGuiClient.sendUpdate(this.getPacketIdentifier(), packet));
        super.method_25419();
    }

    public void method_16014(double mouseX, double mouseY) {
        this.availableTrainsList.mouseMoved(mouseX, mouseY);
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        this.availableTrainsList.mouseScrolled(mouseX, mouseY, amount);
        return super.method_25401(mouseX, mouseY, amount);
    }

    @Override
    protected boolean shouldRenderExtra() {
        return this.isSelectingTrain;
    }

    @Override
    protected void renderExtra(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.availableTrainsList.render(matrices, this.field_22793);
    }

    @Override
    protected String getNumberStringKey() {
        return "gui.mtr.siding_number";
    }

    @Override
    protected class_2960 getPacketIdentifier() {
        return PACKET_UPDATE_SIDING;
    }

    private void onSelectingTrain() {
        ArrayList trainsForListTemp = new ArrayList();
        ArrayList trainsForListUnavailable = new ArrayList();
        TrainClientRegistry.forEach(this.transportMode, (id, trainProperties) -> {
            TrainForList trainForList = new TrainForList((Siding)this.savedRailBase, (String)id, (TrainProperties)trainProperties);
            (trainForList.isAvailable ? trainsForListTemp : trainsForListUnavailable).add(trainForList);
        });
        trainsForListTemp.addAll(trainsForListUnavailable);
        this.availableTrainsList.setData(trainsForListTemp, false, false, false, false, true, false);
        this.setIsSelectingTrain(true);
    }

    private void setIsSelectingTrain(boolean isSelectingTrain) {
        this.isSelectingTrain = isSelectingTrain;
        this.buttonSelectTrain.field_22764 = !isSelectingTrain;
        this.buttonUnlimitedTrains.field_22764 = !isSelectingTrain;
        this.textFieldMaxTrains.field_22764 = !isSelectingTrain;
        this.sliderAccelerationConstant.field_22764 = !isSelectingTrain;
        this.buttonIsManual.field_22764 = !isSelectingTrain;
        this.sliderMaxManualSpeed.field_22764 = !isSelectingTrain && this.buttonIsManual.method_20372();
        this.sliderDwellTimeMin.field_22764 = !isSelectingTrain && this.buttonIsManual.method_20372();
        this.sliderDwellTimeSec.field_22764 = !isSelectingTrain && this.buttonIsManual.method_20372();
        this.buttonSelectTrain.method_25355(TrainClientRegistry.getTrainProperties((String)((Siding)this.savedRailBase).getTrainId()).name);
        this.availableTrainsList.x = isSelectingTrain ? 20 : this.field_22789;
    }

    private void onAdd(NameColorDataBase data, int index) {
        String baseTrainType;
        if (data instanceof TrainForList && ((Siding)this.savedRailBase).isValidVehicle(TrainType.getSpacing(baseTrainType = ((TrainForList)data).trainProperties.baseTrainType))) {
            ((Siding)this.savedRailBase).setTrainIdAndBaseType(((TrainForList)data).trainId, baseTrainType, packet -> PacketTrainDataGuiClient.sendUpdate(IPacket.PACKET_UPDATE_SIDING, packet));
            this.setIsSelectingTrain(false);
        }
    }

    private String accelerationSliderFormatter(int value) {
        float valueMeterPerTickSquared = (float)value / 1000.0f + 0.001f;
        return String.format("%s m/s\u00b2 (%s km/h/s)", Float.valueOf(RailwayData.round(valueMeterPerTickSquared * 400.0f, 1)), Float.valueOf(RailwayData.round(valueMeterPerTickSquared * 1440.0f, 1)));
    }

    private String speedSliderFormatter(int value) {
        RailType railType = Train.convertMaxManualSpeed(value);
        return railType == null ? Text.translatable("gui.mtr.unlimited", new Object[0]).getString() : String.format("%s km/h", railType.speedLimit);
    }

    private int drawWrappedText(class_4587 matrices, class_2561 component, int y, int color) {
        List splitText = this.field_22793.method_1728((class_5348)component, 160);
        int newY = y;
        for (class_5481 formattedCharSequence : splitText) {
            int nextY = newY + 8 + 2;
            if (nextY > this.field_22790 - 20 - 8) {
                this.field_22793.method_1729(matrices, "...", (float)(this.field_22789 - 160 - 20), (float)newY, color);
                return this.field_22790;
            }
            this.field_22793.method_27528(matrices, formattedCharSequence, (float)(this.field_22789 - 160 - 20), (float)newY, color);
            newY = nextY;
        }
        return newY + 6;
    }

    private static String fetchWikipediaArticle(String wikipediaArticle) {
        String result = WIKIPEDIA_ARTICLES.get(wikipediaArticle);
        if (result == null) {
            CompletableFuture.runAsync(() -> Patreon.openConnectionSafeJson("https://en.wikipedia.org/w/api.php?format=json&action=query&prop=extracts&explaintext&exintro&titles=" + wikipediaArticle, jsonElement -> {
                JsonObject pagesObject = jsonElement.getAsJsonObject().getAsJsonObject("query").getAsJsonObject("pages");
                pagesObject.entrySet().stream().findFirst().ifPresent(entry -> WIKIPEDIA_ARTICLES.put(wikipediaArticle, pagesObject.getAsJsonObject((String)entry.getKey()).get("extract").getAsString()));
            }, new String[0]));
            WIKIPEDIA_ARTICLES.put(wikipediaArticle, "");
            return "";
        }
        return result;
    }

    private static class TrainForList
    extends NameColorDataBase {
        private final String trainId;
        private final TrainProperties trainProperties;
        private final boolean isAvailable;

        private TrainForList(Siding savedRailBase, String trainId, TrainProperties trainProperties) {
            this.trainId = trainId;
            this.trainProperties = trainProperties;
            this.isAvailable = savedRailBase.isValidVehicle(TrainType.getSpacing(trainProperties.baseTrainType));
            this.name = (this.isAvailable ? "" : "\u26a0 ") + trainProperties.name.getString();
            this.color = this.isAvailable ? trainProperties.color : 0;
        }

        @Override
        protected boolean hasTransportMode() {
            return false;
        }
    }
}

