/*
 * Decompiled with CFR 0.152.
 */
package mtr.screen;

import java.util.stream.Collectors;
import mtr.block.BlockTrainAnnouncer;
import mtr.data.DataConverter;
import mtr.data.RailwayData;
import mtr.mappings.RegistryUtilities;
import mtr.mappings.Text;
import mtr.mappings.UtilitiesClient;
import mtr.screen.DashboardList;
import mtr.screen.TrainSensorScreenBase;
import mtr.screen.WidgetBetterTextField;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_339;
import net.minecraft.class_3419;
import net.minecraft.class_3545;
import net.minecraft.class_4587;
import net.minecraft.class_638;

public class TrainAnnouncerScreen
extends TrainSensorScreenBase {
    private final String initialMessage;
    private final String initialSoundIdString;
    private final DashboardList availableSoundsList;
    private static final int MAX_MESSAGE_LENGTH = 256;

    public TrainAnnouncerScreen(class_2338 pos) {
        super(pos, true, new class_3545((Object)new WidgetBetterTextField("", 256), (Object)Text.translatable("gui.mtr.announcement_message", new Object[0])), new class_3545((Object)new WidgetBetterTextField("", 256), (Object)Text.translatable("gui.mtr.sound_file", new Object[0])));
        this.field_22787 = class_310.method_1551();
        class_638 world = this.field_22787.field_1687;
        if (world != null) {
            class_2586 entity = world.method_8321(pos);
            if (entity instanceof BlockTrainAnnouncer.TileEntityTrainAnnouncer) {
                this.initialMessage = ((BlockTrainAnnouncer.TileEntityTrainAnnouncer)entity).getMessage();
                this.initialSoundIdString = ((BlockTrainAnnouncer.TileEntityTrainAnnouncer)entity).getSoundIdString();
            } else {
                this.initialMessage = "";
                this.initialSoundIdString = "";
            }
        } else {
            this.initialMessage = "";
            this.initialSoundIdString = "";
        }
        this.availableSoundsList = new DashboardList((data, color) -> {
            String soundIdString = data.name;
            if (!soundIdString.isEmpty() && world != null && this.field_22787.field_1724 != null) {
                world.method_45446(pos, RegistryUtilities.createSoundEvent(new class_2960(soundIdString)), class_3419.field_15245, 1000000.0f, 1.0f, false);
            }
        }, null, null, null, (data, color) -> {
            this.textFields[1].method_1852(data.name);
            this.setListVisibility(false);
        }, null, null, () -> "", text -> {}, false);
        this.availableSoundsList.setData(class_310.method_1551().method_1483().method_4864().stream().map(soundId -> new DataConverter(soundId.toString(), -15592942)).sorted().collect(Collectors.toList()), true, false, false, false, true, false);
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.textFields[0].method_1852(this.initialMessage);
        this.textFields[1].method_1852(this.initialSoundIdString);
        this.setListVisibility(false);
        this.availableSoundsList.y = 58;
        this.availableSoundsList.height = this.field_22790 - this.availableSoundsList.y - 20;
        this.availableSoundsList.width = this.field_22789 / 2 - 20;
        this.availableSoundsList.init(this::addDrawableChild);
    }

    @Override
    public void method_25393() {
        super.method_25393();
        this.availableSoundsList.tick();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            if (RailwayData.isBetween(mouseX, UtilitiesClient.getWidgetX((class_339)this.textFields[1]), UtilitiesClient.getWidgetX((class_339)this.textFields[1]) + this.textFields[1].method_25368()) && RailwayData.isBetween(mouseY, UtilitiesClient.getWidgetY((class_339)this.textFields[1]), UtilitiesClient.getWidgetY((class_339)this.textFields[1]) + this.textFields[1].method_25364())) {
                this.setListVisibility(true);
            } else if (!RailwayData.isBetween(mouseX, this.availableSoundsList.x, this.availableSoundsList.x + this.availableSoundsList.width) || !RailwayData.isBetween(mouseY, this.availableSoundsList.y, this.availableSoundsList.y + this.availableSoundsList.height)) {
                this.setListVisibility(false);
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public void method_16014(double mouseX, double mouseY) {
        this.availableSoundsList.mouseMoved(mouseX, mouseY);
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        this.availableSoundsList.mouseScrolled(mouseX, mouseY, amount);
        return super.method_25401(mouseX, mouseY, amount);
    }

    @Override
    protected void renderAdditional(class_4587 matrices) {
        class_329.method_25294((class_4587)matrices, (int)this.availableSoundsList.x, (int)this.availableSoundsList.y, (int)(this.availableSoundsList.x + this.availableSoundsList.width), (int)(this.availableSoundsList.y + this.availableSoundsList.height), (int)-15592942);
        this.availableSoundsList.render(matrices, this.field_22793);
    }

    private void setListVisibility(boolean visible) {
        this.availableSoundsList.x = visible ? this.field_22789 / 2 : this.field_22789;
    }
}

