/*
 * Decompiled with CFR 0.152.
 */
package mtr.screen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import mtr.block.BlockTrainSensorBase;
import mtr.client.ClientData;
import mtr.client.IDrawing;
import mtr.data.IGui;
import mtr.data.NameColorDataBase;
import mtr.data.Route;
import mtr.mappings.ScreenMapper;
import mtr.mappings.Text;
import mtr.mappings.UtilitiesClient;
import mtr.packet.IPacket;
import mtr.packet.PacketTrainDataGuiClient;
import mtr.screen.DashboardListSelectorScreen;
import mtr.screen.WidgetBetterCheckbox;
import mtr.screen.WidgetBetterTextField;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_3545;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_638;

public abstract class TrainSensorScreenBase
extends ScreenMapper
implements IGui,
IPacket {
    private boolean stoppedOnly;
    private boolean movingOnly;
    protected final class_2338 pos;
    protected final WidgetBetterTextField[] textFields;
    private final Set<Long> filterRouteIds;
    private final int textFieldCount;
    private final class_2561[] textFieldLabels;
    private final WidgetBetterCheckbox stoppedOnlyCheckbox;
    private final WidgetBetterCheckbox movingOnlyCheckbox;
    private final class_4185 filterButton;
    private final boolean hasSpeedCheckboxes;
    private final int yStart;

    @SafeVarargs
    public TrainSensorScreenBase(class_2338 pos, boolean hasSpeedCheckboxes, class_3545<WidgetBetterTextField, class_2561> ... textFieldsAndLabels) {
        super((class_2561)Text.literal(""));
        this.pos = pos;
        this.textFieldCount = textFieldsAndLabels.length;
        this.textFields = new WidgetBetterTextField[this.textFieldCount];
        this.textFieldLabels = new class_2561[this.textFieldCount];
        for (int i = 0; i < this.textFieldCount; ++i) {
            this.textFields[i] = (WidgetBetterTextField)textFieldsAndLabels[i].method_15442();
            this.textFieldLabels[i] = (class_2561)textFieldsAndLabels[i].method_15441();
        }
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            this.filterRouteIds = new HashSet<Long>();
        } else {
            class_2586 entity = world.method_8321(pos);
            if (entity instanceof BlockTrainSensorBase.TileEntityTrainSensorBase) {
                this.filterRouteIds = ((BlockTrainSensorBase.TileEntityTrainSensorBase)entity).getRouteIds();
                this.stoppedOnly = ((BlockTrainSensorBase.TileEntityTrainSensorBase)entity).getStoppedOnly();
                this.movingOnly = ((BlockTrainSensorBase.TileEntityTrainSensorBase)entity).getMovingOnly();
            } else {
                this.filterRouteIds = new HashSet<Long>();
            }
        }
        this.stoppedOnlyCheckbox = new WidgetBetterCheckbox(0, 0, 0, 20, (class_2561)Text.translatable("gui.mtr.stopped_only", new Object[0]), checked -> this.setChecked(checked, this.movingOnly));
        this.movingOnlyCheckbox = new WidgetBetterCheckbox(0, 0, 0, 20, (class_2561)Text.translatable("gui.mtr.moving_only", new Object[0]), checked -> this.setChecked(this.stoppedOnly, checked));
        this.filterButton = UtilitiesClient.newButton(button -> {
            if (this.field_22787 != null) {
                ArrayList<NameColorDataBase> routes = new ArrayList<NameColorDataBase>(ClientData.ROUTES);
                Collections.sort(routes);
                UtilitiesClient.setScreen(this.field_22787, new DashboardListSelectorScreen(this, routes, this.filterRouteIds, false, false));
            }
        });
        this.hasSpeedCheckboxes = hasSpeedCheckboxes;
        this.yStart = (this.textFieldCount == 0 ? 20 : 84) + (hasSpeedCheckboxes ? 40 : 0);
    }

    protected void method_25426() {
        super.method_25426();
        int textFieldWidth = this.textFieldCount == 0 ? 0 : (this.field_22789 - 40) / this.textFieldCount;
        for (int i = 0; i < this.textFieldCount; ++i) {
            IDrawing.setPositionAndWidth((class_339)this.textFields[i], 22 + textFieldWidth * i, 36, textFieldWidth - 4);
            this.addDrawableChild(this.textFields[i]);
        }
        if (this.hasSpeedCheckboxes) {
            IDrawing.setPositionAndWidth((class_339)this.stoppedOnlyCheckbox, 20, this.yStart - 40, 144);
            IDrawing.setPositionAndWidth((class_339)this.movingOnlyCheckbox, 20, this.yStart - 20, 144);
            this.addDrawableChild(this.stoppedOnlyCheckbox);
            this.addDrawableChild(this.movingOnlyCheckbox);
            this.setChecked(this.stoppedOnly, this.movingOnly);
        }
        IDrawing.setPositionAndWidth((class_339)this.filterButton, 20, this.yStart + 40, 72);
        this.filterButton.method_25355((class_2561)Text.translatable("selectWorld.edit", new Object[0]));
        this.addDrawableChild(this.filterButton);
    }

    public void method_25393() {
        for (WidgetBetterTextField textField : this.textFields) {
            textField.method_1865();
        }
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        try {
            int i;
            this.method_25420(matrices);
            for (i = 0; i < this.textFieldCount; ++i) {
                this.field_22793.method_30883(matrices, this.textFieldLabels[i], 20.0f + (float)(this.field_22789 / 2 - 20) * (float)i, 20.0f, -1);
            }
            this.field_22793.method_30883(matrices, (class_2561)Text.translatable("gui.mtr.filtered_routes", this.filterRouteIds.size()), 20.0f, (float)(this.yStart + 6), -1);
            this.field_22793.method_30883(matrices, (class_2561)Text.translatable(this.filterRouteIds.isEmpty() ? "gui.mtr.filtered_routes_empty" : "gui.mtr.filtered_routes_condition", new Object[0]), 20.0f, (float)(this.yStart + 20 + 6), -1);
            i = 0;
            for (long routeId : this.filterRouteIds) {
                Route route = (Route)ClientData.DATA_CACHE.routeIdMap.get(routeId);
                if (route != null) {
                    this.field_22793.method_30883(matrices, (class_2561)Text.literal(IGui.formatStationName(route.name)), 20.0f, (float)(this.yStart + 60 + 6 + i), -1);
                }
                i += 8;
            }
            this.renderAdditional(matrices);
            super.method_25394(matrices, mouseX, mouseY, delta);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void method_25419() {
        String[] strings = new String[this.textFieldCount];
        for (int i = 0; i < this.textFieldCount; ++i) {
            strings[i] = this.textFields[i].method_1882();
        }
        PacketTrainDataGuiClient.sendTrainSensorC2S(this.pos, this.filterRouteIds, this.stoppedOnly, this.movingOnly, this.getNumber(), strings);
        super.method_25419();
    }

    public boolean method_25421() {
        return false;
    }

    protected void renderAdditional(class_4587 matrices) {
    }

    protected int getNumber() {
        return 0;
    }

    private void setChecked(boolean newStoppedOnly, boolean newMovingOnly) {
        this.stoppedOnly = newMovingOnly && this.stoppedOnly ? false : newStoppedOnly;
        this.movingOnly = newStoppedOnly && this.movingOnly ? false : newMovingOnly;
        this.stoppedOnlyCheckbox.setChecked(this.stoppedOnly);
        this.movingOnlyCheckbox.setChecked(this.movingOnly);
    }
}

