/*
 * Decompiled with CFR 0.152.
 */
package mtr.screen;

import java.util.Locale;
import java.util.function.Consumer;
import mtr.data.IGui;
import mtr.data.RailwayData;
import mtr.mappings.Text;
import mtr.mappings.UtilitiesClient;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_342;

public class WidgetBetterTextField
extends class_342
implements IGui {
    private final String filter;
    private final String suggestion;
    private final int newMaxLength;
    private static final int DEFAULT_MAX_LENGTH = 128;

    public WidgetBetterTextField(String suggestion) {
        this("", suggestion, 128);
    }

    public WidgetBetterTextField(String suggestion, int maxLength) {
        this("", suggestion, maxLength);
    }

    public WidgetBetterTextField(TextFieldFilter textFieldFilter, String suggestion, int maxLength) {
        this(textFieldFilter.filter, suggestion, maxLength);
    }

    public WidgetBetterTextField(String filter, String suggestion, int maxLength) {
        super(class_310.method_1551().field_1772, 0, 0, 0, 20, (class_2561)Text.literal(""));
        this.filter = filter;
        this.suggestion = suggestion;
        this.newMaxLength = maxLength;
        this.method_1863(text -> {});
        this.method_1880(0);
    }

    public void method_1863(Consumer<String> changedListener) {
        super.method_1863(text -> {
            String newText;
            if (this.filter.isEmpty()) {
                newText = this.trySetLength((String)text);
            } else {
                newText = this.trySetLength(text.toUpperCase(Locale.ENGLISH).replaceAll(this.filter, ""));
                if (!newText.equals(text)) {
                    this.method_1852(newText);
                }
            }
            this.method_1887(newText.isEmpty() && this.suggestion != null ? this.suggestion : "");
            changedListener.accept(newText);
        });
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.method_1885() && RailwayData.isBetween(mouseX, UtilitiesClient.getWidgetX((class_339)this), UtilitiesClient.getWidgetX((class_339)this) + this.field_22758) && RailwayData.isBetween(mouseY, UtilitiesClient.getWidgetY((class_339)this), UtilitiesClient.getWidgetY((class_339)this) + this.field_22759)) {
            if (button == 1) {
                this.method_1852("");
            }
            return super.method_25402(mouseX, mouseY, 0);
        }
        this.method_25365(false);
        return false;
    }

    public void method_1880(int maxLength) {
        super.method_1880(Integer.MAX_VALUE);
    }

    private String trySetLength(String text) {
        return text.isEmpty() ? "" : text.substring(0, Math.min(this.newMaxLength, text.length()));
    }

    public static enum TextFieldFilter {
        POSITIVE_INTEGER("\\D"),
        INTEGER("[^-\\d]"),
        HEX("[^\\dA-F]"),
        LETTER("[^A-Z]");

        private final String filter;

        private TextFieldFilter(String filter) {
            this.filter = filter;
        }
    }
}

