/*
 * Decompiled with CFR 0.152.
 */
package mtr.screen;

import java.awt.Color;
import java.util.Locale;
import java.util.Random;
import java.util.function.Consumer;
import mtr.client.IDrawing;
import mtr.data.IGui;
import mtr.mappings.ButtonMapper;
import mtr.mappings.ScreenMapper;
import mtr.mappings.Text;
import mtr.mappings.UtilitiesClient;
import mtr.screen.WidgetBetterTextField;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_329;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import org.apache.commons.lang3.StringUtils;

public class WidgetColorSelector
extends ButtonMapper
implements IGui {
    private int color;
    private final ScreenMapper screen;
    private final boolean hasMargin;
    private final Runnable callback;

    public WidgetColorSelector(ScreenMapper screen, boolean hasMargin, Runnable callback) {
        super(0, 0, 0, 20, (class_2561)Text.literal(""), button -> {});
        this.screen = screen;
        this.hasMargin = hasMargin;
        this.callback = callback;
    }

    @Deprecated
    public WidgetColorSelector(ScreenMapper screen, Runnable callback) {
        this(screen, true, callback);
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        super.method_25394(matrices, mouseX, mouseY, delta);
        if (this.field_22764) {
            int margin = this.hasMargin ? 1 : 0;
            class_329.method_25294((class_4587)matrices, (int)(UtilitiesClient.getWidgetX((class_339)this) - margin), (int)(UtilitiesClient.getWidgetY((class_339)this) - margin), (int)(UtilitiesClient.getWidgetX((class_339)this) + this.field_22758 + margin), (int)(UtilitiesClient.getWidgetY((class_339)this) + this.field_22759 + margin), (int)(0xFF000000 | this.color));
        }
    }

    public void method_25306() {
        UtilitiesClient.setScreen(class_310.method_1551(), new ColorSelectorScreen(this.color, color -> {
            UtilitiesClient.setScreen(class_310.method_1551(), this.screen);
            this.setColor((int)color);
            this.callback.run();
        }));
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int newColor) {
        int clampedColor = (newColor & 0xFFFFFF) == 0 ? new Random().nextInt(0x1000000) : newColor & 0xFFFFFF;
        this.color = clampedColor;
    }

    private static class ColorSelectorScreen
    extends ScreenMapper {
        private float hue;
        private float saturation;
        private float brightness;
        private DraggingState draggingState = DraggingState.NONE;
        private final int oldColor;
        private final Consumer<Integer> colorCallback;
        private final WidgetBetterTextField textFieldColor;
        private final WidgetBetterTextField textFieldRed;
        private final WidgetBetterTextField textFieldGreen;
        private final WidgetBetterTextField textFieldBlue;
        private final class_4185 buttonReset;
        private static final int RIGHT_WIDTH = 60;

        private ColorSelectorScreen(int oldColor, Consumer<Integer> colorCallback) {
            super((class_2561)Text.literal(""));
            this.oldColor = oldColor;
            this.colorCallback = colorCallback;
            this.textFieldColor = new WidgetBetterTextField(WidgetBetterTextField.TextFieldFilter.HEX, Text.literal(Integer.toHexString(oldColor).toUpperCase(Locale.ENGLISH)).getString(), 6);
            this.textFieldRed = new WidgetBetterTextField(WidgetBetterTextField.TextFieldFilter.POSITIVE_INTEGER, Text.literal(String.valueOf(oldColor >> 16 & 0xFF)).getString(), 3);
            this.textFieldGreen = new WidgetBetterTextField(WidgetBetterTextField.TextFieldFilter.POSITIVE_INTEGER, Text.literal(String.valueOf(oldColor >> 8 & 0xFF)).getString(), 3);
            this.textFieldBlue = new WidgetBetterTextField(WidgetBetterTextField.TextFieldFilter.POSITIVE_INTEGER, Text.literal(String.valueOf(oldColor & 0xFF)).getString(), 3);
            this.buttonReset = UtilitiesClient.newButton((class_2561)Text.translatable("gui.mtr.reset_sign", new Object[0]), button -> {
                this.setHsb(oldColor, true);
                button.field_22763 = false;
            });
        }

        protected void method_25426() {
            super.method_25426();
            int startX = 80 + this.getMainWidth();
            int startY = 36;
            IDrawing.setPositionAndWidth((class_339)this.textFieldColor, startX + 2, 36, 56);
            IDrawing.setPositionAndWidth((class_339)this.textFieldRed, startX + 2, 80, 56);
            IDrawing.setPositionAndWidth((class_339)this.textFieldGreen, startX + 2, 104, 56);
            IDrawing.setPositionAndWidth((class_339)this.textFieldBlue, startX + 2, 128, 56);
            IDrawing.setPositionAndWidth((class_339)this.buttonReset, startX, this.getMainHeight(), 60);
            this.setHsb(this.oldColor, true);
            this.textFieldColor.method_1863(text -> this.textCallback((String)text, -1));
            this.textFieldRed.method_1863(text -> this.textCallback((String)text, 16));
            this.textFieldGreen.method_1863(text -> this.textCallback((String)text, 8));
            this.textFieldBlue.method_1863(text -> this.textCallback((String)text, 0));
            this.addDrawableChild(this.textFieldColor);
            this.addDrawableChild(this.textFieldRed);
            this.addDrawableChild(this.textFieldGreen);
            this.addDrawableChild(this.textFieldBlue);
            this.addDrawableChild(this.buttonReset);
        }

        public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
            try {
                this.method_25420(matrices);
                super.method_25394(matrices, mouseX, mouseY, delta);
                int mainWidth = this.getMainWidth();
                int mainHeight = this.getMainHeight();
                ColorSelectorScreen.method_27534((class_4587)matrices, (class_327)this.field_22793, (class_2561)Text.translatable("gui.mtr.color", new Object[0]), (int)(80 + mainWidth + 30), (int)20, (int)-1);
                ColorSelectorScreen.method_25300((class_4587)matrices, (class_327)this.field_22793, (String)"RGB", (int)(80 + mainWidth + 30), (int)64, (int)-1);
                class_289 tesselator = class_289.method_1348();
                class_287 buffer = tesselator.method_1349();
                UtilitiesClient.beginDrawingRectangle(buffer);
                int selectedColor = Color.HSBtoRGB(this.hue, this.saturation, this.brightness);
                IDrawing.drawRectangle((class_4588)buffer, 80 + mainWidth + 1, 157.0, 80 + mainWidth + 60 - 1, mainHeight - 1, selectedColor);
                for (int drawHue = 0; drawHue < mainHeight; ++drawHue) {
                    int color = Color.HSBtoRGB((float)drawHue / (float)(mainHeight - 1), 1.0f, 1.0f);
                    IDrawing.drawRectangle((class_4588)buffer, 40 + mainWidth, 20 + drawHue, 60 + mainWidth, 20 + drawHue + 1, color);
                }
                for (int drawSaturation = 0; drawSaturation < mainWidth; ++drawSaturation) {
                    for (int drawBrightness = 0; drawBrightness < mainHeight; ++drawBrightness) {
                        int color = Color.HSBtoRGB(this.hue, (float)drawSaturation / (float)(mainWidth - 1), (float)drawBrightness / (float)(mainHeight - 1));
                        IDrawing.drawRectangle((class_4588)buffer, 20 + drawSaturation, 20 + mainHeight - drawBrightness - 1, 20 + drawSaturation + 1, 20 + mainHeight - drawBrightness, color);
                    }
                }
                int selectedHueInt = Math.round(this.hue * (float)(mainHeight - 1));
                int selectedSaturationInt = Math.round(this.saturation * (float)(mainWidth - 1));
                int selectedBrightnessInt = Math.round(this.brightness * (float)(mainHeight - 1));
                IDrawing.drawRectangle((class_4588)buffer, 40 + mainWidth, 20 + selectedHueInt - 1, 60 + mainWidth, 20 + selectedHueInt + 2, -16777216);
                IDrawing.drawRectangle((class_4588)buffer, 40 + mainWidth, 20 + selectedHueInt, 60 + mainWidth, 20 + selectedHueInt + 1, -1);
                IDrawing.drawRectangle((class_4588)buffer, 20 + selectedSaturationInt - 1, 20 + mainHeight - selectedBrightnessInt - 1, 20 + selectedSaturationInt + 2, 20 + mainHeight - selectedBrightnessInt, -16777216);
                IDrawing.drawRectangle((class_4588)buffer, 20 + selectedSaturationInt, 20 + mainHeight - selectedBrightnessInt - 2, 20 + selectedSaturationInt + 1, 20 + mainHeight - selectedBrightnessInt + 1, -16777216);
                IDrawing.drawRectangle((class_4588)buffer, 20 + selectedSaturationInt, 20 + mainHeight - selectedBrightnessInt - 1, 20 + selectedSaturationInt + 1, 20 + mainHeight - selectedBrightnessInt, -1);
                tesselator.method_1350();
                UtilitiesClient.finishDrawingRectangle();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void method_25393() {
            this.textFieldRed.method_1865();
            this.textFieldGreen.method_1865();
            this.textFieldBlue.method_1865();
            this.textFieldColor.method_1865();
        }

        public void method_25419() {
            this.colorCallback.accept(Color.HSBtoRGB(this.hue, this.saturation, this.brightness) & 0xFFFFFF);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            int mainWidth = this.getMainWidth();
            int mainHeight = this.getMainHeight();
            this.draggingState = DraggingState.NONE;
            if (mouseY >= 20.0 && mouseY < (double)(20 + mainHeight)) {
                if (mouseX >= 20.0 && mouseX < (double)(20 + mainWidth)) {
                    this.draggingState = DraggingState.SATURATION_BRIGHTNESS;
                } else if (mouseX >= (double)(40 + mainWidth) && mouseX < (double)(60 + mainWidth)) {
                    this.draggingState = DraggingState.HUE;
                }
            }
            this.selectColor(mouseX, mouseY);
            return super.method_25402(mouseX, mouseY, button);
        }

        public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            this.selectColor(mouseX, mouseY);
            return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
        }

        private void selectColor(double mouseX, double mouseY) {
            int mainWidth = this.getMainWidth();
            int mainHeight = this.getMainHeight();
            switch (this.draggingState) {
                case SATURATION_BRIGHTNESS: {
                    this.saturation = (float)class_3532.method_15350((double)((mouseX - 20.0) / (double)mainWidth), (double)0.0, (double)1.0);
                    this.brightness = 1.0f - (float)class_3532.method_15350((double)((mouseY - 20.0) / (double)mainHeight), (double)0.0, (double)1.0);
                    this.setColorText(Color.HSBtoRGB(this.hue, this.saturation, this.brightness), true);
                    break;
                }
                case HUE: {
                    this.hue = (float)class_3532.method_15350((double)((mouseY - 20.0) / (double)mainHeight), (double)0.0, (double)1.0);
                    this.setColorText(Color.HSBtoRGB(this.hue, this.saturation, this.brightness), true);
                }
            }
        }

        private void setHsb(int color, boolean padZero) {
            float[] hsb = Color.RGBtoHSB(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, null);
            this.hue = hsb[0];
            this.saturation = hsb[1];
            this.brightness = hsb[2];
            this.setColorText(color, padZero);
        }

        private void setColorText(int color, boolean padZero) {
            String colorString = Integer.toHexString(color & 0xFFFFFF).toUpperCase(Locale.ENGLISH);
            this.textFieldColor.method_1852(padZero ? StringUtils.leftPad((String)colorString, (int)6, (String)"0") : colorString);
            this.textFieldRed.method_1852(String.valueOf(color >> 16 & 0xFF));
            this.textFieldGreen.method_1852(String.valueOf(color >> 8 & 0xFF));
            this.textFieldBlue.method_1852(String.valueOf(color & 0xFF));
            this.buttonReset.field_22763 = (color & 0xFFFFFF) != this.oldColor;
        }

        private void textCallback(String text, int shift) {
            try {
                boolean isHex = shift < 0;
                int compare = Integer.parseInt(text, isHex ? 16 : 10);
                int currentColor = Color.HSBtoRGB(this.hue, this.saturation, this.brightness) & 0xFFFFFF;
                if ((isHex ? currentColor : currentColor >> shift & 0xFF) != compare) {
                    this.setHsb(isHex ? compare : (currentColor & ~(255 << shift)) + (compare << shift), !isHex);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private int getMainWidth() {
            return this.field_22789 - 100 - 60;
        }

        private int getMainHeight() {
            return this.field_22790 - 40;
        }
    }

    private static enum DraggingState {
        NONE,
        SATURATION_BRIGHTNESS,
        HUE;

    }
}

