/*
 * Decompiled with CFR 0.152.
 */
package mtr.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import mtr.client.ClientData;
import mtr.client.IDrawing;
import mtr.data.AreaBase;
import mtr.data.Depot;
import mtr.data.IGui;
import mtr.data.RailwayData;
import mtr.data.SavedRailBase;
import mtr.data.Station;
import mtr.data.TransportMode;
import mtr.mappings.SelectableMapper;
import mtr.mappings.Text;
import mtr.mappings.UtilitiesClient;
import mtr.mappings.WidgetMapper;
import net.minecraft.class_2338;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_2902;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_329;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_364;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class WidgetMap
implements WidgetMapper,
SelectableMapper,
class_364,
IGui {
    private int x;
    private int y;
    private int width;
    private int height;
    private double scale;
    private double centerX;
    private double centerY;
    private class_3545<Integer, Integer> drawArea1;
    private class_3545<Integer, Integer> drawArea2;
    private MapState mapState;
    private boolean showStations;
    private final TransportMode transportMode;
    private final OnDrawCorners onDrawCorners;
    private final Runnable onDrawCornersMouseRelease;
    private final Consumer<Long> onClickAddPlatformToRoute;
    private final Consumer<SavedRailBase> onClickEditSavedRail;
    private final BiFunction<Double, Double, Boolean> isRestrictedMouseArea;
    private final class_638 world;
    private final class_746 player;
    private final class_327 textRenderer;
    private static final int ARGB_BLUE = -12417548;
    private static final int SCALE_UPPER_LIMIT = 64;
    private static final double SCALE_LOWER_LIMIT = 0.0078125;

    public WidgetMap(TransportMode transportMode, OnDrawCorners onDrawCorners, Runnable onDrawCornersMouseRelease, Consumer<Long> onClickAddPlatformToRoute, Consumer<SavedRailBase> onClickEditSavedRail, BiFunction<Double, Double, Boolean> isRestrictedMouseArea) {
        this.transportMode = transportMode;
        this.onDrawCorners = onDrawCorners;
        this.onDrawCornersMouseRelease = onDrawCornersMouseRelease;
        this.onClickAddPlatformToRoute = onClickAddPlatformToRoute;
        this.onClickEditSavedRail = onClickEditSavedRail;
        this.isRestrictedMouseArea = isRestrictedMouseArea;
        class_310 minecraftClient = class_310.method_1551();
        this.world = minecraftClient.field_1687;
        this.player = minecraftClient.field_1724;
        this.textRenderer = minecraftClient.field_1772;
        if (this.player == null) {
            this.centerX = 0.0;
            this.centerY = 0.0;
        } else {
            this.centerX = this.player.method_23317();
            this.centerY = this.player.method_23321();
        }
        this.scale = 1.0;
        this.setShowStations(true);
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        class_289 tesselator = class_289.method_1348();
        class_287 buffer = tesselator.method_1349();
        UtilitiesClient.beginDrawingRectangle(buffer);
        RenderSystem.enableBlend();
        class_3545<Integer, Integer> topLeft = this.coordsToWorldPos(0, 0);
        class_3545<Integer, Integer> bottomRight = this.coordsToWorldPos(this.width, this.height);
        int increment = this.scale >= 1.0 ? 1 : (int)Math.ceil(1.0 / this.scale);
        for (int i = ((Integer)topLeft.method_15442()).intValue(); i <= (Integer)bottomRight.method_15442(); i += increment) {
            for (int j = ((Integer)topLeft.method_15441()).intValue(); j <= (Integer)bottomRight.method_15441(); j += increment) {
                if (this.world == null) continue;
                int color = WidgetMap.divideColorRGB(this.world.method_8320((class_2338)RailwayData.newBlockPos((int)i, (int)(this.world.method_8624((class_2902.class_2903)class_2902.class_2903.field_13197, (int)i, (int)j) - 1), (int)j)).method_26204().method_26403().field_16011, 2);
                this.drawRectangleFromWorldCoords(buffer, i, j, i + increment, j + increment, 0xFF000000 | color);
            }
        }
        class_3545<Double, Double> mouseWorldPos = this.coordsToWorldPos((double)mouseX - (double)this.x, (double)(mouseY - this.y));
        try {
            if (this.showStations) {
                ClientData.DATA_CACHE.getPosToPlatforms(this.transportMode).forEach((platformPos, platforms) -> this.drawRectangleFromWorldCoords(buffer, platformPos.method_10263(), platformPos.method_10260(), platformPos.method_10263() + 1, platformPos.method_10260() + 1, -1));
                for (Station station : ClientData.STATIONS) {
                    if (!AreaBase.nonNullCorners(station)) continue;
                    this.drawRectangleFromWorldCoords(buffer, (class_3545<Integer, Integer>)station.corner1, (class_3545<Integer, Integer>)station.corner2, 0x7F000000 + station.color);
                }
                this.mouseOnSavedRail(mouseWorldPos, (savedRail, x1, z1, x2, z2) -> this.drawRectangleFromWorldCoords(buffer, x1, z1, x2, z2, -1), true);
            } else {
                ClientData.DATA_CACHE.getPosToSidings(this.transportMode).forEach((sidingPos, sidings) -> this.drawRectangleFromWorldCoords(buffer, sidingPos.method_10263(), sidingPos.method_10260(), sidingPos.method_10263() + 1, sidingPos.method_10260() + 1, -1));
                for (Depot depot : ClientData.DEPOTS) {
                    if (!depot.isTransportMode(this.transportMode) || !AreaBase.nonNullCorners(depot)) continue;
                    this.drawRectangleFromWorldCoords(buffer, (class_3545<Integer, Integer>)depot.corner1, (class_3545<Integer, Integer>)depot.corner2, 0x7F000000 + depot.color);
                }
                this.mouseOnSavedRail(mouseWorldPos, (savedRail, x1, z1, x2, z2) -> this.drawRectangleFromWorldCoords(buffer, x1, z1, x2, z2, -1), false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.mapState == MapState.EDITING_AREA && this.drawArea1 != null && this.drawArea2 != null) {
            this.drawRectangleFromWorldCoords(buffer, this.drawArea1, this.drawArea2, Integer.MAX_VALUE);
        }
        if (this.player != null) {
            this.drawFromWorldCoords(this.player.method_23317(), this.player.method_23321(), (x1, y1) -> {
                this.drawRectangle(buffer, x1 - 2.0, y1 - 3.0, x1 + 2.0, y1 + 3.0, -1);
                this.drawRectangle(buffer, x1 - 3.0, y1 - 2.0, x1 + 3.0, y1 + 2.0, -1);
                this.drawRectangle(buffer, x1 - 2.0, y1 - 2.0, x1 + 2.0, y1 + 2.0, -12417548);
            });
        }
        tesselator.method_1350();
        RenderSystem.disableBlend();
        UtilitiesClient.finishDrawingRectangle();
        if (this.mapState == MapState.EDITING_AREA) {
            class_329.method_25303((class_4587)matrices, (class_327)this.textRenderer, (String)Text.translatable("gui.mtr.edit_area", new Object[0]).getString(), (int)(this.x + 6), (int)(this.y + 6), (int)-1);
        } else if (this.mapState == MapState.EDITING_ROUTE) {
            class_329.method_25303((class_4587)matrices, (class_327)this.textRenderer, (String)Text.translatable("gui.mtr.edit_route", new Object[0]).getString(), (int)(this.x + 6), (int)(this.y + 6), (int)-1);
        }
        if (this.scale >= 8.0) {
            try {
                if (this.showStations) {
                    ClientData.DATA_CACHE.getPosToPlatforms(this.transportMode).forEach((platformPos, platforms) -> this.drawSavedRail(matrices, (class_2338)platformPos, (List<? extends SavedRailBase>)platforms));
                } else {
                    ClientData.DATA_CACHE.getPosToSidings(this.transportMode).forEach((sidingPos, sidings) -> this.drawSavedRail(matrices, (class_2338)sidingPos, (List<? extends SavedRailBase>)sidings));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        class_4597.class_4598 immediate = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
        if (this.showStations) {
            for (Station station : ClientData.STATIONS) {
                if (!this.canDrawAreaText(station)) continue;
                class_2338 pos = station.getCenter();
                String stationString = String.format("%s|(%s)", station.name, Text.translatable("gui.mtr.zone_number", station.zone).getString());
                this.drawFromWorldCoords(pos.method_10263(), pos.method_10260(), (x1, y1) -> IDrawing.drawStringWithFont(matrices, this.textRenderer, immediate, stationString, (float)this.x + x1.floatValue(), (float)this.y + y1.floatValue(), 0xF000F0));
            }
        } else {
            for (Depot depot : ClientData.DEPOTS) {
                if (!this.canDrawAreaText(depot)) continue;
                class_2338 pos = depot.getCenter();
                this.drawFromWorldCoords(pos.method_10263(), pos.method_10260(), (x1, y1) -> IDrawing.drawStringWithFont(matrices, this.textRenderer, immediate, depot.name, (float)this.x + x1.floatValue(), (float)this.y + y1.floatValue(), 0xF000F0));
            }
        }
        immediate.method_22993();
        String mousePosText = String.format("(%s, %s)", Float.valueOf(RailwayData.round((Double)mouseWorldPos.method_15442(), 1)), Float.valueOf(RailwayData.round((Double)mouseWorldPos.method_15441(), 1)));
        class_329.method_25303((class_4587)matrices, (class_327)this.textRenderer, (String)mousePosText, (int)(this.x + this.width - 6 - this.textRenderer.method_1727(mousePosText)), (int)(this.y + 6), (int)-1);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.mapState == MapState.EDITING_AREA) {
            this.drawArea2 = this.coordsToWorldPos((int)Math.round(mouseX - (double)this.x), (int)Math.round(mouseY - (double)this.y));
            if (((Integer)this.drawArea1.method_15442()).equals(this.drawArea2.method_15442())) {
                this.drawArea2 = new class_3545((Object)((Integer)this.drawArea2.method_15442() + 1), (Object)((Integer)this.drawArea2.method_15441()));
            }
            if (((Integer)this.drawArea1.method_15441()).equals(this.drawArea2.method_15441())) {
                this.drawArea2 = new class_3545((Object)((Integer)this.drawArea2.method_15442()), (Object)((Integer)this.drawArea2.method_15441() + 1));
            }
            this.onDrawCorners.onDrawCorners(this.drawArea1, this.drawArea2);
        } else {
            this.centerX -= deltaX / this.scale;
            this.centerY -= deltaY / this.scale;
        }
        return true;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.mapState == MapState.EDITING_AREA) {
            this.onDrawCornersMouseRelease.run();
        }
        return true;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.method_25405(mouseX, mouseY)) {
            if (ClientData.hasPermission()) {
                if (this.mapState == MapState.EDITING_AREA) {
                    this.drawArea1 = this.coordsToWorldPos((int)(mouseX - (double)this.x), (int)(mouseY - (double)this.y));
                    this.drawArea2 = null;
                } else if (this.mapState == MapState.EDITING_ROUTE) {
                    class_3545<Double, Double> mouseWorldPos = this.coordsToWorldPos(mouseX - (double)this.x, mouseY - (double)this.y);
                    this.mouseOnSavedRail(mouseWorldPos, (savedRail, x1, z1, x2, z2) -> this.onClickAddPlatformToRoute.accept(savedRail.id), true);
                } else {
                    class_3545<Double, Double> mouseWorldPos = this.coordsToWorldPos(mouseX - (double)this.x, mouseY - (double)this.y);
                    this.mouseOnSavedRail(mouseWorldPos, (savedRail, x1, z1, x2, z2) -> this.onClickEditSavedRail.accept(savedRail), this.showStations);
                }
            }
            return true;
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        double oldScale = this.scale;
        if (oldScale > 0.0078125 && amount < 0.0) {
            this.centerX -= (mouseX - (double)this.x - (double)this.width / 2.0) / this.scale;
            this.centerY -= (mouseY - (double)this.y - (double)this.height / 2.0) / this.scale;
        }
        this.scale(amount);
        if (oldScale < 64.0 && amount > 0.0) {
            this.centerX += (mouseX - (double)this.x - (double)this.width / 2.0) / this.scale;
            this.centerY += (mouseY - (double)this.y - (double)this.height / 2.0) / this.scale;
        }
        return true;
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseY >= (double)this.y && mouseX < (double)(this.x + this.width) && mouseY < (double)(this.y + this.height) && (!(mouseX >= (double)(this.x + this.width - 200)) || !(mouseY >= (double)(this.y + this.height - 20))) && this.isRestrictedMouseArea.apply(mouseX, mouseY) == false;
    }

    public void method_25365(boolean focused) {
    }

    public boolean method_25370() {
        return false;
    }

    public void setPositionAndSize(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public void scale(double amount) {
        this.scale *= Math.pow(2.0, amount);
        this.scale = class_3532.method_15350((double)this.scale, (double)0.0078125, (double)64.0);
    }

    public void find(double x1, double z1, double x2, double z2) {
        this.centerX = (x1 + x2) / 2.0;
        this.centerY = (z1 + z2) / 2.0;
        this.scale = Math.max(2.0, this.scale);
    }

    public void find(class_2338 pos) {
        this.centerX = pos.method_10263();
        this.centerY = pos.method_10260();
        this.scale = Math.max(8.0, this.scale);
    }

    public void startEditingArea(AreaBase editingArea) {
        this.mapState = MapState.EDITING_AREA;
        this.drawArea1 = editingArea.corner1;
        this.drawArea2 = editingArea.corner2;
    }

    public void startEditingRoute() {
        this.mapState = MapState.EDITING_ROUTE;
    }

    public void stopEditing() {
        this.mapState = MapState.DEFAULT;
    }

    public void setShowStations(boolean showStations) {
        this.showStations = showStations;
    }

    private void mouseOnSavedRail(class_3545<Double, Double> mouseWorldPos, MouseOnSavedRailCallback mouseOnSavedRailCallback, boolean isPlatform) {
        try {
            (isPlatform ? ClientData.DATA_CACHE.getPosToPlatforms(this.transportMode) : ClientData.DATA_CACHE.getPosToSidings(this.transportMode)).forEach((savedRailPos, savedRails) -> {
                int savedRailCount = savedRails.size();
                for (int i = 0; i < savedRailCount; ++i) {
                    float left = savedRailPos.method_10263();
                    float right = savedRailPos.method_10263() + 1;
                    float top = (float)savedRailPos.method_10260() + (float)i / (float)savedRailCount;
                    float bottom = (float)savedRailPos.method_10260() + ((float)i + 1.0f) / (float)savedRailCount;
                    if (!RailwayData.isBetween((Double)mouseWorldPos.method_15442(), left, right) || !RailwayData.isBetween((Double)mouseWorldPos.method_15441(), top, bottom)) continue;
                    mouseOnSavedRailCallback.mouseOnSavedRailCallback((SavedRailBase)savedRails.get(i), left, top, right, bottom);
                }
            });
        }
        catch (ConcurrentModificationException concurrentModificationException) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class_3545<Integer, Integer> coordsToWorldPos(int mouseX, int mouseY) {
        class_3545<Double, Double> worldPos = this.coordsToWorldPos((double)mouseX, (double)mouseY);
        return new class_3545((Object)((int)Math.floor((Double)worldPos.method_15442())), (Object)((int)Math.floor((Double)worldPos.method_15441())));
    }

    private class_3545<Double, Double> coordsToWorldPos(double mouseX, double mouseY) {
        double left = (mouseX - (double)this.width / 2.0) / this.scale + this.centerX;
        double right = (mouseY - (double)this.height / 2.0) / this.scale + this.centerY;
        return new class_3545((Object)left, (Object)right);
    }

    private void drawFromWorldCoords(double worldX, double worldZ, BiConsumer<Double, Double> callback) {
        double coordsX = (worldX - this.centerX) * this.scale + (double)this.width / 2.0;
        double coordsY = (worldZ - this.centerY) * this.scale + (double)this.height / 2.0;
        if (RailwayData.isBetween(coordsX, 0.0, this.width) && RailwayData.isBetween(coordsY, 0.0, this.height)) {
            callback.accept(coordsX, coordsY);
        }
    }

    private void drawRectangleFromWorldCoords(class_287 buffer, class_3545<Integer, Integer> corner1, class_3545<Integer, Integer> corner2, int color) {
        this.drawRectangleFromWorldCoords(buffer, ((Integer)corner1.method_15442()).intValue(), ((Integer)corner1.method_15441()).intValue(), ((Integer)corner2.method_15442()).intValue(), ((Integer)corner2.method_15441()).intValue(), color);
    }

    private void drawRectangleFromWorldCoords(class_287 buffer, double posX1, double posZ1, double posX2, double posZ2, int color) {
        double x1 = (posX1 - this.centerX) * this.scale + (double)this.width / 2.0;
        double z1 = (posZ1 - this.centerY) * this.scale + (double)this.height / 2.0;
        double x2 = (posX2 - this.centerX) * this.scale + (double)this.width / 2.0;
        double z2 = (posZ2 - this.centerY) * this.scale + (double)this.height / 2.0;
        this.drawRectangle(buffer, x1, z1, x2, z2, color);
    }

    private void drawRectangle(class_287 buffer, double xA, double yA, double xB, double yB, int color) {
        double x1 = Math.min(xA, xB);
        double y1 = Math.min(yA, yB);
        double x2 = Math.max(xA, xB);
        double y2 = Math.max(yA, yB);
        if (x1 < (double)this.width && y1 < (double)this.height && x2 >= 0.0 && y2 >= 0.0) {
            IDrawing.drawRectangle((class_4588)buffer, (double)this.x + Math.max(0.0, x1), (double)this.y + y1, (double)this.x + x2, (double)this.y + y2, color);
        }
    }

    private boolean canDrawAreaText(AreaBase areaBase) {
        return areaBase.getCenter() != null && this.scale >= (double)(80.0f / (float)Math.max(Math.abs((Integer)areaBase.corner1.method_15442() - (Integer)areaBase.corner2.method_15442()), Math.abs((Integer)areaBase.corner1.method_15441() - (Integer)areaBase.corner2.method_15441())));
    }

    private void drawSavedRail(class_4587 matrices, class_2338 savedRailPos, List<? extends SavedRailBase> savedRails) {
        int savedRailCount = savedRails.size();
        for (int i = 0; i < savedRailCount; ++i) {
            int index = i;
            this.drawFromWorldCoords((double)savedRailPos.method_10263() + 0.5, (double)savedRailPos.method_10260() + ((double)i + 0.5) / (double)savedRailCount, (x1, y1) -> class_329.method_25300((class_4587)matrices, (class_327)this.textRenderer, (String)((SavedRailBase)savedRails.get((int)index)).name, (int)(this.x + x1.intValue()), (int)(this.y + y1.intValue() - 4), (int)-1));
        }
    }

    private static int divideColorRGB(int color, int amount) {
        int r = (color >> 16 & 0xFF) / amount;
        int g = (color >> 8 & 0xFF) / amount;
        int b = (color & 0xFF) / amount;
        return (r << 16) + (g << 8) + b;
    }

    @FunctionalInterface
    public static interface OnDrawCorners {
        public void onDrawCorners(class_3545<Integer, Integer> var1, class_3545<Integer, Integer> var2);
    }

    @FunctionalInterface
    private static interface MouseOnSavedRailCallback {
        public void mouseOnSavedRailCallback(SavedRailBase var1, double var2, double var4, double var6, double var8);
    }

    private static enum MapState {
        DEFAULT,
        EDITING_AREA,
        EDITING_ROUTE;

    }
}

