/*
 * Decompiled with CFR 0.152.
 */
package mtr.servlet;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import mtr.data.DataCache;
import mtr.data.Depot;
import mtr.data.Platform;
import mtr.data.RailwayData;
import mtr.data.Route;
import mtr.data.RouteType;
import mtr.data.Station;
import mtr.data.TransportMode;
import mtr.libraries.javax.servlet.AsyncContext;
import mtr.libraries.javax.servlet.http.HttpServlet;
import mtr.libraries.javax.servlet.http.HttpServletRequest;
import mtr.libraries.javax.servlet.http.HttpServletResponse;
import mtr.servlet.IServletHandler;
import mtr.servlet.Webserver;
import net.minecraft.class_2338;
import net.minecraft.class_2350;

public class DataServletHandler
extends HttpServlet {
    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        AsyncContext asyncContext = request.startAsync();
        Webserver.callback.accept(() -> {
            JsonArray dataArray = new JsonArray();
            Webserver.getWorlds.get().forEach(world -> {
                RailwayData railwayData = RailwayData.getInstance(world);
                JsonArray routesArray = new JsonArray();
                JsonObject stationPositionsObject = new JsonObject();
                JsonObject stationsObject = new JsonObject();
                JsonArray typesObject = new JsonArray();
                HashSet types = new HashSet();
                DataCache dataCache = Webserver.getDataCache.apply(railwayData);
                if (dataCache != null) {
                    Webserver.getRoutes.apply(railwayData).forEach(route -> {
                        if (route.isHidden) {
                            return;
                        }
                        JsonObject routeObject = new JsonObject();
                        routeObject.addProperty("color", (Number)route.color);
                        routeObject.addProperty("name", route.name);
                        routeObject.addProperty("number", route.isLightRailRoute ? route.lightRailRouteNumber : "");
                        String type = IServletHandler.createRouteKey(route.transportMode, route.routeType);
                        routeObject.addProperty("type", type);
                        types.add(type);
                        JsonArray routeStationsArray = new JsonArray();
                        routeObject.add("stations", (JsonElement)routeStationsArray);
                        JsonArray routeDurationsArray = new JsonArray();
                        routeObject.add("durations", (JsonElement)routeDurationsArray);
                        JsonArray routeDensityArray = new JsonArray();
                        routeObject.add("densities", (JsonElement)routeDensityArray);
                        routeObject.addProperty("circular", route.circularState == Route.CircularState.NONE ? "" : (route.circularState == Route.CircularState.CLOCKWISE ? "cw" : "ccw"));
                        Depot depot = dataCache.routeIdToOneDepot.get(route.id);
                        float accumulatedTime = 0.0f;
                        class_2338 prevPlatformPos = null;
                        for (int i = 0; i < route.platformIds.size(); ++i) {
                            Platform platform;
                            long prevPlatformId;
                            long platformId = route.platformIds.get((int)i).platformId;
                            float time = 0.0f;
                            if (i > 0 && depot != null && depot.platformTimes.containsKey(prevPlatformId = route.platformIds.get((int)(i - 1)).platformId) && depot.platformTimes.get(prevPlatformId).containsKey(platformId)) {
                                time = depot.platformTimes.get(prevPlatformId).get(platformId).floatValue();
                            }
                            Station station = dataCache.platformIdToStation.get(platformId);
                            boolean addedStation = false;
                            class_2338 thisPlatformPos = null;
                            if (station != null && (platform = dataCache.platformIdMap.get(platformId)) != null) {
                                try {
                                    String newId = station.id + "_" + route.color;
                                    routeStationsArray.add(newId);
                                    thisPlatformPos = platform.getMidPos();
                                    if (stationPositionsObject.has(newId)) {
                                        stationPositionObject = stationPositionsObject.getAsJsonObject(newId);
                                        int existingX = stationPositionObject.get("x").getAsInt();
                                        int existingZ = stationPositionObject.get("y").getAsInt();
                                        stationPositionObject.addProperty("x", (Number)((existingX + thisPlatformPos.method_10263()) / 2));
                                        stationPositionObject.addProperty("y", (Number)((existingZ + thisPlatformPos.method_10260()) / 2));
                                    } else {
                                        stationPositionObject = new JsonObject();
                                        stationPositionObject.addProperty("x", (Number)thisPlatformPos.method_10263());
                                        stationPositionObject.addProperty("y", (Number)thisPlatformPos.method_10260());
                                        stationPositionObject.addProperty("vertical", Boolean.valueOf(platform.getAxis() == class_2350.class_2351.field_11051));
                                        stationPositionsObject.add(newId, (JsonElement)stationPositionObject);
                                    }
                                    JsonObject stationObject = new JsonObject();
                                    stationObject.addProperty("name", station.name);
                                    stationObject.addProperty("color", (Number)station.color);
                                    stationObject.addProperty("zone", (Number)station.zone);
                                    class_2338 stationCenter = station.getCenter();
                                    stationObject.addProperty("x", (Number)(stationCenter == null ? 0 : stationCenter.method_10263()));
                                    stationObject.addProperty("z", (Number)(stationCenter == null ? 0 : stationCenter.method_10260()));
                                    JsonArray stationConnectionsArray = new JsonArray();
                                    dataCache.stationIdToConnectingStations.get(station).forEach(connectingStation -> stationConnectionsArray.add(String.valueOf(connectingStation.id)));
                                    stationObject.add("connections", (JsonElement)stationConnectionsArray);
                                    stationsObject.add(String.valueOf(station.id), (JsonElement)stationObject);
                                    addedStation = true;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (prevPlatformPos != null && thisPlatformPos != null && railwayData != null) {
                                routeDensityArray.add((Number)railwayData.railwayDataRouteFinderModule.getConnectionDensity(prevPlatformPos, thisPlatformPos));
                            } else {
                                routeDensityArray.add((Number)0);
                            }
                            prevPlatformPos = thisPlatformPos;
                            accumulatedTime += time;
                            if (i <= 0 || !addedStation) continue;
                            routeDurationsArray.add((Number)Float.valueOf(accumulatedTime));
                            accumulatedTime = 0.0f;
                        }
                        routesArray.add((JsonElement)routeObject);
                    });
                }
                for (TransportMode transportMode : TransportMode.values()) {
                    for (RouteType routeType : RouteType.values()) {
                        String type = IServletHandler.createRouteKey(transportMode, routeType);
                        if (!types.contains(type)) continue;
                        typesObject.add(type);
                    }
                }
                JsonObject dataObject = new JsonObject();
                dataObject.add("routes", (JsonElement)routesArray);
                dataObject.add("positions", (JsonElement)stationPositionsObject);
                dataObject.add("stations", (JsonElement)stationsObject);
                dataObject.add("types", (JsonElement)typesObject);
                dataArray.add((JsonElement)dataObject);
            });
            IServletHandler.sendResponse(response, asyncContext, dataArray.toString());
        });
    }
}

