/*
 * Decompiled with CFR 0.152.
 */
package mtr.servlet;

import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import mtr.MTR;
import mtr.data.DataCache;
import mtr.data.RailwayData;
import mtr.data.Route;
import mtr.libraries.org.eclipse.jetty.server.Connector;
import mtr.libraries.org.eclipse.jetty.server.Server;
import mtr.libraries.org.eclipse.jetty.server.ServerConnector;
import mtr.libraries.org.eclipse.jetty.servlet.DefaultServlet;
import mtr.libraries.org.eclipse.jetty.servlet.ServletContextHandler;
import mtr.libraries.org.eclipse.jetty.servlet.ServletHolder;
import mtr.libraries.org.eclipse.jetty.util.resource.Resource;
import mtr.libraries.org.eclipse.jetty.util.thread.QueuedThreadPool;
import mtr.servlet.ArrivalsServletHandler;
import mtr.servlet.DataServletHandler;
import mtr.servlet.DelaysServletHandler;
import mtr.servlet.InfoServletHandler;
import mtr.servlet.RouteFinderServletHandler;
import net.minecraft.class_1937;
import net.minecraft.class_3532;

public abstract class Webserver {
    public static Consumer<Runnable> callback = Runnable::run;
    public static Supplier<List<class_1937>> getWorlds = ArrayList::new;
    public static Function<RailwayData, Set<Route>> getRoutes = railwayData -> new HashSet();
    public static Function<RailwayData, DataCache> getDataCache = railwayData -> null;
    private static Server webServer;
    private static ServerConnector serverConnector;

    public static void init() {
        webServer = new Server(new QueuedThreadPool(100, 10, 120));
        serverConnector = new ServerConnector(webServer);
        webServer.setConnectors(new Connector[]{serverConnector});
        ServletContextHandler context = new ServletContextHandler();
        webServer.setHandler(context);
        URL url = MTR.class.getResource("/assets/mtr/website/");
        if (url != null) {
            try {
                context.setBaseResource(Resource.newResource(url.toURI()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ServletHolder servletHolder = new ServletHolder("default", DefaultServlet.class);
        servletHolder.setInitParameter("dirAllowed", "true");
        servletHolder.setInitParameter("cacheControl", "max-age=0,public");
        context.addServlet(servletHolder, "/");
        context.addServlet(DataServletHandler.class, "/data");
        context.addServlet(InfoServletHandler.class, "/info");
        context.addServlet(ArrivalsServletHandler.class, "/arrivals");
        context.addServlet(DelaysServletHandler.class, "/delays");
        context.addServlet(RouteFinderServletHandler.class, "/route");
    }

    public static void start(Path path) {
        int port = 8888;
        try {
            port = class_3532.method_15340((int)Integer.parseInt(String.join((CharSequence)"", Files.readAllLines(path)).replaceAll("\\D", "")), (int)1025, (int)65535);
        }
        catch (Exception ignored) {
            try {
                Files.write(path, Collections.singleton(String.valueOf(port)), new OpenOption[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        serverConnector.setPort(port);
        try {
            webServer.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void stop() {
        try {
            webServer.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

