/*
 * Decompiled with CFR 0.152.
 */
package mtr.sound;

import java.util.Random;
import mtr.MTRClient;
import mtr.data.TrainClient;
import mtr.mappings.RegistryUtilities;
import mtr.sound.TrainSoundBase;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import net.minecraft.class_638;

public class JonTrainSound
extends TrainSoundBase {
    private final TrainClient train;
    public final String soundId;
    public final JonTrainSoundConfig config;
    private final char[] SOUND_GROUP_LETTERS = new char[]{'a', 'b', 'c'};
    private final int SOUND_GROUP_SIZE = this.SOUND_GROUP_LETTERS.length;
    private static final String SOUND_ACCELERATION = "_acceleration_";
    private static final String SOUND_DECELERATION = "_deceleration_";
    private static final String SOUND_DOOR_OPEN = "_door_open";
    private static final String SOUND_DOOR_CLOSE = "_door_close";
    private static final String SOUND_RANDOM = "_random";
    private static final int RANDOM_SOUND_CHANCE = 300;

    private JonTrainSound(String soundId, JonTrainSoundConfig config, TrainClient train) {
        this.config = config;
        this.soundId = soundId;
        this.train = train;
    }

    public JonTrainSound(String soundId, JonTrainSoundConfig config) {
        this(soundId, config, null);
    }

    @Override
    public TrainSoundBase createTrainInstance(TrainClient train) {
        return new JonTrainSound(this.soundId, this.config, train);
    }

    @Override
    public void playNearestCar(class_1937 world, class_2338 pos, int carIndex) {
        if (!(world instanceof class_638) || !MTRClient.canPlaySound()) {
            return;
        }
        if (this.config.speedSoundCount > 0 && this.soundId != null) {
            float referenceAcceleration = this.config.constantPlaybackSpeed ? this.train.accelerationConstant : 0.01f;
            int floorSpeed = (int)Math.floor(this.train.getSpeed() / referenceAcceleration / 4.0f);
            if (floorSpeed > 0) {
                Random random = new Random();
                if (floorSpeed >= 30 && random.nextInt(300) == 0) {
                    ((class_638)world).method_45446(pos, RegistryUtilities.createSoundEvent(new class_2960("mtr", this.soundId + SOUND_RANDOM)), class_3419.field_15245, 10.0f, 1.0f, false);
                }
                int index = Math.min(floorSpeed, this.config.speedSoundCount) - 1;
                boolean isAccelerating = this.train.speedChange() == 0.0f ? this.config.useAccelerationSoundsWhenCoasting || random.nextBoolean() : this.train.speedChange() > 0.0f;
                String speedSoundId = this.soundId + (isAccelerating ? SOUND_ACCELERATION : SOUND_DECELERATION) + index / this.SOUND_GROUP_SIZE + this.SOUND_GROUP_LETTERS[index % this.SOUND_GROUP_SIZE];
                ((class_638)world).method_45446(pos, RegistryUtilities.createSoundEvent(new class_2960("mtr", speedSoundId)), class_3419.field_15245, 1.0f, 1.0f, false);
            }
        }
    }

    @Override
    public void playAllCars(class_1937 world, class_2338 pos, int carIndex) {
    }

    @Override
    public void playAllCarsDoorOpening(class_1937 world, class_2338 pos, int carIndex) {
        String soundId;
        if (world instanceof class_638 && this.config.doorSoundBaseId != null && (soundId = this.train.justOpening() ? this.config.doorSoundBaseId + SOUND_DOOR_OPEN : (this.train.justClosing(this.config.doorCloseSoundTime) ? this.config.doorSoundBaseId + SOUND_DOOR_CLOSE : null)) != null) {
            ((class_638)world).method_45446(pos, RegistryUtilities.createSoundEvent(new class_2960("mtr", soundId)), class_3419.field_15245, 1.0f, 1.0f, false);
        }
    }

    public static class JonTrainSoundConfig {
        public final String doorSoundBaseId;
        public final int speedSoundCount;
        public final float doorCloseSoundTime;
        public final boolean useAccelerationSoundsWhenCoasting;
        public final boolean constantPlaybackSpeed;

        public JonTrainSoundConfig(String doorSoundBaseId, int speedSoundCount, float doorCloseSoundTime, boolean useAccelerationSoundsWhenCoasting, boolean constantPlaybackSpeed) {
            this.doorSoundBaseId = doorSoundBaseId;
            this.speedSoundCount = speedSoundCount;
            this.doorCloseSoundTime = doorCloseSoundTime;
            this.useAccelerationSoundsWhenCoasting = useAccelerationSoundsWhenCoasting;
            this.constantPlaybackSpeed = constantPlaybackSpeed;
        }

        public JonTrainSoundConfig(String doorSoundBaseId, int speedSoundCount, float doorCloseSoundTime, boolean useAccelerationSoundsWhenCoasting) {
            this.doorSoundBaseId = doorSoundBaseId;
            this.speedSoundCount = speedSoundCount;
            this.doorCloseSoundTime = doorCloseSoundTime;
            this.useAccelerationSoundsWhenCoasting = useAccelerationSoundsWhenCoasting;
            this.constantPlaybackSpeed = false;
        }
    }
}

