/*
 * Decompiled with CFR 0.152.
 */
package mtr.sound.bve;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import mtr.mappings.Utilities;
import mtr.mappings.UtilitiesClient;
import mtr.sound.bve.ConfigFile;
import mtr.sound.bve.MotorData4;
import mtr.sound.bve.MotorData5;
import mtr.sound.bve.MotorDataBase;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.apache.commons.io.IOUtils;

public class BveTrainSoundConfig {
    public final String baseName;
    public final String audioBaseName;
    public final ConfigFile soundCfg;
    public final MotorDataBase motorData;

    public BveTrainSoundConfig(class_3300 manager, String baseName) {
        class_2960 baseLocation = new class_2960((String)(baseName.contains(":") ? baseName : "mtr:" + baseName));
        this.baseName = baseLocation.toString();
        String configBaseName = baseLocation.method_12836() + ":sounds/" + baseLocation.method_12832();
        this.audioBaseName = baseLocation.method_12836() + ":" + baseLocation.method_12832() + "_";
        this.soundCfg = new ConfigFile(BveTrainSoundConfig.readResource(manager, new class_2960(configBaseName + "/sound.cfg")), this);
        this.motorData = this.soundCfg.motorNoiseDataType == 4 ? new MotorData4(manager, configBaseName) : new MotorData5(manager, configBaseName);
    }

    public static String readResource(class_3300 manager, class_2960 location) {
        try {
            List<class_3298> resources = UtilitiesClient.getResources(manager, location);
            if (resources.size() < 1) {
                return "";
            }
            return IOUtils.toString((InputStream)Utilities.getInputStream(resources.get(0)), (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            return "";
        }
    }
}

