/*
 * Decompiled with CFR 0.152.
 */
package mtr.sound.bve;

import java.util.Locale;
import mtr.mappings.RegistryUtilities;
import mtr.sound.bve.BveTrainSoundConfig;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import org.apache.commons.lang3.StringUtils;

public class ConfigFile {
    public final class_3414[] run = new class_3414[1];
    public final class_3414[] flange = new class_3414[1];
    public final class_3414[] motor = new class_3414[40];
    public final class_3414[] joint = new class_3414[1];
    public final class_3414 air;
    public final class_3414 airZero;
    public final class_3414 airHigh;
    public final class_3414 brakeEmergency;
    public final class_3414 doorOpen;
    public final class_3414 doorClose;
    public final class_3414 brakeHandleApply;
    public final class_3414 brakeHandleRelease;
    public final class_3414 compressorAttack;
    public final class_3414 compressorLoop;
    public final class_3414 compressorRelease;
    public final class_3414 noise;
    public final class_3414 shoe;
    public final int motorNoiseDataType;
    public final float motorVolumeMultiply;
    public final float breakerDelay;
    public final float regenerationLimit;
    public final float motorOutputAtCoast;
    public final int mrPressMin = 700;
    public final int mrPressMax = 800;
    public final float mrCompressorSpeed = 5.0f;
    public final float mrServiceBrakeReduce = 5.0f;
    public final float doorCloseSoundLength;

    public ConfigFile(String textContent, BveTrainSoundConfig config) {
        String[] lines = textContent.split("[\\r\\n]+");
        String section = "";
        class_3414 air = null;
        class_3414 airZero = null;
        class_3414 airHigh = null;
        class_3414 brakeEmergency = null;
        class_3414 doorOpen = null;
        class_3414 doorClose = null;
        class_3414 brakeHandleApply = null;
        class_3414 brakeHandleRelease = null;
        class_3414 compressorAttack = null;
        class_3414 compressorLoop = null;
        class_3414 compressorRelease = null;
        class_3414 noise = null;
        class_3414 shoe = null;
        int motorNoiseDataType = 5;
        float motorVolumeMultiply = 1.0f;
        float breakerDelay = 0.0f;
        float regenerationLimit = 0.0f;
        float motorOutputAtCoast = 0.4f;
        float doorCloseSoundLength = 1.0f;
        for (String line : lines) {
            String trimLine = line.trim().replaceAll("\\s*(;|#|//).+", "");
            if (StringUtils.isEmpty((CharSequence)trimLine)) continue;
            if (trimLine.contains("=")) {
                String[] tokens = trimLine.split("=");
                if (tokens.length != 2) continue;
                String key = tokens[0].trim().toLowerCase(Locale.ENGLISH).replaceAll("\\s", "");
                String value = tokens[1].trim().toLowerCase(Locale.ENGLISH).replace("\\", "/").replaceAll("\\.wav|\\s|.+/", "");
                if (StringUtils.isEmpty((CharSequence)value)) continue;
                class_3414 valueAsSoundEvent = RegistryUtilities.createSoundEvent(new class_2960(config.audioBaseName + value));
                block14 : switch (section) {
                    case "mtr": {
                        switch (key) {
                            case "motornoisedatatype": {
                                motorNoiseDataType = Integer.parseInt(value);
                                break block14;
                            }
                            case "motorvolumemultiply": {
                                motorVolumeMultiply = Float.parseFloat(value);
                                break block14;
                            }
                            case "doorclosesoundlength": {
                                doorCloseSoundLength = Float.parseFloat(value);
                                break block14;
                            }
                            case "breakerdelay": {
                                breakerDelay = Float.parseFloat(value);
                                break block14;
                            }
                            case "regenerationlimit": {
                                regenerationLimit = Float.parseFloat(value) / 3.6f;
                                break block14;
                            }
                            case "motoroutputatcoast": {
                                motorOutputAtCoast = Float.parseFloat(value);
                            }
                        }
                        break;
                    }
                    case "run": 
                    case "rolling": {
                        if (Integer.parseInt(key) >= this.run.length) break;
                        this.run[Integer.parseInt((String)key)] = valueAsSoundEvent;
                        break;
                    }
                    case "flange": {
                        if (Integer.parseInt(key) >= this.flange.length) break;
                        this.flange[Integer.parseInt((String)key)] = valueAsSoundEvent;
                        break;
                    }
                    case "motor": {
                        if (Integer.parseInt(key) >= this.motor.length) break;
                        this.motor[Integer.parseInt((String)key)] = valueAsSoundEvent;
                        break;
                    }
                    case "joint": 
                    case "switch": {
                        if (Integer.parseInt(key) >= this.joint.length) break;
                        this.joint[Integer.parseInt((String)key)] = valueAsSoundEvent;
                        break;
                    }
                    case "brake": {
                        switch (key) {
                            case "bcrelease": {
                                air = valueAsSoundEvent;
                                break block14;
                            }
                            case "bcreleasefull": {
                                airZero = valueAsSoundEvent;
                                break block14;
                            }
                            case "bcreleasehigh": {
                                airHigh = valueAsSoundEvent;
                                break block14;
                            }
                            case "emergency": {
                                brakeEmergency = valueAsSoundEvent;
                            }
                        }
                        break;
                    }
                    case "door": {
                        switch (key) {
                            case "open": 
                            case "openleft": 
                            case "openright": {
                                doorOpen = valueAsSoundEvent;
                                break;
                            }
                            case "close": 
                            case "closeleft": 
                            case "closeright": {
                                doorClose = valueAsSoundEvent;
                            }
                        }
                    }
                    case "brakehandle": {
                        switch (key) {
                            case "apply": {
                                brakeHandleApply = valueAsSoundEvent;
                                break block14;
                            }
                            case "release": {
                                brakeHandleRelease = valueAsSoundEvent;
                            }
                        }
                        break;
                    }
                    case "compressor": {
                        switch (key) {
                            case "attack": {
                                compressorAttack = valueAsSoundEvent;
                                break;
                            }
                            case "loop": {
                                compressorLoop = valueAsSoundEvent;
                                break;
                            }
                            case "release": {
                                compressorRelease = valueAsSoundEvent;
                            }
                        }
                    }
                    case "others": {
                        switch (key) {
                            case "noise": {
                                noise = valueAsSoundEvent;
                                break block14;
                            }
                            case "shoe": {
                                shoe = valueAsSoundEvent;
                            }
                        }
                    }
                }
                continue;
            }
            if (!trimLine.startsWith("[") || !trimLine.endsWith("]")) continue;
            section = trimLine.substring(1, trimLine.length() - 1).trim().replace(" ", "").toLowerCase(Locale.ENGLISH);
        }
        if (airZero == null) {
            airZero = air;
        }
        if (airHigh == null) {
            airHigh = air;
        }
        this.air = air;
        this.airZero = airZero;
        this.airHigh = airHigh;
        this.brakeEmergency = brakeEmergency;
        this.doorOpen = doorOpen;
        this.doorClose = doorClose;
        this.brakeHandleApply = brakeHandleApply;
        this.brakeHandleRelease = brakeHandleRelease;
        this.compressorAttack = compressorAttack;
        this.compressorLoop = compressorLoop;
        this.compressorRelease = compressorRelease;
        this.noise = noise;
        this.shoe = shoe;
        this.motorNoiseDataType = motorNoiseDataType;
        this.motorVolumeMultiply = motorVolumeMultiply;
        this.breakerDelay = breakerDelay;
        this.regenerationLimit = regenerationLimit;
        this.motorOutputAtCoast = motorOutputAtCoast;
        this.doorCloseSoundLength = doorCloseSoundLength;
    }
}

