/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.entity.boat;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1690;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_554;
import net.minecraft.class_5601;
import net.minecraft.class_5617;
import net.minecraft.class_7752;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import potionstudios.byg.BYG;
import potionstudios.byg.common.entity.boat.BYGBoat;
import potionstudios.byg.util.ModPlatform;

public class BYGBoatRenderer
extends class_897<BYGBoat> {
    private final Map<BYGBoat.BYGType, Pair<class_2960, class_554>> boatResources;

    public BYGBoatRenderer(class_5617.class_5618 context, boolean hasChest) {
        super(context);
        this.field_4673 = 0.8f;
        this.boatResources = ModPlatform.INSTANCE.hasLoadErrors() ? new HashMap<BYGBoat.BYGType, Pair<class_2960, class_554>>() : (Map)Stream.of(BYGBoat.BYGType.values()).collect(ImmutableMap.toImmutableMap(bygType -> bygType, bygType -> Pair.of((Object)BYG.createLocation(BYGBoatRenderer.getTextureLocation(bygType, hasChest)), (Object)this.createBoatModel(context, (BYGBoat.BYGType)((Object)bygType), hasChest))));
    }

    private class_554 createBoatModel(class_5617.class_5618 context, BYGBoat.BYGType bygType, boolean hasChest) {
        class_5601 modellayerlocation = hasChest ? BYGBoatRenderer.createChestBoatModelName(bygType) : BYGBoatRenderer.createBoatModelName(bygType);
        return hasChest ? new class_7752(context.method_32167(modellayerlocation)) : new class_554(context.method_32167(modellayerlocation));
    }

    public static class_5601 createChestBoatModelName(BYGBoat.BYGType type) {
        return new class_5601(BYG.createLocation("chest_boat/" + type.getName()), "main");
    }

    public static class_5601 createBoatModelName(BYGBoat.BYGType type) {
        return new class_5601(BYG.createLocation("boat/" + type.getName()), "main");
    }

    private static String getTextureLocation(BYGBoat.BYGType bygType, boolean hasChest) {
        return hasChest ? "textures/entity/chest_boat/" + bygType.getName() + ".png" : "textures/entity/boat/" + bygType.getName() + ".png";
    }

    public void render(BYGBoat boat, float entityYaw, float partialTicks, class_4587 matrixStackIn, @NotNull class_4597 multiBufferSource, int packedLightIn) {
        float k;
        matrixStackIn.method_22903();
        matrixStackIn.method_22904(0.0, 0.375, 0.0);
        matrixStackIn.method_22907(class_7833.field_40716.rotationDegrees(180.0f - entityYaw));
        float h = (float)boat.method_7533() - partialTicks;
        float j = boat.method_7554() - partialTicks;
        if (j < 0.0f) {
            j = 0.0f;
        }
        if (h > 0.0f) {
            matrixStackIn.method_22907(class_7833.field_40714.rotationDegrees(class_3532.method_15374((float)h) * h * j / 10.0f * (float)boat.method_7543()));
        }
        if (!class_3532.method_15347((float)(k = boat.method_7547(partialTicks)), (float)0.0f)) {
            matrixStackIn.method_22907(new Quaternionf().setAngleAxis(boat.method_7547(partialTicks) * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
        }
        Pair<class_2960, class_554> pair = this.boatResources.get((Object)boat.getBYGBoatType());
        class_2960 resourceLocation = (class_2960)pair.getFirst();
        class_554 boatModel = (class_554)pair.getSecond();
        matrixStackIn.method_22905(-1.0f, -1.0f, 1.0f);
        matrixStackIn.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
        boatModel.method_22952((class_1690)boat, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        class_4588 vertexConsumer = multiBufferSource.getBuffer(boatModel.method_23500(resourceLocation));
        boatModel.method_2828(matrixStackIn, vertexConsumer, packedLightIn, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        if (!boat.method_5869()) {
            class_4588 vertexConsumer2 = multiBufferSource.getBuffer(class_1921.method_23589());
            boatModel.method_22954().method_22698(matrixStackIn, vertexConsumer2, packedLightIn, class_4608.field_21444);
        }
        matrixStackIn.method_22909();
        super.method_3936((class_1297)boat, entityYaw, partialTicks, matrixStackIn, multiBufferSource, packedLightIn);
    }

    @NotNull
    public class_2960 getTextureLocation(BYGBoat boat) {
        return (class_2960)this.boatResources.get((Object)boat.getBYGBoatType()).getFirst();
    }
}

