/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.biome.end;

import com.google.common.base.Suppliers;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_1972;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5742;
import net.minecraft.class_6780;
import net.minecraft.class_6880;
import net.minecraft.class_6910;
import org.jetbrains.annotations.NotNull;
import potionstudios.byg.BYG;
import potionstudios.byg.common.world.biome.LayerUtil;
import potionstudios.byg.common.world.biome.LayersBiomeData;
import potionstudios.byg.common.world.biome.LazyLoadSeed;
import potionstudios.byg.common.world.biome.end.EndBiomesConfig;
import potionstudios.byg.mixin.access.BiomeSourceAccess;
import potionstudios.byg.util.BYGUtil;
import terrablender.worldgen.noise.Area;

public class BYGEndBiomeSource
extends class_1966
implements LazyLoadSeed {
    public static final Codec<BYGEndBiomeSource> CODEC = Codec.unit(BYGEndBiomeSource::new);
    public static final class_2960 LOCATION = BYG.createLocation("end");
    private class_2378<class_1959> biomeRegistry;
    private class_6780 islandBiomeResolver;
    private class_6780 voidBiomeResolver;
    private class_6780 skyBiomeResolver;
    private final int skyLayersStartY;

    public BYGEndBiomeSource() {
        EndBiomesConfig config = EndBiomesConfig.getConfig();
        this.skyLayersStartY = class_5742.method_33100((int)config.skyLayerStartY());
    }

    @NotNull
    public class_6880<class_1959> method_38109(int x, int y, int z, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_6544.class_6552 sampler) {
        int quartX = class_5742.method_33101((int)x);
        int quartY = class_5742.method_33101((int)y);
        int quartZ = class_5742.method_33101((int)z);
        int chunkX = x >> 2;
        int chunkZ = z >> 2;
        if ((long)chunkX * (long)chunkX + (long)chunkZ * (long)chunkZ <= 4096L) {
            return this.biomeRegistry.method_40290(class_1972.field_9411);
        }
        if (y > this.skyLayersStartY) {
            return this.skyBiomeResolver.method_38109(x, y, z, sampler);
        }
        double heightValue = sampler.comp_367().method_40464((class_6910.class_6912)new class_6910.class_6914(quartX, quartY, quartZ));
        if (heightValue > 40.0) {
            return this.islandBiomeResolver.method_38109(x, y, z, sampler);
        }
        if (heightValue >= 0.0) {
            return this.islandBiomeResolver.method_38109(x, y, z, sampler);
        }
        return heightValue < -20.0 ? this.voidBiomeResolver.method_38109(x, y, z, sampler) : this.islandBiomeResolver.method_38109(x, y, z, sampler);
    }

    @NotNull
    protected Codec<? extends class_1966> method_28442() {
        return CODEC;
    }

    @NotNull
    protected Stream<class_6880<class_1959>> method_49494() {
        return Stream.empty();
    }

    @Override
    public void lazyLoad(long seed, class_2378<class_1959> biomeRegistry) {
        this.biomeRegistry = biomeRegistry;
        ((BiomeSourceAccess)((Object)this)).byg_setPossibleBiomes((Supplier<Set<class_6880<class_1959>>>)Suppliers.memoize(() -> (Set)BYGEndBiomeSource.getPossibleBiomes(biomeRegistry).stream().collect(ObjectOpenHashSet.toSet())));
        EndBiomesConfig config = EndBiomesConfig.getConfig();
        Set possibleBiomes = this.method_28443().stream().map(class_6880::method_40230).map(Optional::orElseThrow).collect(Collectors.toSet());
        BiPredicate<Collection<class_5321<class_1959>>, class_5321<class_1959>> filter = (existing, added) -> !existing.contains(added) && possibleBiomes.contains(added);
        this.islandBiomeResolver = BYGEndBiomeSource.getIslandBiomeResolver(biomeRegistry, seed, config.islandLayers().filter(filter));
        this.voidBiomeResolver = BYGEndBiomeSource.getVoidBiomeResolver(biomeRegistry, seed, config.voidLayers().filter(filter));
        this.skyBiomeResolver = BYGEndBiomeSource.getSkyBiomeResolver(biomeRegistry, seed, config.skyLayers().filter(filter));
    }

    @NotNull
    private static List<class_6880<class_1959>> getPossibleBiomes(class_2378<class_1959> biomeRegistry) {
        EndBiomesConfig config = EndBiomesConfig.getConfig(false, false, biomeRegistry);
        TreeSet<String> missingBiomes = new TreeSet<String>();
        BiPredicate<Collection<class_5321<class_1959>>, class_5321<class_1959>> filter = (existing, added) -> {
            boolean biomeRegistryHas = biomeRegistry.method_35842(added);
            if (!biomeRegistryHas) {
                missingBiomes.add(added.method_29177().toString());
            }
            return !existing.contains(added) && biomeRegistryHas;
        };
        LayersBiomeData usedIslandLayer = config.islandLayers().filter(filter);
        LayersBiomeData usedVoidLayer = config.voidLayers().filter(filter);
        LayersBiomeData usedSkyLayer = config.skyLayers().filter(filter);
        String ignored = BYGUtil.dumpCollection(missingBiomes);
        if (!ignored.isEmpty()) {
            BYG.logWarning(String.format("Config \"%s\" warned:\nThe following biome entries were ignored due to not being in this world's biome registry:\n%s", EndBiomesConfig.CONFIG_PATH.get(), ignored));
        }
        List<class_6880<class_1959>> biomesFromBiomeData = BYGUtil.createBiomesFromBiomeData(biomeRegistry, usedIslandLayer, usedVoidLayer, usedSkyLayer);
        biomesFromBiomeData.add((class_6880<class_1959>)biomeRegistry.method_40290(class_1972.field_9411));
        return biomesFromBiomeData;
    }

    public static class_6780 getIslandBiomeResolver(class_2378<class_1959> biomeRegistry, long seed, LayersBiomeData islandLayersBiomeData) {
        Area layers = LayerUtil.createLayers(biomeRegistry, seed, islandLayersBiomeData.biomeWeights(), islandLayersBiomeData.biomeSize(), EndBiomesConfig.CONFIG_PATH.get());
        return (x, y, z, sampler) -> (class_6880)biomeRegistry.method_40265(layers.get(x, z)).orElseThrow();
    }

    public static class_6780 getVoidBiomeResolver(class_2378<class_1959> biomeRegistry, long seed, LayersBiomeData voidLayersBiomeData) {
        Area layers = LayerUtil.createLayers(biomeRegistry, seed, voidLayersBiomeData.biomeWeights(), voidLayersBiomeData.biomeSize(), EndBiomesConfig.CONFIG_PATH.get());
        return (x, y, z, sampler) -> (class_6880)biomeRegistry.method_40265(layers.get(x, z)).orElseThrow();
    }

    public static class_6780 getSkyBiomeResolver(class_2378<class_1959> biomeRegistry, long seed, LayersBiomeData skyLayersBiomeData) {
        Area layers = LayerUtil.createLayers(biomeRegistry, seed, skyLayersBiomeData.biomeWeights(), skyLayersBiomeData.biomeSize(), EndBiomesConfig.CONFIG_PATH.get());
        return (x, y, z, sampler) -> (class_6880)biomeRegistry.method_40265(layers.get(x, z)).orElseThrow();
    }
}

