/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.biome.overworld;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.corgilib.serialization.codec.CodecUtil;
import corgitaco.corgilib.serialization.codec.FromFileCodec;
import corgitaco.corgilib.serialization.codec.Wrapped;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_156;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import potionstudios.byg.common.world.biome.BYGBiomes;
import potionstudios.byg.common.world.biome.overworld.BYGOverworldBiomeSelectors;

public record OverworldRegion(int overworldWeight, Wrapped<List<List<class_5321<class_1959>>>> oceans, Wrapped<List<List<class_5321<class_1959>>>> middleBiomes, Wrapped<List<List<class_5321<class_1959>>>> middleBiomesVariant, Wrapped<List<List<class_5321<class_1959>>>> plateauBiomes, Wrapped<List<List<class_5321<class_1959>>>> plateauBiomesVariant, Wrapped<List<List<class_5321<class_1959>>>> extremeHills, Wrapped<List<List<class_5321<class_1959>>>> beachBiomes, Wrapped<List<List<class_5321<class_1959>>>> peakBiomes, Wrapped<List<List<class_5321<class_1959>>>> peakBiomesVariant, Wrapped<List<List<class_5321<class_1959>>>> slopeBiomes, Wrapped<List<List<class_5321<class_1959>>>> slopeBiomesVariant, Map<class_5321<class_1959>, class_5321<class_1959>> swapper) {
    public static final Codec<OverworldRegion> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("weight").forGetter(overworldRegion -> overworldRegion.overworldWeight), (App)BYGOverworldBiomeSelectors.BIOME_LAYOUT_CODEC.fieldOf("ocean_biomes").forGetter(overworldRegion -> overworldRegion.oceans), (App)BYGOverworldBiomeSelectors.BIOME_LAYOUT_CODEC.fieldOf("middle_biomes").forGetter(overworldRegion -> overworldRegion.middleBiomes), (App)BYGOverworldBiomeSelectors.BIOME_LAYOUT_CODEC.fieldOf("middle_biomes_variant").forGetter(overworldRegion -> overworldRegion.middleBiomesVariant), (App)BYGOverworldBiomeSelectors.BIOME_LAYOUT_CODEC.fieldOf("plateau_biomes").forGetter(overworldRegion -> overworldRegion.plateauBiomes), (App)BYGOverworldBiomeSelectors.BIOME_LAYOUT_CODEC.fieldOf("plateau_biomes_variant").forGetter(overworldRegion -> overworldRegion.plateauBiomesVariant), (App)BYGOverworldBiomeSelectors.BIOME_LAYOUT_CODEC.fieldOf("shattered_biomes").forGetter(overworldRegion -> overworldRegion.extremeHills), (App)BYGOverworldBiomeSelectors.BIOME_LAYOUT_CODEC.fieldOf("beach_biomes").orElse(BYGOverworldBiomeSelectors.BEACH_BIOMES_VANILLA).forGetter(overworldRegion -> overworldRegion.beachBiomes), (App)BYGOverworldBiomeSelectors.BIOME_LAYOUT_CODEC.fieldOf("peak_biomes").orElse(BYGOverworldBiomeSelectors.PEAK_BIOMES_VANILLA).forGetter(overworldRegion -> overworldRegion.peakBiomes), (App)BYGOverworldBiomeSelectors.BIOME_LAYOUT_CODEC.fieldOf("peak_biomes_variant").orElse(BYGOverworldBiomeSelectors.PEAK_BIOMES_VARIANT_VANILLA).forGetter(overworldRegion -> overworldRegion.peakBiomesVariant), (App)BYGOverworldBiomeSelectors.BIOME_LAYOUT_CODEC.fieldOf("slope_biomes").orElse(BYGOverworldBiomeSelectors.SLOPE_BIOMES_VANILLA).forGetter(overworldRegion -> overworldRegion.slopeBiomes), (App)BYGOverworldBiomeSelectors.BIOME_LAYOUT_CODEC.fieldOf("slope_biomes_variant").orElse(BYGOverworldBiomeSelectors.SLOPE_BIOMES_VARIANT_VANILLA).forGetter(overworldRegion -> overworldRegion.slopeBiomesVariant), (App)Codec.unboundedMap((Codec)class_2960.field_25139.comapFlatMap(resourceLocation -> {
        if (!resourceLocation.method_12836().equals("minecraft")) {
            throw new IllegalArgumentException("Only biomes from MC can be used as the swapper's key!!! You put: \"" + resourceLocation + "\"");
        }
        return DataResult.success((Object)class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)resourceLocation));
    }, class_5321::method_29177), (Codec)CodecUtil.BIOME_CODEC).fieldOf("swapper").forGetter(overworldRegion -> overworldRegion.swapper)).apply((Applicative)builder, OverworldRegion::new));
    public static final Codec<OverworldRegion> VERIFYING_CODEC = CODEC.flatXmap(OverworldRegion.verifyRegion(), OverworldRegion.verifyRegion());
    public static final Codec<OverworldRegion> OLD_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("weight").forGetter(overworldRegion -> overworldRegion.overworldWeight), (App)BYGOverworldBiomeSelectors.OLD_BIOME_LAYOUT_CODEC.fieldOf("oceans").forGetter(overworldRegion -> (List)overworldRegion.oceans.value()), (App)BYGOverworldBiomeSelectors.OLD_BIOME_LAYOUT_CODEC.fieldOf("middle_biomes").forGetter(overworldRegion -> (List)overworldRegion.middleBiomes.value()), (App)BYGOverworldBiomeSelectors.OLD_BIOME_LAYOUT_CODEC.fieldOf("middle_biomes_variant").forGetter(overworldRegion -> (List)overworldRegion.middleBiomesVariant.value()), (App)BYGOverworldBiomeSelectors.OLD_BIOME_LAYOUT_CODEC.fieldOf("plateau_biomes").forGetter(overworldRegion -> (List)overworldRegion.plateauBiomes.value()), (App)BYGOverworldBiomeSelectors.OLD_BIOME_LAYOUT_CODEC.fieldOf("plateau_biomes_variant").forGetter(overworldRegion -> (List)overworldRegion.plateauBiomesVariant.value()), (App)BYGOverworldBiomeSelectors.OLD_BIOME_LAYOUT_CODEC.fieldOf("shattered_biomes").forGetter(overworldRegion -> (List)overworldRegion.extremeHills.value()), (App)BYGOverworldBiomeSelectors.OLD_BIOME_LAYOUT_CODEC.fieldOf("beach_biomes").orElse((Object)((List)BYGOverworldBiomeSelectors.BEACH_BIOMES_VANILLA.value())).forGetter(overworldRegion -> (List)overworldRegion.beachBiomes.value()), (App)BYGOverworldBiomeSelectors.OLD_BIOME_LAYOUT_CODEC.fieldOf("peak_biomes").orElse((Object)((List)BYGOverworldBiomeSelectors.PEAK_BIOMES_VANILLA.value())).forGetter(overworldRegion -> (List)overworldRegion.peakBiomes.value()), (App)BYGOverworldBiomeSelectors.OLD_BIOME_LAYOUT_CODEC.fieldOf("peak_biomes_variant").orElse((Object)((List)BYGOverworldBiomeSelectors.PEAK_BIOMES_VARIANT_VANILLA.value())).forGetter(overworldRegion -> (List)overworldRegion.peakBiomesVariant.value()), (App)BYGOverworldBiomeSelectors.OLD_BIOME_LAYOUT_CODEC.fieldOf("slope_biomes").orElse((Object)((List)BYGOverworldBiomeSelectors.SLOPE_BIOMES_VANILLA.value())).forGetter(overworldRegion -> (List)overworldRegion.slopeBiomes.value()), (App)BYGOverworldBiomeSelectors.OLD_BIOME_LAYOUT_CODEC.fieldOf("slope_biomes_variant").orElse((Object)((List)BYGOverworldBiomeSelectors.SLOPE_BIOMES_VARIANT_VANILLA.value())).forGetter(overworldRegion -> (List)overworldRegion.slopeBiomesVariant.value()), (App)Codec.unboundedMap((Codec)class_2960.field_25139.comapFlatMap(resourceLocation -> {
        if (!resourceLocation.method_12836().equals("minecraft")) {
            throw new IllegalArgumentException("Only biomes from MC can be used as the swapper's key!!! You put: \"" + resourceLocation + "\"");
        }
        return DataResult.success((Object)class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)resourceLocation));
    }, class_5321::method_29177), (Codec)CodecUtil.BIOME_CODEC).fieldOf("swapper").forGetter(overworldRegion -> overworldRegion.swapper)).apply((Applicative)builder, OverworldRegion::fromOldCodec));
    public static final FromFileCodec<OverworldRegion> BIOME_PROVIDER_DATA_FROM_FILE_CODEC = FromFileCodec.create(VERIFYING_CODEC, (String)"regions");
    public static final Map<String, Pair<Map<String, String>, Wrapped<OverworldRegion>>> BIOME_REGIONS = new HashMap<String, Pair<Map<String, String>, Wrapped<OverworldRegion>>>();
    private static final int OVERWORLD_WEIGHT = 3;
    public static final Map<String, String> COMMENTS = (Map)class_156.method_654(new HashMap(), map -> {
        map.put("", "/*\nThis file uses the \".json5\" file extension which allows for comments like this in a json file!\nYour text editor may show this file with invalid/no syntax, if so, we recommend you download:\n\nVSCode: https://code.visualstudio.com/\nJSON5 plugin(for VSCode): https://marketplace.visualstudio.com/items?itemName=mrmlnc.vscode-json5\n\nto make editing this file much easier.\n\nA region is a unique biome layout comprised of numerous biome selectors for a given type of terrain in an MC world.\nBiome selectors may be inlined or may call a file from \"this_file_parent_directory/biome_selectors\"\n*/");
        map.put("peak_biomes", "Appearing on mountainous terrain & BELOW weirdness 0, here is the \"peak_biomes\" layout:\n\n[ ARID-ICY, DRY-ICY, NEUTRAL-ICY, WET-ICY, HUMID-ICY ],\n[ ARID-COLD, DRY-COLD, NEUTRAL-COLD, WET-COLD, HUMID-COLD ],\n[ ARID-NEUTRAL, DRY-NEUTRAL, NEUTRAL-NEUTRAL, WET-NEUTRAL, HUMID-NEUTRAL ],\n[ ARID-WARM, DRY-WARM, NEUTRAL-WARM, WET-WARM, HUMID-WARM ],\n[ ARID-HOT, DRY-HOT, NEUTRAL-HOT, WET-HOT, HUMID-HOT ]\n\nAll keys passed in must be valid in the biome registry!\n\"minecraft:the_void\" is invalid as it represents a value of \"NULL(nothing)\" internally.\n");
        map.put("peak_biomes_variant", BYGOverworldBiomeSelectors.PEAK_BIOMES_VARIANT_LAYOUT);
        map.put("ocean_biomes", "Appearing on terrain below sea level, here is the \"ocean_biomes\" layout:\n[ DEEP-ICY, DEEP-COLD, DEEP-NEUTRAL, DEEP-WARM, DEEP-HOT ]\n[ SHALLOW-ICY, SHALLOW-COLD, SHALLOW-NEUTRAL, SHALLOW-WARM, SHALLOW-HOT ],\n\nAll keys passed in must be valid in the biome registry!\n\"minecraft:the_void\" is invalid as it represents a value of \"NULL(nothing)\" internally.\n");
        map.put("plateau_biomes", "Appearing on elevated flat terrain BELOW weirdness 0 or in unfilled(\"NULL(nothing)\") spots in \"plateau_biome_variants\", here is the \"plateau_biomes\" layout:\n\n[ ARID-ICY, DRY-ICY, NEUTRAL-ICY, WET-ICY, HUMID-ICY ],\n[ ARID-COLD, DRY-COLD, NEUTRAL-COLD, WET-COLD, HUMID-COLD ],\n[ ARID-NEUTRAL, DRY-NEUTRAL, NEUTRAL-NEUTRAL, WET-NEUTRAL, HUMID-NEUTRAL ],\n[ ARID-WARM, DRY-WARM, NEUTRAL-WARM, WET-WARM, HUMID-WARM ],\n[ ARID-HOT, DRY-HOT, NEUTRAL-HOT, WET-HOT, HUMID-HOT ]\n\nAll keys passed in must be valid in the biome registry!\n\"minecraft:the_void\" is invalid as it represents a value of \"NULL(nothing)\" internally.\n");
        map.put("plateau_biomes_variant", BYGOverworldBiomeSelectors.PLATEAU_BIOMES_VARIANT_LAYOUT);
        map.put("middle_biomes", "Appearing on terrain BELOW weirdness 0 or in unfilled(\"NULL(nothing)\") spots in \"middle_biomes_variants\", here is the \"middle_biomes\" layout:\n\n[ ARID-ICY, DRY-ICY, NEUTRAL-ICY, WET-ICY, HUMID-ICY ],\n[ ARID-COLD, DRY-COLD, NEUTRAL-COLD, WET-COLD, HUMID-COLD ],\n[ ARID-NEUTRAL, DRY-NEUTRAL, NEUTRAL-NEUTRAL, WET-NEUTRAL, HUMID-NEUTRAL ],\n[ ARID-WARM, DRY-WARM, NEUTRAL-WARM, WET-WARM, HUMID-WARM ],\n[ ARID-HOT, DRY-HOT, NEUTRAL-HOT, WET-HOT, HUMID-HOT ]\n\nAll keys passed in must be valid in the biome registry!\n\"minecraft:the_void\" is invalid as it represents a value of \"NULL(nothing)\" internally.\n");
        map.put("middle_biomes_variant", BYGOverworldBiomeSelectors.MIDDLE_BIOMES_VARIANT_LAYOUT);
        map.put("shattered_biomes", "Appearing on shattered terrain here is the \"shattered_biomes\" layout:\n\n[ ARID-ICY, DRY-ICY, NEUTRAL-ICY, WET-ICY, HUMID-ICY ],\n[ ARID-COLD, DRY-COLD, NEUTRAL-COLD, WET-COLD, HUMID-COLD ],\n[ ARID-NEUTRAL, DRY-NEUTRAL, NEUTRAL-NEUTRAL, WET-NEUTRAL, HUMID-NEUTRAL ],\n[ ARID-WARM, DRY-WARM, NEUTRAL-WARM, WET-WARM, HUMID-WARM ],\n[ ARID-HOT, DRY-HOT, NEUTRAL-HOT, WET-HOT, HUMID-HOT ]\n\nAll keys passed in must be valid in the biome registry!\nIn slots containing \"minecraft:the_void\", biomes at the equivalent temperature/humidity index in \"middle_biomes\" will be used instead.\n");
        map.put("beach_biomes", "Appearing on terrain bordering oceans, here is the \"beach_biomes\" layout:\n\n[ ARID-ICY, DRY-ICY, NEUTRAL-ICY, WET-ICY, HUMID-ICY ],\n[ ARID-COLD, DRY-COLD, NEUTRAL-COLD, WET-COLD, HUMID-COLD ],\n[ ARID-NEUTRAL, DRY-NEUTRAL, NEUTRAL-NEUTRAL, WET-NEUTRAL, HUMID-NEUTRAL ],\n[ ARID-WARM, DRY-WARM, NEUTRAL-WARM, WET-WARM, HUMID-WARM ],\n[ ARID-HOT, DRY-HOT, NEUTRAL-HOT, WET-HOT, HUMID-HOT ]\n\nAll keys passed in must be valid in the biome registry!\n\"minecraft:the_void\" is invalid as it represents a value of \"NULL(nothing)\" internally.\n");
        map.put("swapper", "Used to swap biomes not found in the biome selectors.\nBiomes found within the biome selectors, may not be used as the swapped \"value\" and biomes only from Minecraft may be used as the \"key\".\n\n\"key\" = \"minecraft:biome_registry_path\"\n\"value\" = \"modid:new_biome_registry_path\"\n\nFor example:\n{\n\"key1\":\"value1\",\n\"key2\":\"value2\",\n\"key3\":\"value3\"\n}\n");
        map.put("weight", "The weight of this provider/region against all other providers.\nHigher numbers do NOT increase the provider's size.\nWeight \"0\" disables this provider and all its entries.\n");
    });
    public static final Wrapped<OverworldRegion> REGION_1 = OverworldRegion.create("region_1", new OverworldRegion(3, BYGOverworldBiomeSelectors.OCEANS_VANILLA, BYGOverworldBiomeSelectors.MIDDLE_BIOMES_1, BYGOverworldBiomeSelectors.MIDDLE_BIOMES_VARIANT_VANILLA, BYGOverworldBiomeSelectors.PLATEAU_BIOMES_1, BYGOverworldBiomeSelectors.PLATEAU_BIOMES_VARIANT_VANILLA, BYGOverworldBiomeSelectors.SHATTERED_BIOMES_VANILLA, BYGOverworldBiomeSelectors.BEACH_BIOMES_1, BYGOverworldBiomeSelectors.PEAK_BIOMES_1, BYGOverworldBiomeSelectors.PEAK_BIOMES_VARIANT_VANILLA, BYGOverworldBiomeSelectors.SLOPE_BIOMES_1, BYGOverworldBiomeSelectors.SLOPE_BIOMES_VARIANT_VANILLA, (Map)class_156.method_654(new IdentityHashMap(), map -> {
        map.put(class_1972.field_38748, BYGBiomes.WHITE_MANGROVE_MARSHES);
        map.put(class_1972.field_9471, BYGBiomes.CYPRESS_SWAMPLANDS);
        map.put(class_1972.field_9419, BYGBiomes.DACITE_SHORE);
    })));
    public static final Wrapped<OverworldRegion> REGION_2 = OverworldRegion.create("region_2", new OverworldRegion(3, BYGOverworldBiomeSelectors.OCEANS_VANILLA, BYGOverworldBiomeSelectors.MIDDLE_BIOMES_2, BYGOverworldBiomeSelectors.MIDDLE_BIOMES_VARIANT_VANILLA, BYGOverworldBiomeSelectors.PLATEAU_BIOMES_2, BYGOverworldBiomeSelectors.PLATEAU_BIOMES_VARIANT_VANILLA, BYGOverworldBiomeSelectors.SHATTERED_BIOMES_VANILLA, BYGOverworldBiomeSelectors.BEACH_BIOMES_1, BYGOverworldBiomeSelectors.PEAK_BIOMES_1, BYGOverworldBiomeSelectors.PEAK_BIOMES_VARIANT_VANILLA, BYGOverworldBiomeSelectors.SLOPE_BIOMES_1, BYGOverworldBiomeSelectors.SLOPE_BIOMES_VARIANT_VANILLA, (Map)class_156.method_654(new IdentityHashMap(), map -> {
        map.put(class_1972.field_9471, BYGBiomes.WHITE_MANGROVE_MARSHES);
        map.put(class_1972.field_9419, BYGBiomes.DACITE_SHORE);
    })));
    public static final Wrapped<OverworldRegion> REGION_3 = OverworldRegion.create("region_3", new OverworldRegion(3, BYGOverworldBiomeSelectors.OCEANS_VANILLA, BYGOverworldBiomeSelectors.MIDDLE_BIOMES_3, BYGOverworldBiomeSelectors.MIDDLE_BIOMES_VARIANT_VANILLA, BYGOverworldBiomeSelectors.PLATEAU_BIOMES_3, BYGOverworldBiomeSelectors.PLATEAU_BIOMES_VARIANT_VANILLA, BYGOverworldBiomeSelectors.SHATTERED_BIOMES_VANILLA, BYGOverworldBiomeSelectors.BEACH_BIOMES_1, BYGOverworldBiomeSelectors.PEAK_BIOMES_1, BYGOverworldBiomeSelectors.PEAK_BIOMES_VARIANT_VANILLA, BYGOverworldBiomeSelectors.SLOPE_BIOMES_1, BYGOverworldBiomeSelectors.SLOPE_BIOMES_VARIANT_VANILLA, (Map)class_156.method_654(new IdentityHashMap(), map -> {
        map.put(class_1972.field_38748, BYGBiomes.WHITE_MANGROVE_MARSHES);
        map.put(class_1972.field_9471, BYGBiomes.BAYOU);
    })));
    public static final Wrapped<OverworldRegion> RARE_REGION_1 = OverworldRegion.create("rare_region_1", new OverworldRegion(1, BYGOverworldBiomeSelectors.OCEANS, BYGOverworldBiomeSelectors.MIDDLE_BIOMES_3, BYGOverworldBiomeSelectors.MIDDLE_BIOMES_VARIANT_VANILLA, BYGOverworldBiomeSelectors.PLATEAU_BIOMES_3, BYGOverworldBiomeSelectors.PLATEAU_BIOMES_VARIANT_VANILLA, BYGOverworldBiomeSelectors.SHATTERED_BIOMES_VANILLA, BYGOverworldBiomeSelectors.BEACH_BIOMES_1, BYGOverworldBiomeSelectors.PEAK_BIOMES_1, BYGOverworldBiomeSelectors.PEAK_BIOMES_VARIANT_VANILLA, BYGOverworldBiomeSelectors.SLOPE_BIOMES_1, BYGOverworldBiomeSelectors.SLOPE_BIOMES_VARIANT_VANILLA, (Map)class_156.method_654(new IdentityHashMap(), map -> {
        map.put(class_1972.field_9471, BYGBiomes.CYPRESS_SWAMPLANDS);
        map.put(class_1972.field_38748, BYGBiomes.BAYOU);
    })));
    public static final List<Wrapped<OverworldRegion>> OVERWORLD_DEFAULTS = ImmutableList.of(REGION_1, REGION_2, REGION_3, RARE_REGION_1);

    private static OverworldRegion fromOldCodec(int overworldWeight, List<List<class_5321<class_1959>>> oceans, List<List<class_5321<class_1959>>> middleBiomes, List<List<class_5321<class_1959>>> middleBiomesVariant, List<List<class_5321<class_1959>>> plateauBiomes, List<List<class_5321<class_1959>>> plateauBiomesVariant, List<List<class_5321<class_1959>>> extremeHills, List<List<class_5321<class_1959>>> beachBiomes, List<List<class_5321<class_1959>>> peakBiomes, List<List<class_5321<class_1959>>> peakBiomesVariant, List<List<class_5321<class_1959>>> slopeBiomes, List<List<class_5321<class_1959>>> slopeBiomesVariant, Map<class_5321<class_1959>, class_5321<class_1959>> swapper) {
        return new OverworldRegion(overworldWeight, OverworldRegion.checkForMatching(oceans), OverworldRegion.checkForMatching(middleBiomes), OverworldRegion.checkForMatching(middleBiomesVariant), OverworldRegion.checkForMatching(plateauBiomes), OverworldRegion.checkForMatching(plateauBiomesVariant), OverworldRegion.checkForMatching(extremeHills), OverworldRegion.checkForMatching(beachBiomes), OverworldRegion.checkForMatching(peakBiomes), OverworldRegion.checkForMatching(peakBiomesVariant), OverworldRegion.checkForMatching(slopeBiomes), OverworldRegion.checkForMatching(slopeBiomesVariant), swapper);
    }

    private static Wrapped<List<List<class_5321<class_1959>>>> checkForMatching(List<List<class_5321<class_1959>>> val) {
        return OverworldRegion.checkForMatching(val, BYGOverworldBiomeSelectors.BIOME_LAYOUTS);
    }

    private static Function<OverworldRegion, DataResult<OverworldRegion>> verifyRegion() {
        return region1 -> {
            StringBuilder errors = new StringBuilder();
            region1.forEachBiomeSelector(biomeResourceKey -> {
                if (region1.swapper().containsKey(biomeResourceKey)) {
                    errors.append(biomeResourceKey.method_29177()).append(",");
                }
            });
            if (!errors.isEmpty()) {
                return DataResult.error(() -> String.format("Attempting to assign a biome resource key in both the swapper and biome selectors! \n%s", errors));
            }
            return DataResult.success((Object)region1);
        };
    }

    public static <T> Wrapped<T> checkForMatching(T val, Map<String, Pair<Map<String, String>, Wrapped<T>>> registry) {
        for (Map.Entry<String, Pair<Map<String, String>, Wrapped<T>>> entry : registry.entrySet()) {
            Wrapped second = (Wrapped)entry.getValue().getSecond();
            if (!second.value().equals(val)) continue;
            return second;
        }
        return new Wrapped(Optional.empty(), val);
    }

    private static Wrapped<OverworldRegion> create(String id, OverworldRegion overworldRegion) {
        return OverworldRegion.create(id, overworldRegion, COMMENTS);
    }

    private static Wrapped<OverworldRegion> create(String id, OverworldRegion overworldRegion, Map<String, String> comments) {
        Wrapped result = new Wrapped(Optional.of(id), (Object)overworldRegion);
        BIOME_REGIONS.put(id, (Pair<Map<String, String>, Wrapped<OverworldRegion>>)Pair.of(comments, (Object)result));
        return result;
    }

    public Collection<List<List<class_5321<class_1959>>>> allBiomeSelectors() {
        return Set.of((List)this.beachBiomes.value(), (List)this.peakBiomes.value(), (List)this.peakBiomesVariant.value(), (List)this.middleBiomes.value(), (List)this.middleBiomesVariant.value(), (List)this.plateauBiomes.value(), (List)this.plateauBiomesVariant.value(), (List)this.slopeBiomes.value(), (List)this.slopeBiomesVariant.value(), (List)this.oceans.value());
    }

    public void forEachBiomeSelector(Consumer<class_5321<class_1959>> biome) {
        for (List<List<class_5321<class_1959>>> biomeSelector : this.allBiomeSelectors()) {
            for (List<class_5321<class_1959>> resourceKeys : biomeSelector) {
                for (class_5321<class_1959> resourceKey : resourceKeys) {
                    biome.accept(resourceKey);
                }
            }
        }
    }
}

