/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_3037;
import net.minecraft.class_4651;
import net.minecraft.class_4656;
import net.minecraft.class_6796;
import net.minecraft.class_6880;
import net.minecraft.class_6885;

public class FloatingIslandConfig
implements class_3037 {
    public static final Codec<FloatingIslandConfig> CODEC = RecordCodecBuilder.create(codecRecorder -> codecRecorder.group((App)class_4651.field_24937.fieldOf("top_block_provider").forGetter(config -> config.topBlockProvider), (App)class_4651.field_24937.fieldOf("block_provider").forGetter(config -> config.blockProvider), (App)Codec.INT.fieldOf("min_radius").orElse((Object)13).forGetter(config -> config.minRadius), (App)Codec.INT.fieldOf("max_radius").orElse((Object)15).forGetter(config -> config.maxRadius), (App)class_6796.field_35731.fieldOf("island_features").forGetter(floatingIslandConfig -> floatingIslandConfig.features)).apply((Applicative)codecRecorder, FloatingIslandConfig::new));
    private final class_4651 topBlockProvider;
    private final class_4651 blockProvider;
    private final int minRadius;
    private final int maxRadius;
    private final class_6885<class_6796> features;

    FloatingIslandConfig(class_4651 topBlockProvider, class_4651 blockProvider, int minRadius, int maxRadius, class_6885<class_6796> features) {
        this.topBlockProvider = topBlockProvider;
        this.blockProvider = blockProvider;
        this.minRadius = minRadius;
        this.maxRadius = maxRadius;
        this.features = features;
    }

    public class_4651 getBlockProvider() {
        return this.blockProvider;
    }

    public class_4651 getTopBlockProvider() {
        return this.topBlockProvider;
    }

    public int getMinRadius() {
        return Math.abs(this.minRadius);
    }

    public int getMaxRadius() {
        return Math.abs(this.maxRadius);
    }

    public int getMaxPossibleRadius() {
        int returnValue = this.maxRadius - this.minRadius;
        if (returnValue <= 0) {
            returnValue = 1;
        }
        return Math.abs(returnValue);
    }

    public class_6885<class_6796> getPlacedFeatures() {
        return this.features;
    }

    public static class Builder {
        private class_4651 topBlockProvider = class_4656.method_38433((class_2680)class_2246.field_10219.method_9564());
        private class_4651 blockProvider = class_4656.method_38433((class_2680)class_2246.field_10340.method_9564());
        private int minRadius = 1;
        private int maxRadius = 3;
        private List<class_6880<class_6796>> features = new ArrayList<class_6880<class_6796>>();

        public Builder setTopBlock(class_2248 block) {
            this.topBlockProvider = block != null ? class_4656.method_38433((class_2680)block.method_9564()) : class_4656.method_38433((class_2680)class_2246.field_10340.method_9564());
            return this;
        }

        public Builder setTopBlock(class_2680 state) {
            this.topBlockProvider = state != null ? class_4656.method_38433((class_2680)state) : class_4656.method_38433((class_2680)class_2246.field_10340.method_9564());
            return this;
        }

        public Builder setTopBlock(class_4651 provider) {
            this.topBlockProvider = provider != null ? provider : class_4656.method_38433((class_2680)class_2246.field_10340.method_9564());
            return this;
        }

        public Builder setBlock(class_2248 block) {
            this.blockProvider = block != null ? class_4656.method_38433((class_2680)block.method_9564()) : class_4656.method_38433((class_2680)class_2246.field_10340.method_9564());
            return this;
        }

        public Builder setBlock(class_2680 state) {
            this.blockProvider = state != null ? class_4656.method_38433((class_2680)state) : class_4656.method_38433((class_2680)class_2246.field_10340.method_9564());
            return this;
        }

        public Builder setBlock(class_4651 provider) {
            this.blockProvider = provider != null ? provider : class_4656.method_38433((class_2680)class_2246.field_10340.method_9564());
            return this;
        }

        public Builder setMinRadius(int minRadius) {
            this.minRadius = minRadius <= 0 ? 1 : minRadius;
            return this;
        }

        public Builder setMaxRadius(int maxRadius) {
            this.maxRadius = maxRadius <= 0 ? this.minRadius + 1 : maxRadius;
            return this;
        }

        @SafeVarargs
        public final Builder addFeatures(class_6880<class_6796> ... features) {
            this.features.addAll(Arrays.asList(features));
            return this;
        }

        public Builder copy(FloatingIslandConfig config) {
            this.topBlockProvider = config.topBlockProvider;
            this.blockProvider = config.blockProvider;
            this.minRadius = config.minRadius;
            this.maxRadius = config.maxRadius;
            this.features = config.features.method_40239().toList();
            return this;
        }

        public FloatingIslandConfig build() {
            return new FloatingIslandConfig(this.topBlockProvider, this.blockProvider, this.minRadius, this.maxRadius, (class_6885<class_6796>)class_6885.method_40242(this.features));
        }
    }
}

