/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.gen.overworld;

import com.mojang.serialization.Codec;
import corgitaco.corgilib.math.blendingfunction.BlendingFunctions;
import java.util.HashSet;
import java.util.Optional;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3532;
import net.minecraft.class_4651;
import net.minecraft.class_4657;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_6005;
import net.minecraft.class_6017;
import net.minecraft.class_6019;
import potionstudios.byg.common.block.BYGBlocks;
import potionstudios.byg.common.world.feature.BYGFeatures;
import potionstudios.byg.common.world.feature.config.NoisySphereConfig;
import potionstudios.byg.common.world.feature.config.SimpleBlockProviderConfig;
import potionstudios.byg.common.world.math.noise.fastnoise.FastNoise;

public class ArchFeature
extends class_3031<SimpleBlockProviderConfig> {
    protected long seed;
    protected static FastNoise fastNoise;

    public ArchFeature(Codec<SimpleBlockProviderConfig> configCodec) {
        super(configCodec);
    }

    public boolean method_13151(class_5821<SimpleBlockProviderConfig> featurePlaceContext) {
        return this.place(featurePlaceContext.method_33652(), featurePlaceContext.method_33653(), featurePlaceContext.method_33654(), featurePlaceContext.method_33655(), (SimpleBlockProviderConfig)featurePlaceContext.method_33656());
    }

    public boolean place(class_5281 world, class_2794 chunkGenerator, class_5819 random, class_2338 center, SimpleBlockProviderConfig config) {
        int points;
        this.setSeed(world.method_8412());
        double angle = random.method_43058() * Math.PI;
        class_1923 chunkPos = new class_1923(center);
        center = chunkPos.method_33943(center.method_10264());
        int distance = 40 + random.method_43048(6);
        int archHeight = 25 + random.method_43048(10);
        center = center.method_10069(0, archHeight, 0);
        double xOffset = Math.sin(angle) * (double)distance;
        double zOffset = Math.cos(angle) * (double)distance;
        class_4657 blockProvider = new class_4657(class_6005.method_34971().method_34975((Object)BYGBlocks.RED_ROCK.defaultBlockState(), 4).method_34975((Object)class_2246.field_10415.method_9564(), 1));
        NoisySphereConfig build = new NoisySphereConfig.Builder().withRadiusSettings(new NoisySphereConfig.RadiusSettings((class_6017)class_6019.method_35017((int)10, (int)15), (class_6017)class_6019.method_35017((int)10, (int)15), 0, (class_6017)class_6019.method_35017((int)10, (int)15))).withBlockProvider((class_4651)blockProvider).withNoiseFrequency(0.02f).withTopBlockProvider((class_4651)blockProvider).build();
        class_2338 start = center.method_10069((int)(-xOffset), 0, (int)(-zOffset));
        start = new class_2338(start.method_10263(), world.method_8624(class_2902.class_2903.field_13195, start.method_10263(), start.method_10260()) - 5, start.method_10260());
        class_2338 end = center.method_10069((int)xOffset, 0, (int)zOffset);
        end = new class_2338(end.method_10263(), world.method_8624(class_2902.class_2903.field_13195, end.method_10263(), end.method_10260()) - 5, end.method_10260());
        HashSet<class_2338> spherePositions = new HashSet<class_2338>();
        for (int pointCount = points = 1000; pointCount >= 1; --pointCount) {
            double factor = (double)pointCount / (double)points;
            spherePositions.add(class_2338.method_49637((double)class_3532.method_16436((double)factor, (double)start.method_10263(), (double)center.method_10263()), (double)ArchFeature.easeOutCubic(factor, start.method_10264(), center.method_10264()), (double)class_3532.method_16436((double)factor, (double)start.method_10260(), (double)center.method_10260())));
            spherePositions.add(class_2338.method_49637((double)class_3532.method_16436((double)factor, (double)end.method_10263(), (double)center.method_10263()), (double)ArchFeature.easeOutCubic(factor, end.method_10264(), center.method_10264()), (double)class_3532.method_16436((double)factor, (double)end.method_10260(), (double)center.method_10260())));
        }
        for (class_2338 spherePosition : spherePositions) {
            int size = 1;
            class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
            BYGFeatures.BOULDER.get().method_13151((class_5821<NoisySphereConfig>)new class_5821(Optional.empty(), world, chunkGenerator, random, spherePosition, (class_3037)build));
            for (int x = -size; x <= size; ++x) {
                for (int y = -size; y <= size; ++y) {
                    for (int z = -size; z <= size; ++z) {
                        mutableBlockPos.method_10101((class_2382)spherePosition).method_10100(x, y, z);
                    }
                }
            }
        }
        return true;
    }

    public void setSeed(long seed) {
        if (this.seed != seed || fastNoise == null) {
            fastNoise = new FastNoise((int)seed);
            fastNoise.SetNoiseType(FastNoise.NoiseType.Simplex);
            this.seed = seed;
        }
    }

    public static double easeOutCubic(double factor, double min, double max) {
        double range = max - min;
        return min + range * BlendingFunctions.easeOutCubic((double)factor);
    }
}

