/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.math.noise.simplex;

public class OpenSimplex2 {
    private static final long PRIME_X = 5910200641878280303L;
    private static final long PRIME_Y = 6452764530575939509L;
    private static final long PRIME_Z = 6614699811220273867L;
    private static final long HASH_UNIQUIFIER = 6026932503003350773L;
    private static final long PAIR_SEED_FLIP_BITS = -5968755714895566377L;
    private static final double SKEW2 = 0.366025403784439;
    private static final double UNSKEW2 = -0.21132486540518713;
    private static final double ROOT3OVER3 = 0.577350269189626;
    private static final double ROTATE3_ORTHOGONALIZER = -0.21132486540518713;
    private static final double NORMALIZER2 = 0.01001634121365712;
    private static final double NORMALIZER3 = 0.07969837668935331;
    private static final int N_GRADS_2D = 128;
    private static final int N_GRADS_3D = 256;
    private static float[] GRADIENTS_2D;
    private static float[] GRADIENTS_3D;

    public static float noise2(long seed, double x, double y) {
        double s = 0.366025403784439 * (x + y);
        double xs = x + s;
        double ys = y + s;
        return OpenSimplex2.noise2_UnskewedBase(seed, xs, ys);
    }

    private static float noise2_UnskewedBase(long seed, double xs, double ys) {
        float a1;
        float value = 0.0f;
        int xsb = OpenSimplex2.fastFloor(xs);
        int ysb = OpenSimplex2.fastFloor(ys);
        float xi = (float)(xs - (double)xsb);
        float yi = (float)(ys - (double)ysb);
        long xsbp = (long)xsb * 5910200641878280303L;
        long ysbp = (long)ysb * 6452764530575939509L;
        float t = (xi + yi) * -0.21132487f;
        float dx0 = xi + t;
        float dy0 = yi + t;
        float a0 = 0.5f - dx0 * dx0 - dy0 * dy0;
        if (a0 > 0.0f) {
            value = a0 * a0 * (a0 * a0) * OpenSimplex2.grad(seed, xsbp, ysbp, dx0, dy0);
        }
        if ((a1 = -3.1547005f * t + (-0.6666667f + a0)) > 0.0f) {
            float dx1 = dx0 - 0.57735026f;
            float dy1 = dy0 - 0.57735026f;
            value += a1 * a1 * (a1 * a1) * OpenSimplex2.grad(seed, xsbp + 5910200641878280303L, ysbp + 6452764530575939509L, dx1, dy1);
        }
        if (dy0 > dx0) {
            dx2 = dx0 - -0.21132487f;
            dy2 = dy0 - 0.7886751f;
            float a2 = 0.5f - dx2 * dx2 - dy2 * dy2;
            if (a2 > 0.0f) {
                value += a2 * a2 * (a2 * a2) * OpenSimplex2.grad(seed, xsbp, ysbp + 6452764530575939509L, dx2, dy2);
            }
        } else {
            dx2 = dx0 - 0.7886751f;
            dy2 = dy0 - -0.21132487f;
            float a2 = 0.5f - dx2 * dx2 - dy2 * dy2;
            if (a2 > 0.0f) {
                value += a2 * a2 * (a2 * a2) * OpenSimplex2.grad(seed, xsbp + 5910200641878280303L, ysbp, dx2, dy2);
            }
        }
        return value;
    }

    public static float noise3_ImproveXZ(long seed, double x, double y, double z) {
        double xz = x + z;
        double s2 = xz * -0.21132486540518713;
        double yy = y * 0.577350269189626;
        double xr = x + s2 + yy;
        double zr = z + s2 + yy;
        double yr = xz * -0.577350269189626 + yy;
        return OpenSimplex2.noise3_UnrotatedBase(seed, xr, yr, zr);
    }

    private static float noise3_UnrotatedBase(long seed, double xr, double yr, double zr) {
        int xrb = OpenSimplex2.fastRound(xr);
        int yrb = OpenSimplex2.fastRound(yr);
        int zrb = OpenSimplex2.fastRound(zr);
        float xri = (float)(xr - (double)xrb);
        float yri = (float)(yr - (double)yrb);
        float zri = (float)(zr - (double)zrb);
        int xNSign = (int)(-1.0f - xri) | 1;
        int yNSign = (int)(-1.0f - yri) | 1;
        int zNSign = (int)(-1.0f - zri) | 1;
        float ax0 = (float)xNSign * -xri;
        float ay0 = (float)yNSign * -yri;
        float az0 = (float)zNSign * -zri;
        long xrbp = (long)xrb * 5910200641878280303L;
        long yrbp = (long)yrb * 6452764530575939509L;
        long zrbp = (long)zrb * 6614699811220273867L;
        float value = 0.0f;
        float a = 0.6f - xri * xri - (yri * yri + zri * zri);
        int l = 0;
        while (true) {
            if (a > 0.0f) {
                value += a * a * (a * a) * OpenSimplex2.grad(seed, xrbp, yrbp, zrbp, xri, yri, zri);
            }
            if (ax0 >= ay0 && ax0 >= az0) {
                b = a + ax0 + ax0;
                if (b > 1.0f) {
                    value += (b -= 1.0f) * b * (b * b) * OpenSimplex2.grad(seed, xrbp - (long)xNSign * 5910200641878280303L, yrbp, zrbp, xri + (float)xNSign, yri, zri);
                }
            } else if (ay0 > ax0 && ay0 >= az0) {
                b = a + ay0 + ay0;
                if (b > 1.0f) {
                    value += (b -= 1.0f) * b * (b * b) * OpenSimplex2.grad(seed, xrbp, yrbp - (long)yNSign * 6452764530575939509L, zrbp, xri, yri + (float)yNSign, zri);
                }
            } else {
                b = a + az0 + az0;
                if (b > 1.0f) {
                    value += (b -= 1.0f) * b * (b * b) * OpenSimplex2.grad(seed, xrbp, yrbp, zrbp - (long)zNSign * 6614699811220273867L, xri, yri, zri + (float)zNSign);
                }
            }
            if (l == 1) break;
            ax0 = 0.5f - ax0;
            ay0 = 0.5f - ay0;
            az0 = 0.5f - az0;
            xri = (float)xNSign * ax0;
            yri = (float)yNSign * ay0;
            zri = (float)zNSign * az0;
            a += 0.75f - ax0 - (ay0 + az0);
            xrbp += (long)(xNSign >> 1) & 0x5205402B9270C86FL;
            yrbp += (long)(yNSign >> 1) & 0x598CD327003817B5L;
            zrbp += (long)(zNSign >> 1) & 0x5BCC226E9FA0BACBL;
            xNSign = -xNSign;
            yNSign = -yNSign;
            zNSign = -zNSign;
            seed ^= 0xAD2AB84D169129D7L;
            ++l;
        }
        return value;
    }

    private static float grad(long seed, long xrvp, long yrvp, float dx, float dy) {
        long hash = seed ^ xrvp ^ yrvp;
        hash *= 6026932503003350773L;
        hash ^= hash >> 56;
        int gi = (int)hash & 0xFE;
        return GRADIENTS_2D[gi | 0] * dx + GRADIENTS_2D[gi | 1] * dy;
    }

    private static float grad(long seed, long xrvp, long yrvp, long zrvp, float dx, float dy, float dz) {
        long hash = seed ^ xrvp ^ (yrvp ^ zrvp);
        hash *= 6026932503003350773L;
        hash ^= hash >> 54;
        int gi = (int)hash & 0x3FC;
        return GRADIENTS_3D[gi | 0] * dx + GRADIENTS_3D[gi | 1] * dy + GRADIENTS_3D[gi | 2] * dz;
    }

    private static int fastFloor(double x) {
        int xi = (int)x;
        return x < (double)xi ? xi - 1 : xi;
    }

    private static int fastRound(double x) {
        return x < 0.0 ? (int)(x - 0.5) : (int)(x + 0.5);
    }

    static {
        int i;
        int i2;
        int[] grad2FillIndices = new int[]{1, 4, 7, 10, 13, 16, 19, 22};
        GRADIENTS_2D = new float[256];
        float[] grad2 = new float[]{0.13052619f, 0.9914449f, 0.38268343f, 0.9238795f, 0.6087614f, 0.7933533f, 0.7933533f, 0.6087614f, 0.9238795f, 0.38268343f, 0.9914449f, 0.13052619f, 0.9914449f, -0.13052619f, 0.9238795f, -0.38268343f, 0.7933533f, -0.6087614f, 0.6087614f, -0.7933533f, 0.38268343f, -0.9238795f, 0.13052619f, -0.9914449f, -0.13052619f, -0.9914449f, -0.38268343f, -0.9238795f, -0.6087614f, -0.7933533f, -0.7933533f, -0.6087614f, -0.9238795f, -0.38268343f, -0.9914449f, -0.13052619f, -0.9914449f, 0.13052619f, -0.9238795f, 0.38268343f, -0.7933533f, 0.6087614f, -0.6087614f, 0.7933533f, -0.38268343f, 0.9238795f, -0.13052619f, 0.9914449f};
        for (i2 = 0; i2 < grad2.length; ++i2) {
            grad2[i2] = (float)((double)grad2[i2] / 0.01001634121365712);
        }
        for (i2 = 0; i2 < GRADIENTS_2D.length - grad2.length + 1; i2 += grad2.length) {
            for (int j = 0; j < grad2.length; ++j) {
                OpenSimplex2.GRADIENTS_2D[i2 + j] = grad2[j];
            }
        }
        for (int grad2FillIndex : grad2FillIndices) {
            int gi = grad2FillIndex * 2;
            OpenSimplex2.GRADIENTS_2D[i2 | 0] = grad2[gi | 0];
            OpenSimplex2.GRADIENTS_2D[i2 | 1] = grad2[gi | 1];
            i2 += 2;
        }
        int[] grad3FillIndices = new int[]{12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 44, 45, 46, 47};
        GRADIENTS_3D = new float[1024];
        float[] grad3 = new float[]{-2.2247448f, -2.2247448f, -1.0f, 0.0f, -2.2247448f, -2.2247448f, 1.0f, 0.0f, -3.0862665f, -1.1721513f, 0.0f, 0.0f, -1.1721513f, -3.0862665f, 0.0f, 0.0f, -2.2247448f, -1.0f, -2.2247448f, 0.0f, -2.2247448f, 1.0f, -2.2247448f, 0.0f, -1.1721513f, 0.0f, -3.0862665f, 0.0f, -3.0862665f, 0.0f, -1.1721513f, 0.0f, -2.2247448f, -1.0f, 2.2247448f, 0.0f, -2.2247448f, 1.0f, 2.2247448f, 0.0f, -3.0862665f, 0.0f, 1.1721513f, 0.0f, -1.1721513f, 0.0f, 3.0862665f, 0.0f, -2.2247448f, 2.2247448f, -1.0f, 0.0f, -2.2247448f, 2.2247448f, 1.0f, 0.0f, -1.1721513f, 3.0862665f, 0.0f, 0.0f, -3.0862665f, 1.1721513f, 0.0f, 0.0f, -1.0f, -2.2247448f, -2.2247448f, 0.0f, 1.0f, -2.2247448f, -2.2247448f, 0.0f, 0.0f, -3.0862665f, -1.1721513f, 0.0f, 0.0f, -1.1721513f, -3.0862665f, 0.0f, -1.0f, -2.2247448f, 2.2247448f, 0.0f, 1.0f, -2.2247448f, 2.2247448f, 0.0f, 0.0f, -1.1721513f, 3.0862665f, 0.0f, 0.0f, -3.0862665f, 1.1721513f, 0.0f, -1.0f, 2.2247448f, -2.2247448f, 0.0f, 1.0f, 2.2247448f, -2.2247448f, 0.0f, 0.0f, 1.1721513f, -3.0862665f, 0.0f, 0.0f, 3.0862665f, -1.1721513f, 0.0f, -1.0f, 2.2247448f, 2.2247448f, 0.0f, 1.0f, 2.2247448f, 2.2247448f, 0.0f, 0.0f, 3.0862665f, 1.1721513f, 0.0f, 0.0f, 1.1721513f, 3.0862665f, 0.0f, 2.2247448f, -2.2247448f, -1.0f, 0.0f, 2.2247448f, -2.2247448f, 1.0f, 0.0f, 1.1721513f, -3.0862665f, 0.0f, 0.0f, 3.0862665f, -1.1721513f, 0.0f, 0.0f, 2.2247448f, -1.0f, -2.2247448f, 0.0f, 2.2247448f, 1.0f, -2.2247448f, 0.0f, 3.0862665f, 0.0f, -1.1721513f, 0.0f, 1.1721513f, 0.0f, -3.0862665f, 0.0f, 2.2247448f, -1.0f, 2.2247448f, 0.0f, 2.2247448f, 1.0f, 2.2247448f, 0.0f, 1.1721513f, 0.0f, 3.0862665f, 0.0f, 3.0862665f, 0.0f, 1.1721513f, 0.0f, 2.2247448f, 2.2247448f, -1.0f, 0.0f, 2.2247448f, 2.2247448f, 1.0f, 0.0f, 3.0862665f, 1.1721513f, 0.0f, 0.0f, 1.1721513f, 3.0862665f, 0.0f, 0.0f};
        for (i = 0; i < grad3.length; ++i) {
            grad3[i] = (float)((double)grad3[i] / 0.07969837668935331);
        }
        for (i = 0; i < GRADIENTS_3D.length - grad3.length + 1; i += grad3.length) {
            for (int j = 0; j < grad3.length; ++j) {
                OpenSimplex2.GRADIENTS_3D[i + j] = grad3[j];
            }
        }
        for (int grad3FillIndex : grad3FillIndices) {
            int gi = grad3FillIndex * 4;
            OpenSimplex2.GRADIENTS_3D[i | 0] = grad3[gi | 0];
            OpenSimplex2.GRADIENTS_3D[i | 1] = grad3[gi | 1];
            OpenSimplex2.GRADIENTS_3D[i | 2] = grad3[gi | 2];
            i += 4;
        }
    }
}

