/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.structure.volcano;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_4076;
import net.minecraft.class_5539;
import net.minecraft.class_5742;
import net.minecraft.class_6626;
import net.minecraft.class_6862;
import net.minecraft.class_7138;
import net.minecraft.class_7151;
import org.jetbrains.annotations.NotNull;
import potionstudios.byg.common.world.structure.BYGStructureTypes;
import potionstudios.byg.common.world.structure.volcano.VolcanoPiece;

public class VolcanoStructure
extends class_3195 {
    public static final Codec<VolcanoStructure> CODEC = RecordCodecBuilder.mapCodec(archStructureInstance -> archStructureInstance.group((App)VolcanoStructure.method_42697((RecordCodecBuilder.Instance)archStructureInstance)).apply((Applicative)archStructureInstance, VolcanoStructure::new)).codec();

    public VolcanoStructure(class_3195.class_7302 structureSettings) {
        super(structureSettings);
    }

    private static void generatePieces(class_6626 piecesBuilder, class_3195.class_7149 context) {
        class_2919 random = context.comp_566();
        int seed = random.method_43054();
        class_1923 chunkPos = context.comp_568();
        int blockX = chunkPos.method_33939(random.method_43048(16));
        int blockZ = chunkPos.method_33941(random.method_43048(16));
        int baseHeight = context.comp_562().method_16397(blockX, blockZ, class_2902.class_2903.field_13195, context.comp_569(), context.comp_564());
        class_2338 origin = new class_2338(blockX, baseHeight, blockZ);
        double baseRadius = random.method_43051(75, 120);
        double leakage = 2.0 - random.method_43058() * 2.0;
        int volcanoConeSize = random.method_43051(75, 120) + 50;
        int volcanoStartHeight = volcanoConeSize - 10;
        double threshold = 1.0;
        int maxY = -random.method_43051(5, 35);
        int fluidYOffset = random.method_43051(2, 5);
        int coneSizePacked = class_4076.method_18675((int)volcanoConeSize);
        for (int x = -coneSizePacked; x <= coneSizePacked; ++x) {
            for (int z = -coneSizePacked; z <= coneSizePacked; ++z) {
                long chunk = class_1923.method_8331((int)(class_4076.method_18675((int)blockX) + x), (int)(class_4076.method_18675((int)blockZ) + z));
                piecesBuilder.method_35462((class_3443)new VolcanoPiece(new PieceStructureInfo(origin, seed, baseRadius, leakage, volcanoConeSize, volcanoStartHeight, threshold, maxY, fluidYOffset), 0, VolcanoStructure.getWritableArea(new class_1923(chunk), context.comp_569())));
            }
        }
    }

    public static class_3341 getWritableArea(class_1923 chunkPos, class_5539 accessor) {
        int i = chunkPos.method_8326();
        int j = chunkPos.method_8328();
        int k = accessor.method_31607() + 1;
        int l = accessor.method_31600() - 1;
        return new class_3341(i, k, j, i + 15, l, j + 15);
    }

    private static boolean matchesBiome(class_2338 pos, class_2794 generator, class_6862<class_1959> biomeTagKey, class_7138 randomState) {
        return generator.method_12098().method_38109(class_5742.method_33100((int)pos.method_10263()), class_5742.method_33100((int)pos.method_10264()), class_5742.method_33100((int)pos.method_10260()), randomState.method_42371()).method_40220(biomeTagKey);
    }

    @NotNull
    public Optional<class_3195.class_7150> method_38676(@NotNull class_3195.class_7149 generationContext) {
        return VolcanoStructure.method_41612((class_3195.class_7149)generationContext, (class_2902.class_2903)class_2902.class_2903.field_13194, piecesBuilder -> VolcanoStructure.generatePieces(piecesBuilder, generationContext));
    }

    @NotNull
    public class_7151<?> method_41618() {
        return BYGStructureTypes.VOLCANO.get();
    }

    public record PieceStructureInfo(class_2338 origin, int noiseSeed, double baseRadius, double leakage, int volcanoConeSize, int volcanoStartHeight, double threshold, int maxY, int fluidY) {
        public static final Codec<PieceStructureInfo> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)class_2338.field_25064.fieldOf("origin").forGetter(PieceStructureInfo::origin), (App)Codec.INT.fieldOf("noiseSeed").forGetter(PieceStructureInfo::noiseSeed), (App)Codec.DOUBLE.fieldOf("baseRadius").forGetter(PieceStructureInfo::baseRadius), (App)Codec.DOUBLE.fieldOf("leakage").forGetter(PieceStructureInfo::leakage), (App)Codec.INT.fieldOf("volcanoConeSize").forGetter(PieceStructureInfo::volcanoConeSize), (App)Codec.INT.fieldOf("volcanoStartHeight").forGetter(PieceStructureInfo::volcanoStartHeight), (App)Codec.DOUBLE.fieldOf("threshold").forGetter(PieceStructureInfo::threshold), (App)Codec.INT.fieldOf("maxY").forGetter(PieceStructureInfo::maxY), (App)Codec.INT.fieldOf("fluidY").forGetter(PieceStructureInfo::fluidY)).apply((Applicative)builder, PieceStructureInfo::new));
    }
}

