/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.util;

import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2378;
import net.minecraft.class_2794;
import net.minecraft.class_2960;
import net.minecraft.class_5363;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import potionstudios.byg.BYG;
import potionstudios.byg.common.world.biome.BYGDebugBiomeSource;
import potionstudios.byg.common.world.biome.LazyLoadSeed;
import potionstudios.byg.common.world.biome.end.BYGEndBiomeSource;
import potionstudios.byg.common.world.biome.end.EndBiomesConfig;
import potionstudios.byg.common.world.biome.nether.BYGNetherBiomeSource;
import potionstudios.byg.common.world.biome.nether.NetherBiomesConfig;
import potionstudios.byg.mixin.access.BiomeSourceAccess;
import potionstudios.byg.mixin.access.ChunkGeneratorAccess;

public class BiomeSourceRepairUtils {
    public static void repairBiomeSources(class_2378<class_1959> biomeRegistry, MinecraftServer server) {
        EndBiomesConfig endBiomesConfig;
        NetherBiomesConfig netherBiomesConfig = NetherBiomesConfig.getConfig(true, false, biomeRegistry);
        class_2378 levelStems = server.method_30611().method_30530(class_7924.field_41224);
        if (netherBiomesConfig.forceBYGNetherBiomeSource()) {
            Supplier<class_1966> netherBiomeSource = BYGNetherBiomeSource::new;
            Optional levelStem = levelStems.method_31189(class_5363.field_25413);
            if (levelStem.isEmpty()) {
                BYG.logError(String.format("Unable to find level stem/dimension \"%s\", this is most likely due to a world being moved across minecraft versions, Oh The Biomes You'll Go cannot support this operation.\nSkipping biome source repair....", class_5363.field_25413));
            } else {
                BiomeSourceRepairUtils.repair((class_5363)levelStem.get(), BYGNetherBiomeSource.LOCATION, netherBiomeSource);
            }
        }
        if ((endBiomesConfig = EndBiomesConfig.getConfig(true, false, biomeRegistry)).forceBYGEndBiomeSource()) {
            Supplier<class_1966> endBiomeSource = BYGEndBiomeSource::new;
            Optional levelStem = levelStems.method_31189(class_5363.field_25414);
            if (levelStem.isEmpty()) {
                BYG.logError(String.format("Unable to find level stem/dimension \"%s\", this is most likely due to a world being moved across minecraft versions, Oh The Biomes You'll Go cannot support this operation.\nSkipping biome source repair....", class_5363.field_25414));
            } else {
                BiomeSourceRepairUtils.repair((class_5363)levelStem.get(), BYGEndBiomeSource.LOCATION, endBiomeSource);
            }
        }
        levelStems.forEach(dimension -> {
            class_1966 biomeSource = dimension.comp_1013().method_12098();
            if (biomeSource instanceof LazyLoadSeed) {
                LazyLoadSeed lazyLoadSeed = (LazyLoadSeed)biomeSource;
                lazyLoadSeed.lazyLoad(server.method_27728().method_28057().method_28028(), biomeRegistry);
            }
        });
    }

    private static boolean repair(class_5363 dimension, class_2960 targetBiomeSourceID, Supplier<class_1966> replacement) {
        class_2794 generator = dimension.comp_1013();
        Codec<? extends class_1966> codec = ((BiomeSourceAccess)generator.method_12098()).byg_invokeCodec();
        if (!class_7923.field_41156.method_10221(codec).equals((Object)targetBiomeSourceID) && !(generator.method_12098() instanceof BYGDebugBiomeSource)) {
            class_1966 replacementBiomeSource = replacement.get();
            ((ChunkGeneratorAccess)generator).byg_setBiomeSource(replacementBiomeSource);
            return true;
        }
        return false;
    }
}

