/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.config;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_2248;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_3222;
import net.minecraft.class_5251;
import potionstudios.byg.client.BiomepediaInventoryConfig;
import potionstudios.byg.common.block.sapling.GrowingPatterns;
import potionstudios.byg.common.entity.npc.TradesConfig;
import potionstudios.byg.common.world.biome.end.EndBiomesConfig;
import potionstudios.byg.common.world.biome.nether.NetherBiomesConfig;
import potionstudios.byg.common.world.surfacerules.SurfaceRulesConfig;
import potionstudios.byg.config.BiomepediaConfig;
import potionstudios.byg.config.ConfigVersionTracker;
import potionstudios.byg.config.SettingsConfig;
import potionstudios.byg.config.json.OverworldBiomeConfig;
import potionstudios.byg.util.FeatureGrowerFromBlockPattern;
import potionstudios.byg.util.ModPlatform;

public class BYGConfigHandler {
    public static final Set<Exception> CONFIG_EXCEPTIONS = new HashSet<Exception>();

    public static String loadAllConfigs(boolean serialize, boolean recreate) {
        return BYGConfigHandler.loadAllConfigs(serialize, recreate, ModPlatform.INSTANCE.isClientEnvironment());
    }

    public static String loadAllConfigs(boolean serialize, boolean recreate, boolean isClientSide) {
        StringBuilder errors = new StringBuilder();
        errors.append(BYGConfigHandler.tryCatchErrors(() -> EndBiomesConfig.getConfig(serialize, recreate, null)));
        errors.append(BYGConfigHandler.tryCatchErrors(() -> NetherBiomesConfig.getConfig(serialize, recreate, null)));
        errors.append(BYGConfigHandler.tryCatchErrors(() -> OverworldBiomeConfig.getConfig(serialize, recreate)));
        errors.append(BYGConfigHandler.tryCatchErrors(() -> SurfaceRulesConfig.getConfig(serialize, recreate)));
        errors.append(BYGConfigHandler.tryCatchErrors(() -> {
            GrowingPatterns.getConfig(serialize, recreate);
            FeatureGrowerFromBlockPattern.ENTRIES.forEach(c -> {
                Object patt2108$temp = c.get();
                if (patt2108$temp instanceof class_2248) {
                    class_2248 block = (class_2248)patt2108$temp;
                    ((FeatureGrowerFromBlockPattern)c.get()).load(block);
                }
            });
        }));
        errors.append(BYGConfigHandler.tryCatchErrors(() -> TradesConfig.getConfig(serialize, recreate)));
        errors.append(BYGConfigHandler.tryCatchErrors(() -> SettingsConfig.getConfig(serialize, recreate)));
        if (isClientSide) {
            errors.append(BYGConfigHandler.tryCatchErrors(() -> BiomepediaInventoryConfig.getConfig(serialize, recreate)));
        }
        errors.append(BYGConfigHandler.tryCatchErrors(() -> BiomepediaConfig.getConfig(serialize, recreate)));
        errors.append(BYGConfigHandler.tryCatchErrors(() -> ConfigVersionTracker.getConfig(new ConfigVersionTracker(6), recreate)));
        errors.append(BYGConfigHandler.tryCatchErrors(BYGConfigHandler::makeREADME));
        if (!errors.isEmpty()) {
            return String.format("Config errors were found:\n\n%s", errors);
        }
        return errors.toString();
    }

    private static String tryCatchErrors(Runnable run) {
        String error = "";
        try {
            run.run();
        }
        catch (Exception e) {
            error = e.getMessage();
        }
        return error + (!error.isEmpty() ? "\n" : "");
    }

    private static void makeREADME() {
        try {
            Path configPath = ModPlatform.INSTANCE.configPath();
            Files.createDirectories(configPath, new FileAttribute[0]);
            Files.write(configPath.resolve("README.txt"), "For information on how BYG configs work, you can find that here: https://github.com/AOCAWOL/BYG/wiki/Configs".getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void displayChatErrors(class_3222 serverPlayer) {
        serverPlayer.method_7353((class_2561)class_2561.method_43471((String)"byg.config.error").method_27692(class_124.field_1061), false);
        Path latestLogPath = ModPlatform.INSTANCE.configPath().getParent().getParent().resolve("logs").resolve("latest.log");
        serverPlayer.method_7353((class_2561)class_2561.method_43471((String)"byg.config.error.latestlog").method_27692(class_124.field_1073).method_27694(text -> text.method_27703(class_5251.method_27718((class_124)class_124.field_1079)).method_10982(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11746, latestLogPath.toString())).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"corgilib.clickevent.hovertext")))), false);
        serverPlayer.method_7353((class_2561)class_2561.method_43470((String)""), false);
        serverPlayer.method_7353((class_2561)class_2561.method_43471((String)"byg.config.error.commandvalidate").method_27692(class_124.field_1061), false);
        serverPlayer.method_7353((class_2561)class_2561.method_43471((String)"byg.config.error.resetconfigs").method_27692(class_124.field_1061), false);
        serverPlayer.method_7353((class_2561)class_2561.method_43471((String)"byg.config.error.restart").method_27692(class_124.field_1061), false);
    }
}

