/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.config.json;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.corgilib.serialization.codec.CommentedCodec;
import corgitaco.corgilib.serialization.codec.FromFileOps;
import corgitaco.corgilib.serialization.codec.Wrapped;
import corgitaco.corgilib.serialization.jankson.JanksonJsonOps;
import corgitaco.corgilib.serialization.jankson.JanksonUtil;
import corgitaco.corgilib.shadow.blue.endless.jankson.JsonElement;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1959;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import potionstudios.byg.BYG;
import potionstudios.byg.common.world.biome.overworld.BYGOverworldBiomeSelectors;
import potionstudios.byg.common.world.biome.overworld.OverworldRegion;
import potionstudios.byg.config.BYGConfigHandler;
import potionstudios.byg.util.ModPlatform;

public record OverworldBiomeConfig(boolean generateOverworld, List<Wrapped<OverworldRegion>> values, Map<class_5321<class_1959>, class_5321<class_1959>> globalSwapper) {
    public static final Codec<Map<class_5321<class_1959>, class_5321<class_1959>>> BIOME_SWAPPER = Codec.unboundedMap((Codec)class_5321.method_39154((class_5321)class_7924.field_41236), (Codec)class_5321.method_39154((class_5321)class_7924.field_41236));
    public static final Codec<OverworldBiomeConfig> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)CommentedCodec.of((Codec)Codec.BOOL, (String)"overworld_enabled", (String)"Global toggle to enable or disable BYG's overworld biomes.").forGetter(overworldBiomeConfig -> overworldBiomeConfig.generateOverworld), (App)CommentedCodec.of((Codec)OverworldRegion.BIOME_PROVIDER_DATA_FROM_FILE_CODEC.listOf(), (String)"regions", (String)"A list of weighted regions containing a unique biome layout.\nRegions may be inlined or may call a file from \"this_file_parent_directory/regions\"").forGetter(overworldBiomeConfig -> overworldBiomeConfig.values), (App)CommentedCodec.of(BIOME_SWAPPER, (String)"global_biome_swapper", (String)"Global biome swapper that swaps any biome of your choice with another in all BYG Overworld regions.\n\nYou must use biome ids.\n\nExample:\n=====================\n\n\"global_biome_swapper\": {\n    \"byg:atacama_desert\": \"minecraft:desert\",\n    \"byg:bayou\": \"minecraft:swamp\",\n    \"minecraft:sunflower_plains\": \"byg:black_forest\"\n}\n\n=====================\n\n").forGetter(overworldBiomeConfig -> overworldBiomeConfig.globalSwapper)).apply((Applicative)builder, OverworldBiomeConfig::new));
    public static final OverworldBiomeConfig DEFAULT = new OverworldBiomeConfig(true, OverworldRegion.OVERWORLD_DEFAULTS, Map.of());
    public static OverworldBiomeConfig INSTANCE = null;
    public static final Codec<List<Wrapped<OverworldRegion>>> FROM_OLD_CODEC_LIST = OverworldRegion.OLD_CODEC.listOf().comapFlatMap(biomeProviderDataList -> {
        ArrayList<Wrapped> wrapped = new ArrayList<Wrapped>();
        for (int i = 0; i < biomeProviderDataList.size(); ++i) {
            OverworldRegion overworldRegion = (OverworldRegion)biomeProviderDataList.get(i);
            String id = "region_" + (i + 1);
            Wrapped dataWrapped = new Wrapped(Optional.of(id), (Object)overworldRegion);
            OverworldRegion.BIOME_REGIONS.put(id, (Pair<Map<String, String>, Wrapped<OverworldRegion>>)Pair.of(OverworldRegion.COMMENTS, (Object)dataWrapped));
            wrapped.add(dataWrapped);
        }
        return DataResult.success(wrapped);
    }, wrapped -> wrapped.stream().map(Wrapped::value).collect(Collectors.toList()));
    public static final Codec<OverworldBiomeConfig> OLD_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.BOOL.fieldOf("overworld_enabled").forGetter(overworldBiomeConfig -> overworldBiomeConfig.generateOverworld), (App)FROM_OLD_CODEC_LIST.fieldOf("providers").forGetter(overworldBiomeConfig -> overworldBiomeConfig.values), (App)BIOME_SWAPPER.fieldOf("global_biome_swapper").forGetter(overworldBiomeConfig -> overworldBiomeConfig.globalSwapper)).apply((Applicative)builder, OverworldBiomeConfig::new));

    public static OverworldBiomeConfig getConfig() {
        return OverworldBiomeConfig.getConfig(false, false);
    }

    public static OverworldBiomeConfig getConfig(boolean serialize, boolean recreate) {
        if (INSTANCE == null || serialize || recreate) {
            INSTANCE = OverworldBiomeConfig.readConfig(recreate);
        }
        return INSTANCE;
    }

    public static void setConfigInstance(OverworldBiomeConfig config) {
        INSTANCE = config;
    }

    private static OverworldBiomeConfig readConfig(boolean recreate) {
        Path path = ModPlatform.INSTANCE.configPath().resolve("overworld").resolve("byg-overworld-biomes.json5");
        OverworldBiomeConfig getOldOrDefault = OverworldBiomeConfig.readAndDeleteOldOverworldConfig(ModPlatform.INSTANCE.configPath().resolve("overworld-biomes.json"), OLD_CODEC, (DynamicOps<JsonElement>)JanksonJsonOps.INSTANCE, DEFAULT);
        if (getOldOrDefault != DEFAULT) {
            BYG.logWarning("Old overworld config detected, lets try and repair it...");
        }
        FromFileOps.Access registry = new FromFileOps.Access();
        FromFileOps fromFileOps = new FromFileOps((DynamicOps)JanksonJsonOps.INSTANCE, registry);
        Path regions = path.getParent().resolve("regions");
        Path biomePickers = path.getParent().resolve("biome_selectors");
        try {
            OverworldBiomeConfig.createDefaultsAndRegister(recreate, BYGOverworldBiomeSelectors.BIOME_LAYOUTS, registry.get("biome_layout"), BYGOverworldBiomeSelectors.BIOME_LAYOUT_CODEC, (FromFileOps<JsonElement>)fromFileOps, biomePickers);
            OverworldBiomeConfig.createDefaultsAndRegister(recreate, OverworldRegion.BIOME_REGIONS, registry.get("regions"), OverworldRegion.BIOME_PROVIDER_DATA_FROM_FILE_CODEC, (FromFileOps<JsonElement>)fromFileOps, regions);
            if (!path.toFile().exists() || recreate) {
                JanksonUtil.createConfig((Path)path, CODEC, (String)"/*\nThis file uses the \".json5\" file extension which allows for comments like this in a json file!\nYour text editor may show this file with invalid/no syntax, if so, we recommend you download:\n\nVSCode: https://code.visualstudio.com/\nJSON5 plugin(for VSCode): https://marketplace.visualstudio.com/items?itemName=mrmlnc.vscode-json5\n\nto make editing this file much easier.\n*/", Map.of(), (DynamicOps)fromFileOps, (Object)getOldOrDefault);
            }
            OverworldBiomeConfig overworldBiomeConfig = (OverworldBiomeConfig)JanksonUtil.readConfig((Path)path, CODEC, (DynamicOps)fromFileOps);
            BYG.logInfo(String.format("\"%s\" was read.", path));
            return overworldBiomeConfig;
        }
        catch (Exception e) {
            e.printStackTrace();
            BYGConfigHandler.CONFIG_EXCEPTIONS.add(e);
            return DEFAULT;
        }
    }

    private static <T> void createDefaultsAndRegister(boolean recreate, Map<String, Pair<Map<String, String>, T>> defaults, Map<String, T> registry, Codec<T> codec, FromFileOps<JsonElement> fromFileOps, Path providers) throws IOException {
        defaults.forEach((s, listWrapped) -> {
            Path registryPath = providers.resolve(s + ".json5");
            if (!registryPath.toFile().exists() || recreate) {
                JanksonUtil.createConfig((Path)registryPath, (Codec)codec, (String)((Map)listWrapped.getFirst()).getOrDefault("", "/*\nThis file uses the \".json5\" file extension which allows for comments like this in a json file!\nYour text editor may show this file with invalid/no syntax, if so, we recommend you download:\n\nVSCode: https://code.visualstudio.com/\nJSON5 plugin(for VSCode): https://marketplace.visualstudio.com/items?itemName=mrmlnc.vscode-json5\n\nto make editing this file much easier.\n*/"), (Map)((Map)listWrapped.getFirst()), (DynamicOps)fromFileOps, (Object)listWrapped.getSecond());
            }
            registry.putIfAbsent((String)s, (Object)listWrapped.getSecond());
        });
        Files.walk(providers, new FileVisitOption[0]).forEach(path1 -> {
            String fileName = path1.getFileName().toString();
            if (fileName.endsWith(".json5") || fileName.endsWith(".json")) {
                String relativizedPath = providers.relativize((Path)path1).toString();
                String id = relativizedPath.replace(".json5", "").replace(".json", "").replace("\\", "/");
                try {
                    registry.put(id, JanksonUtil.readConfig((Path)path1, (Codec)codec, (DynamicOps)fromFileOps));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    BYGConfigHandler.CONFIG_EXCEPTIONS.add(e);
                }
            }
        });
    }

    private static <T> T readAndDeleteOldOverworldConfig(Path oldPath, Codec<T> codec, DynamicOps<JsonElement> ops, T from) {
        if (oldPath.toFile().exists()) {
            try {
                from = JanksonUtil.readConfig((Path)oldPath, codec, ops);
                Files.delete(oldPath);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return from;
    }
}

