/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.util;

import com.mojang.serialization.Codec;
import java.nio.file.Path;
import java.util.Map;
import net.minecraft.class_1966;
import net.minecraft.class_2794;
import net.minecraft.class_3754;
import net.minecraft.class_5284;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_6686;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import potionstudios.byg.BYG;
import potionstudios.byg.common.world.surfacerules.SurfaceRulesConfig;
import potionstudios.byg.mixin.access.BiomeSourceAccess;
import potionstudios.byg.mixin.access.NoiseBasedChunkGeneratorAccess;
import potionstudios.byg.mixin.access.NoiseGeneratorSettingsAccess;
import potionstudios.byg.util.ModPlatform;

public class AddSurfaceRulesUtil {
    public static void appendSurfaceRule(class_5455 registryAccess, class_5321<class_5363> levelStemKey, class_6686.class_6708 ruleSource) {
        class_5363 levelStem = (class_5363)registryAccess.method_30530(class_7924.field_41224).method_29107(levelStemKey);
        if (levelStem == null) {
            BYG.logError(String.format("Unable to find level stem/dimension \"%s\", this is most likely due to a world being moved across minecraft versions, Oh The Biomes You'll Go cannot support this operation.\nNot adding surface rules....", levelStemKey));
            return;
        }
        class_2794 chunkGenerator = levelStem.comp_1013();
        boolean hasBYGBiome = chunkGenerator.method_12098().method_28443().stream().anyMatch(biomeHolder -> ((class_5321)biomeHolder.method_40230().orElseThrow()).method_29177().method_12836().equals("byg"));
        if (hasBYGBiome) {
            Path path = SurfaceRulesConfig.CONFIG_PATHS.get().get(levelStemKey);
            Map<class_5321<class_5363>, class_6686.class_6708> surfaceRulesConfig = SurfaceRulesConfig.getConfig(true, false);
            if (surfaceRulesConfig.containsKey(levelStemKey) && surfaceRulesConfig.get(levelStemKey) != null) {
                if (chunkGenerator instanceof class_3754) {
                    class_5284 noiseGeneratorSettings = (class_5284)((NoiseBasedChunkGeneratorAccess)chunkGenerator).byg_getSettings().comp_349();
                    if (levelStemKey == class_5363.field_25413) {
                        ((NoiseGeneratorSettingsAccess)noiseGeneratorSettings).byg_setSurfaceRule(class_6686.method_39050((class_6686.class_6708[])new class_6686.class_6708[]{surfaceRulesConfig.get(levelStemKey), ModPlatform.INSTANCE.getTerraBlenderNetherSurfaceRules(noiseGeneratorSettings.comp_478())}));
                    } else {
                        ((NoiseGeneratorSettingsAccess)noiseGeneratorSettings).byg_setSurfaceRule(class_6686.method_39050((class_6686.class_6708[])new class_6686.class_6708[]{ruleSource, noiseGeneratorSettings.comp_478()}));
                    }
                } else {
                    BYG.logWarning(String.format("Ignoring BYG's appended surface rule \"%s\" for dimension: \"%s\" because the chunk generator was not an instance of \"NoiseBasedChunkGenerator\".\nThe chunk generator was an instanceof \"%s\".", path.toString(), levelStemKey.method_29177(), chunkGenerator.getClass().getName()));
                }
            } else {
                throw new IllegalStateException(String.format("Surface rules for \"%s\" are required to load. Fix the Surface Rule config file found at: \"%s\"", levelStemKey.method_29177(), path));
            }
        }
        Codec<? extends class_1966> biomeSourceCodec = ((BiomeSourceAccess)chunkGenerator.method_12098()).byg_invokeCodec();
        BYG.logInfo(String.format("Loading dimension \"%s\" with biome source: \"%s\".", levelStemKey.method_29177(), class_7923.field_41156.method_10221(biomeSourceCodec).toString()));
    }
}

