/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.util;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3218;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_6005;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import potionstudios.byg.BYG;
import potionstudios.byg.common.block.sapling.GrowingPatterns;
import potionstudios.byg.util.BYGUtil;

public interface FeatureGrowerFromBlockPattern {
    public static final List<Supplier<? extends FeatureGrowerFromBlockPattern>> ENTRIES = new ArrayList<Supplier<? extends FeatureGrowerFromBlockPattern>>();

    default public void load(class_2248 block) {
        this.serializePatterns(block);
    }

    public ImmutableList<Pair<List<class_2382>, class_6005<GrowingPatterns.FeatureSpawner>>> getPatterns();

    public void setPatterns(ImmutableList<Pair<List<class_2382>, class_6005<GrowingPatterns.FeatureSpawner>>> var1);

    default public void serializePatterns(class_2248 key) {
        ArrayList list = new ArrayList();
        GrowingPatterns.getConfig().getPatterns(key).map(ArrayList::new).ifPresent(growingPatternEntries -> {
            growingPatternEntries.sort(Comparator.comparingInt(p -> {
                int saplingCount = 0;
                for (String s : p.pattern()) {
                    char[] chars;
                    for (char aChar : chars = s.toCharArray()) {
                        if (aChar != 'x' && aChar != 'X') continue;
                        ++saplingCount;
                    }
                }
                return saplingCount;
            }));
            for (GrowingPatterns.GrowingPatternEntry growingPatternEntry : growingPatternEntries) {
                List<String> pattern = growingPatternEntry.pattern();
                ArrayList<class_2382> offsets = new ArrayList<class_2382>();
                int patternLoopSize = Math.min(pattern.size(), 5);
                StringBuilder builder = new StringBuilder();
                for (int i = 0; i < patternLoopSize; ++i) {
                    String s = pattern.get(i);
                    String substring = s.substring(0, Math.min(s.length(), 5));
                    builder.append(substring);
                }
                String patternCombined = builder.toString();
                String trimmed = patternCombined.trim();
                if (trimmed.length() > 1) {
                    int zOffset = -patternLoopSize / 2;
                    for (int i = 0; i < patternLoopSize; ++i) {
                        char[] charArray;
                        String s = pattern.get(i);
                        int range = Math.min(s.length(), 5);
                        String substring = s.substring(0, range);
                        int xOffset = -range / 2;
                        for (char c : charArray = substring.toCharArray()) {
                            if (c == 'x' || c == 'X') {
                                offsets.add(new class_2382(xOffset, 0, zOffset));
                            }
                            ++xOffset;
                        }
                        ++zOffset;
                    }
                } else {
                    offsets.add(class_2382.field_11176);
                }
                list.add(Pair.of(offsets, growingPatternEntry.spawners()));
            }
        });
        Collections.reverse(list);
        this.setPatterns((ImmutableList<Pair<List<class_2382>, class_6005<GrowingPatterns.FeatureSpawner>>>)ImmutableList.copyOf(list));
    }

    default public boolean growFeature(class_2248 block, class_3218 level, class_2338 pos, class_5819 rand) {
        class_2338.class_2339 mutableBlockPos = pos.method_25503();
        int range = 2;
        for (Pair entry : this.getPatterns()) {
            for (int xMove = -range; xMove <= range; ++xMove) {
                for (int zMove = -range; zMove <= range; ++zMove) {
                    String blockID;
                    Optional configuredFeaturesOptionalRegistry;
                    class_2338.class_2339 mutableBlockPos1 = new class_2338.class_2339().method_10101((class_2382)mutableBlockPos.method_10101((class_2382)pos).method_10100(xMove, 0, zMove));
                    List offsets = (List)entry.getFirst();
                    class_6005 treePicker = (class_6005)entry.getSecond();
                    boolean matchedPattern = FeatureGrowerFromBlockPattern.patternMatches(level, offsets, mutableBlockPos1, (class_2338)mutableBlockPos, block, false);
                    boolean rotated = false;
                    if (!matchedPattern && FeatureGrowerFromBlockPattern.patternMatches(level, offsets, mutableBlockPos1, (class_2338)mutableBlockPos, block, true)) {
                        matchedPattern = true;
                        rotated = true;
                    }
                    if (!matchedPattern || !(configuredFeaturesOptionalRegistry = level.method_30349().method_33310(class_7924.field_41239)).isPresent()) continue;
                    class_2378 configuredFeaturesRegistry = (class_2378)configuredFeaturesOptionalRegistry.get();
                    Optional randomValue = treePicker.method_34973(rand);
                    if (!randomValue.isPresent()) continue;
                    GrowingPatterns.FeatureSpawner featureSpawner = (GrowingPatterns.FeatureSpawner)randomValue.get();
                    class_2975 configuredFeature = (class_2975)configuredFeaturesRegistry.method_29107(featureSpawner.spawnerID());
                    class_2960 blockKey = class_7923.field_41175.method_10221((Object)block);
                    String string = blockID = blockKey == null ? "unknown_grower_block" : blockKey.toString();
                    if (configuredFeature != null) {
                        class_2382 spawnOffset = featureSpawner.spawnOffset();
                        class_2338 growthPos = mutableBlockPos1.method_10081(spawnOffset);
                        if (configuredFeature.method_12862((class_5281)level, level.method_14178().method_12129(), rand, growthPos.method_10062())) {
                            for (class_2382 offset : offsets) {
                                class_2338.class_2339 movedPos;
                                class_2680 offsetState;
                                if (rotated) {
                                    offset = new class_2382(offset.method_10260(), offset.method_10264(), offset.method_10263());
                                }
                                if (!(offsetState = level.method_8320((class_2338)(movedPos = mutableBlockPos1.method_10101((class_2382)mutableBlockPos).method_30927(offset)))).method_27852(block)) continue;
                                level.method_8650((class_2338)movedPos, false);
                            }
                            if (GrowingPatterns.getConfig().logGrowth()) {
                                BYG.logInfo(String.format("Grower \"%s\" grew configured feature \"%s\" at position %s(growth offset: %s).", blockID, featureSpawner, growthPos, spawnOffset));
                            }
                            return true;
                        }
                        if (!GrowingPatterns.getConfig().logGrowth()) continue;
                        BYG.logInfo(String.format("Grower \"%s\" couldn't grow configured feature \"%s\" at position %s(growth offset: %s).", blockID, featureSpawner, growthPos, spawnOffset));
                        continue;
                    }
                    BYG.logError(String.format("Grower \"%s\" failed when attempting to spawn configured feature \"%s\" at position %s. \"%s\" is not a valid configured feature ID in this world's datapack configured feature registry! Valid entries:\n %s", blockID, featureSpawner, pos, featureSpawner, BYGUtil.dumpRegistry(configuredFeaturesRegistry)));
                }
            }
        }
        return false;
    }

    public static boolean patternMatches(class_3218 level, List<class_2382> offsets, class_2338.class_2339 mutableBlockPos, class_2338 pos, class_2248 block, boolean rotated) {
        for (class_2382 offset : offsets) {
            if (rotated) {
                offset = new class_2382(offset.method_10260(), offset.method_10264(), offset.method_10263());
            }
            mutableBlockPos.method_10101((class_2382)pos).method_30927(offset);
            class_2680 offsetState = level.method_8320((class_2338)mutableBlockPos);
            if (offsetState.method_27852(block)) continue;
            return false;
        }
        return true;
    }
}

