/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.openloader.packs;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.darkhax.openloader.Constants;
import net.darkhax.openloader.config.ConfigSchema;
import net.darkhax.openloader.packs.RepoType;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_3258;
import net.minecraft.class_3259;
import net.minecraft.class_3264;
import net.minecraft.class_3285;
import net.minecraft.class_3288;
import net.minecraft.class_5250;
import net.minecraft.class_5352;

public class OpenLoaderRepositorySource
implements class_3285 {
    private static final class_5352 SOURCE = class_5352.method_45281(name -> class_2561.method_43469((String)"pack.nameAndSource", (Object[])new Object[]{name, class_2561.method_43471((String)"pack.source.openloader")}).method_27692(class_124.field_1060), (boolean)true);
    private final RepoType type;
    private final List<File> directories;
    private final ConfigSchema.PackConfig config;

    public OpenLoaderRepositorySource(RepoType type, ConfigSchema.PackConfig config, Path configDir) {
        this.type = type;
        this.config = config;
        this.directories = new ArrayList<File>();
        this.directories.add(configDir.resolve(type.getPath()).toFile());
        for (String customDir : config.additionalFolders) {
            this.directories.add(new File(customDir));
        }
        for (File directory : this.directories) {
            if (!directory.exists()) {
                Constants.LOG.info("Generating new {} folder at {}.", (Object)type.displayName, (Object)directory.getAbsolutePath());
                directory.mkdirs();
            }
            if (directory.isDirectory()) continue;
            Constants.LOG.error("Improper {} folder specified. Must be a directory! See {}.", (Object)type.displayName, (Object)directory.getAbsolutePath());
            throw new IllegalStateException("Can not load " + type.displayName + " from non-directory. " + directory.getAbsolutePath());
        }
    }

    public void method_14453(Consumer<class_3288> consumer) {
        if (this.config.enabled) {
            Constants.LOG.info("Preparing {} injection.", (Object)this.type.displayName);
            for (File parentDirectory : this.directories) {
                int newPackCount = 0;
                int failedPacks = 0;
                for (File packCandidate : Objects.requireNonNull(parentDirectory.listFiles())) {
                    String typeName;
                    boolean isFolderPack;
                    boolean isArchivePack = this.isArchivePack(packCandidate, false);
                    boolean bl = isFolderPack = !isArchivePack && OpenLoaderRepositorySource.isFolderPack(packCandidate, false);
                    String string = isArchivePack ? "archive" : (typeName = isFolderPack ? "folder" : "invalid");
                    if (isArchivePack || isFolderPack) {
                        class_5250 displayName;
                        String packName = this.type.getPath() + "/" + packCandidate.getName();
                        class_3288 pack = class_3288.method_45275((String)packName, (class_2561)(displayName = class_2561.method_43470((String)packName)), (boolean)true, (class_3288.class_7680)this.createPackSupplier(packCandidate), (class_3264)this.type.getPackType(), (class_3288.class_3289)class_3288.class_3289.field_14280, (class_5352)SOURCE);
                        if (pack == null) continue;
                        consumer.accept(pack);
                        ++newPackCount;
                        Constants.LOG.info("Loaded {} {} from {}.", (Object)typeName, (Object)this.type.getName(), (Object)packCandidate.getAbsolutePath());
                        continue;
                    }
                    Constants.LOG.error("Skipping {}. It is not a valid {}!", (Object)packCandidate.getAbsolutePath(), (Object)this.type.getName());
                    this.isArchivePack(packCandidate, true);
                    OpenLoaderRepositorySource.isFolderPack(packCandidate, true);
                    ++failedPacks;
                }
                Constants.LOG.info("Successfully injected {}/{} packs from {}.", (Object)newPackCount, (Object)(newPackCount + failedPacks), (Object)parentDirectory.getAbsolutePath());
            }
        } else {
            Constants.LOG.info("Skipping {}. Disabled by user config.", (Object)this.type.displayName);
        }
    }

    private class_3288.class_7680 createPackSupplier(File packFile) {
        return name -> packFile.isDirectory() ? new class_3259(name, packFile.toPath(), false) : new class_3258(name, packFile, false);
    }

    private boolean isArchivePack(File candidate, boolean logIssues) {
        if (candidate.isFile()) {
            boolean isZipCompatibleArchive;
            String fileName = candidate.getName();
            boolean bl = isZipCompatibleArchive = OpenLoaderRepositorySource.endsWithIgnoreCase(fileName, ".zip") || OpenLoaderRepositorySource.endsWithIgnoreCase(fileName, ".jar");
            if (!isZipCompatibleArchive && logIssues) {
                Constants.LOG.warn("Can not load {} as an archive. It must be a .zip or .jar file!", (Object)candidate.getAbsolutePath());
            }
            return isZipCompatibleArchive;
        }
        if (logIssues) {
            Constants.LOG.warn("Can not load {} as an archive. It is not a file.", (Object)candidate.getAbsolutePath());
        }
        return false;
    }

    private static boolean isFolderPack(File candidate, boolean logIssues) {
        if (candidate.isDirectory()) {
            if (new File(candidate, "pack.mcmeta").isFile()) {
                return true;
            }
            if (logIssues) {
                Constants.LOG.warn("Can not load {} as a folder pack. It is missing a pack.mcmeta file!", (Object)candidate.getAbsolutePath());
            }
        } else if (logIssues) {
            Constants.LOG.warn("Can not load {} as folder. It is not a directory.", (Object)candidate.getAbsolutePath());
        }
        return false;
    }

    private static boolean endsWithIgnoreCase(String str, String suffix) {
        int suffixLength = suffix.length();
        return str.regionMatches(true, str.length() - suffixLength, suffix, 0, suffixLength);
    }
}

