/*
 * Decompiled with CFR 0.152.
 */
package msnj.tcwm;

import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class MTRVersions<G>
implements Comparable<MTRVersions<G>> {
    public final int[] parts;

    public MTRVersions(int[] parts) {
        this.parts = parts;
    }

    public static MTRVersions<Object> parse(String src) {
        ArrayList<Integer> parts = new ArrayList<Integer>();
        String[] strParts = src.split("-");
        for (int i2 = 1; i2 < strParts.length; ++i2) {
            String[] subParts;
            for (String subPart : subParts = strParts[i2].split("\\.")) {
                if (!subPart.matches("\\d+")) continue;
                parts.add(Integer.parseInt(subPart));
            }
        }
        return new MTRVersions<Object>(parts.stream().mapToInt(i -> i).toArray());
    }

    @Override
    public int compareTo(@NotNull MTRVersions o) {
        for (int i = 0; i < Math.min(this.parts.length, o.parts.length); ++i) {
            if (this.parts[i] == o.parts[i]) continue;
            return Integer.compare(this.parts[i], o.parts[i]);
        }
        return Integer.compare(this.parts.length, o.parts.length);
    }

    public boolean verification(String path) {
        return this.compareTo(MTRVersions.parse("-" + path)) >= 0;
    }

    public String toString() {
        int f = 0;
        for (int part : this.parts) {
            f = f == 0 ? part : f * 10 + part;
        }
        return String.valueOf(f);
    }
}

