/*
 * Decompiled with CFR 0.152.
 */
package msnj.tcwm.block;

import java.util.function.Predicate;
import msnj.tcwm.RealityCityConstruction;
import msnj.tcwm.block.Blocks;
import msnj.tcwm.mappings.BlockEntityClientSerializableMapper;
import msnj.tcwm.mappings.BlockEntityMapper;
import msnj.tcwm.mappings.BlockMapper;
import msnj.tcwm.mappings.EntityBlockMapper;
import msnj.tcwm.mappings.RegistryUtilities;
import msnj.tcwm.network.PacketPlaySound;
import msnj.tcwm.network.PacketScreen;
import mtr.Blocks;
import mtr.block.IBlock;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StationBroadcaster
extends BlockMapper
implements EntityBlockMapper {
    private static final class_2746 POWERED = class_2746.method_11825((String)"powered");

    public StationBroadcaster() {
        super(class_4970.class_2251.method_9630((class_4970)((class_4970)Blocks.TRAIN_REDSTONE_SENSOR.get())));
        this.method_9590((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{POWERED});
    }

    @Override
    public BlockEntityMapper createBlockEntity(class_2338 pos, class_2680 state) {
        return new StationBroadcasterEntity(pos, state);
    }

    @Nullable
    public class_2680 method_9605(class_1750 blockPlaceContext) {
        return (class_2680)this.method_9564().method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(blockPlaceContext.method_8045().method_8479(blockPlaceContext.method_8037())));
    }

    public StationBroadcasterEntity getBlockEntity(class_1937 level, class_2338 blockPos) {
        class_2586 temp = level.method_8321(blockPos);
        if (temp instanceof StationBroadcasterEntity) {
            StationBroadcasterEntity blockEntity = (StationBroadcasterEntity)temp;
            return blockEntity;
        }
        return null;
    }

    public class_1269 method_9534(@NotNull class_2680 blockState, @NotNull class_1937 level, @NotNull class_2338 blockPos, class_1657 player, class_1268 interactionHand, class_3965 blockHitResult) {
        return IBlock.checkHoldingBrush((class_1937)level, (class_1657)player, () -> {
            if (!level.field_9236) {
                PacketScreen.sendScreenBlockS2C((class_3222)player, "SSBAS", blockPos);
            }
        });
    }

    public void method_9612(class_2680 blockState, class_1937 level, class_2338 blockPos, class_2248 block, class_2338 blockPos2, boolean bl) {
        boolean bl2;
        if (!level.field_9236 && (bl2 = ((Boolean)blockState.method_11654((class_2769)POWERED)).booleanValue()) != level.method_8479(blockPos)) {
            if (bl2) {
                level.method_8652(blockPos, (class_2680)blockState.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false)), 3);
            } else {
                level.method_8652(blockPos, (class_2680)blockState.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(true)), 3);
                this.playSound(level, blockPos);
            }
        }
    }

    public void playSound(class_1937 level, class_2338 blockPos) {
        StationBroadcasterEntity s = this.getBlockEntity(level, blockPos);
        class_2960 soundEventId = new class_2960(s.getSoundID());
        class_3414 soundEvent = RegistryUtilities.createSoundEvent(soundEventId);
        if (level instanceof class_3218) {
            class_3218 sl = (class_3218)level;
            Predicate<class_3222> psp = player -> true;
            sl.method_18766(psp).forEach(player -> PacketPlaySound.sendPlaySoundS2C(player, blockPos, soundEventId, s.getRange(), s.getPitch()));
        } else {
            RealityCityConstruction.LOGGER.error("Failed to Play Sound to Player.");
        }
    }

    public static class StationBroadcasterEntity
    extends BlockEntityClientSerializableMapper {
        private String soundID = "tcwm:miku.hand_in_hand";
        private float range = 1.4f;
        private Pitch pitch = Pitch.DEFAULT;

        public StationBroadcasterEntity(class_2338 blockPos, class_2680 blockState) {
            super((class_2591)Blocks.BlockEntityTypes.HOMO_STATION_BROADCASTER.get(), blockPos, blockState);
        }

        @Override
        public final void readCompoundTag(class_2487 compoundTag) {
            super.readCompoundTag(compoundTag);
            this.soundID = compoundTag.method_10558("soundID");
            this.range = compoundTag.method_10583("range");
            this.pitch = Pitch.getValue(compoundTag.method_10583("pitch"));
        }

        public float getRange() {
            return this.range;
        }

        public Pitch getPitch() {
            return this.pitch;
        }

        public String getSoundID() {
            return this.soundID;
        }

        public void setPitch(Pitch pitch) {
            this.pitch = pitch;
        }

        public void setSoundID(String soundID) {
            this.soundID = soundID;
        }

        public void setRange(float range) {
            this.range = range;
        }

        @Override
        public final void writeCompoundTag(class_2487 compoundTag) {
            super.writeCompoundTag(compoundTag);
            compoundTag.method_10582("soundID", this.soundID);
            compoundTag.method_10548("range", this.range);
            compoundTag.method_10548("pitch", this.pitch.getPitch());
        }

        public static enum Pitch {
            VERY_SLOW(0.5f),
            SLOW(0.75f),
            DEFAULT(1.0f),
            FAST(1.5f),
            VERY_FAST(2.0f);

            final float pitch;

            private Pitch(float pitch) {
                this.pitch = pitch;
            }

            public float getPitch() {
                return this.pitch;
            }

            public static Pitch getValue(float f) {
                if (f == 0.5f) {
                    return VERY_SLOW;
                }
                if (f == 0.75f) {
                    return SLOW;
                }
                if (f == 1.0f) {
                    return DEFAULT;
                }
                if (f == 1.5f) {
                    return FAST;
                }
                if (f == 2.0f) {
                    return VERY_FAST;
                }
                return DEFAULT;
            }
        }
    }
}

