/*
 * Decompiled with CFR 0.152.
 */
package msnj.tcwm.data.settings;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import msnj.tcwm.RealityCityConstruction;

public class JsonIO {
    private Path jsonPath;
    public boolean customRailwaySignIsOpen = true;
    public boolean disabledMixins = false;
    private static final JsonParser JSON_PARSER = new JsonParser();

    private JsonIO(Path path) {
        this.jsonPath = path;
    }

    public static JsonIO read(Path jsonPath) {
        try {
            JsonObject jsonObject = JSON_PARSER.parse(String.join((CharSequence)"", Files.readAllLines(jsonPath))).getAsJsonObject();
            JsonIO io = new JsonIO(jsonPath);
            io.customRailwaySignIsOpen = jsonObject.get("EnableCustomSign").getAsBoolean();
            io.disabledMixins = jsonObject.get("DisabledMixin").getAsBoolean();
            return io;
        }
        catch (IOException ie) {
            RealityCityConstruction.LOGGER.error("Fatal! path is null");
            ie.printStackTrace();
            JsonIO io = new JsonIO(jsonPath);
            JsonIO.write(io);
            return io;
        }
        catch (NullPointerException ne) {
            ne.printStackTrace();
            RealityCityConstruction.LOGGER.warn("continue run...");
            JsonIO io = new JsonIO(jsonPath);
            JsonIO.write(io);
            return io;
        }
    }

    public static void write(JsonIO io) {
        if (io.jsonPath == null) {
            return;
        }
        try {
            JsonObject configObject = new JsonObject();
            configObject.addProperty("EnableCustomSign", Boolean.valueOf(io.customRailwaySignIsOpen));
            configObject.addProperty("DisabledMixin", Boolean.valueOf(io.disabledMixins));
            Files.write(io.jsonPath, Collections.singleton(new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)configObject)), new OpenOption[0]);
        }
        catch (IOException ie) {
            ie.printStackTrace();
        }
    }

    public static JsonIO get(Path path) {
        return new JsonIO(path);
    }
}

