/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.mtrtm;

import com.lx862.mtrtm.Mappings;
import com.lx862.mtrtm.Util;
import com.lx862.mtrtm.data.ExposedTrainData;
import com.lx862.mtrtm.mixin.SidingAccessorMixin;
import com.lx862.mtrtm.mixin.TrainAccessorMixin;
import com.lx862.mtrtm.mixin.TrainServerAccessorMixin;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import mtr.data.Depot;
import mtr.data.RailwayData;
import mtr.data.Route;
import mtr.data.RouteType;
import mtr.data.Station;
import mtr.data.TrainServer;
import mtr.packet.IPacket;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import net.minecraft.class_5250;

public class MtrUtil {
    public static void syncTrainToPlayers(TrainServer trainServer, List<class_3222> players) {
        class_2540 trainPacket = PacketByteBufs.create();
        trainServer.writePacket(trainPacket);
        class_2540 packet = PacketByteBufs.create();
        packet.writeBytes((ByteBuf)trainPacket);
        for (class_3222 player : players) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)IPacket.PACKET_UPDATE_TRAINS, (class_2540)packet);
        }
    }

    public static class_3545<class_5250, class_5250> getInterchangeRouteNames(Station station, Route thisRoute, RailwayData data, class_124 forceColor) {
        class_5250 chinTexts = Mappings.literalText("");
        class_5250 engTexts = Mappings.literalText("");
        class_5250 comma = Mappings.literalText(", ");
        HashMap<String, Route> routeInSta = new HashMap<String, Route>();
        for (Route rt : data.routes) {
            if (rt.isHidden || MtrUtil.getRouteName(rt.name).equals(MtrUtil.getRouteName(thisRoute.name)) || rt.name.startsWith("[WIP]") || rt.routeType == RouteType.HIGH_SPEED) continue;
            for (Route.RoutePlatform pid : rt.platformIds) {
                Station sta = (Station)data.dataCache.platformIdToStation.get(pid.platformId);
                if (sta == null || sta.id != station.id) continue;
                routeInSta.put(MtrUtil.getRouteName(rt.name), rt);
            }
        }
        if (routeInSta.isEmpty()) {
            return null;
        }
        boolean first = true;
        for (Route route : routeInSta.values()) {
            class_5250 chinText = Mappings.literalText(MtrUtil.getRouteName(MtrUtil.getNameChinese(route.name)));
            class_5250 engText = Mappings.literalText(MtrUtil.getRouteName(MtrUtil.getNameEnglish(route.name)));
            if (forceColor == null) {
                chinText.method_10862(class_2583.field_24360.method_36139(route.color));
                engText.method_10862(class_2583.field_24360.method_36139(route.color));
            } else {
                chinTexts.method_10862(class_2583.field_24360.method_10977(forceColor));
                engText.method_10862(class_2583.field_24360.method_10977(forceColor));
            }
            if (first) {
                chinTexts.method_10852((class_2561)chinText);
                engTexts.method_10852((class_2561)engText);
            } else {
                chinTexts.method_10852((class_2561)comma).method_10852((class_2561)chinText);
                engTexts.method_10852((class_2561)comma).method_10852((class_2561)engText);
            }
            first = false;
        }
        return new class_3545((Object)chinTexts, (Object)engTexts);
    }

    public static Station findStation(String targetSta, class_1937 world) {
        RailwayData data = RailwayData.getInstance((class_1937)world);
        if (data == null) {
            return null;
        }
        Map staMap = data.dataCache.stationIdMap;
        for (Map.Entry entry : staMap.entrySet()) {
            if (((Station)entry.getValue()).name.trim().equals(targetSta)) {
                return (Station)entry.getValue();
            }
            for (String lang : ((Station)entry.getValue()).name.split("\\|")) {
                if (!lang.trim().equalsIgnoreCase(targetSta)) continue;
                return (Station)entry.getValue();
            }
        }
        return null;
    }

    public static Set<Depot> findDepots(String targetDepot, class_1937 world) {
        String trimmedTargetDepot = targetDepot == null ? null : targetDepot.toLowerCase(Locale.ENGLISH).trim();
        RailwayData data = RailwayData.getInstance((class_1937)world);
        if (data == null) {
            return Set.of();
        }
        if (trimmedTargetDepot == null) {
            return data.depots;
        }
        return data.depots.stream().filter(e -> e.name.toLowerCase(Locale.ENGLISH).trim().contains(trimmedTargetDepot)).collect(Collectors.toSet());
    }

    public static String getRouteName(String str) {
        return str.split("\\|\\|")[0].replace("|", " ");
    }

    public static String getNameChinese(String str) {
        return str.split("\\|")[0];
    }

    public static String getNameEnglish(String str) {
        String[] splitted = str.split("\\|");
        return splitted.length > 1 ? splitted[1] : "";
    }

    public static ExposedTrainData getNearestTrain(class_1937 world, class_3222 player, class_243 playerPos) {
        ExposedTrainData trainData;
        RailwayData railwayData = RailwayData.getInstance((class_1937)world);
        ArrayList<ExposedTrainData> trainDataList = new ArrayList<ExposedTrainData>();
        ExposedTrainData closestTrainCar = null;
        for (Object siding : railwayData.sidings) {
            for (TrainServer train2 : ((SidingAccessorMixin)siding).getTrains()) {
                class_243[] positions = new class_243[train2.trainCars + 1];
                for (int i = 0; i <= train2.trainCars; ++i) {
                    positions[i] = ((TrainAccessorMixin)train2).getTheRoutePosition(((TrainAccessorMixin)train2).getReversed() ? train2.trainCars - i : i, train2.spacing);
                }
                trainDataList.add(new ExposedTrainData(train2, ((TrainServerAccessorMixin)train2).getRouteId(), positions, ((TrainAccessorMixin)train2).getIsManualAllowed()));
            }
        }
        class_243 closestPos = null;
        for (ExposedTrainData train3 : trainDataList) {
            if (player != null && train3.train.isPlayerRiding((class_1657)player)) {
                closestTrainCar = train3;
                break;
            }
            for (int i = 0; i < train3.positions.length; ++i) {
                boolean isCloser;
                if (closestTrainCar == null) {
                    closestTrainCar = train3;
                    closestPos = train3.positions[i];
                    continue;
                }
                double lastTrainDistance = Util.getManhattenDistance(closestPos, playerPos);
                double thisTrainDistance = Util.getManhattenDistance(train3.positions[i], playerPos);
                boolean bl = isCloser = thisTrainDistance < lastTrainDistance;
                if (!isCloser) continue;
                closestTrainCar = train3;
                closestPos = train3.positions[i];
            }
        }
        if ((trainData = closestTrainCar) == null) {
            return null;
        }
        if (trainData.isManual) {
            trainData.isCurrentlyManual = ((TrainAccessorMixin)trainData.train).getIsCurrentlyManual();
            if (trainData.isCurrentlyManual) {
                trainData.accelerationSign = ((TrainAccessorMixin)trainData.train).getManualNotch();
                trainData.manualCooldown = ((TrainServerAccessorMixin)trainData.train).getManualCoolDown();
                trainData.manualToAutomaticTime = ((TrainAccessorMixin)trainData.train).getManualToAutomaticTime();
            }
        }
        return trainData;
    }
}

