/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.mtrtm.commands;

import com.lx862.mtrtm.Mappings;
import com.lx862.mtrtm.MtrUtil;
import com.lx862.mtrtm.TransitManager;
import com.lx862.mtrtm.Util;
import com.lx862.mtrtm.data.ExposedTrainData;
import com.lx862.mtrtm.data.TrainState;
import com.lx862.mtrtm.mixin.SidingAccessorMixin;
import com.lx862.mtrtm.mixin.TrainAccessorMixin;
import com.lx862.mtrtm.mixin.TrainServerAccessorMixin;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import mtr.data.Depot;
import mtr.data.IGui;
import mtr.data.Platform;
import mtr.data.RailType;
import mtr.data.RailwayData;
import mtr.data.Route;
import mtr.data.SavedRailBase;
import mtr.data.Siding;
import mtr.data.Station;
import mtr.path.PathData;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2164;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class train {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"train").requires(ctx -> ctx.method_9259(2))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"halt").then(class_2170.method_9247((String)"dwell").executes(context -> train.haltDwell((CommandContext<class_2168>)context)))).then(class_2170.method_9247((String)"speed").executes(context -> train.haltSpeed((CommandContext<class_2168>)context))))).then(class_2170.method_9247((String)"toggleCollision").executes(context -> train.toggleCollision((CommandContext<class_2168>)context)))).then(class_2170.method_9247((String)"board").executes(context -> train.board((CommandContext<class_2168>)context)))).then(class_2170.method_9247((String)"ejectAllPassengers").executes(context -> train.ejectPassengers((CommandContext<class_2168>)context)))).then(class_2170.method_9247((String)"clear").executes(context -> train.clearNearestTrain((CommandContext<class_2168>)context)))).then(class_2170.method_9247((String)"deploy").executes(context -> train.deploy((CommandContext<class_2168>)context)))).then(class_2170.method_9247((String)"skipDwell").executes(context -> train.skipDwell((CommandContext<class_2168>)context)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"jump").then(class_2170.method_9247((String)"siding").executes(context -> train.jump((CommandContext<class_2168>)context, true, false, false, false, true)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"next").then(class_2170.method_9247((String)"platform").executes(context -> train.jump((CommandContext<class_2168>)context, true, false, true, false, false)))).then(class_2170.method_9247((String)"path").executes(context -> train.jump((CommandContext<class_2168>)context, true, true, false, false, false)))).then(class_2170.method_9247((String)"stopPosition").executes(context -> train.jump((CommandContext<class_2168>)context, true, false, false, true, false))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"previous").then(class_2170.method_9247((String)"platform").executes(context -> train.jump((CommandContext<class_2168>)context, false, false, true, false, false)))).then(class_2170.method_9247((String)"path").executes(context -> train.jump((CommandContext<class_2168>)context, false, true, false, false, false)))))).executes(context -> train.getNearestTrain((CommandContext<class_2168>)context, Util.getPlayerFromContext((CommandContext<class_2168>)context))));
    }

    private static int deploy(CommandContext<class_2168> context) {
        RailwayData data = RailwayData.getInstance((class_1937)((class_2168)context.getSource()).method_9225());
        ExposedTrainData nearestTrain = train.getNearestTrainOrError(context);
        List<Siding> trainSidings = data.sidings.stream().filter(siding -> siding.id == nearestTrain.train.sidingId).toList();
        Siding trainSiding = null;
        if (!trainSidings.isEmpty()) {
            trainSiding = trainSidings.get(0);
        }
        nearestTrain.train.deployTrain();
        ((class_2168)context.getSource()).method_9226((class_2561)Mappings.literalText("Deploying the nearest train (Siding " + trainSiding.name + ")...").method_27692(class_124.field_1060), false);
        ((class_2168)context.getSource()).method_9226((class_2561)Mappings.literalText("Train ID: " + trainSiding.getTrainId()).method_27692(class_124.field_1060), false);
        if (nearestTrain.isManual) {
            ((class_2168)context.getSource()).method_9226((class_2561)Mappings.literalText("NOTE: Train is currently in manual mode.").method_27692(class_124.field_1054), false);
        }
        return 1;
    }

    private static int jump(CommandContext<class_2168> context, boolean next, boolean isPath, boolean isPlatform, boolean isNextStop, boolean isSiding) {
        ExposedTrainData trainData = train.getNearestTrainOrError(context);
        double currentRailProgress = trainData.train.getRailProgress();
        List<Double> distances = ((TrainAccessorMixin)trainData.train).getDistances();
        double targetDistance = -1.0;
        int pathIndex = -1;
        if (isNextStop) {
            targetDistance = distances.get(((TrainAccessorMixin)trainData.train).getNextStoppingIndex());
        } else if (isSiding) {
            targetDistance = distances.get(0);
        } else {
            boolean justOneMorePath = false;
            for (int i = 0; i < trainData.train.path.size(); ++i) {
                boolean isStoppablePlatform;
                int pIndex = next ? i : trainData.train.path.size() - 1 - i;
                PathData path = (PathData)trainData.train.path.get(pIndex);
                boolean bl = isStoppablePlatform = path.dwellTime > 0 && path.rail.railType == RailType.PLATFORM;
                if ((!isPlatform || !isStoppablePlatform) && !isPath) continue;
                double dist = distances.get(pIndex);
                if (next && dist > currentRailProgress) {
                    targetDistance = dist;
                    pathIndex = pIndex;
                    break;
                }
                if (next || !(dist < currentRailProgress)) continue;
                if (trainData.train.getSpeed() == 0.0f || isPlatform || trainData.train.getSpeed() > 0.0f && justOneMorePath) {
                    targetDistance = dist;
                    pathIndex = pIndex;
                    break;
                }
                justOneMorePath = true;
            }
        }
        if (targetDistance == -1.0) {
            throw new class_2164((class_2561)Mappings.literalText("Cannot find the next path to stop to."));
        }
        ((TrainAccessorMixin)trainData.train).setNextStoppingIndex(Math.max(pathIndex, ((TrainAccessorMixin)trainData.train).getNextStoppingIndex()));
        ((TrainAccessorMixin)trainData.train).setRailProgress(targetDistance);
        MtrUtil.syncTrainToPlayers(trainData.train, ((class_2168)context.getSource()).method_9225().method_18456());
        ((class_2168)context.getSource()).method_9226((class_2561)Mappings.literalText("Jumped to distance " + Math.round(targetDistance) + "m.").method_27692(class_124.field_1060), false);
        return 1;
    }

    private static int ejectPassengers(CommandContext<class_2168> context) {
        ExposedTrainData nearestTrain = train.getNearestTrainOrError(context);
        ((TrainAccessorMixin)nearestTrain.train).getRidingEntities().clear();
        MtrUtil.syncTrainToPlayers(nearestTrain.train, ((class_2168)context.getSource()).method_9225().method_18456());
        ((class_2168)context.getSource()).method_9226((class_2561)Mappings.literalText("All passengers cleared from train!").method_27692(class_124.field_1060), false);
        return 1;
    }

    private static int board(CommandContext<class_2168> context) throws CommandSyntaxException {
        ExposedTrainData nearestTrain = train.getNearestTrainOrError(context);
        ((TrainAccessorMixin)nearestTrain.train).getRidingEntities().add(((class_2168)context.getSource()).method_9207().method_5667());
        MtrUtil.syncTrainToPlayers(nearestTrain.train, ((class_2168)context.getSource()).method_9225().method_18456());
        ((class_2168)context.getSource()).method_9226((class_2561)Mappings.literalText("Train boarded!").method_27692(class_124.field_1060), false);
        return 1;
    }

    private static int clearNearestTrain(CommandContext<class_2168> context) {
        ExposedTrainData nearestTrain = train.getNearestTrainOrError(context);
        RailwayData railwayData = RailwayData.getInstance((class_1937)((class_2168)context.getSource()).method_9225());
        long sidingId = nearestTrain.train.sidingId;
        Siding trainSiding = (Siding)railwayData.dataCache.sidingIdMap.get(sidingId);
        ((SidingAccessorMixin)trainSiding).getTrains().removeIf(train2 -> train2.id == nearestTrain.train.id);
        ((class_2168)context.getSource()).method_9226((class_2561)Mappings.literalText("Siding cleared!").method_27692(class_124.field_1060), false);
        return 1;
    }

    private static int skipDwell(CommandContext<class_2168> context) {
        ExposedTrainData nearestTrain = train.getNearestTrainOrError(context);
        ((TrainAccessorMixin)nearestTrain.train).setElapsedDwellTicks(nearestTrain.train.getTotalDwellTicks());
        MtrUtil.syncTrainToPlayers(nearestTrain.train, ((class_2168)context.getSource()).method_9225().method_18456());
        ((class_2168)context.getSource()).method_9226((class_2561)Mappings.literalText("Dwell time skipped!").method_27692(class_124.field_1060), false);
        return 1;
    }

    private static int haltDwell(CommandContext<class_2168> context) {
        ExposedTrainData nearestTrain = train.getNearestTrainOrError(context);
        boolean halted = TransitManager.getTrainState(nearestTrain.train.id, TrainState.HALT_DWELL);
        TransitManager.setTrainState(nearestTrain.train.id, TrainState.HALT_DWELL, !halted);
        ((class_2168)context.getSource()).method_9226((class_2561)Mappings.literalText("Dwell timer for the nearest train has been " + (!halted ? "paused" : "resumed")).method_27692(class_124.field_1060), false);
        return 1;
    }

    private static int haltSpeed(CommandContext<class_2168> context) {
        ExposedTrainData nearestTrain = train.getNearestTrainOrError(context);
        boolean halted = TransitManager.getTrainState(nearestTrain.train.id, TrainState.HALT_SPEED);
        TransitManager.setTrainState(nearestTrain.train.id, TrainState.HALT_SPEED, !halted);
        ((class_2168)context.getSource()).method_9226((class_2561)Mappings.literalText("The nearest train has " + (!halted ? "been brought to a halt" : "resumed it's operation")).method_27692(class_124.field_1060), false);
        return 1;
    }

    private static int toggleCollision(CommandContext<class_2168> context) {
        ExposedTrainData nearestTrain = train.getNearestTrainOrError(context);
        boolean skipCollision = TransitManager.getTrainState(nearestTrain.train.id, TrainState.SKIP_COLLISION);
        TransitManager.setTrainState(nearestTrain.train.id, TrainState.SKIP_COLLISION, !skipCollision);
        ((class_2168)context.getSource()).method_9226((class_2561)Mappings.literalText("Collision detection for the nearest train is now " + (!skipCollision ? "bypassed" : "reset to normal")).method_27692(class_124.field_1060), false);
        return 1;
    }

    private static ExposedTrainData getNearestTrainOrError(CommandContext<class_2168> context) throws class_2164 {
        class_3222 player = Util.getPlayerFromContext(context);
        ExposedTrainData trainData = player != null ? MtrUtil.getNearestTrain((class_1937)((class_2168)context.getSource()).method_9225(), player, player.method_33571()) : MtrUtil.getNearestTrain((class_1937)((class_2168)context.getSource()).method_9225(), null, ((class_2168)context.getSource()).method_9222());
        if (trainData == null) {
            throw new class_2164((class_2561)Mappings.literalText("Cannot find any nearest train!"));
        }
        return trainData;
    }

    public static int getNearestTrain(CommandContext<class_2168> context, class_3222 player) {
        int currentRouteColor;
        RailwayData data = RailwayData.getInstance((class_1937)((class_2168)context.getSource()).method_9225());
        ExposedTrainData trainData = MtrUtil.getNearestTrain((class_1937)((class_2168)context.getSource()).method_9225(), player, player.method_33571());
        if (trainData == null) {
            ((class_2168)context.getSource()).method_9226((class_2561)Mappings.literalText("Cannot find any train.").method_27692(class_124.field_1061), false);
            return 1;
        }
        if (trainData.isManual) {
            trainData.isCurrentlyManual = ((TrainAccessorMixin)trainData.train).getIsCurrentlyManual();
            if (trainData.isCurrentlyManual) {
                trainData.accelerationSign = ((TrainAccessorMixin)trainData.train).getManualNotch();
                trainData.manualCooldown = ((TrainServerAccessorMixin)trainData.train).getManualCoolDown();
                trainData.manualToAutomaticTime = ((TrainAccessorMixin)trainData.train).getManualToAutomaticTime();
            }
        }
        long sidingId = trainData.train.sidingId;
        List<Siding> sidingList = data.sidings.stream().filter(sd -> sd.id == sidingId).toList();
        if (sidingList.isEmpty()) {
            ((class_2168)context.getSource()).method_9226((class_2561)Mappings.literalText("Cannot find corresponding siding.").method_27692(class_124.field_1061), false);
            return 1;
        }
        Siding siding = sidingList.get(0);
        Depot sidingDepot = null;
        for (Depot depot : data.depots) {
            if (!depot.inArea(siding.getMidPos().method_10263(), siding.getMidPos().method_10260())) continue;
            sidingDepot = depot;
            break;
        }
        if (sidingDepot == null) {
            ((class_2168)context.getSource()).method_9226((class_2561)Mappings.literalText("No depot associated with that siding.").method_27692(class_124.field_1061), false);
            return 1;
        }
        List<Route> trainRoutes = data.routes.stream().filter(rt -> rt.id == trainData.routeId).toList();
        String currentRouteName = "N/A";
        String currentRouteDestination = null;
        double remainingDwell = ((float)trainData.train.getTotalDwellTicks() - trainData.train.getElapsedDwellTicks()) / 20.0f;
        int displayedDwell = (int)Math.round(remainingDwell);
        Object dwellString = remainingDwell < 0.0 ? "0s (" + Math.abs(displayedDwell) + " overdue)" : Util.getReadableTimeMs((long)displayedDwell * 1000L);
        Platform lastPlatformInRoute = null;
        if (!trainRoutes.isEmpty()) {
            Route runningRoute = trainRoutes.get(0);
            currentRouteColor = runningRoute.color;
            currentRouteName = IGui.formatStationName((String)runningRoute.name);
            long lastPlatformId = runningRoute.getLastPlatformId();
            Station lastStation = (Station)data.dataCache.platformIdToStation.get(lastPlatformId);
            lastPlatformInRoute = (Platform)data.dataCache.platformIdMap.get(lastPlatformId);
            if (lastStation == null) {
                class_2338 midPos = lastPlatformInRoute.getMidPos();
                currentRouteDestination = "Platform " + lastPlatformInRoute.name + " (" + midPos.method_10263() + ", " + midPos.method_10264() + ", " + midPos.method_10260() + ")";
            } else {
                currentRouteDestination = IGui.formatStationName((String)lastStation.name) + " (" + lastPlatformInRoute.name + ")";
            }
        } else {
            currentRouteColor = 0;
        }
        int depotColor = sidingDepot.color;
        String depotSidingName = IGui.formatStationName((String)sidingDepot.name) + " (Siding " + siding.name + ")";
        class_5250 depotName = Mappings.literalText(depotSidingName).method_27694(style -> style.method_36139(depotColor));
        class_5250 routeName = Mappings.literalText(currentRouteName).method_27694(style -> style.method_36139(currentRouteColor));
        class_5250 destinationName = currentRouteDestination == null ? null : Mappings.literalText(currentRouteDestination).method_27692(class_124.field_1060);
        String title = IGui.formatStationName((String)trainData.train.trainId) + " (" + trainData.train.trainCars + "-cars)";
        class_5250 pos = Mappings.literalText(String.format("%d, %d, %d", Math.round(trainData.positions[0].method_10216()), Math.round(trainData.positions[0].method_10214()), Math.round(trainData.positions[0].method_10215()))).method_27692(class_124.field_1060);
        class_5250 dwell = Mappings.literalText((String)dwellString).method_27692(class_124.field_1060);
        class_5250 isManual = Mappings.literalText(trainData.isManual ? (trainData.isCurrentlyManual ? "Manual (Currently Manual)" : "Manual (Current ATO)") : "ATO").method_27692(class_124.field_1060);
        class_5250 trainNotch = Mappings.literalText(trainData.accelerationSign == -2 ? "B2" : (trainData.accelerationSign == -1 ? "B1" : (trainData.accelerationSign == 0 ? "N" : (trainData.accelerationSign == 1 ? "P1" : "P2")))).method_27692(class_124.field_1060);
        int manualToAutoTimeMs = trainData.manualToAutomaticTime * 10 * 50;
        int manualCooldownMs = trainData.manualCooldown * 50;
        class_5250 PMLeft = Mappings.literalText(Util.getReadableTimeMs(manualToAutoTimeMs - manualCooldownMs)).method_27692(class_124.field_1060);
        Set<UUID> ridingEntities = ((TrainAccessorMixin)trainData.train).getRidingEntities();
        StringBuilder ridingEntitiesStr = new StringBuilder();
        for (UUID uuid : ((TrainAccessorMixin)trainData.train).getRidingEntities()) {
            class_3222 ridingPlayer = ((class_2168)context.getSource()).method_9211().method_3760().method_14602(uuid);
            if (ridingPlayer == null) continue;
            ridingEntitiesStr.append(ridingPlayer.method_7334().getName()).append("\n");
        }
        boolean hasEffectApplied = false;
        class_5250 effectText = Mappings.literalText("");
        for (class_3222 state : TrainState.values()) {
            boolean enabled = TransitManager.getTrainState(trainData.train.id, (TrainState)state);
            if (!enabled) continue;
            hasEffectApplied = true;
            class_5250 thisEffectText = Mappings.literalText(state.getName()).method_27692(class_124.field_1060).method_27692(class_124.field_1073);
            effectText.method_10852((class_2561)thisEffectText).method_27693(" ");
        }
        class_2568 hoverEvent = new class_2568(class_2568.class_5247.field_24342, (Object)Mappings.literalText(ridingEntitiesStr.toString()).method_27692(class_124.field_1060));
        class_2558 clickEvent = new class_2558(class_2558.class_2559.field_11750, "/traininv " + siding.id);
        ((class_2168)context.getSource()).method_9226((class_2561)Mappings.literalText("===== " + title + " =====").method_27692(class_124.field_1060), false);
        train.sendKeyValueFeedback(context, Mappings.literalText("Mode: "), isManual);
        train.sendKeyValueFeedback(context, Mappings.literalText("Depot/Siding: "), train.teleportToSavedRailText(depotName, (SavedRailBase)siding));
        train.sendKeyValueFeedback(context, Mappings.literalText("Position: "), pos);
        train.sendKeyValueFeedback(context, Mappings.literalText("Running Route: "), routeName);
        if (trainData.train.getSpeed() == 0.0f && trainData.train.getTotalDwellTicks() > 0) {
            train.sendKeyValueFeedback(context, Mappings.literalText("Dwell left: "), dwell);
        }
        if (hasEffectApplied) {
            train.sendKeyValueFeedback(context, Mappings.literalText("Effect applied: "), effectText);
        }
        if (destinationName != null) {
            train.sendKeyValueFeedback(context, Mappings.literalText("Destination: "), train.teleportToSavedRailText(destinationName, (SavedRailBase)lastPlatformInRoute));
        }
        if (!((TrainAccessorMixin)trainData.train).getInventory().method_5442()) {
            ((class_2168)context.getSource()).method_9226((class_2561)Mappings.literalText("Train Inventory: (Click Here)").method_27692(class_124.field_1065).method_27694(style -> style.method_10958(clickEvent)), false);
        }
        if (trainData.isManual && trainData.isCurrentlyManual) {
            train.sendKeyValueFeedback(context, Mappings.literalText("Train Notch: "), trainNotch);
            train.sendKeyValueFeedback(context, Mappings.literalText("Switching to ATO in: "), PMLeft);
        }
        if (!ridingEntities.isEmpty()) {
            ((class_2168)context.getSource()).method_9226((class_2561)Mappings.literalText("Riding players: (Hover Here)").method_27692(class_124.field_1065).method_27694(style -> style.method_10949(hoverEvent)), false);
        }
        return 1;
    }

    private static void sendKeyValueFeedback(CommandContext<class_2168> context, class_5250 key, class_5250 value) {
        ((class_2168)context.getSource()).method_9226((class_2561)key.method_27692(class_124.field_1065).method_10852((class_2561)value), false);
    }

    private static class_5250 teleportToSavedRailText(class_5250 originalText, SavedRailBase savedRail) {
        if (savedRail == null) {
            return originalText;
        }
        class_2338 midPos = savedRail.getMidPos();
        class_2568 hoverEventTp = new class_2568(class_2568.class_5247.field_24342, (Object)Mappings.literalText("Click to teleport").method_27692(class_124.field_1060));
        class_2558 clickEventTp = new class_2558(class_2558.class_2559.field_11750, "/tp " + midPos.method_10263() + " " + midPos.method_10264() + " " + midPos.method_10260());
        return originalText.method_27692(class_124.field_1073).method_27694(e -> e.method_10949(hoverEventTp).method_10958(clickEventTp));
    }
}

