/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.mtrtm.config;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.lx862.mtrtm.TransitManager;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import net.fabricmc.loader.api.FabricLoader;

public class Config {
    private static final Path CONFIG_PATH = Paths.get(FabricLoader.getInstance().getConfigDir().toString(), "transitmanager");
    public static int mtrJourneyPlannerTickTime = 0;
    public static int shearPSDOpLevel = 0;

    public static boolean load() {
        if (!Files.exists(CONFIG_PATH.resolve("config.json"), new LinkOption[0])) {
            TransitManager.LOGGER.info("[TransitManager] Config not found, generating one...");
            Config.writeConfig();
            return true;
        }
        TransitManager.LOGGER.info("[TransitManager] Reading Train Config...");
        try {
            JsonObject jsonConfig = new JsonParser().parse(String.join((CharSequence)"", Files.readAllLines(CONFIG_PATH.resolve("config.json")))).getAsJsonObject();
            try {
                mtrJourneyPlannerTickTime = jsonConfig.get("mtrJourneyPlannerTickTime").getAsInt();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                shearPSDOpLevel = jsonConfig.get("shearPSDOpLevel").getAsInt();
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static void writeConfig() {
        TransitManager.LOGGER.info("[TransitManager] Writing Config...");
        JsonObject jsonConfig = new JsonObject();
        jsonConfig.addProperty("mtrJourneyPlannerTickTime", (Number)mtrJourneyPlannerTickTime);
        jsonConfig.addProperty("shearPSDOpLevel", (Number)shearPSDOpLevel);
        CONFIG_PATH.toFile().mkdirs();
        try {
            Files.write(CONFIG_PATH.resolve("config.json"), Collections.singleton(new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)jsonConfig)), new OpenOption[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

