/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.config;

import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import me.jellysquid.mods.lithium.common.compat.worldedit.WorldEditCompat;
import me.jellysquid.mods.lithium.common.config.Option;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.ModMetadata;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LithiumConfig {
    private static final Logger LOGGER = LogManager.getLogger((String)"LithiumConfig");
    private static final String JSON_KEY_LITHIUM_OPTIONS = "lithium:options";
    private final Map<String, Option> options = new HashMap<String, Option>();
    private final Set<Option> optionsWithDependencies = new ObjectLinkedOpenHashSet();

    private void applyLithiumCompat() {
        Option option = this.options.get("mixin.block.hopper.worldedit_compat");
        if (!option.isEnabled() && WorldEditCompat.WORLD_EDIT_PRESENT) {
            option.addModOverride(true, "lithium-fabric");
        }
    }

    private LithiumConfig() {
        InputStream defaultPropertiesStream = LithiumConfig.class.getResourceAsStream("/assets/lithium/lithium-mixin-config-default.properties");
        if (defaultPropertiesStream == null) {
            throw new IllegalStateException("Lithium mixin config default properties could not be read!");
        }
        try (BufferedReader propertiesReader = new BufferedReader(new InputStreamReader(defaultPropertiesStream));){
            Properties properties = new Properties();
            properties.load(propertiesReader);
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(ruleName, enabled) -> this.addMixinRule((String)ruleName, Boolean.parseBoolean((String)enabled))));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IllegalStateException("Lithium mixin config default properties could not be read!");
        }
        InputStream dependenciesStream = LithiumConfig.class.getResourceAsStream("/assets/lithium/lithium-mixin-config-dependencies.properties");
        if (dependenciesStream == null) {
            throw new IllegalStateException("Lithium mixin config dependencies could not be read!");
        }
        try (BufferedReader propertiesReader = new BufferedReader(new InputStreamReader(dependenciesStream));){
            Properties properties = new Properties();
            properties.load(propertiesReader);
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(o1, o2) -> {
                String[] dependenciesSplit;
                String rulename = (String)o1;
                String dependencies = (String)o2;
                for (String dependency : dependenciesSplit = dependencies.split(",")) {
                    String[] split = dependency.split(":");
                    if (split.length != 2) {
                        return;
                    }
                    String dependencyName = split[0];
                    String requiredState = split[1];
                    this.addRuleDependency(rulename, dependencyName, Boolean.parseBoolean(requiredState));
                }
            }));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IllegalStateException("Lithium mixin config dependencies could not be read!");
        }
    }

    public static LithiumConfig load(File file) {
        LithiumConfig config = new LithiumConfig();
        if (file.exists()) {
            Properties props = new Properties();
            try (FileInputStream fin = new FileInputStream(file);){
                props.load(fin);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not load config file", e);
            }
            config.readProperties(props);
        } else {
            try {
                LithiumConfig.writeDefaultConfig(file);
            }
            catch (IOException e) {
                LOGGER.warn("Could not write default configuration file", (Throwable)e);
            }
        }
        config.applyLithiumCompat();
        config.applyModOverrides();
        while (config.applyDependencies()) {
        }
        return config;
    }

    private void addRuleDependency(String rule, String dependency, boolean requiredValue) {
        Option option = this.options.get(rule);
        if (option == null) {
            LOGGER.error("Option {} for dependency '{} depends on {}={}' not found. Skipping.", (Object)rule, (Object)rule, (Object)dependency, (Object)requiredValue);
            return;
        }
        Option dependencyOption = this.options.get(dependency);
        if (dependencyOption == null) {
            LOGGER.error("Option {} for dependency '{} depends on {}={}' not found. Skipping.", (Object)dependency, (Object)rule, (Object)dependency, (Object)requiredValue);
            return;
        }
        option.addDependency(dependencyOption, requiredValue);
        this.optionsWithDependencies.add(option);
    }

    private void addMixinRule(String mixin, boolean enabled) {
        if (this.options.putIfAbsent(mixin, new Option(mixin, enabled, false)) != null) {
            throw new IllegalStateException("Mixin rule already defined: " + mixin);
        }
    }

    private void readProperties(Properties props) {
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            boolean enabled;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            Option option = this.options.get(key);
            if (option == null) {
                LOGGER.warn("No configuration key exists with name '{}', ignoring", (Object)key);
                continue;
            }
            if (value.equalsIgnoreCase("true")) {
                enabled = true;
            } else if (value.equalsIgnoreCase("false")) {
                enabled = false;
            } else {
                LOGGER.warn("Invalid value '{}' encountered for configuration key '{}', ignoring", (Object)value, (Object)key);
                continue;
            }
            option.setEnabled(enabled, true);
        }
    }

    private void applyModOverrides() {
        for (ModContainer container : FabricLoader.getInstance().getAllMods()) {
            ModMetadata meta = container.getMetadata();
            if (!meta.containsCustomValue(JSON_KEY_LITHIUM_OPTIONS)) continue;
            CustomValue overrides = meta.getCustomValue(JSON_KEY_LITHIUM_OPTIONS);
            if (overrides.getType() != CustomValue.CvType.OBJECT) {
                LOGGER.warn("Mod '{}' contains invalid Lithium option overrides, ignoring", (Object)meta.getId());
                continue;
            }
            for (Map.Entry entry : overrides.getAsObject()) {
                this.applyModOverride(meta, (String)entry.getKey(), (CustomValue)entry.getValue());
            }
        }
    }

    private void applyModOverride(ModMetadata meta, String name, CustomValue value) {
        Option option;
        if (!name.startsWith("mixin.")) {
            name = LithiumConfig.getMixinRuleName(name);
        }
        if ((option = this.options.get(name)) == null) {
            LOGGER.warn("Mod '{}' attempted to override option '{}', which doesn't exist, ignoring", (Object)meta.getId(), (Object)name);
            return;
        }
        if (value.getType() != CustomValue.CvType.BOOLEAN) {
            LOGGER.warn("Mod '{}' attempted to override option '{}' with an invalid value, ignoring", (Object)meta.getId(), (Object)name);
            return;
        }
        boolean enabled = value.getAsBoolean();
        if (!enabled && option.isEnabled()) {
            option.clearModsDefiningValue();
        }
        if (!enabled || option.isEnabled() || option.getDefiningMods().isEmpty()) {
            option.addModOverride(enabled, meta.getId());
        }
    }

    public Option getEffectiveOptionForMixin(String mixinClassName) {
        int nextSplit;
        int lastSplit = 0;
        Option rule = null;
        while ((nextSplit = mixinClassName.indexOf(46, lastSplit)) != -1) {
            String key = LithiumConfig.getMixinRuleName(mixinClassName.substring(0, nextSplit));
            Option candidate = this.options.get(key);
            if (candidate != null && !(rule = candidate).isEnabled()) {
                return rule;
            }
            lastSplit = nextSplit + 1;
        }
        return rule;
    }

    private boolean applyDependencies() {
        boolean changed = false;
        for (Option optionWithDependency : this.optionsWithDependencies) {
            changed |= optionWithDependency.disableIfDependenciesNotMet(LOGGER, this);
        }
        return changed;
    }

    private static void writeDefaultConfig(File file) throws IOException {
        File dir = file.getParentFile();
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                throw new IOException("Could not create parent directories");
            }
        } else if (!dir.isDirectory()) {
            throw new IOException("The parent file is not a directory");
        }
        try (FileWriter writer = new FileWriter(file);){
            writer.write("# This is the configuration file for Lithium.\n");
            writer.write("# This file exists for debugging purposes and should not be configured otherwise.\n");
            writer.write("# Before configuring anything, take a backup of the worlds that will be opened.\n");
            writer.write("#\n");
            writer.write("# You can find information on editing this file and all the available options here:\n");
            writer.write("# https://github.com/jellysquid3/lithium-fabric/wiki/Configuration-File\n");
            writer.write("#\n");
            writer.write("# By default, this file will be empty except for this notice.\n");
        }
    }

    private static String getMixinRuleName(String name) {
        return "mixin." + name;
    }

    public int getOptionCount() {
        return this.options.size();
    }

    public int getOptionOverrideCount() {
        return (int)this.options.values().stream().filter(Option::isOverridden).count();
    }

    public Option getParent(Option option) {
        String optionName = option.getName();
        int split = optionName.lastIndexOf(46);
        if (split != -1) {
            String key = optionName.substring(0, split);
            return this.options.get(key);
        }
        return null;
    }
}

