/*
 * Decompiled with CFR 0.152.
 */
package com.minenash.seamless_loading_screen.config;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.mojang.logging.LogUtils;
import dev.isxander.yacl3.config.GsonConfigInstance;
import java.awt.Color;
import java.lang.reflect.Type;
import java.util.function.Supplier;
import org.slf4j.Logger;

public class SafeColorTypeAdapter
extends GsonConfigInstance.ColorTypeAdapter {
    private static final Logger LOGGER = LogUtils.getLogger();
    public final Supplier<Color> supplier;
    public boolean errored = false;

    public SafeColorTypeAdapter(Supplier<Color> supplier) {
        this.supplier = supplier;
    }

    public boolean errored() {
        boolean errored = this.errored;
        this.errored = false;
        return errored;
    }

    public Color deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        try {
            if (jsonElement instanceof JsonPrimitive) {
                JsonPrimitive primitive = (JsonPrimitive)jsonElement;
                if (primitive.isNumber()) {
                    return super.deserialize(jsonElement, type, jsonDeserializationContext);
                }
                if (primitive.getAsString().contains("#")) {
                    this.errored = true;
                    return new Color(Integer.parseInt(primitive.getAsString().replace("#", ""), 16), false);
                }
            }
        }
        catch (NumberFormatException | UnsupportedOperationException e) {
            LOGGER.warn("Exception thrown during Color Deserialization", (Throwable)e);
        }
        this.errored = true;
        LOGGER.warn("Unable to parse a given color form the config file, such will be set to default! [Value: {}]", (Object)jsonElement);
        return this.supplier.get();
    }

    public JsonElement serialize(Color color, Type type, JsonSerializationContext jsonSerializationContext) {
        return super.serialize(color, type, jsonSerializationContext);
    }
}

