/*
 * Decompiled with CFR 0.152.
 */
package net.szum123321.window_title_changer;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_7367;
import net.szum123321.window_title_changer.WindowTitleChanger;

public class ResourceProvider {
    private final Path mainPath = FabricLoader.getInstance().getConfigDir().resolve("WindowTitleChanger/").toAbsolutePath();
    private final Path iconsFolderPath = this.mainPath.resolve("icons");
    private boolean changeIcons;

    public ResourceProvider(boolean changeIcons) {
        this.createFolders();
        if (changeIcons) {
            this.changeIcons = this.checkIcons();
        }
    }

    public boolean changeIcons() {
        return this.changeIcons;
    }

    public class_7367<InputStream> get16Icon() {
        return () -> Files.newInputStream(this.mainPath.resolve("icons/").resolve(WindowTitleChanger.config.icon16x16), new OpenOption[0]);
    }

    public class_7367<InputStream> get32Icon() {
        return () -> Files.newInputStream(this.mainPath.resolve("icons/").resolve(WindowTitleChanger.config.icon32x32), new OpenOption[0]);
    }

    private void createFolders() {
        File icons;
        if (!this.mainPath.toFile().exists()) {
            this.mainPath.toFile().mkdirs();
        }
        if (!(icons = this.iconsFolderPath.toFile()).exists()) {
            icons.mkdirs();
        }
    }

    private boolean checkIcons() {
        FormatterStringBuilder builder = new FormatterStringBuilder();
        if (WindowTitleChanger.config.icon16x16.equals("")) {
            builder.append("No 16x16 icon provided!", new Object[0]);
        } else {
            this.isValidIcon(this.iconsFolderPath.resolve(WindowTitleChanger.config.icon16x16).toFile(), builder);
        }
        if (WindowTitleChanger.config.icon32x32.equals("")) {
            builder.append("No 32x32 icon provided!", new Object[0]);
        } else {
            this.isValidIcon(this.iconsFolderPath.resolve(WindowTitleChanger.config.icon32x32).toFile(), builder);
        }
        if (!builder.isEmpty()) {
            builder.buildStream().forEach(x$0 -> WindowTitleChanger.LOGGER.error(x$0, new Object[0]));
            WindowTitleChanger.LOGGER.error("Because of the above error, window icon won't be changed!", new Object[0]);
            WindowTitleChanger.LOGGER.error("If you're playing on a modpack, please report this error to modpack's creator!", new Object[0]);
        }
        return builder.isEmpty();
    }

    private void isValidIcon(File f, FormatterStringBuilder builder) {
        if (!f.exists()) {
            builder.append("File %s doesn't exists!", f);
        } else if (f.isDirectory()) {
            builder.append("%s is a directory", f);
        } else if (!f.getName().substring(f.getName().lastIndexOf(".") + 1).equals("png")) {
            builder.append("%s is not a png image!", f);
        }
    }

    private static class FormatterStringBuilder {
        private final StringBuilder builder = new StringBuilder();

        public FormatterStringBuilder append(String msg, Object ... args) {
            this.builder.append(String.format(msg, args));
            this.builder.append("\n");
            return this;
        }

        public boolean isEmpty() {
            return this.builder.length() == 0;
        }

        public String build() {
            return this.builder.toString();
        }

        public Stream<String> buildStream() {
            return Arrays.stream(this.build().split("\n"));
        }
    }
}

