/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.fabric;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import com.google.common.util.concurrent.Futures;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.BaseItem;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.fabric.FabricAdapter;
import com.sk89q.worldedit.fabric.FabricEntity;
import com.sk89q.worldedit.fabric.FabricWorldEdit;
import com.sk89q.worldedit.fabric.WorldEditFakePlayer;
import com.sk89q.worldedit.fabric.WorldEditGenListener;
import com.sk89q.worldedit.fabric.internal.ExtendedMinecraftServer;
import com.sk89q.worldedit.fabric.internal.FabricWorldNativeAccess;
import com.sk89q.worldedit.fabric.internal.NBTConverter;
import com.sk89q.worldedit.fabric.mixin.AccessorDerivedLevelData;
import com.sk89q.worldedit.fabric.mixin.AccessorPrimaryLevelData;
import com.sk89q.worldedit.fabric.mixin.AccessorServerChunkCache;
import com.sk89q.worldedit.function.mask.AbstractExtentMask;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.mask.Mask2D;
import com.sk89q.worldedit.internal.Constants;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.util.SideEffect;
import com.sk89q.worldedit.util.SideEffectSet;
import com.sk89q.worldedit.util.TreeGenerator;
import com.sk89q.worldedit.util.io.file.SafeFiles;
import com.sk89q.worldedit.world.AbstractWorld;
import com.sk89q.worldedit.world.RegenOptions;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.item.ItemTypes;
import com.sk89q.worldedit.world.weather.WeatherType;
import com.sk89q.worldedit.world.weather.WeatherTypes;
import java.lang.ref.WeakReference;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2404;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2802;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2841;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_32;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3829;
import net.minecraft.class_3949;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5217;
import net.minecraft.class_5268;
import net.minecraft.class_5281;
import net.minecraft.class_5285;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5819;
import net.minecraft.class_6802;
import net.minecraft.class_6808;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public class FabricWorld
extends AbstractWorld {
    private static final class_5819 random = class_5819.method_43047();
    private final WeakReference<class_1937> worldRef;
    private final FabricWorldNativeAccess worldNativeAccess;
    private static final LoadingCache<class_3218, WorldEditFakePlayer> fakePlayers = CacheBuilder.newBuilder().weakKeys().softValues().build(CacheLoader.from(WorldEditFakePlayer::new));

    private static class_2960 getDimensionRegistryKey(class_1937 world) {
        return Objects.requireNonNull(world.method_8503(), "server cannot be null").method_30611().method_30530(class_7924.field_41241).method_10221((Object)world.method_8597());
    }

    FabricWorld(class_1937 world) {
        Preconditions.checkNotNull((Object)world);
        this.worldRef = new WeakReference<class_1937>(world);
        this.worldNativeAccess = new FabricWorldNativeAccess(this.worldRef);
    }

    public class_1937 getWorld() {
        class_1937 world = (class_1937)this.worldRef.get();
        if (world != null) {
            return world;
        }
        throw new RuntimeException("The reference to the world was lost (i.e. the world may have been unloaded)");
    }

    @Override
    public String getName() {
        class_5217 levelProperties = this.getWorld().method_8401();
        return ((class_5268)levelProperties).method_150();
    }

    @Override
    public String getId() {
        return this.getName() + "_" + FabricWorld.getDimensionRegistryKey(this.getWorld());
    }

    @Override
    public Path getStoragePath() {
        class_1937 world = this.getWorld();
        MinecraftServer server = world.method_8503();
        Preconditions.checkState((boolean)(server instanceof ExtendedMinecraftServer), (Object)"Need a server world");
        return ((ExtendedMinecraftServer)server).getStoragePath(world);
    }

    @Override
    public <B extends BlockStateHolder<B>> boolean setBlock(BlockVector3 position, B block, SideEffectSet sideEffects) throws WorldEditException {
        this.clearContainerBlockContents(position);
        return this.worldNativeAccess.setBlock(position, block, sideEffects);
    }

    @Override
    public Set<SideEffect> applySideEffects(BlockVector3 position, BlockState previousType, SideEffectSet sideEffectSet) {
        this.worldNativeAccess.applySideEffects(position, previousType, sideEffectSet);
        return Sets.intersection(FabricWorldEdit.inst.getPlatform().getSupportedSideEffects(), sideEffectSet.getSideEffectsToApply());
    }

    @Override
    public int getBlockLightLevel(BlockVector3 position) {
        Preconditions.checkNotNull((Object)position);
        return this.getWorld().method_22339(FabricAdapter.toBlockPos(position));
    }

    @Override
    public boolean clearContainerBlockContents(BlockVector3 position) {
        Preconditions.checkNotNull((Object)position);
        class_2586 tile = this.getWorld().method_8321(FabricAdapter.toBlockPos(position));
        if (tile instanceof class_3829) {
            ((class_3829)tile).method_5448();
            return true;
        }
        return false;
    }

    @Override
    public BiomeType getBiome(BlockVector3 position) {
        Preconditions.checkNotNull((Object)position);
        class_2818 chunk = this.getWorld().method_8497(position.getX() >> 4, position.getZ() >> 4);
        return this.getBiomeInChunk(position, (class_2791)chunk);
    }

    private BiomeType getBiomeInChunk(BlockVector3 position, class_2791 chunk) {
        return FabricAdapter.adapt((class_1959)chunk.method_16359(position.getX() >> 2, position.getY() >> 2, position.getZ() >> 2).comp_349());
    }

    @Override
    public boolean setBiome(BlockVector3 position, BiomeType biome) {
        Preconditions.checkNotNull((Object)position);
        Preconditions.checkNotNull((Object)biome);
        class_2818 chunk = this.getWorld().method_8497(position.getBlockX() >> 4, position.getBlockZ() >> 4);
        class_2841 biomeArray = (class_2841)chunk.method_38259(chunk.method_31602(position.getY())).method_38294();
        biomeArray.method_16678(position.getX() & 3, position.getY() & 3, position.getZ() & 3, (Object)((class_2378)this.getWorld().method_30349().method_33310(class_7924.field_41236).orElseThrow()).method_40290(class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)new class_2960(biome.getId()))));
        chunk.method_12008(true);
        return true;
    }

    @Override
    public boolean useItem(BlockVector3 position, BaseItem item, Direction face) {
        WorldEditFakePlayer fakePlayer;
        class_1799 stack = FabricAdapter.adapt(new BaseItemStack(item.getType(), item.getNbtData(), 1));
        class_3218 world = (class_3218)this.getWorld();
        try {
            fakePlayer = (WorldEditFakePlayer)((Object)fakePlayers.get((Object)world));
        }
        catch (ExecutionException ignored) {
            return false;
        }
        fakePlayer.method_6122(class_1268.field_5808, stack);
        fakePlayer.method_5641(position.getBlockX(), position.getBlockY(), position.getBlockZ(), (float)face.toVector().toYaw(), (float)face.toVector().toPitch());
        class_2338 blockPos = FabricAdapter.toBlockPos(position);
        class_3965 rayTraceResult = new class_3965(FabricAdapter.toVec3(position), FabricAdapter.adapt(face), blockPos, false);
        class_1838 itemUseContext = new class_1838((class_1657)fakePlayer, class_1268.field_5808, rayTraceResult);
        class_1269 used = stack.method_7981(itemUseContext);
        if (used != class_1269.field_5812) {
            used = this.getWorld().method_8320(blockPos).method_26174((class_1937)world, (class_1657)fakePlayer, class_1268.field_5808, rayTraceResult);
        }
        if (used != class_1269.field_5812) {
            used = stack.method_7913((class_1937)world, (class_1657)fakePlayer, class_1268.field_5808).method_5467();
        }
        return used == class_1269.field_5812;
    }

    @Override
    public void dropItem(Vector3 position, BaseItemStack item) {
        Preconditions.checkNotNull((Object)position);
        Preconditions.checkNotNull((Object)item);
        if (item.getType() == ItemTypes.AIR) {
            return;
        }
        class_1542 entity = new class_1542(this.getWorld(), position.getX(), position.getY(), position.getZ(), FabricAdapter.adapt(item));
        entity.method_6982(10);
        this.getWorld().method_8649((class_1297)entity);
    }

    @Override
    public void simulateBlockMine(BlockVector3 position) {
        class_2338 pos = FabricAdapter.toBlockPos(position);
        this.getWorld().method_22352(pos, true);
    }

    @Override
    public boolean canPlaceAt(BlockVector3 position, BlockState blockState) {
        return FabricAdapter.adapt(blockState).method_26184((class_4538)this.getWorld(), FabricAdapter.toBlockPos(position));
    }

    @Override
    public boolean regenerate(Region region, Extent extent, RegenOptions options) {
        class_2802 provider = this.getWorld().method_8398();
        if (!(provider instanceof class_3215)) {
            return false;
        }
        try {
            this.doRegen(region, extent, options);
        }
        catch (Exception e) {
            throw new IllegalStateException("Regen failed", e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRegen(Region region, Extent extent, RegenOptions options) throws Exception {
        Path tempDir = Files.createTempDirectory("WorldEditWorldGen", new FileAttribute[0]);
        class_32 levelStorage = class_32.method_26999((Path)tempDir);
        try (class_32.class_5143 session = levelStorage.method_27002("WorldEditTempGen");){
            AccessorPrimaryLevelData levelProperties;
            class_3218 originalWorld = (class_3218)this.getWorld();
            class_5217 class_52172 = originalWorld.method_8401();
            if (class_52172 instanceof AccessorDerivedLevelData) {
                AccessorDerivedLevelData derivedLevelData = (AccessorDerivedLevelData)class_52172;
                levelProperties = (AccessorPrimaryLevelData)derivedLevelData.getWrapped();
            } else {
                levelProperties = (AccessorPrimaryLevelData)originalWorld.method_8401();
            }
            class_5285 originalOpts = levelProperties.method_28057();
            long seed = options.getSeed().orElse(originalWorld.method_8412());
            class_5285 newOpts = options.getSeed().isPresent() ? originalOpts.method_28024(OptionalLong.of(seed)) : originalOpts;
            levelProperties.setWorldOptions(newOpts);
            class_5321 worldRegKey = originalWorld.method_27983();
            try (class_3218 serverWorld = new class_3218(originalWorld.method_8503(), (Executor)class_156.method_18349(), session, (class_5268)originalWorld.method_8401(), worldRegKey, new class_5363(originalWorld.method_40134(), originalWorld.method_14178().method_12129()), (class_3949)new WorldEditGenListener(), originalWorld.method_27982(), seed, (List)ImmutableList.of(), false);){
                this.regenForWorld(region, extent, serverWorld, options);
                while (originalWorld.method_8503().method_16075()) {
                    Thread.yield();
                }
            }
            finally {
                levelProperties.setWorldOptions(originalOpts);
            }
        }
        finally {
            SafeFiles.tryHardToDeleteDir(tempDir);
        }
    }

    private void regenForWorld(Region region, Extent extent, class_3218 serverWorld, RegenOptions options) throws WorldEditException {
        List<CompletableFuture<class_2791>> chunkLoadings = this.submitChunkLoadTasks(region, serverWorld);
        ((AccessorServerChunkCache)serverWorld.method_14178()).getMainThreadProcessor().method_18857(() -> {
            if (chunkLoadings.stream().anyMatch(ftr -> ftr.isDone() && Futures.getUnchecked((Future)ftr) == null)) {
                return false;
            }
            return chunkLoadings.stream().allMatch(CompletableFuture::isDone);
        });
        HashMap<class_1923, class_2791> chunks = new HashMap<class_1923, class_2791>();
        for (CompletableFuture<class_2791> future : chunkLoadings) {
            class_2791 chunk = future.getNow(null);
            Preconditions.checkState((chunk != null ? 1 : 0) != 0, (Object)"Failed to generate a chunk, regen failed.");
            chunks.put(chunk.method_12004(), chunk);
        }
        for (BlockVector3 vec : region) {
            class_2338 pos = FabricAdapter.toBlockPos(vec);
            class_2791 chunk = (class_2791)chunks.get(new class_1923(pos));
            BlockStateHolder<BlockState> state = FabricAdapter.adapt(chunk.method_8320(pos));
            class_2586 blockEntity = chunk.method_8321(pos);
            if (blockEntity != null) {
                state = state.toBaseBlock(NBTConverter.fromNative(blockEntity.method_38243()));
            }
            extent.setBlock(vec, state.toBaseBlock());
            if (!options.shouldRegenBiomes()) continue;
            BiomeType biome = this.getBiomeInChunk(vec, chunk);
            extent.setBiome(vec, biome);
        }
    }

    private List<CompletableFuture<class_2791>> submitChunkLoadTasks(Region region, class_3218 world) {
        AccessorServerChunkCache chunkManager = (AccessorServerChunkCache)world.method_14178();
        ArrayList<CompletableFuture<class_2791>> chunkLoadings = new ArrayList<CompletableFuture<class_2791>>();
        for (BlockVector2 chunk : region.getChunks()) {
            chunkLoadings.add((CompletableFuture<class_2791>)chunkManager.callGetChunkFuture(chunk.getX(), chunk.getZ(), class_2806.field_12795, true).thenApply(either -> either.left().orElse(null)));
        }
        return chunkLoadings;
    }

    @Nullable
    private static class_5321<class_2975<?, ?>> createTreeFeatureGenerator(TreeGenerator.TreeType type) {
        return switch (type) {
            case TreeGenerator.TreeType.TREE -> class_6808.field_35905;
            case TreeGenerator.TreeType.BIG_TREE -> class_6808.field_35912;
            case TreeGenerator.TreeType.REDWOOD -> class_6808.field_35909;
            case TreeGenerator.TreeType.TALL_REDWOOD -> class_6808.field_35915;
            case TreeGenerator.TreeType.MEGA_REDWOOD -> class_6808.field_35916;
            case TreeGenerator.TreeType.BIRCH -> class_6808.field_35907;
            case TreeGenerator.TreeType.JUNGLE -> class_6808.field_35914;
            case TreeGenerator.TreeType.SMALL_JUNGLE -> class_6808.field_35911;
            case TreeGenerator.TreeType.SHORT_JUNGLE -> class_6808.field_35913;
            case TreeGenerator.TreeType.JUNGLE_BUSH -> class_6808.field_35920;
            case TreeGenerator.TreeType.SWAMP -> class_6808.field_35919;
            case TreeGenerator.TreeType.ACACIA -> class_6808.field_35908;
            case TreeGenerator.TreeType.DARK_OAK -> class_6808.field_35906;
            case TreeGenerator.TreeType.TALL_BIRCH -> class_6808.field_35917;
            case TreeGenerator.TreeType.RED_MUSHROOM -> class_6808.field_35904;
            case TreeGenerator.TreeType.BROWN_MUSHROOM -> class_6808.field_35903;
            case TreeGenerator.TreeType.WARPED_FUNGUS -> class_6808.field_35901;
            case TreeGenerator.TreeType.CRIMSON_FUNGUS -> class_6808.field_35899;
            case TreeGenerator.TreeType.CHORUS_PLANT -> class_6802.field_35798;
            case TreeGenerator.TreeType.RANDOM -> FabricWorld.createTreeFeatureGenerator(TreeGenerator.TreeType.values()[ThreadLocalRandom.current().nextInt(TreeGenerator.TreeType.values().length)]);
            default -> null;
        };
    }

    @Override
    public boolean generateTree(TreeGenerator.TreeType type, EditSession editSession, BlockVector3 position) {
        class_3218 world = (class_3218)this.getWorld();
        class_2975 generator = Optional.ofNullable(FabricWorld.createTreeFeatureGenerator(type)).map(k -> (class_2975)world.method_30349().method_30530(class_7924.field_41239).method_29107(k)).orElse(null);
        class_3215 chunkManager = world.method_14178();
        if (type == TreeGenerator.TreeType.CHORUS_PLANT) {
            position = position.add(0, 1, 0);
        }
        return generator != null && generator.method_12862((class_5281)world, chunkManager.method_12129(), random, FabricAdapter.toBlockPos(position));
    }

    @Override
    public void checkLoadedChunk(BlockVector3 pt) {
        this.getWorld().method_22350(FabricAdapter.toBlockPos(pt));
    }

    @Override
    public void fixAfterFastMode(Iterable<BlockVector2> chunks) {
        this.fixLighting(chunks);
    }

    @Override
    public void fixLighting(Iterable<BlockVector2> chunks) {
        class_1937 world = this.getWorld();
        for (BlockVector2 chunk : chunks) {
            world.method_8398().method_12130().method_15512(new class_1923(chunk.getBlockX(), chunk.getBlockZ()), true);
        }
    }

    @Override
    public boolean playEffect(Vector3 position, int type, int data) {
        return true;
    }

    @Override
    public WeatherType getWeather() {
        class_5217 info = this.getWorld().method_8401();
        if (info.method_203()) {
            return WeatherTypes.THUNDER_STORM;
        }
        if (info.method_156()) {
            return WeatherTypes.RAIN;
        }
        return WeatherTypes.CLEAR;
    }

    @Override
    public long getRemainingWeatherDuration() {
        class_5268 info = (class_5268)this.getWorld().method_8401();
        if (info.method_203()) {
            return info.method_145();
        }
        if (info.method_156()) {
            return info.method_190();
        }
        return info.method_155();
    }

    @Override
    public void setWeather(WeatherType weatherType) {
        this.setWeather(weatherType, 0L);
    }

    @Override
    public void setWeather(WeatherType weatherType, long duration) {
        class_5268 info = (class_5268)this.getWorld().method_8401();
        if (weatherType == WeatherTypes.THUNDER_STORM) {
            info.method_167(0);
            info.method_147(true);
            info.method_173((int)duration);
        } else if (weatherType == WeatherTypes.RAIN) {
            info.method_167(0);
            info.method_157(true);
            info.method_164((int)duration);
        } else if (weatherType == WeatherTypes.CLEAR) {
            info.method_157(false);
            info.method_147(false);
            info.method_167((int)duration);
        }
    }

    @Override
    public int getMinY() {
        return this.getWorld().method_31607();
    }

    @Override
    public int getMaxY() {
        return this.getWorld().method_31600() - 1;
    }

    @Override
    public BlockVector3 getSpawnPosition() {
        class_5217 worldProps = this.getWorld().method_8401();
        return BlockVector3.at(worldProps.method_215(), worldProps.method_144(), worldProps.method_166());
    }

    @Override
    public BlockState getBlock(BlockVector3 position) {
        class_2680 mcState = this.getWorld().method_8497(position.getBlockX() >> 4, position.getBlockZ() >> 4).method_8320(FabricAdapter.toBlockPos(position));
        return FabricAdapter.adapt(mcState);
    }

    @Override
    public BaseBlock getFullBlock(BlockVector3 position) {
        class_2338 pos = new class_2338(position.getBlockX(), position.getBlockY(), position.getBlockZ());
        class_2586 tile = ((class_2818)this.getWorld().method_22350(pos)).method_12201(pos, class_2818.class_2819.field_12859);
        if (tile != null) {
            return this.getBlock(position).toBaseBlock(NBTConverter.fromNative(tile.method_38243()));
        }
        return this.getBlock(position).toBaseBlock();
    }

    @Override
    public int hashCode() {
        return this.getWorld().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof FabricWorld) {
            FabricWorld other = (FabricWorld)o;
            class_1937 otherWorld = (class_1937)other.worldRef.get();
            class_1937 thisWorld = (class_1937)this.worldRef.get();
            return otherWorld != null && otherWorld.equals(thisWorld);
        }
        if (o instanceof World) {
            return ((World)o).getName().equals(this.getName());
        }
        return false;
    }

    @Override
    public List<? extends Entity> getEntities(Region region) {
        class_1937 world = this.getWorld();
        class_238 box = new class_238(FabricAdapter.toBlockPos(region.getMinimumPoint()), FabricAdapter.toBlockPos(region.getMaximumPoint().add(BlockVector3.ONE)));
        List nmsEntities = world.method_8333((class_1297)null, box, e -> region.contains(FabricAdapter.adapt(e.method_24515())));
        return (List)nmsEntities.stream().map(FabricEntity::new).collect(ImmutableList.toImmutableList());
    }

    @Override
    public List<? extends Entity> getEntities() {
        class_1937 world = this.getWorld();
        if (!(world instanceof class_3218)) {
            return Collections.emptyList();
        }
        return (List)Streams.stream((Iterable)((class_3218)world).method_27909()).map(FabricEntity::new).collect(ImmutableList.toImmutableList());
    }

    @Override
    @Nullable
    public Entity createEntity(Location location, BaseEntity entity) {
        class_2487 tag;
        class_3218 world = (class_3218)this.getWorld();
        String entityId = entity.getType().getId();
        Optional entityType = class_1299.method_5898((String)entityId);
        if (entityType.isEmpty()) {
            return null;
        }
        CompoundTag nativeTag = entity.getNbtData();
        if (nativeTag != null) {
            tag = NBTConverter.toNative(entity.getNbtData());
            this.removeUnwantedEntityTagsRecursively(tag);
        } else {
            tag = new class_2487();
        }
        tag.method_10582("id", entityId);
        class_1297 createdEntity = class_1299.method_17842((class_2487)tag, (class_1937)world, loadedEntity -> {
            loadedEntity.method_5641(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
            return loadedEntity;
        });
        if (createdEntity != null) {
            world.method_30771(createdEntity);
            return new FabricEntity(createdEntity);
        }
        return null;
    }

    private void removeUnwantedEntityTagsRecursively(class_2487 tag) {
        for (String name : Constants.NO_COPY_ENTITY_NBT_FIELDS) {
            tag.method_10551(name);
        }
        if (tag.method_10573("Passengers", 9)) {
            class_2499 nbttaglist = tag.method_10554("Passengers", 10);
            for (int i = 0; i < nbttaglist.size(); ++i) {
                this.removeUnwantedEntityTagsRecursively(nbttaglist.method_10602(i));
            }
        }
    }

    @Override
    public Mask createLiquidMask() {
        return new AbstractExtentMask(this){

            @Override
            public boolean test(BlockVector3 vector) {
                return FabricAdapter.adapt(this.getExtent().getBlock(vector)).method_26204() instanceof class_2404;
            }

            @Override
            @Nullable
            public Mask2D toMask2D() {
                return null;
            }
        };
    }
}

