/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.twelvemonkeys.imageio.plugins.webp.WebPImageReaderSpi;
import dev.isxander.yacl3.impl.utils.YACLConstants;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_332;
import net.minecraft.class_3673;
import net.minecraft.class_4587;
import net.minecraft.class_5253;

public interface ImageRenderer {
    public static final Map<class_2960, CompletableFuture<Optional<ImageRenderer>>> CACHE = new ConcurrentHashMap<class_2960, CompletableFuture<Optional<ImageRenderer>>>();

    public int render(class_4587 var1, int var2, int var3, int var4);

    public void close();

    default public void tick() {
    }

    public static CompletableFuture<Optional<ImageRenderer>> getOrMakeAsync(class_2960 id, Supplier<Optional<ImageRenderer>> factory) {
        return CACHE.computeIfAbsent(id, key -> CompletableFuture.supplyAsync(factory, YACLConstants.SINGLE_THREAD_EXECUTOR));
    }

    public static CompletableFuture<Optional<ImageRenderer>> getOrMakeSync(class_2960 id, Supplier<Optional<ImageRenderer>> factory) {
        return CACHE.computeIfAbsent(id, key -> CompletableFuture.completedFuture((Optional)factory.get()));
    }

    public static void closeAll() {
        CACHE.values().forEach(future -> future.thenAccept(opt -> opt.ifPresent(ImageRenderer::close)));
        CACHE.clear();
    }

    public static class AnimatedNativeImageBacked
    extends NativeImageBacked {
        private int currentFrame;
        private double lastFrameTime;
        private final double[] frameDelays;
        private final int frameCount;
        private final int packCols;
        private final int packRows;
        private final int frameWidth;
        private final int frameHeight;

        public AnimatedNativeImageBacked(class_1011 image, int frameWidth, int frameHeight, int frameCount, double[] frameDelayMS, int packCols, int packRows, class_2960 uniqueLocation) {
            super(image, uniqueLocation);
            this.frameWidth = frameWidth;
            this.frameHeight = frameHeight;
            this.frameCount = frameCount;
            this.frameDelays = frameDelayMS;
            this.packCols = packCols;
            this.packRows = packRows;
        }

        public static AnimatedNativeImageBacked createGIFFromTexture(class_2960 textureLocation) throws IOException {
            class_3300 resourceManager = class_310.method_1551().method_1478();
            class_3298 resource = (class_3298)resourceManager.method_14486(textureLocation).orElseThrow();
            return AnimatedNativeImageBacked.createGIF(resource.method_14482(), textureLocation);
        }

        public static AnimatedNativeImageBacked createWEBPFromTexture(class_2960 textureLocation) throws IOException {
            class_3300 resourceManager = class_310.method_1551().method_1478();
            class_3298 resource = (class_3298)resourceManager.method_14486(textureLocation).orElseThrow();
            return AnimatedNativeImageBacked.createWEBP(resource.method_14482(), textureLocation);
        }

        public static AnimatedNativeImageBacked createGIF(InputStream is, class_2960 uniqueLocation) {
            AnimatedNativeImageBacked animatedNativeImageBacked;
            block8: {
                InputStream inputStream = is;
                try {
                    ImageReader reader = ImageIO.getImageReadersBySuffix("gif").next();
                    reader.setInput(ImageIO.createImageInputStream(is));
                    AnimFrameProvider animFrameFunction = i -> {
                        IIOMetadata metadata = reader.getImageMetadata(i);
                        String metaFormatName = metadata.getNativeMetadataFormatName();
                        IIOMetadataNode root = (IIOMetadataNode)metadata.getAsTree(metaFormatName);
                        IIOMetadataNode graphicsControlExtensionNode = (IIOMetadataNode)root.getElementsByTagName("GraphicControlExtension").item(0);
                        int delay = Integer.parseInt(graphicsControlExtensionNode.getAttribute("delayTime")) * 10;
                        return new AnimFrame(delay, 0, 0);
                    };
                    animatedNativeImageBacked = AnimatedNativeImageBacked.createFromImageReader(reader, animFrameFunction, uniqueLocation);
                    if (inputStream == null) break block8;
                }
                catch (Throwable reader) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable animFrameFunction) {
                                reader.addSuppressed(animFrameFunction);
                            }
                        }
                        throw reader;
                    }
                    catch (Exception e) {
                        class_128 crashReport = class_128.method_560((Throwable)e, (String)"Failed to load GIF image");
                        class_129 category = crashReport.method_562("YACL Gui");
                        category.method_578("Image identifier", (Object)uniqueLocation.toString());
                        throw new class_148(crashReport);
                    }
                }
                inputStream.close();
            }
            return animatedNativeImageBacked;
        }

        public static AnimatedNativeImageBacked createWEBP(InputStream is, class_2960 uniqueLocation) {
            AnimatedNativeImageBacked animatedNativeImageBacked;
            block9: {
                InputStream inputStream = is;
                try {
                    ImageReader reader = new WebPImageReaderSpi().createReaderInstance();
                    reader.setInput(ImageIO.createImageInputStream(is));
                    int numImages = reader.getNumImages(true);
                    AnimFrameProvider animFrameFunction = i -> null;
                    if (numImages > 1) {
                        Class<?> webpReaderClass = Class.forName("com.twelvemonkeys.imageio.plugins.webp.WebPImageReader");
                        Field framesField = webpReaderClass.getDeclaredField("frames");
                        framesField.setAccessible(true);
                        List frames = (List)framesField.get(reader);
                        Class<?> animationFrameClass = Class.forName("com.twelvemonkeys.imageio.plugins.webp.AnimationFrame");
                        Field durationField = animationFrameClass.getDeclaredField("duration");
                        durationField.setAccessible(true);
                        Field boundsField = animationFrameClass.getDeclaredField("bounds");
                        boundsField.setAccessible(true);
                        animFrameFunction = i -> {
                            Rectangle bounds = (Rectangle)boundsField.get(frames.get(i));
                            return new AnimFrame((Integer)durationField.get(frames.get(i)), bounds.x, bounds.y);
                        };
                    }
                    animatedNativeImageBacked = AnimatedNativeImageBacked.createFromImageReader(reader, animFrameFunction, uniqueLocation);
                    if (inputStream == null) break block9;
                }
                catch (Throwable reader) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable numImages) {
                                reader.addSuppressed(numImages);
                            }
                        }
                        throw reader;
                    }
                    catch (Throwable e) {
                        class_128 crashReport = class_128.method_560((Throwable)e, (String)"Failed to load WEBP image");
                        class_129 category = crashReport.method_562("YACL Gui");
                        category.method_578("Image identifier", (Object)uniqueLocation.toString());
                        throw new class_148(crashReport);
                    }
                }
                inputStream.close();
            }
            return animatedNativeImageBacked;
        }

        private static AnimatedNativeImageBacked createFromImageReader(ImageReader reader, AnimFrameProvider animationProvider, class_2960 uniqueLocation) throws Exception {
            if (reader.isSeekForwardOnly()) {
                throw new RuntimeException("Image reader is not seekable");
            }
            int frameCount = reader.getNumImages(true);
            int frameWidth = IntStream.range(0, frameCount).map(i -> {
                try {
                    return reader.getWidth(i);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }).max().orElseThrow();
            int frameHeight = IntStream.range(0, frameCount).map(i -> {
                try {
                    return reader.getHeight(i);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }).max().orElseThrow();
            double ratio = (double)frameWidth / (double)frameHeight;
            int cols = (int)Math.ceil(Math.sqrt(frameCount) / Math.sqrt(ratio));
            int rows = (int)Math.ceil((double)frameCount / (double)cols);
            class_1011 image = new class_1011(frameWidth * cols, frameHeight * rows, true);
            BufferedImage bi = null;
            Graphics graphics = null;
            double[] frameDelays = new double[frameCount];
            for (int i2 = 0; i2 < frameCount; ++i2) {
                AnimFrame frame = animationProvider.get(i2);
                if (frameCount > 1) {
                    frameDelays[i2] = frame.durationMS;
                }
                if (bi == null) {
                    bi = reader.read(i2);
                    graphics = bi.createGraphics();
                } else {
                    BufferedImage deltaFrame = reader.read(i2);
                    graphics.drawImage(deltaFrame, frame.xOffset, frame.yOffset, null);
                }
                int xOffset = (frameWidth - bi.getWidth()) / 2;
                int yOffset = (frameHeight - bi.getHeight()) / 2;
                for (int w = 0; w < bi.getWidth(); ++w) {
                    for (int h = 0; h < bi.getHeight(); ++h) {
                        int rgb = bi.getRGB(w, h);
                        int r = class_5253.class_5254.method_27765((int)rgb);
                        int g = class_5253.class_5254.method_27766((int)rgb);
                        int b = class_5253.class_5254.method_27767((int)rgb);
                        int a = class_5253.class_5254.method_27762((int)rgb);
                        int col = i2 % cols;
                        int row = (int)Math.floor((double)i2 / (double)cols);
                        image.method_4305(frameWidth * col + w + xOffset, frameHeight * row + h + yOffset, class_5253.class_8045.method_48344((int)a, (int)b, (int)g, (int)r));
                    }
                }
            }
            image.method_4301(0, 0, 0, false);
            if (graphics != null) {
                graphics.dispose();
            }
            reader.dispose();
            return new AnimatedNativeImageBacked(image, frameWidth, frameHeight, frameCount, frameDelays, cols, rows, uniqueLocation);
        }

        @Override
        public int render(class_4587 matrices, int x, int y, int renderWidth) {
            if (this.image == null) {
                return 0;
            }
            float ratio = (float)renderWidth / (float)this.frameWidth;
            int targetHeight = (int)((float)this.frameHeight * ratio);
            int currentCol = this.currentFrame % this.packCols;
            int currentRow = (int)Math.floor((double)this.currentFrame / (double)this.packCols);
            matrices.method_22903();
            matrices.method_46416((float)x, (float)y, 0.0f);
            matrices.method_22905(ratio, ratio, 1.0f);
            RenderSystem.setShaderTexture((int)0, (class_2960)this.uniqueLocation);
            class_332.method_25290((class_4587)matrices, (int)0, (int)0, (float)(this.frameWidth * currentCol), (float)(this.frameHeight * currentRow), (int)this.frameWidth, (int)this.frameHeight, (int)this.width, (int)this.height);
            matrices.method_22909();
            if (this.frameCount > 1) {
                double timeMS = class_3673.method_15974() * 1000.0;
                if (this.lastFrameTime == 0.0) {
                    this.lastFrameTime = timeMS;
                }
                if (timeMS - this.lastFrameTime >= this.frameDelays[this.currentFrame]) {
                    ++this.currentFrame;
                    this.lastFrameTime = timeMS;
                }
                if (this.currentFrame >= this.frameCount - 1) {
                    this.currentFrame = 0;
                }
            }
            return targetHeight;
        }

        @FunctionalInterface
        private static interface AnimFrameProvider {
            public AnimFrame get(int var1) throws Exception;
        }

        private record AnimFrame(int durationMS, int xOffset, int yOffset) {
        }
    }

    public static class NativeImageBacked
    implements ImageRenderer {
        protected static final class_1060 textureManager = class_310.method_1551().method_1531();
        protected class_1011 image;
        protected class_1043 texture;
        protected final class_2960 uniqueLocation;
        protected final int width;
        protected final int height;

        public NativeImageBacked(class_1011 image, class_2960 uniqueLocation) {
            this.image = image;
            this.texture = new class_1043(image);
            this.uniqueLocation = uniqueLocation;
            textureManager.method_4616(this.uniqueLocation, (class_1044)this.texture);
            this.width = image.method_4307();
            this.height = image.method_4323();
        }

        private NativeImageBacked(Path imagePath, class_2960 uniqueLocation) throws IOException {
            this.uniqueLocation = uniqueLocation;
            this.image = class_1011.method_4309((InputStream)new FileInputStream(imagePath.toFile()));
            this.width = this.image.method_4307();
            this.height = this.image.method_4323();
            this.texture = new class_1043(this.image);
            textureManager.method_4616(this.uniqueLocation, (class_1044)this.texture);
        }

        public static Optional<ImageRenderer> createFromPath(Path path, class_2960 uniqueLocation) {
            try {
                return Optional.of(new NativeImageBacked(path, uniqueLocation));
            }
            catch (IOException e) {
                e.printStackTrace();
                return Optional.empty();
            }
        }

        @Override
        public int render(class_4587 matrices, int x, int y, int renderWidth) {
            if (this.image == null) {
                return 0;
            }
            float ratio = (float)renderWidth / (float)this.width;
            int targetHeight = (int)((float)this.height * ratio);
            matrices.method_22903();
            matrices.method_46416((float)x, (float)y, 0.0f);
            matrices.method_22905(ratio, ratio, 1.0f);
            RenderSystem.setShaderTexture((int)0, (class_2960)this.uniqueLocation);
            class_332.method_25290((class_4587)matrices, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)this.width, (int)this.height, (int)this.width, (int)this.height);
            matrices.method_22909();
            return targetHeight;
        }

        @Override
        public void close() {
            this.image.close();
            this.image = null;
            this.texture = null;
            textureManager.method_4615(this.uniqueLocation);
        }
    }

    public static class TextureBacked
    implements ImageRenderer {
        private final class_2960 location;
        private final int width;
        private final int height;
        private final int textureWidth;
        private final int textureHeight;
        private final float u;
        private final float v;

        public TextureBacked(class_2960 location, float u, float v, int width, int height, int textureWidth, int textureHeight) {
            this.location = location;
            this.width = width;
            this.height = height;
            this.textureWidth = textureWidth;
            this.textureHeight = textureHeight;
            this.u = u;
            this.v = v;
        }

        @Override
        public int render(class_4587 matrices, int x, int y, int renderWidth) {
            float ratio = (float)renderWidth / (float)this.width;
            int targetHeight = (int)((float)this.height * ratio);
            matrices.method_22903();
            matrices.method_46416((float)x, (float)y, 0.0f);
            matrices.method_22905(ratio, ratio, 1.0f);
            RenderSystem.setShaderTexture((int)0, (class_2960)this.location);
            class_332.method_25290((class_4587)matrices, (int)0, (int)0, (float)this.u, (float)this.v, (int)this.width, (int)this.height, (int)this.textureWidth, (int)this.textureHeight);
            matrices.method_22909();
            return targetHeight;
        }

        @Override
        public void close() {
        }
    }
}

