/*
 * Decompiled with CFR 0.152.
 */
package dev.redstudio.redcore.utils;

import dev.redstudio.redcore.ProjectConstants;
import dev.redstudio.redcore.ticking.RedClientTicker;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public final class OptiNotFine {
    private static final String OPTIFINE_CLASS = "optifine.Installer";
    private static final String SHADERS_CLASS = "net.optifine.shaders.Shaders";
    private static final String SHADER_PACK_LOADED_FIELD = "shaderPackLoaded";
    private static final String GAME_SETTINGS_CLASS = "net.minecraft.client.settings.GameSettings";
    private static final String FAST_RENDER_FIELD = "ofFastRender";
    private static boolean checkedOptiFineInstalled = false;
    private static boolean isOptiFineInstalled = true;
    private static MethodHandle shaderPackLoadedHandle = null;
    private static MethodHandle fastRenderGetterHandle = null;
    private static MethodHandle fastRenderSetterHandle = null;

    public static boolean isOptiFineInstalled() {
        if (!checkedOptiFineInstalled) {
            try {
                Class.forName(OPTIFINE_CLASS);
            }
            catch (ClassNotFoundException ignored) {
                isOptiFineInstalled = false;
            }
            checkedOptiFineInstalled = true;
        }
        return isOptiFineInstalled;
    }

    public static boolean shadersEnabled() {
        if (!OptiNotFine.isOptiFineInstalled()) {
            return false;
        }
        try {
            if (shaderPackLoadedHandle == null) {
                Field shaderPackLoadedField = Class.forName(SHADERS_CLASS).getDeclaredField(SHADER_PACK_LOADED_FIELD);
                shaderPackLoadedHandle = MethodHandles.lookup().unreflectGetter(shaderPackLoadedField);
            }
            return shaderPackLoadedHandle.invoke();
        }
        catch (Throwable exception) {
            ProjectConstants.RED_LOGGER.framedError("OptiNotFine", "Could not get OptiFine shaders status.", "If shaders are enabled things might break", exception.getMessage());
            return false;
        }
    }

    public static void forceOptiFineFastRenderOff() {
        RedClientTicker.startClientTicker();
        MinecraftForge.EVENT_BUS.register(OptiNotFine.class);
    }

    private static void disableFastRender() {
        if (!OptiNotFine.isOptiFineInstalled()) {
            return;
        }
        try {
            if (fastRenderGetterHandle == null || fastRenderSetterHandle == null) {
                Field fastRenderField = Class.forName(GAME_SETTINGS_CLASS).getDeclaredField(FAST_RENDER_FIELD);
                fastRenderGetterHandle = MethodHandles.lookup().unreflectGetter(fastRenderField);
                fastRenderSetterHandle = MethodHandles.lookup().unreflectSetter(fastRenderField);
            }
            Minecraft mc = Minecraft.func_71410_x();
            if (fastRenderGetterHandle.invoke(mc.field_71474_y)) {
                fastRenderSetterHandle.invoke(mc.field_71474_y, false);
            }
        }
        catch (Throwable exception) {
            ProjectConstants.RED_LOGGER.framedError("OptiNotFine", "Could not disable OptiFine fast renderer", "Things will break", exception.getMessage());
        }
    }

    @SubscribeEvent
    public static void onClientQuarterTickEvent(TickEvent.ClientTickEvent clientTickEvent) {
        OptiNotFine.disableFastRender();
    }

    @Generated
    private OptiNotFine() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

