/*
 * Decompiled with CFR 0.152.
 */
package io.redstudioragnarok.redcore.vectors;

import io.netty.buffer.ByteBuf;
import io.redstudioragnarok.redcore.vectors.Vector3F;
import net.jafama.FastMath;
import net.minecraft.util.math.Vec3d;

@Deprecated
public final class Vector3D {
    public double x;
    public double y;
    public double z;

    public Vector3D() {
    }

    public Vector3D(double inputX, double inputY, double inputZ) {
        this.x = inputX;
        this.y = inputY;
        this.z = inputZ;
    }

    public Vector3D(Vector3D input) {
        this.x = input.x;
        this.y = input.y;
        this.z = input.z;
    }

    public Vector3D(Vector3F input) {
        this.x = input.x;
        this.y = input.y;
        this.z = input.z;
    }

    public Vector3D(Vec3d input) {
        this.x = input.field_72450_a;
        this.y = input.field_72448_b;
        this.z = input.field_72449_c;
    }

    public Vec3d toVec3d() {
        return new Vec3d(this.x, this.y, this.z);
    }

    public void zero() {
        this.z = 0.0;
        this.y = 0.0;
        this.x = 0.0;
    }

    public void copy(Vector3D inputVector) {
        this.x = inputVector.x;
        this.y = inputVector.y;
        this.z = inputVector.z;
    }

    public void copy(Vector3F inputVector) {
        this.x = inputVector.x;
        this.y = inputVector.y;
        this.z = inputVector.z;
    }

    public void set(double inputX, double inputY, double inputZ) {
        this.x = inputX;
        this.y = inputY;
        this.z = inputZ;
    }

    public void add(Vector3D inputVector) {
        this.x += inputVector.x;
        this.y += inputVector.y;
        this.z += inputVector.z;
    }

    public void add(Vector3F inputVector) {
        this.x += (double)inputVector.x;
        this.y += (double)inputVector.y;
        this.z += (double)inputVector.z;
    }

    public void scale(double multiplier) {
        this.x *= multiplier;
        this.y *= multiplier;
        this.z *= multiplier;
    }

    public void lerp(Vector3D input, float partialTicks, Vector3D target) {
        this.x = input.x + (target.x - input.x) * (double)partialTicks;
        this.y = input.y + (target.y - input.y) * (double)partialTicks;
        this.z = input.z + (target.z - input.z) * (double)partialTicks;
    }

    public double distanceTo(Vector3D target) {
        double xDelta = target.x - this.x;
        double yDelta = target.y - this.y;
        double zDelta = target.z - this.z;
        return FastMath.sqrt(xDelta * xDelta + yDelta * yDelta + zDelta * zDelta);
    }

    public double distanceTo(Vector3F target) {
        double xDelta = (double)target.x - this.x;
        double yDelta = (double)target.y - this.y;
        double zDelta = (double)target.z - this.z;
        return FastMath.sqrt(xDelta * xDelta + yDelta * yDelta + zDelta * zDelta);
    }

    public void write(ByteBuf byteBuf) {
        byteBuf.writeDouble(this.x);
        byteBuf.writeDouble(this.y);
        byteBuf.writeDouble(this.z);
    }

    public void read(ByteBuf byteBuf) {
        this.x = byteBuf.readDouble();
        this.y = byteBuf.readDouble();
        this.z = byteBuf.readDouble();
    }
}

