/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.relauncher.config;

import com.cleanroommc.relauncher.CleanroomRelauncher;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import net.minecraft.launchwrapper.Launch;

public class RelauncherConfiguration {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final File FILE = new File(Launch.minecraftHome, "config/relauncher.json");
    @SerializedName(value="selectedVersion")
    private String cleanroomVersion;
    @SerializedName(value="latestVersion")
    private String latestCleanroomVersion;
    @SerializedName(value="javaPath")
    private String javaExecutablePath;
    @SerializedName(value="args")
    private String javaArguments = "";
    @SerializedName(value="javaVersion")
    private int javaVersion = 24;
    @SerializedName(value="javaVendor")
    private String javaVendor = "adoptium";
    @SerializedName(value="darkMode")
    private boolean darkMode = true;
    @SerializedName(value="autoUpdate")
    private boolean autoUpdate = false;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RelauncherConfiguration read() {
        if (!FILE.exists()) {
            return new RelauncherConfiguration();
        }
        try (InputStreamReader baseReader = new InputStreamReader((InputStream)new FileInputStream(FILE), StandardCharsets.UTF_8);){
            JsonReader reader = new JsonReader((Reader)baseReader);
            reader.setLenient(true);
            RelauncherConfiguration relauncherConfiguration = (RelauncherConfiguration)GSON.fromJson(reader, RelauncherConfiguration.class);
            return relauncherConfiguration;
        }
        catch (IOException e) {
            CleanroomRelauncher.LOGGER.error("Unable to read config", (Throwable)e);
            return new RelauncherConfiguration();
        }
    }

    public String getCleanroomVersion() {
        return this.cleanroomVersion;
    }

    public String getLatestCleanroomVersion() {
        return this.latestCleanroomVersion;
    }

    public String getJavaExecutablePath() {
        return this.javaExecutablePath;
    }

    public String getJavaArguments() {
        return this.javaArguments;
    }

    public int getJavaVersion() {
        return this.javaVersion <= 0 ? 24 : this.javaVersion;
    }

    public String getJavaVendor() {
        return this.javaVendor == null || this.javaVendor.isEmpty() ? "adoptium" : this.javaVendor.toLowerCase();
    }

    public boolean isDarkMode() {
        return this.darkMode;
    }

    public boolean isAutoUpdate() {
        return this.autoUpdate;
    }

    public void setCleanroomVersion(String cleanroomVersion) {
        this.cleanroomVersion = cleanroomVersion;
    }

    public void setLatestCleanroomVersion(String latestCleanroomVersion) {
        this.latestCleanroomVersion = latestCleanroomVersion;
    }

    public void setJavaExecutablePath(String javaExecutablePath) {
        this.javaExecutablePath = javaExecutablePath.replace("\\\\", "/");
    }

    public void setJavaArguments(String javaArguments) {
        this.javaArguments = javaArguments;
    }

    public void setJavaVersion(int javaVersion) {
        this.javaVersion = javaVersion;
    }

    public void setJavaVendor(String javaVendor) {
        this.javaVendor = javaVendor == null || javaVendor.isEmpty() ? "adoptium" : javaVendor.toLowerCase();
    }

    public void setDarkMode(boolean darkMode) {
        this.darkMode = darkMode;
    }

    public void setAutoUpdate(boolean autoUpdate) {
        this.autoUpdate = autoUpdate;
    }

    public void save() {
        FILE.getParentFile().mkdirs();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(FILE), StandardCharsets.UTF_8);){
            String nl = System.lineSeparator();
            writer.write("// Cleanroom Relauncher configuration" + nl);
            writer.write("// This file is parsed leniently; comments are allowed and preserved on save." + nl + nl);
            writer.write("{" + nl);
            writer.write("  // Cleanroom version to launch (auto-selected on first run)" + nl);
            writer.write("  \"selectedVersion\": " + (this.cleanroomVersion == null ? "null" : "\"" + RelauncherConfiguration.escapeJson(this.cleanroomVersion) + "\"") + "," + nl);
            writer.write("  // Latest Cleanroom version seen by the relauncher (informational)" + nl);
            writer.write("  \"latestVersion\": " + (this.latestCleanroomVersion == null ? "null" : "\"" + RelauncherConfiguration.escapeJson(this.latestCleanroomVersion) + "\"") + "," + nl);
            writer.write("  // Preferred Java vendor: \"adoptium\" (Temurin) or \"graalvm\" (GraalVM Community JDK)." + nl);
            writer.write("  // If chosen vendor is unavailable for your OS/arch/version, the relauncher falls back to Adoptium automatically." + nl);
            writer.write("  \"javaVendor\": \"" + RelauncherConfiguration.escapeJson(this.getJavaVendor()) + "\"," + nl);
            writer.write("  // Java major version to use (e.g., 24). Changing this triggers auto re-download and switch." + nl);
            writer.write("  \"javaVersion\": " + this.getJavaVersion() + "," + nl);
            writer.write("  // UI theme: dark mode on/off (default: true). When enabled, all relauncher UI uses a dark theme." + nl);
            writer.write("  \"darkMode\": " + (this.isDarkMode() ? "true" : "false") + "," + nl);
            writer.write("  // Automatically switch to the latest Cleanroom release on launch." + nl);
            writer.write("  // When true, the relauncher will always select the latest release, skipping update prompts." + nl);
            writer.write("  \"autoUpdate\": " + (this.isAutoUpdate() ? "true" : "false") + "," + nl);
            writer.write("  // Optional absolute path to a Java executable. Leave null/empty to let the relauncher manage Java automatically." + nl);
            String jp = this.getJavaExecutablePath();
            writer.write("  \"javaPath\": " + (jp == null || jp.isEmpty() ? "null" : "\"" + RelauncherConfiguration.escapeJson(jp) + "\"") + "," + nl);
            writer.write("  // Optional JVM arguments appended when launching Cleanroom." + nl);
            String ja = this.getJavaArguments();
            writer.write("  \"args\": " + (ja == null ? "\"\"" : "\"" + RelauncherConfiguration.escapeJson(ja) + "\"") + nl);
            writer.write("}" + nl);
        }
        catch (IOException e) {
            CleanroomRelauncher.LOGGER.error("Unable to save config", (Throwable)e);
        }
    }

    private static String escapeJson(String s) {
        StringBuilder sb = new StringBuilder(s.length() + 16);
        block7: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\"': {
                    sb.append("\\\"");
                    continue block7;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block7;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block7;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block7;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block7;
                }
                default: {
                    if (c < ' ') {
                        sb.append(String.format("\\u%04x", c));
                        continue block7;
                    }
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

