/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.relauncher.gui;

import com.cleanroommc.relauncher.CleanroomRelauncher;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public final class SetupProgressDialog {
    private final JFrame frame;
    private final JProgressBar progressBar;
    private final JLabel messageLabel;

    private SetupProgressDialog(String title) {
        boolean dark = CleanroomRelauncher.CONFIG != null && CleanroomRelauncher.CONFIG.isDarkMode();
        this.frame = new JFrame(title);
        try {
            ImageIcon icon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(SetupProgressDialog.class.getResource("/cleanroom-relauncher.png")));
            this.frame.setIconImage(icon.getImage());
        }
        catch (Exception icon) {
            // empty catch block
        }
        if (dark) {
            this.frame.setUndecorated(true);
        }
        this.frame.setDefaultCloseOperation(0);
        this.frame.setSize(500, 120);
        this.frame.setResizable(false);
        this.frame.setLocationRelativeTo(null);
        JPanel panel = new JPanel(new BorderLayout(10, 10));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.messageLabel = new JLabel("Setting Up Necessary Libraries (Only Happens Once)");
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setStringPainted(true);
        this.progressBar.setValue(0);
        panel.add((Component)this.messageLabel, "North");
        panel.add((Component)this.progressBar, "Center");
        if (dark) {
            JPanel outer = new JPanel(new BorderLayout());
            JPanel header = SetupProgressDialog.buildDarkHeader(title, this.frame);
            outer.add((Component)header, "North");
            outer.add((Component)panel, "Center");
            this.frame.setContentPane(outer);
            SetupProgressDialog.applyDark(outer);
        } else {
            this.frame.setContentPane(panel);
        }
    }

    public static SetupProgressDialog show(String title) {
        SetupProgressDialog[] holder = new SetupProgressDialog[1];
        try {
            SwingUtilities.invokeAndWait(() -> {
                holder[0] = new SetupProgressDialog(title);
                holder[0].frame.setVisible(true);
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        return holder[0];
    }

    public void close() {
        if (this.frame == null) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            this.frame.setVisible(false);
            this.frame.dispose();
        });
    }

    public void setMessage(String msg) {
        if (this.messageLabel == null) {
            return;
        }
        SwingUtilities.invokeLater(() -> this.messageLabel.setText(msg));
    }

    public void setIndeterminate(boolean indeterminate) {
        if (this.progressBar == null) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            this.progressBar.setIndeterminate(indeterminate);
            if (indeterminate) {
                this.progressBar.setString("");
            }
        });
    }

    public void setProgressPercent(int percent) {
        if (this.progressBar == null) {
            return;
        }
        int p = Math.max(0, Math.min(100, percent));
        SwingUtilities.invokeLater(() -> {
            this.progressBar.setIndeterminate(false);
            this.progressBar.setValue(p);
            this.progressBar.setString(p + "%");
        });
    }

    public void setProgress(int percent, String text) {
        if (this.progressBar == null) {
            return;
        }
        int p = Math.max(0, Math.min(100, percent));
        String s = text == null || text.isEmpty() ? p + "%" : text;
        SwingUtilities.invokeLater(() -> {
            this.progressBar.setIndeterminate(false);
            this.progressBar.setValue(p);
            this.progressBar.setString(s);
        });
    }

    private static void applyDark(JComponent root) {
        Color bg = new Color(0x1E1E1E);
        Color bg2 = new Color(0x2D2D2D);
        Color fg = new Color(0xE0E0E0);
        UIManager.put("ProgressBar.selectionForeground", fg);
        UIManager.put("ProgressBar.selectionBackground", bg2);
        UIManager.put("ProgressBar.foreground", new Color(5025616));
        SwingUtilities.invokeLater(() -> {
            root.setBackground(bg);
            for (Component c : root.getComponents()) {
                SetupProgressDialog.tint(c, bg, bg2, fg);
            }
        });
    }

    private static void tint(Component c, Color bg, Color bg2, Color fg) {
        if (c instanceof JPanel) {
            c.setBackground(bg);
        } else if (c instanceof JLabel) {
            c.setBackground(bg);
            ((JLabel)c).setForeground(fg);
        } else if (c instanceof JProgressBar) {
            c.setBackground(bg2);
            ((JProgressBar)c).setForeground(new Color(5025616));
        }
        if (c instanceof JComponent) {
            for (Component child : ((JComponent)c).getComponents()) {
                SetupProgressDialog.tint(child, bg, bg2, fg);
            }
        }
    }

    private static JPanel buildDarkHeader(String title, final JFrame frame) {
        Color bg = new Color(0x2D2D2D);
        Color fg = new Color(0xE0E0E0);
        JPanel header = new JPanel(new BorderLayout());
        header.setBackground(bg);
        header.setBorder(BorderFactory.createEmptyBorder(6, 10, 6, 10));
        JLabel t = new JLabel(title);
        t.setForeground(fg);
        header.add((Component)t, "West");
        final Point[] drag = new Point[]{null};
        header.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                drag[0] = e.getPoint();
            }
        });
        header.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (drag[0] != null) {
                    Point p = e.getLocationOnScreen();
                    frame.setLocation(p.x - drag[0].x, p.y - drag[0].y);
                }
            }
        });
        return header;
    }
}

