/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.relauncher.shade.javautils;

import com.cleanroommc.relauncher.shade.javautils.api.JavaInstall;
import com.cleanroommc.relauncher.shade.javautils.api.JavaVendor;
import com.cleanroommc.relauncher.shade.javautils.api.JavaVersion;
import com.cleanroommc.relauncher.shade.platformutils.Platform;
import java.io.File;
import java.io.IOException;

class JavaInstallImpl
implements JavaInstall {
    private final File home;
    private final File java;
    private final File javaw;
    private final File javac;
    private final JavaVendor vendor;
    private final JavaVersion version;

    static JavaInstall of(File root, File executable, String version, String vendor) throws IOException {
        return new JavaInstallImpl(root, executable, version, vendor);
    }

    private JavaInstallImpl(File home, File executable, String version, String vendor) throws IOException {
        this.home = home;
        this.java = executable;
        File file = this.javaw = Platform.current().isWindows() ? new File(executable.getParentFile(), "javaw.exe") : executable;
        if (!this.java.isFile()) {
            throw new IOException("Java Executable not found at: " + this.java.getAbsolutePath());
        }
        if (!this.javaw.isFile()) {
            throw new IOException("Javaw Executable not found at: " + this.javaw.getAbsolutePath());
        }
        this.javac = new File(executable.getParentFile(), Platform.current().isWindows() ? "javac.exe" : "javac");
        this.vendor = JavaVendor.find(vendor);
        this.version = JavaVersion.parseOrThrow(version);
    }

    @Override
    public File home() {
        return this.home;
    }

    @Override
    public File executable(boolean wrapper) {
        return wrapper ? this.javaw : this.java;
    }

    @Override
    public JavaVersion version() {
        return this.version;
    }

    @Override
    public JavaVendor vendor() {
        return this.vendor;
    }

    @Override
    public boolean jdk() {
        return this.javac.exists();
    }

    public String toString() {
        return this.vendor() + (this.jdk() ? " JDK" : "JRE") + " v" + this.version() + " @ " + this.home().getAbsolutePath();
    }

    public int hashCode() {
        return this.home.getAbsolutePath().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof JavaInstall) {
            return this.home().getAbsolutePath().equals(((JavaInstall)obj).home().getAbsolutePath());
        }
        return false;
    }

    @Override
    public int compareTo(JavaInstall o) {
        int comparedVersion = this.version().compareTo(o.version());
        if (comparedVersion != 0) {
            return comparedVersion;
        }
        return this.vendor().compareTo(o.vendor());
    }
}

